/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Dwdm.eAisSquelchMode;
import cerent.cms.idl.Dwdm.eTermMode;
import cerent.cms.idl.Dwdm.eWavelength;
import cerent.cms.idl.Dwdm.sDwdmCardConfig;
import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.SDebug;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.UScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DwdmCardProvPane
extends NodeProvPane
implements ActionListener,
DocumentListener {
    private final String DATA_RATE_RULE_MSG;
    private final String TERM_MODE_RULE_MSG;
    private final String CARD_MODE_RULE_MSG;
    private static final String REGEN_GROUP_RULE_MSG = "Creating regeneration group requires that:\n1) Both cards have the same card type\n2) Both cards have the same payload data type\n3) Both cards have the same termination mode\n4) Neither card is part of another regeneration peer group\n5) Neither card is part of a YCable protection group\n";
    private final String WAVE_LENGTH_RULE_MSG;
    protected DwdmModuleModel eqpmtModel = (DwdmModuleModel)this.getUiModel();
    protected DwdmTrkLineModel firstTrk = this.eqpmtModel.getFirstTrunkLine();
    private JLabel framingTypeLBL;
    private JComboBox termModeCB;
    private JComboBox cardModeCB;
    private JComboBox wavelengthCB;
    private JComboBox regenPeerCB;
    private JComboBox squelchCB;
    private JLabel tunableWavelengthsLBL;
    private FixedLengthField nameTF;
    private int curPeerSlot;
    private boolean createFramingTypeLabel;
    private boolean createCardModeCB = false;
    private String[] tunableWavelength;
    private String framingTypeKey;
    private String payloadDataTypeKey;
    private String termModeKey;
    private String cardModeKey;
    private String squelchKey;
    private int eqType;
    private EntityTableModel etm;
    private EntityModel chassis;
    private ElementModelsDelegate emd;
    private DwdmTrkLineModel[] peerFirstTrks;
    protected static final SDebug db = new SDebug("DwdmCardProvPane");

    public DwdmCardProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        String string2 = AdminState.getAdminTermDSBLD(this.eqpmtModel.getNodeModel().getTDMTerminology());
        this.DATA_RATE_RULE_MSG = "Changing the payload data type requires that:\n1) All ports are in " + string2 + " state\n" + "2) No ports have DCC terminations\n" + "3) No ports are part of any timing source\n" + "4) No ports have any active Section Trace mode\n" + "5) For all 2R payload data types, no trunk ports have any GCC termination or G.709 OTN Status enabled.\n" + "If any port is YCable protected, the above rules also apply to peer port.\n" + "If the card is in a regeneration group, the above rules apply to peer card.\n";
        this.TERM_MODE_RULE_MSG = "Changing the termination mode requires that:\n1) All ports are in " + string2 + " state\n" + "2) No ports have DCC terminations\n" + "3) No ports have any OH circuits when transitioning to Transparent mode\n" + "4) No ports have any active Section Trace when transitioning to Transparent mode\n" + "5) No trunk ports are a timing source.\n" + "If any client port is YCable protected, the above rules apply to the peer port.\n";
        this.CARD_MODE_RULE_MSG = "Changing the card operation mode requires that all ports are in " + string2 + " state.\n";
        this.WAVE_LENGTH_RULE_MSG = "Changing wavelength requires that all trunk ports are in " + string2 + " state.\n";
        this.eqType = this.eqpmtModel.getEqType();
        switch (this.eqType) {
            case 119: {
                this.framingTypeKey = "declMXP10GDwdmFramingType";
                this.payloadDataTypeKey = "declMXP10GPayloadDataType";
                this.termModeKey = "declTermModeTransparentSection";
                this.tunableWavelength = new String[2];
                this.createFramingTypeLabel = false;
                break;
            }
            case 182: {
                this.framingTypeKey = "declMXP10GDwdmFramingType";
                this.payloadDataTypeKey = "declMXP10GPayloadDataType";
                this.termModeKey = "mxp25GTermMode";
                this.squelchKey = "aisSquelch";
                this.tunableWavelength = new String[8];
                this.createFramingTypeLabel = false;
                break;
            }
            case 118: {
                this.framingTypeKey = "declTXP10GDwdmFramingType";
                this.payloadDataTypeKey = "declTXP10GPayloadDataType";
                this.termModeKey = "declTermModeTransparentSection";
                this.tunableWavelength = new String[2];
                this.createFramingTypeLabel = false;
                break;
            }
            case 181: {
                this.framingTypeKey = "declTXP10GDwdmFramingType";
                this.payloadDataTypeKey = "declTXP10EPayloadDataType";
                this.termModeKey = "declTermModeFullSet";
                this.squelchKey = "aisSquelch";
                this.tunableWavelength = new String[8];
                this.createFramingTypeLabel = false;
                break;
            }
            default: {
                this.framingTypeKey = "declTXP25GFramingType";
                this.payloadDataTypeKey = "declTXP25GPayloadDataType";
                this.termModeKey = "declTermModeFullSet";
                this.tunableWavelength = new String[4];
                this.createFramingTypeLabel = true;
                break;
            }
            case 183: 
            case 184: {
                this.framingTypeKey = null;
                this.payloadDataTypeKey = null;
                this.termModeKey = null;
                this.cardModeKey = "dwdmCardMode";
                this.tunableWavelength = new String[4];
                this.createFramingTypeLabel = false;
                this.createCardModeCB = true;
            }
        }
        if (this.eqpmtModel.supportRegenGroup()) {
            NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.eqpmtModel.getNodeModel();
            this.etm = nodeModelDelegate.getEntityTableModel();
            this.chassis = (EntityModel)this.etm.getChassis();
            this.emd = nodeModelDelegate.getElementModelsDelegate();
            this.peerFirstTrks = new DwdmTrkLineModel[0];
        }
        this.initProvPane();
    }

    protected void initProvPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        this.add((Component)uScrollPane);
        jPanel.add(this.createCardInfoPanel());
        jPanel.add(this.createCardParametersPanel());
        if (db.on()) {
            db.println("init: finish");
        }
    }

    protected Attribute[] getAttributeFor(String string) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeArray(string);
    }

    protected Attribute getAttributeValFor(String string, int n) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeForVal(string, n);
    }

    private JLabel createLabel(String string) {
        return this.createLabel(string, 175, 20);
    }

    private JLabel createLabel(String string, int n, int n2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(n, n2));
        return jLabel;
    }

    private JPanel createCardInfoPanel() {
        JPanel jPanel = DwdmCardProvPane.createVerticalPanel("Card Provisioning");
        if (this.createCardModeCB) {
            this.cardModeCB = this.addComboBox(jPanel, "Card Mode: ", this.getAttributeFor(this.cardModeKey));
            this.cardModeCB.setEnabled(false);
        } else {
            this.createFramingTypeControl(jPanel, this.createFramingTypeLabel ? "Framing Type: " : null);
            jPanel.add(Box.createVerticalStrut(5));
            this.termModeCB = this.addComboBox(jPanel, "Termination Mode: ", this.getAttributeFor(this.termModeKey));
        }
        if (this.eqType == 182 || this.eqType == 181) {
            jPanel.add(Box.createVerticalStrut(5));
            this.squelchCB = this.addComboBox(jPanel, "AIS/Squelch Configuration: ", this.getAttributeFor(this.squelchKey));
        }
        jPanel.add(Box.createVerticalStrut(5));
        Object[] objectArray = this.eqType == 182 || this.eqType == 181 ? this.getAttributeFor("declDwdmWLBandWavelength") : this.getAttributeFor("declDwdmWavelength");
        this.wavelengthCB = this.addComboBox(jPanel, "Wavelength: ", objectArray);
        this.wavelengthCB.setRenderer(new WavelengthListCellRenderer());
        if (this.eqpmtModel.supportRegenGroup()) {
            jPanel.add(Box.createVerticalStrut(5));
            this.regenPeerCB = this.addComboBox(jPanel, "Regeneration Peer Slot: ", this.getAttributeFor("declDwdmRegenPeer"));
            this.nameTF = this.addTextPanel(jPanel, "Regeneration Group Name:", 32);
        }
        return jPanel;
    }

    private FixedLengthField addTextPanel(JPanel jPanel, String string, int n) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        if (string != null) {
            jPanel2.add(this.createLabel(string));
        }
        FixedLengthField fixedLengthField = new FixedLengthField(n);
        fixedLengthField.setColumns(n);
        jPanel2.add(fixedLengthField);
        fixedLengthField.getDocument().addDocumentListener(this);
        jPanel.add(jPanel2);
        this.enableComponent(fixedLengthField);
        return fixedLengthField;
    }

    private JPanel createCardParametersPanel() {
        JPanel jPanel = DwdmCardProvPane.createVerticalPanel("Card Parameters");
        this.tunableWavelengthsLBL = this.addLabel(jPanel, "Tunable Wavelengths: ", 600, 20);
        return jPanel;
    }

    private JComboBox addComboBox(JPanel jPanel, String string, Object[] objectArray) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        if (string != null) {
            jPanel2.add(this.createLabel(string));
        }
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jPanel2.add(jComboBox);
        jComboBox.addActionListener(this);
        jPanel.add(jPanel2);
        this.enableComponent(jComboBox);
        if (string.startsWith("Wavelength")) {
            StringBuffer stringBuffer = new StringBuffer("   ");
            stringBuffer.append(" ** means the supported wavelength ");
            jPanel2.add(this.createLabel(stringBuffer.toString(), 300, 20));
        }
        return jComboBox;
    }

    private void createFramingTypeControl(JPanel jPanel, String string) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        if (string != null) {
            jPanel2.add(this.createLabel(string, 175, 20));
            this.framingTypeLBL = this.createLabel("      ");
            jPanel2.add(this.framingTypeLBL);
        } else {
            this.framingTypeLBL = null;
        }
        jPanel.add(jPanel2);
    }

    private JLabel addLabel(JPanel jPanel, String string, int n, int n2) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        if (string != null) {
            jPanel2.add(this.createLabel(string));
        }
        JLabel jLabel = this.createLabel("", n, n2);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        return jLabel;
    }

    private JLabel addLabel(JPanel jPanel, String string) {
        return this.addLabel(jPanel, string, 300, 20);
    }

    private int getTermModeFromCB() {
        return ((Attribute)this.termModeCB.getSelectedItem()).getIntValue();
    }

    private eCardOperMode getCardModeFromCB() {
        return eCardOperMode.from_int(((Attribute)this.cardModeCB.getSelectedItem()).getIntValue());
    }

    private int getWavelengthFromCB() {
        return ((Attribute)this.wavelengthCB.getSelectedItem()).getIntValue();
    }

    private int getAisSquelchFromCB() {
        return this.squelchCB != null ? ((Attribute)this.squelchCB.getSelectedItem()).getIntValue() : 0;
    }

    private int getRegenPeerFromCB() {
        return this.regenPeerCB != null ? ((Attribute)this.regenPeerCB.getSelectedItem()).getIntValue() : 0;
    }

    private String getRegenGroupNameFromTF() {
        return this.nameTF != null ? this.nameTF.getText() : "";
    }

    private sDwdmCardConfig getDwdmCardConfig() {
        sDwdmCardConfig sDwdmCardConfig2 = new sDwdmCardConfig();
        sDwdmCardConfig2.termMode = eTermMode.from_int(this.getTermModeFromCB());
        sDwdmCardConfig2.wavelength = eWavelength.from_int(this.getWavelengthFromCB());
        sDwdmCardConfig2.regenPeerSlot = (short)this.getRegenPeerFromCB();
        sDwdmCardConfig2.regenGroupName = this.getRegenGroupNameFromTF();
        sDwdmCardConfig2.aisSquelch = eAisSquelchMode.from_int(this.getAisSquelchFromCB());
        return sDwdmCardConfig2;
    }

    private void updateAISMode() {
        sDwdmCardConfig sDwdmCardConfig2 = new sDwdmCardConfig();
        int n = DwdmTrkLineModel.mapFramingType(this.getDataRate());
        sDwdmCardConfig2.termMode = eTermMode.from_int(this.getTermModeFromCB());
        int n2 = sDwdmCardConfig2.termMode.value();
        if (!(n != 0 && n != 1 || sDwdmCardConfig2.termMode.value() != 1 && sDwdmCardConfig2.termMode.value() != 2)) {
            this.squelchCB.setEnabled(false);
            this.squelchCB.setSelectedItem(this.getAttributeValFor(this.squelchKey, 1));
        } else if (n == 2 || n == 3) {
            this.squelchCB.setSelectedItem(this.getAttributeValFor(this.squelchKey, 2));
            this.squelchCB.setEnabled(false);
        } else {
            this.squelchCB.setEnabled(true);
        }
    }

    private void updateTermModeControl() {
        if (!this.createCardModeCB) {
            boolean bl;
            int n = DwdmTrkLineModel.mapFramingType(this.getDataRate());
            boolean bl2 = bl = this.getRegenPeerFromCB() != 0 || n != 0 && n != 1;
            if (bl) {
                this.termModeCB.setSelectedItem(this.getAttributeValFor(this.termModeKey, 0));
            }
            this.termModeCB.setEnabled(!bl && this.isUserAuthorized());
        }
    }

    private void updateFramingTypeLabel() {
        if (this.createFramingTypeLabel) {
            Attribute attribute = this.getAttributeValFor(this.framingTypeKey, EntityCellRenderer.mapPayloadType(this.getDataRate()));
            if (this.framingTypeLBL != null) {
                this.framingTypeLBL.setText(attribute.getKey());
            }
        }
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update from " + observable + "arg obj is " + object);
        }
        if (observable == this.firstTrk || observable == this.eqpmtModel) {
            if (object.equals(ModelUpdateType.CHANGED)) {
                this.requestRefresh(observable, this.getRefreshThread(observable));
            }
        } else {
            this.requestRefresh(observable, new Runnable(){

                public void run() {
                    DwdmCardProvPane.this.updateRegenPeerCB();
                }
            });
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                DwdmCardProvPane.this.refreshModule(observable);
                DwdmCardProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshModule(Observable observable) {
        if (observable instanceof DwdmModuleModel) {
            this.setCardWavelengths();
        }
    }

    protected void refreshLine(Observable observable) {
        if (observable instanceof AbstractDwdmLineModel) {
            try {
                this.refreshFromModel();
            }
            catch (Exception exception) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                return;
            }
        }
    }

    protected void registerWithModel() {
        this.eqpmtModel.addObserver((Observer)((Object)this));
        this.firstTrk.addObserver((Observer)((Object)this));
        if (this.emd != null) {
            for (int i = 0; i < this.peerFirstTrks.length; ++i) {
                this.peerFirstTrks[i].addObserver((Observer)((Object)this));
            }
            if (this.eqType != 121) {
                this.emd.addObserver((Observer)((Object)this));
            }
            this.chassis.addObserver((Observer)((Object)this));
        }
    }

    protected void unRegisterWithModel() {
        this.eqpmtModel.deleteObserver((Observer)((Object)this));
        this.firstTrk.deleteObserver((Observer)((Object)this));
        if (this.emd != null) {
            for (int i = 0; i < this.peerFirstTrks.length; ++i) {
                this.peerFirstTrks[i].deleteObserver((Observer)((Object)this));
            }
            this.emd.deleteObserver((Observer)((Object)this));
            this.chassis.deleteObserver((Observer)((Object)this));
        }
    }

    public void destroy() {
        this.unRegisterWithModel();
        super.destroy();
    }

    private String getExtraMfgInfo(String string) {
        Map map = this.eqpmtModel.getExtraInfoMap();
        String string2 = (String)map.get(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    private synchronized void setCardWavelengths() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.tunableWavelength.length; ++i) {
            this.tunableWavelength[i] = i == 0 ? this.getExtraMfgInfo("WL") : this.getExtraMfgInfo("WL" + i);
            if (this.tunableWavelength[i].length() > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.tunableWavelength[i]);
                stringBuffer.append("nm");
            }
            db.info("WL" + i + "=" + this.tunableWavelength[i]);
        }
        this.tunableWavelengthsLBL.setText(stringBuffer.toString());
    }

    public void applyChangesToModel() throws Exception {
        if (db.on()) {
            db.println("calling applyChangesToModel");
        }
        try {
            this.setCursor(3);
            if (this.cardModeCB != null) {
                this.firstTrk.setWavelength(this.getWavelengthFromCB());
                this.eqpmtModel.setCardOperMode(this.getCardModeFromCB());
            } else {
                this.firstTrk.setDwdmCardConfig(this.getDwdmCardConfig());
            }
        }
        catch (ResourceInUse resourceInUse) {
            throw new ConfigError(resourceInUse.getMessage() + "\n" + this.CARD_MODE_RULE_MSG);
        }
        catch (DetailedConfigError detailedConfigError) {
            String string = "";
            switch (detailedConfigError.dataElement) {
                case 2: {
                    string = this.DATA_RATE_RULE_MSG;
                    break;
                }
                case 3: {
                    string = this.TERM_MODE_RULE_MSG;
                    break;
                }
                case 4: {
                    string = this.WAVE_LENGTH_RULE_MSG;
                    break;
                }
                case 5: {
                    string = REGEN_GROUP_RULE_MSG;
                }
            }
            throw new ConfigError(detailedConfigError.getMessage() + "\n" + string);
        }
        finally {
            this.setCursor(0);
        }
    }

    public void refreshFromModel() throws Exception {
        int n;
        if (db.on()) {
            db.println("calling refreshFromModel");
        }
        String string = (n = this.eqpmtModel.getEqType()) == 182 || n == 181 ? "declDwdmWLBandWavelength" : "declDwdmWavelength";
        if (this.cardModeCB != null) {
            this.cardModeCB.setSelectedItem(this.getAttributeValFor(this.cardModeKey, this.eqpmtModel.getCardOperMode().value()));
            this.wavelengthCB.setSelectedItem(this.getAttributeValFor(string, this.firstTrk.getWavelength()));
        } else {
            sDwdmCardConfig sDwdmCardConfig2 = this.firstTrk.getDwdmCardConfig();
            this.wavelengthCB.setSelectedItem(this.getAttributeValFor(string, sDwdmCardConfig2.wavelength.value()));
            if (this.squelchCB != null) {
                this.squelchCB.setSelectedItem(this.getAttributeValFor(this.squelchKey, sDwdmCardConfig2.aisSquelch.value()));
            }
            this.wavelengthCB.setSelectedItem(this.getAttributeValFor(string, sDwdmCardConfig2.wavelength.value()));
            if (this.squelchCB != null) {
                this.squelchCB.setSelectedItem(this.getAttributeValFor(this.squelchKey, sDwdmCardConfig2.aisSquelch.value()));
            }
            if (this.regenPeerCB != null) {
                this.curPeerSlot = sDwdmCardConfig2.regenPeerSlot;
                this.nameTF.setText(sDwdmCardConfig2.regenGroupName);
                this.updateRegenPeerCB();
                this.regenPeerCB.setSelectedItem(this.getAttributeValFor("declDwdmRegenPeer", this.curPeerSlot));
            }
            this.termModeCB.setSelectedItem(this.getAttributeValFor(this.termModeKey, sDwdmCardConfig2.termMode.value()));
            if (this.regenPeerCB != null) {
                this.curPeerSlot = sDwdmCardConfig2.regenPeerSlot;
                this.nameTF.setText(sDwdmCardConfig2.regenGroupName);
                this.updateRegenPeerCB();
                this.regenPeerCB.setSelectedItem(this.getAttributeValFor("declDwdmRegenPeer", this.curPeerSlot));
            }
            this.termModeCB.setSelectedItem(this.getAttributeValFor(this.termModeKey, sDwdmCardConfig2.termMode.value()));
            this.updateFramingTypeLabel();
            this.updateTermModeControl();
        }
        if (n == 182 || n == 181) {
            this.updateAISMode();
        }
        this.setCardWavelengths();
        this.resetDirty();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.regenPeerCB) {
            this.updateTermModeControl();
        } else if (object == this.termModeCB && (this.eqType == 182 || this.eqType == 181)) {
            this.updateAISMode();
        }
        this.setDirty();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        this.registerWithModel();
    }

    public void leavingPage() throws Exception {
        super.leavingPage();
        this.unRegisterWithModel();
    }

    private Set getYCableProtectedModuleModel() {
        TreeSet<IModuleModel> treeSet = new TreeSet<IModuleModel>(new EntityModel.EntityModelComparator());
        Iterator iterator = this.emd.getYCableEntities().iterator();
        while (iterator.hasNext()) {
            treeSet.add(((EntityModel)iterator.next()).getModuleModel());
        }
        return treeSet;
    }

    private synchronized void updateRegenPeerCB() {
        Object object;
        DwdmTrkLineModel[] dwdmTrkLineModelArray;
        if (this.regenPeerCB == null) {
            return;
        }
        List list = this.etm.getCompatibleModuleModelForRegenGroup(this.eqpmtModel);
        Set set = this.getYCableProtectedModuleModel();
        TreeSet<Attribute> treeSet = new TreeSet<Attribute>();
        int n = -1;
        treeSet.add(this.getAttributeValFor("declDwdmRegenPeer", 0));
        if (set.contains(this.eqpmtModel)) {
            dwdmTrkLineModelArray = new DwdmTrkLineModel[]{};
        } else {
            dwdmTrkLineModelArray = new DwdmTrkLineModel[list.size()];
            object = list.iterator();
            while (object.hasNext()) {
                DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)object.next();
                dwdmTrkLineModelArray[++n] = dwdmModuleModel.getFirstTrunkLine();
                if (dwdmModuleModel.hasRegenPeer() || set.contains(dwdmModuleModel)) continue;
                treeSet.add(this.getAttributeValFor("declDwdmRegenPeer", dwdmModuleModel.getSlot()));
            }
            treeSet.add(this.getAttributeValFor("declDwdmRegenPeer", this.curPeerSlot));
        }
        for (n = 0; n < this.peerFirstTrks.length; ++n) {
            this.peerFirstTrks[n].deleteObserver((Observer)((Object)this));
        }
        this.peerFirstTrks = dwdmTrkLineModelArray;
        for (n = 0; n < this.peerFirstTrks.length; ++n) {
            this.peerFirstTrks[n].addObserver((Observer)((Object)this));
        }
        object = this.regenPeerCB.getSelectedItem();
        this.regenPeerCB.removeActionListener(this);
        this.regenPeerCB.setModel(new DefaultComboBoxModel<Object>(treeSet.toArray()));
        this.regenPeerCB.addActionListener(this);
        if (object != null && this.regenPeerCB.getSelectedItem() != object) {
            this.regenPeerCB.setSelectedItem(object);
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.DwdmCardProvPane;
    }

    private int getDataRate() {
        int n = -1;
        try {
            n = this.firstTrk.getDataRate();
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        return n;
    }

    class WavelengthListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public WavelengthListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            boolean bl3 = false;
            for (int i = 0; i < DwdmCardProvPane.this.tunableWavelength.length && !(bl3 = this.maybeSetWavelength(string, DwdmCardProvPane.this.tunableWavelength[i], jList, bl, bl2)); ++i) {
            }
            if (!bl3) {
                this.setText(string);
                if (bl) {
                    this.setBackground(jList.getSelectionBackground());
                } else {
                    this.setBackground(Color.lightGray);
                }
            }
            this.setForeground(Color.black);
            this.setEnabled(jList.isEnabled() && DwdmCardProvPane.this.isUserAuthorized());
            this.setFont(jList.getFont());
            this.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : this.noFocusBorder);
            return this;
        }

        private boolean maybeSetWavelength(String string, String string2, JList jList, boolean bl, boolean bl2) {
            if (string2 != null) {
                StringBuffer stringBuffer = new StringBuffer(string2);
                stringBuffer.append("nm");
                if (string.equals(stringBuffer.toString())) {
                    this.setText(string + " **");
                    if (bl) {
                        this.setBackground(jList.getSelectionBackground());
                    } else {
                        this.setBackground(Color.white);
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

