/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sEtherMacAddr;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.If.eALSMode;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.IServiceState;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.IAdminTableAccess;
import cerent.cms.ui.dwdm.DwdmTableModel;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.MacAddrFormat;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.SoakTimePropertyEditor;
import java.awt.Component;

public class DwdmLineProvTableModel
extends DwdmTableModel
implements IAdminTableAccess {
    private long[] macAddr;
    private Attribute[] frameSize;
    protected AdminState[] adminState;
    protected IServiceState[] serviceState;
    protected Attribute[] alsMode;
    protected int[] soakTime;
    public static final int LINENUMBER_INDEX = 0;
    public static final int PORTNAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int SERVICE_STATE_INDEX = 3;
    public static final int ALS_MODE_INDEX = 4;
    public static final int FRAME_SIZE_INDEX = 5;
    public static final int MAC_ADDR_INDEX = 6;
    public static final int AINS_SOAK_INDEX = 7;
    public static final int NEXT_COLUMN_INDEX = 8;
    protected String[] columnNames = new String[]{"Port", "Port Name", "Admin State", "Service State", "ALS Mode", "Max. Size", "Incoming MAC Address", "AINS Soak"};
    protected boolean[][] isDirty;
    private boolean FlgDlgAlreadyShowed = false;
    private static final SDebug db = new SDebug("DwdmLineProvTableModel");
    static /* synthetic */ Class class$java$lang$Object;

    public DwdmLineProvTableModel(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super(db, abstractDwdmLineModelArray);
        this.refreshMyLines(abstractDwdmLineModelArray);
    }

    public void refreshMyLines(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        int n;
        super.refreshMyLines(abstractDwdmLineModelArray);
        this.adminState = new AdminState[this.numLines];
        this.serviceState = new IServiceState[this.numLines];
        this.alsMode = new Attribute[this.numLines];
        this.frameSize = new Attribute[this.numLines];
        this.macAddr = new long[this.numLines];
        this.soakTime = new int[this.numLines];
        for (n = 0; n < this.numLines; ++n) {
            this.macAddr[n] = -1L;
        }
        for (n = 0; n < this.numLines; ++n) {
            this.soakTime[n] = -1;
        }
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public Class getColumnClass(int n) {
        return class$java$lang$Object == null ? (class$java$lang$Object = DwdmLineProvTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0 && n2 != 3 && AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && (!this.isProtectedTrunkPort(n) || n2 != 4)) {
            return n2 == 4 ? this.isAlsSettable(n, n2) : n2 > 0;
        }
        return false;
    }

    private boolean isAlsSettable(int n, int n2) {
        if (n2 != 4 || this.model[n] == null) {
            return true;
        }
        return this.model[n].isAlsSettable();
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isAdminStateDirty(int n) {
        return this.isDirty(n, 2);
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return this.getPortName(n);
                }
                case 4: {
                    return this.getAlsMode(n);
                }
                case 2: {
                    return this.getAdminState(n).toString(this.getTerms());
                }
                case 3: {
                    return this.getServiceState(n).toString(this.getTerms());
                }
                case 5: {
                    return this.getMaxFrameSize(n);
                }
                case 6: {
                    return this.getMacAddress(n);
                }
                case 7: {
                    return this.getSoakTimeAsHHMM(n);
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("DwdmLineProvTableModel: error in getValueAt" + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public AdminState getAdminState(int n) throws Exception {
        if (this.adminState[n] == null) {
            eAdminState eAdminState2 = this.model[n].getAdminStateEnum();
            this.adminState[n] = AdminState.enumToAdminState(eAdminState2);
        }
        return this.adminState[n];
    }

    private IServiceState getServiceState(int n) throws NoSuchInterface {
        if (this.serviceState[n] == null) {
            sServiceState sServiceState2 = this.model[n].getServiceState();
            this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        }
        return this.serviceState[n];
    }

    private TDMTerminology getTerms() {
        return this.eqpmtModel.getNodeModel().getTDMTerminology();
    }

    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value row=" + n + " col=" + n2 + " newVal=" + object);
        }
        try {
            switch (n2) {
                case 1: {
                    this.portNames[n] = (String)object;
                    break;
                }
                case 4: {
                    Attribute attribute = (Attribute)object;
                    if (!this.model[n].supportsAutoALS() && eALSMode.from_int(attribute.getIntValue()) == eALSMode.AUTO) {
                        ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_AUTO_RESTART_NOT_SUPPORTED);
                        return;
                    }
                    if (attribute == this.alsMode[n]) {
                        return;
                    }
                    this.alsMode[n] = attribute;
                    break;
                }
                case 2: {
                    AdminState adminState = (AdminState)object;
                    if (adminState.equals(this.adminState[n])) {
                        return;
                    }
                    this.adminState[n] = adminState;
                    break;
                }
                case 5: {
                    Attribute attribute = (Attribute)object;
                    if (attribute == this.frameSize[n]) {
                        return;
                    }
                    this.frameSize[n] = attribute;
                    break;
                }
                case 6: {
                    long l = MacAddrFormat.parseMacAddr((String)object);
                    if (this.macAddr[n] == l) {
                        return;
                    }
                    this.macAddr[n] = l;
                    break;
                }
                case 7: {
                    int n3 = this.soakTime[n];
                    try {
                        n3 = SoakTimePropertyEditor.toIntValue((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        db.fine("Number Format Exception on " + (String)object);
                    }
                    if (this.soakTime[n] == n3) {
                        return;
                    }
                    this.soakTime[n] = n3;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return;
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    private void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.FlgDlgAlreadyShowed = false;
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.portNames[n] = null;
        this.adminState[n] = null;
        this.serviceState[n] = null;
        this.alsMode[n] = null;
        this.macAddr[n] = -1L;
        this.frameSize[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    protected eAdminState getAdminStateFor(int n) throws Exception {
        return this.getAdminState(n).getAdminStateEnum();
    }

    public void applyToModel() throws Exception {
        int n = 0;
        try {
            for (n = 0; n < this.numLines; ++n) {
                if (this.isDirty(n, 1)) {
                    this.model[n].setAlias(this.getPortName(n));
                    this.isDirty[n][1] = false;
                }
                if (this.isDirty(n, 4)) {
                    if (this.model[n].isSplitterProtectedLine() && this.alsMode[n].getIntValue() != 0) {
                        if (!this.FlgDlgAlreadyShowed) {
                            ErrorMsg.displayWarning(null, (EID)EMC.WID_ALS_WONT_ENGAGE);
                        }
                        this.FlgDlgAlreadyShowed = true;
                    }
                    this.model[n].setALSMode(this.getAlsMode(n).getIntValue());
                    this.isDirty[n][4] = false;
                }
                if (this.isDirty(n, 2)) {
                    if (db.on()) {
                        db.fine("setting line to admin state " + this.getAdminState(n).toString());
                    }
                    this.model[n].setAdminStateNoLpbk(this.getAdminStateFor(n));
                    this.isDirty[n][2] = false;
                }
                if (this.isDirty(n, 5)) {
                    this.model[n].setMaxFrame(this.getMaxFrameSize(n).getIntValue());
                    this.isDirty[n][5] = false;
                }
                if (this.isDirty[n][6]) {
                    this.model[n].setMacAddress(new sEtherMacAddr(MacAddrFormat.toBytes(this.macAddr[n])));
                    this.isDirty[n][6] = false;
                }
                if (!this.isDirty(n, 7)) continue;
                if (db.on()) {
                    db.println("setting line soakTime " + this.getSoakTime(n));
                }
                this.model[n].setSoakTime(this.getSoakTime(n));
            }
        }
        catch (DetailedConfigError detailedConfigError) {
            throw new ConfigError(detailedConfigError.getMessage());
        }
        catch (Exception exception) {
            throw new AnnotatedException("Error applying changes to row " + (n + 1), exception);
        }
    }

    private Attribute getAlsMode(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.alsMode[n] == null) {
            this.alsMode[n] = this.getAttributeFor("AlsMode", this.model[n].getALSMode());
        }
        return this.alsMode[n];
    }

    private Attribute getMaxFrameSize(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.frameSize[n] == null) {
            this.frameSize[n] = this.getAttributeFor("G1000 Port Max Size", this.model[n].getMaxFrame());
        }
        return this.frameSize[n];
    }

    private String getMacAddress(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.macAddr[n] == -1L) {
            this.macAddr[n] = MacAddrFormat.toLong(this.model[n].getMacAddress().addr);
        }
        return MacAddrFormat.formatMacAddr(this.macAddr[n]);
    }

    protected int getSoakTime(int n) throws NoSuchInterface {
        if (this.soakTime[n] == -1) {
            this.soakTime[n] = this.model[n].getSoakTime();
        }
        return this.soakTime[n];
    }

    private String getSoakTimeAsHHMM(int n) throws NoSuchInterface {
        return SoakTimePropertyEditor.toStringHHMM(this.getSoakTime(n));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

