/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.RmonLineUpdate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.DwdmCardDualPane;
import cerent.cms.ui.dwdm.DwdmPayloadPmPane;
import cerent.cms.ui.dwdm.FECPmPane;
import cerent.cms.ui.dwdm.OpticsPmHistPane;
import cerent.cms.ui.dwdm.OpticsPmStatPane;
import cerent.cms.ui.dwdm.OtnPmPane;
import java.awt.Component;

public class DwdmPerfPane
extends AbstractSubTabbedPane
implements ITabName {
    protected AbstractDwdmLineModel[] _lineModels;
    protected DwdmTrkLineModel[] _trunkModels;
    protected IRmonModel[] _rmonModels;
    protected TdmLineModel[] _sonetModels;
    protected boolean _supportsOTN;
    private AbstractPane _otnPmTab;
    private AbstractPane _payPmTab;
    private AbstractPane _optPmTab;

    public DwdmPerfPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
        this._lineModels = dwdmModuleModel.getDwdmLineModels();
        this._trunkModels = dwdmModuleModel.getDwdmTrkLineModels();
        this._sonetModels = dwdmModuleModel.getSonetLines();
        this._rmonModels = dwdmModuleModel.getRmonModels();
        this._supportsOTN = dwdmModuleModel.supportsOTN();
        this.registerWithModel();
    }

    protected void createSubTabs() {
        this._optPmTab = this.getOptPmTab("Optics PM");
        this._payPmTab = this.getPayloadPmTab("Payload PM");
        this.subTabs.addTab("Optics PM", (Component)((Object)this._optPmTab));
        this.subTabs.addTab("Payload PM", (Component)((Object)this._payPmTab));
        if (this._supportsOTN) {
            this._otnPmTab = this.getG709PmTab("OTN PM");
            this.subTabs.addTab("OTN PM", (Component)((Object)this._otnPmTab));
        }
        this.subTabs.setTabPlacement(2);
    }

    private AbstractPane getOptPmTab(String string) {
        return new AbstractSubTabbedPane(string, this.subTabs){

            public void createSubTabs() {
                this.subTabs.addTab("Current Values", (Component)((Object)new OpticsPmStatPane("Current Values", this.subTabs, DwdmPerfPane.this._lineModels)));
                this.subTabs.addTab("Historical PM", (Component)((Object)new OpticsPmHistPane("Historical PM", this.subTabs, DwdmPerfPane.this._lineModels)));
            }
        };
    }

    private AbstractPane getPayloadPmTab(String string) {
        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
        return new DwdmPayloadPmPane("Payload PM", this.subTabs, dwdmModuleModel, this._sonetModels, this._rmonModels);
    }

    private AbstractPane getG709PmTab(String string) {
        return new AbstractSubTabbedPane(string, this.subTabs){

            public void createSubTabs() {
                this.subTabs.addTab("G.709 PM", (Component)((Object)this.getOtnPmTab("G.709 PM", DwdmPerfPane.this._trunkModels)));
                this.subTabs.addTab("FEC PM", (Component)((Object)this.getFECPmTab("FEC PM", DwdmPerfPane.this._trunkModels)));
            }

            private DwdmCardDualPane getOtnPmTab(String string, DwdmTrkLineModel[] dwdmTrkLineModelArray) {
                return new DwdmCardDualPane(this.subTabs, dwdmTrkLineModelArray, new OtnPmPane(string, this.subTabs, dwdmTrkLineModelArray), 4);
            }

            private DwdmCardDualPane getFECPmTab(String string, DwdmTrkLineModel[] dwdmTrkLineModelArray) {
                return new DwdmCardDualPane(this.subTabs, dwdmTrkLineModelArray, new FECPmPane(string, this.subTabs, dwdmTrkLineModelArray), 4);
            }
        };
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof DwdmLineUpdate) {
            DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
            if (db.on()) {
                db.println("Received DwdmLineUpdate...");
            }
            this._lineModels = dwdmLineUpdate.getDwdmLineModels();
            this._trunkModels = dwdmLineUpdate.getDwdmTrkLineModels();
        } else if (object instanceof RmonLineUpdate) {
            RmonLineUpdate rmonLineUpdate = (RmonLineUpdate)object;
            this._rmonModels = rmonLineUpdate.getRmonModels();
        } else if (db.on()) {
            db.println("refreshMyLines received " + object);
        }
    }
}

