/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.dwdm.FECThresholdTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class FECThresholdProvPane
extends NodeProvPane
implements TableModelListener {
    DwdmTrkLineModel[] models;
    FECThresholdTableModel dataModel;
    eIntervalType intervalType = null;
    int numLines;
    boolean notInited = true;
    protected static final SDebug db = new SDebug("FECThresholdProvPane");

    public FECThresholdProvPane(String string, TabbedView tabbedView, DwdmTrkLineModel[] dwdmTrkLineModelArray, eIntervalType eIntervalType2) {
        super(string, tabbedView);
        this.models = dwdmTrkLineModelArray;
        this.intervalType = eIntervalType2;
    }

    protected void init() {
        this.numLines = this.models.length;
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.registerWithModel();
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.notInited = false;
    }

    protected void registerWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.models[i] == null) continue;
            this.models[i].addObserver((Observer)((Object)this));
        }
    }

    public void dispose() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.models[i] == null) continue;
            this.models[i].deleteObserver((Observer)((Object)this));
        }
    }

    public void leavingPage() throws Exception {
        if (this.table != null) {
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        }
        super.leavingPage();
    }

    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
        super.enteringPage();
    }

    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.notInited = true;
        super.destroy();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                FECThresholdProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.models).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            try {
                this.dataModel.refreshLineFromModel(n);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_ROW_PARAM_1, (Object)Integer.toString(n + 1));
            }
        } else if (db.on()) {
            db.println("changeMessage cannot find Model " + observable);
        }
    }

    public void applyChangesToModel() throws Exception {
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    protected FECThresholdTableModel getDataModel() {
        return new FECThresholdTableModel(this.models, this.intervalType);
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.FECThresholdProvPane;
    }
}

