/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Dwdm.eDwdmFecMode;
import cerent.cms.idl.Dwdm.sFECPmThresholds;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.dwdm.DwdmTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;

public class FECThresholdTableModel
extends DwdmTableModel {
    public static final String[] columnNames = new String[]{"Port", "Bit Errors Corrected", "Uncorrectable Words"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int BIT_ERROR_INDEX = 1;
    public static final int UNCORR_INDEX = 2;
    eIntervalType intervalType = null;
    protected sFECPmThresholds[] thresholdsVal;
    private boolean[] isDirty;
    private static final SDebug db = new SDebug("FECThresholdTableModel");
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Object;

    public FECThresholdTableModel(DwdmTrkLineModel[] dwdmTrkLineModelArray, eIntervalType eIntervalType2) {
        super(db, dwdmTrkLineModelArray);
        this.intervalType = eIntervalType2;
        this.refreshMyLines(dwdmTrkLineModelArray);
    }

    public void refreshMyLines(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super.refreshMyLines(abstractDwdmLineModelArray);
        this.isDirty = new boolean[this.numLines];
        this.thresholdsVal = new sFECPmThresholds[this.numLines];
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return class$java$lang$Long == null ? (class$java$lang$Long = FECThresholdTableModel.class$("java.lang.Long")) : class$java$lang$Long;
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = FECThresholdTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.isProtectedTrunkPort(n)) {
            return n2 > 0;
        }
        return false;
    }

    public boolean isRowDirty(int n) {
        return this.isDirty[n];
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return new Long(this.thresholdsVal[n].bitErrCor);
                }
                case 2: {
                    return new Long(this.thresholdsVal[n].uncorWords);
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("FECThresholdTableModel: error in getValueAt" + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        eDwdmFecMode eDwdmFecMode2;
        block13: {
            if (db.on()) {
                db.println("Change in value " + n + " " + n2);
            }
            eDwdmFecMode2 = eDwdmFecMode.STANDARD_FEC;
            DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)this.model[n];
            try {
                eDwdmFecMode2 = dwdmTrkLineModel.getFECMode();
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (db.on()) {
                    db.println("WrongInterfaceType Exception " + n);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) break block13;
                db.println("NoSuchInterface Exception " + n);
            }
        }
        long l = (Long)object;
        sFECPmThresholds sFECPmThresholds2 = this.thresholdsVal[n];
        try {
            switch (n2) {
                case 1: {
                    if (sFECPmThresholds2.bitErrCor == l) {
                        return;
                    }
                    AbstractDwdmLineModel cfr_ignored_0 = this.model[n];
                    this.validate(this.model[n].getValidationPrefix(1, this.intervalType, eDwdmFecMode2) + "BitErrorsCorrected", object.toString());
                    sFECPmThresholds2.bitErrCor = l;
                    break;
                }
                case 2: {
                    if (sFECPmThresholds2.uncorWords == l) {
                        return;
                    }
                    AbstractDwdmLineModel cfr_ignored_1 = this.model[n];
                    this.validate(this.model[n].getValidationPrefix(1, this.intervalType, eDwdmFecMode2) + "UncorrectableWords", object.toString());
                    sFECPmThresholds2.uncorWords = l;
                    break;
                }
                default: {
                    return;
                }
            }
            this.isDirty[n] = true;
            this.fireTableCellUpdated(n, n2);
        }
        catch (ProvisionError provisionError) {
            this.presentProvisionError(this.getColumnName(n2), provisionError);
        }
    }

    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) throws Exception {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        try {
            this.thresholdsVal[n] = ((DwdmTrkLineModel)this.model[n]).getFECThresholds(this.intervalType);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            throw new AnnotatedException("Error refreshing row " + (n + 1), exception);
        }
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.portNames[n] = null;
        this.thresholdsVal[n] = null;
        this.isDirty[n] = false;
    }

    public void applyToModel() throws Exception {
        if (db.on()) {
            db.println("applyToModel");
        }
        int n = 0;
        try {
            for (n = 0; n < this.numLines; ++n) {
                if (!this.isRowDirty(n)) continue;
                ((DwdmTrkLineModel)this.model[n]).setFECThresholds(this.thresholdsVal[n], this.intervalType);
                this.isDirty[n] = false;
            }
        }
        catch (ConfigError configError) {
            throw new AnnotatedException("Value(s) entered for row " + (n + 1) + " not in range", (Exception)((Object)configError));
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            throw new AnnotatedException("Error applying changes to row " + (n + 1), exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

