/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.dwdm.OpticalThresholdTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class OpticalThresholdProvPane
extends NodeProvPane
implements TableModelListener {
    protected AbstractDwdmLineModel[] models;
    protected OpticalThresholdTableModel dataModel;
    protected int thresholdLayer;
    private boolean notInited = true;
    private ObservableManager _obsMgr;
    private final String NOT_APPLICABLE_MSG = "This Threshold is not applicable given the current configuration";
    protected static final SDebug db = new SDebug("OpticalThresholdProvPane");

    public OpticalThresholdProvPane(String string, TabbedView tabbedView, DwdmModuleModel dwdmModuleModel, int n) {
        super(string, tabbedView);
        this.registerWithModel();
        this.models = dwdmModuleModel.getDwdmLineModels();
        this.thresholdLayer = n;
    }

    protected void init() {
        this.dataModel = this.getDataModel(this.thresholdLayer);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        TableColumn tableColumn = this.table.getColumn(OpticalThresholdTableModel.columnNames[0]);
        tableColumn.setPreferredWidth(50);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        this.getObsMgr().addObservable((Observable[])this.models);
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.table.setDefaultRenderer(this.dataModel.getColumnClass(1), new DwdmOpticsCellRenderer());
        this.notInited = false;
    }

    public void dispose() {
        db.info("Called dispose");
        if (this._obsMgr != null) {
            this._obsMgr.removeObservable((Observable[])this.models);
        }
        super.dispose();
    }

    public void leavingPage() throws Exception {
        this.getObsMgr().setPassing(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
        super.enteringPage();
        this.getObsMgr().setPassing(true);
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.notInited = true;
        super.destroy();
    }

    protected void removeColumn(int n) {
        String string = OpticalThresholdTableModel.columnNames[n];
        TableColumn tableColumn = this.table.getColumn(string);
        this.table.removeColumn(tableColumn);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected void changeMessage(Observable observable, Object object) {
        db.info("Got an Update Message for " + observable);
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                OpticalThresholdProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.models).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            try {
                this.dataModel.refreshLineFromModel(n);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_ROW_PARAM_1, (Object)Integer.toString(n + 1));
            }
        } else if (db.on()) {
            db.println("changeMessage cannot find Model " + observable);
        }
    }

    public void applyChangesToModel() throws NoSuchInterface, WrongInterfaceType, ConfigError {
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof DwdmLineUpdate) {
            DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
            if (db.on()) {
                db.println("Received DwdmLineUpdate...");
            }
            this.models = dwdmLineUpdate.getDwdmLineModels();
            if (!this.notInited) {
                this.getObsMgr().setObservable((Observable[])this.models);
                this.dataModel.refreshMyLines(this.models);
            }
        } else if (db.on()) {
            db.println("refreshMyLines received " + object);
        }
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    protected OpticalThresholdTableModel getDataModel(int n) {
        return new OpticalThresholdTableModel(this.models, n);
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.OpticalThresholdProvPane;
    }

    public class DwdmOpticsCellRenderer
    extends DefaultTableCellRenderer {
        public DwdmOpticsCellRenderer() {
            this.setOpaque(true);
            this.setHorizontalTextPosition(4);
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null && object instanceof Float) {
                int n3 = jTable.convertColumnIndexToModel(n2);
                if (!OpticalThresholdProvPane.this.dataModel.supportTxPower(n, n3)) {
                    this.setEnabled(false);
                    this.setToolTipText("This Threshold is not applicable given the current configuration");
                } else if (!OpticalThresholdProvPane.this.dataModel.supportOpticsMon(n, n3)) {
                    this.setEnabled(false);
                    this.setToolTipText("This Threshold is not applicable given the current configuration");
                } else {
                    this.setEnabled(true);
                    this.setToolTipText(null);
                }
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }
}

