/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.e13;

import cerent.cms.idl.Ds123Media.eThresholdType;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.PmThresholdsPane;
import cerent.cms.ui.TabbedView;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;

public abstract class E13LinePmThresholdsPane
extends AbstractPane {
    protected Ds123LineModel[] models = null;
    protected E13LineThresholdButtonPanel buttonPanel = null;
    protected JPanel tablePanel = null;
    protected Pane[] panes = null;
    protected Pane currentPane = null;
    protected CardLayout cl = null;
    public static final int ONE_DAY = 1;
    public static final int MIN_15 = 0;
    public static final String ONE_DAY_PANEL = "1Day";
    public static final String MIN_15_PANEL = "MIN_15";
    private static final SDebug db = new SDebug("Pane.E13LinePmThresholdsPane");

    public E13LinePmThresholdsPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray) {
        super(string, tabbedView);
        this.models = ds123LineModelArray;
        this.panes = new Pane[2];
        this.initializeLayout();
    }

    protected void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.add(this.getButtonPanel(), "North");
        this.add(this.getTablePanel(), "Center");
    }

    protected E13LineThresholdButtonPanel getButtonPanel() {
        this.buttonPanel = new E13LineThresholdButtonPanel();
        return this.buttonPanel;
    }

    protected JPanel getTablePanel() {
        this.tablePanel = new JPanel();
        this.cl = new CardLayout();
        this.tablePanel.setLayout(this.cl);
        this.tablePanel.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
        this.panes[1] = this.getE13PmThresholdsPane(ONE_DAY_PANEL, eThresholdType.THRESHOLD_1_DAY);
        this.tablePanel.add((Component)this.panes[1], ONE_DAY_PANEL);
        this.panes[0] = this.getE13PmThresholdsPane(MIN_15_PANEL, eThresholdType.THRESHOLD_15_MIN);
        this.tablePanel.add((Component)this.panes[0], MIN_15_PANEL);
        this.cl.show(this.tablePanel, MIN_15_PANEL);
        this.currentPane = this.panes[0];
        return this.tablePanel;
    }

    protected abstract PmThresholdsPane getE13PmThresholdsPane(String var1, eThresholdType var2);

    protected void showPanel(Pane pane) {
        block4: {
            try {
                this.currentPane.leavingPage();
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("Error in leaving page");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        try {
            pane.enteringPage();
        }
        catch (Exception exception) {
            db.finest("Exception in showPanel() " + exception);
        }
        this.cl.show(this.tablePanel, pane.getName());
        this.currentPane = pane;
    }

    public JTable getTable() {
        JTable jTable = null;
        if (this.currentPane != null) {
            jTable = this.currentPane.getTable();
        }
        return jTable;
    }

    public void leavingPage() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.leavingPage();
        }
    }

    public void enteringPage() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.enteringPage();
        }
    }

    public void refresh() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.refresh();
        }
    }

    public void destroy() {
        for (int i = 0; i < this.panes.length; ++i) {
            this.panes[i].destroy();
            this.panes[i] = null;
        }
        this.cl = null;
        this.buttonPanel = null;
        super.destroy();
    }

    protected class E13LineThresholdButtonPanel
    extends JPanel {
        public JRadioButton button15Min;
        public JRadioButton button1Day;
        public JButton showButton = new JButton("Show Thresholds");
        public ButtonGroup periodButtonGroup;

        public E13LineThresholdButtonPanel() {
            this.initialize();
        }

        protected void initialize() {
            this.button15Min = new JRadioButton("15 Min", true);
            this.button1Day = new JRadioButton("1 Day");
            this.periodButtonGroup = new ButtonGroup();
            this.periodButtonGroup.add(this.button15Min);
            this.periodButtonGroup.add(this.button1Day);
            this.showButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ E13LineThresholdButtonPanel this$1;
                {
                    this.this$1 = e13LineThresholdButtonPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.refreshAction();
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.button15Min, "North");
            jPanel.add((Component)this.button1Day, "South");
            this.setLayout(new FlowLayout(0));
            this.add(jPanel);
            this.add(this.showButton);
            this.setPreferredSize(new Dimension(800, 50));
        }

        protected void refreshAction() {
            if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                E13LinePmThresholdsPane.this.showPanel(E13LinePmThresholdsPane.this.panes[1]);
            } else {
                E13LinePmThresholdsPane.this.showPanel(E13LinePmThresholdsPane.this.panes[0]);
            }
        }
    }
}

