/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.e13;

import cerent.cms.idl.Ds123Media.eThresholdType;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.PmThresholdsPane;
import cerent.cms.ui.TabbedView;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;

public abstract class E13PathPmThresholdsPane
extends AbstractPane {
    protected Ds123LineModel[] models = null;
    protected E13PathThresholdButtonPanel buttonPanel = null;
    protected JPanel tablePanel = null;
    protected Pane[] panes = null;
    protected Pane currentPane = null;
    protected CardLayout cl = null;
    private static final int NE_15MIN = 0;
    private static final int NE_1DAY = 1;
    private static final int FE_15MIN = 2;
    private static final int FE_1DAY = 3;
    private static final String NE_15MIN_PANEL = "NE_15MIN";
    private static final String NE_1DAY_PANEL = "NE_1DAY";
    private static final String FE_15MIN_PANEL = "FE_15MIN";
    private static final String FE_1DAY_PANEL = "FE_1DAY";
    private static final SDebug db = new SDebug("Pane.E13PathPmThresholdPane");

    public E13PathPmThresholdsPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray) {
        super(string, tabbedView);
        this.models = ds123LineModelArray;
        this.panes = new Pane[4];
        this.initializeLayout();
    }

    protected void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.add(this.getButtonPanel(), "North");
        this.add(this.getTablePanel(), "Center");
    }

    protected abstract boolean showFarEnd();

    protected E13PathThresholdButtonPanel getButtonPanel() {
        this.buttonPanel = new E13PathThresholdButtonPanel();
        return this.buttonPanel;
    }

    protected JPanel getTablePanel() {
        this.tablePanel = new JPanel();
        this.cl = new CardLayout();
        this.tablePanel.setLayout(this.cl);
        this.tablePanel.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
        this.panes[0] = this.getE13PathPmThresholdsPane(NE_15MIN_PANEL, eThresholdType.THRESHOLD_15_MIN, true);
        this.tablePanel.add((Component)this.panes[0], NE_15MIN_PANEL);
        this.panes[1] = this.getE13PathPmThresholdsPane(NE_1DAY_PANEL, eThresholdType.THRESHOLD_1_DAY, true);
        this.tablePanel.add((Component)this.panes[1], NE_1DAY_PANEL);
        this.panes[2] = this.getE13PathPmThresholdsPane(FE_15MIN_PANEL, eThresholdType.THRESHOLD_15_MIN, false);
        this.tablePanel.add((Component)this.panes[2], FE_15MIN_PANEL);
        this.panes[3] = this.getE13PathPmThresholdsPane(FE_1DAY_PANEL, eThresholdType.THRESHOLD_1_DAY, false);
        this.tablePanel.add((Component)this.panes[3], FE_1DAY_PANEL);
        this.cl.show(this.tablePanel, NE_15MIN_PANEL);
        this.currentPane = this.panes[0];
        return this.tablePanel;
    }

    protected abstract PmThresholdsPane getE13PathPmThresholdsPane(String var1, eThresholdType var2, boolean var3);

    protected void showPanel(Pane pane) {
        block4: {
            try {
                this.currentPane.leavingPage();
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("Error in leaving page");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        try {
            pane.enteringPage();
        }
        catch (Exception exception) {
            db.finest("Exception in showPanel() " + exception);
        }
        this.cl.show(this.tablePanel, pane.getName());
        this.currentPane = pane;
    }

    public JTable getTable() {
        JTable jTable = null;
        if (this.currentPane != null) {
            jTable = this.currentPane.getTable();
        }
        return jTable;
    }

    public void leavingPage() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.leavingPage();
        }
    }

    public void enteringPage() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.enteringPage();
        }
    }

    public void refresh() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.refresh();
        }
    }

    public void dispose() {
        for (int i = 0; i < this.panes.length; ++i) {
            this.panes[i].destroy();
            this.panes[i] = null;
        }
        this.cl = null;
        this.buttonPanel = null;
    }

    protected class E13PathThresholdButtonPanel
    extends JPanel {
        public JRadioButton button15Min;
        public JRadioButton button1Day;
        public JRadioButton buttonNE;
        public JRadioButton buttonFE;
        public JButton showButton = new JButton("Show Thresholds");
        public ButtonGroup periodButtonGroup;
        public ButtonGroup NE_FE_ButtonGroup;
        protected int FE_MASK = 2;
        protected int ONE_DAY_MASK = 1;

        public E13PathThresholdButtonPanel() {
            this.initialize();
            this.buttonFE.setEnabled(E13PathPmThresholdsPane.this.showFarEnd());
        }

        protected void initialize() {
            this.button15Min = new JRadioButton("15 Min", true);
            this.button1Day = new JRadioButton("1 Day");
            this.periodButtonGroup = new ButtonGroup();
            this.periodButtonGroup.add(this.button15Min);
            this.periodButtonGroup.add(this.button1Day);
            this.buttonNE = new JRadioButton("Near End", true);
            this.buttonFE = new JRadioButton("Far End");
            this.NE_FE_ButtonGroup = new ButtonGroup();
            this.NE_FE_ButtonGroup.add(this.buttonNE);
            this.NE_FE_ButtonGroup.add(this.buttonFE);
            this.showButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ E13PathThresholdButtonPanel this$1;
                {
                    this.this$1 = e13PathThresholdButtonPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.refreshAction();
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.button15Min, "North");
            jPanel.add((Component)this.button1Day, "South");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)this.buttonNE, "North");
            jPanel2.add((Component)this.buttonFE, "South");
            this.setLayout(new FlowLayout(0));
            this.add(jPanel);
            this.add(jPanel2);
            this.add(this.showButton);
            this.setPreferredSize(new Dimension(800, 50));
        }

        protected void refreshAction() {
            int n = 0;
            if (this.NE_FE_ButtonGroup.getSelection() == this.buttonFE.getModel()) {
                n |= this.FE_MASK;
            }
            if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                n |= this.ONE_DAY_MASK;
            }
            switch (n) {
                case 0: {
                    E13PathPmThresholdsPane.this.showPanel(E13PathPmThresholdsPane.this.panes[0]);
                    break;
                }
                case 1: {
                    E13PathPmThresholdsPane.this.showPanel(E13PathPmThresholdsPane.this.panes[1]);
                    break;
                }
                case 2: {
                    E13PathPmThresholdsPane.this.showPanel(E13PathPmThresholdsPane.this.panes[2]);
                    break;
                }
                case 3: {
                    E13PathPmThresholdsPane.this.showPanel(E13PathPmThresholdsPane.this.panes[3]);
                }
            }
        }
    }
}

