/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ether;

import cerent.cms.idl.Rmon.eStatsId;
import cerent.cms.idl.Rmon.sTimedStats;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.EtherPmStatsSeries;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchStatsId;
import cerent.cms.model.NoSuchStatsSeries;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.ether.AbstractPmHistPane;
import cerent.util.gui.IFixedColumnsTableModel;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractPmHistTableModel
extends AbstractTableModel
implements IFixedColumnsTableModel {
    protected static final int RX_PACKETS = 0;
    protected static final int RX_BYTES = 1;
    protected static final int TX_PACKETS = 2;
    protected static final int TX_BYTES = 3;
    protected static final int RX_TOTAL_ERRORS = 4;
    protected static final int RX_FCS = 5;
    protected static final int RX_ALIGNMENT = 6;
    protected static final int RX_RUNTS = 7;
    protected static final int RX_SHORTS = 8;
    protected static final int RX_OVERSIZED_JABBERS = 9;
    protected String[] parmNames;
    public static final int FIXED_COLUMNS = 1;
    protected int numLines;
    protected boolean refresh;
    protected int nCols;
    protected sTimedStats[][] timedStats;
    protected EtherLineModel etherLineModel;
    protected String lastIntervalTimeStamp;
    private AbstractPmHistPane parent;
    private String[] colNames;
    private EventUtilities eventUtilities;
    private NodeModelDelegate nodeModel;
    static /* synthetic */ Class class$java$lang$String;

    public AbstractPmHistTableModel(AbstractPmHistPane abstractPmHistPane, ModuleModel moduleModel) {
        this.parent = abstractPmHistPane;
        this.refresh = false;
        this.nCols = 0;
        this.colNames = new String[0];
        this.lastIntervalTimeStamp = "";
        this.nodeModel = moduleModel.getNodeModelDelegate();
        this.eventUtilities = EventUtilities.getInstance(this.nodeModel);
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.parmNames[n];
        }
        if (this.refresh && n2 < this.timedStats[n].length + 1 && this.timedStats[n][n2 - 1] != null) {
            return new Long(this.timedStats[n][n2 - 1].count);
        }
        return "";
    }

    public void refreshCols(EtherPmStatsSeries etherPmStatsSeries) {
        this.setDisplayCols(etherPmStatsSeries);
        this.fireTableStructureChanged();
        this.parent.fixedUpColumn();
    }

    public abstract void refresh(EtherLineModel var1, EtherPmStatsSeries var2) throws NoSuchStatsSeries, NoSuchStatsId, NoSuchInterface;

    public void refreshWithoutLines(EtherPmStatsSeries etherPmStatsSeries) {
        this.etherLineModel = null;
        this.refresh = false;
        this.nCols = this.getStatsColCount(etherPmStatsSeries);
        this.timedStats = new sTimedStats[this.numLines][];
        this.lastIntervalTimeStamp = "";
        this.refreshCols(etherPmStatsSeries);
    }

    protected void refreshStats(EtherPmStatsSeries etherPmStatsSeries, int n) throws NoSuchStatsSeries, NoSuchStatsId, NoSuchInterface {
        switch (n) {
            case 0: {
                this.getStatsSeries(etherPmStatsSeries, n, eStatsId.STATS_IfInUcastPkts);
                this.getStatsSeries(etherPmStatsSeries, n, eStatsId.STATS_IfInMulticastPkts);
                this.getStatsSeries(etherPmStatsSeries, n, eStatsId.STATS_IfInBroadcastPkts);
                break;
            }
            case 1: {
                this.getStatsSeries(etherPmStatsSeries, n, eStatsId.STATS_IfInOctets);
                break;
            }
            case 2: {
                this.getStatsSeries(etherPmStatsSeries, n, eStatsId.STATS_IfOutUcastPkts);
                this.getStatsSeries(etherPmStatsSeries, n, eStatsId.STATS_IfOutMulticastPkts);
                this.getStatsSeries(etherPmStatsSeries, n, eStatsId.STATS_IfOutBroadcastPkts);
                break;
            }
            case 3: {
                this.getStatsSeries(etherPmStatsSeries, n, eStatsId.STATS_IfOutOctets);
                break;
            }
            case 4: {
                this.getStatsSeries(etherPmStatsSeries, n, eStatsId.STATS_Dot3StatsFCSErrors);
                this.getStatsSeries(etherPmStatsSeries, n, eStatsId.STATS_Dot3StatsAlignmentErrors);
                this.getStatsSeries(etherPmStatsSeries, n, eStatsId.STATS_EtherStatsUndersizePkts);
                this.getStatsSeries(etherPmStatsSeries, n, eStatsId.STATS_EtherStatsOversizePkts);
                this.getStatsSeries(etherPmStatsSeries, n, eStatsId.STATS_EtherStatsFragments);
                this.getStatsSeries(etherPmStatsSeries, n, eStatsId.STATS_EtherStatsJabbers);
                break;
            }
            case 5: {
                this.getStatsSeries(etherPmStatsSeries, n, eStatsId.STATS_Dot3StatsFCSErrors);
                break;
            }
            case 6: {
                this.getStatsSeries(etherPmStatsSeries, n, eStatsId.STATS_Dot3StatsAlignmentErrors);
                break;
            }
            case 7: {
                this.getStatsSeries(etherPmStatsSeries, n, eStatsId.STATS_EtherStatsFragments);
                break;
            }
            case 8: {
                this.getStatsSeries(etherPmStatsSeries, n, eStatsId.STATS_EtherStatsUndersizePkts);
                break;
            }
            case 9: {
                this.getStatsSeries(etherPmStatsSeries, n, eStatsId.STATS_EtherStatsOversizePkts);
                this.getStatsSeries(etherPmStatsSeries, n, eStatsId.STATS_EtherStatsJabbers);
            }
        }
    }

    public String getLastIntervalTimeStamp() {
        return this.lastIntervalTimeStamp;
    }

    protected void getStatsSeries(EtherPmStatsSeries etherPmStatsSeries, int n, eStatsId eStatsId2) throws NoSuchStatsSeries, NoSuchStatsId, NoSuchInterface {
        sTimedStats[] sTimedStatsArray = this.etherLineModel.getStatsSeries(etherPmStatsSeries, eStatsId2);
        if (this.lastIntervalTimeStamp.length() == 0 && sTimedStatsArray.length > 0) {
            this.lastIntervalTimeStamp = this.eventUtilities.convertSecondsToLongDateFormat(sTimedStatsArray[0].timeStamp);
        }
        for (int i = 0; i < sTimedStatsArray.length; ++i) {
            this.timedStats[n][i].count += sTimedStatsArray[i].count;
        }
    }

    protected sTimedStats[] createColsDefaultData(int n) {
        sTimedStats[] sTimedStatsArray = new sTimedStats[n];
        for (int i = 0; i < n; ++i) {
            sTimedStatsArray[i] = new sTimedStats(0L, 0);
        }
        return sTimedStatsArray;
    }

    private void setDisplayCols(EtherPmStatsSeries etherPmStatsSeries) {
        this.nCols = this.getStatsColCount(etherPmStatsSeries);
        this.colNames = new String[this.nCols];
        for (int i = 0; i < this.nCols; ++i) {
            this.colNames[i] = i > 0 ? "Prev-" + i : "Prev";
        }
    }

    protected int getStatsColCount(EtherPmStatsSeries etherPmStatsSeries) {
        try {
            return etherPmStatsSeries.getMaxBuckets();
        }
        catch (Exception exception) {
            return 1;
        }
    }

    public Class getColumnClass(int n) {
        return class$java$lang$String == null ? (class$java$lang$String = AbstractPmHistTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public int getColumnCount() {
        return 1 + this.nCols;
    }

    public String getColumnName(int n) {
        if (n < 1) {
            return "Param";
        }
        return this.colNames[n - 1];
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getFixedColumnCount() {
        return 1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

