/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ether;

import cerent.cms.idl.Common.sTime;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SecurityModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.BaselineStatsDialog;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.ClearStatsDialog;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ether.AbstractPmStatTableModel;
import cerent.cms.ui.ether.EtherPmCellRenderer;
import cerent.cms.ui.ether.EtherPortTableHeaderRenderer;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.IAsyncObserver;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.job.JobStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class EtherPmStatPane
extends AbstractPane
implements ActionListener,
IAsyncObserver,
Runnable {
    protected EtherLineModel[] lineModels;
    protected NodeModelDelegate nodeModel;
    public static final String REFRESH = "Refresh";
    private JButton refreshPB;
    public static final String ZERO = "Clear...";
    public static final String ZERO_TOOLTIP = "Initialize current registers to zero";
    private JButton zeroPB;
    public static final String BASELINE = "Baseline...";
    public static final String BASELINE_TOOLTIP = "Establish current data as a baseline reference";
    private JButton baselinePB;
    private JLabel dateLB;
    private EtherPmCellRenderer pmCellRenderer;
    private Timer refreshTimer;
    private RefreshTimerListener refreshTimerListener;
    private static final String CLEAR_CURRENT_MSG = "Proceeding will clear these statistics on the card\nand cannot be undone.  Do you really want to initialize\nthe currently selected registers to zero (port";
    private static final String CLEAR_PORT_MSG = "Proceeding will clear these statistics on the card\nand cannot be undone.  Do you really want to initialize\nall current registers on port ";
    private static final String CLEAR_CARD_MSG = "Proceeding will clear these statistics on the card\nand cannot be undone.  Do you really want to initialize\nall current registers on all ports of the card to zero?";
    private static final String[] rateStrs = new String[]{"None", "15 Seconds", "30 Seconds", "1 Minute", "3 Minutes", "5 Minutes"};
    private static final int[] rates = new int[]{86400000, 15000, 30000, 60000, 180000, 300000};
    private static final String AUTOREFRESH_PREF = "ctc";
    private static final String AUTOREFRESH_KEY = "PM-auto-refresh-rate";
    private UComboBox refreshComboBox;
    private boolean enteringPage = false;
    protected AbstractPmStatTableModel dataModel;
    private boolean inited = false;
    private JobStatus jobStatus;
    private String statusString;
    private JTable table2;
    private UScrollPane scrollPane;
    private TableColumn colZero;
    private SecurityModel secModel;
    private Observer pmClearObserver;
    private MouseListener headerListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent mouseEvent) {
            JTable jTable = ((JTableHeader)mouseEvent.getComponent()).getTable();
            if (jTable != null) {
                Point point = mouseEvent.getPoint();
                int n = jTable.getTableHeader().columnAtPoint(point);
                if (n != -1) {
                    jTable.addColumnSelectionInterval(n, n);
                }
            }
        }
    };
    private static final SDebug db = new SDebug("Pane.EtherPmStatPane");
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$String;

    public EtherPmStatPane(String string, TabbedView tabbedView, EtherLineModel[] etherLineModelArray, AbstractPmStatTableModel abstractPmStatTableModel) {
        super(string, tabbedView);
        this.lineModels = etherLineModelArray;
        this.dataModel = abstractPmStatTableModel;
        this.setLayout(new BorderLayout());
        this.nodeModel = ((ModuleModel)this.getUiModel()).getNodeModelDelegate();
    }

    private void init() {
        this.refreshTimer = null;
        this.refreshTimerListener = new RefreshTimerListener();
        this.pmCellRenderer = new EtherPmCellRenderer();
        this.table = new UTable((TableModel)this.dataModel);
        this.table.getTableHeader().setUpdateTableInRealTime(true);
        this.table.setDefaultRenderer(class$java$lang$Long == null ? (class$java$lang$Long = EtherPmStatPane.class$("java.lang.Long")) : class$java$lang$Long, this.pmCellRenderer);
        this.table.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = EtherPmStatPane.class$("java.lang.String")) : class$java$lang$String, this.pmCellRenderer);
        this.table.setColumnSelectionAllowed(true);
        this.table.setRowSelectionAllowed(false);
        this.table.setSelectionMode(0);
        this.scrollPane = new UScrollPane((Component)this.table);
        this.table2 = new UTable((TableModel)this.dataModel);
        ((UTable)this.table2).setExportable(false);
        this.table2.getTableHeader().setUpdateTableInRealTime(false);
        this.table2.setColumnSelectionAllowed(false);
        this.table2.setRowSelectionAllowed(false);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        this.colZero = tableColumnModel.getColumn(0);
        Font font = this.table.getTableHeader().getFont();
        FontMetrics fontMetrics = this.table.getTableHeader().getFontMetrics(font);
        int n = fontMetrics.stringWidth(this.dataModel.widestParmName()) + 20;
        this.colZero.setPreferredWidth(n);
        this.colZero.setResizable(false);
        this.colZero.setMinWidth(n);
        this.colZero.setMaxWidth(n);
        this.updateColumnHeader();
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().addMouseListener(this.headerListener);
        this.dateLB = new JLabel(" ");
        this.dateLB.setAlignmentX(0.0f);
        this.scrollPane.setAlignmentX(0.0f);
        JPanel jPanel = EtherPmStatPane.createVerticalPanel(null);
        JPanel jPanel2 = EtherPmStatPane.createHorizontalPanel(null);
        jPanel2.setLayout(new FlowLayout(0, 5, 5));
        jPanel2.add(this.dateLB);
        jPanel.add(this.getButtonBar());
        jPanel.add(jPanel2);
        this.add(jPanel, "South");
        this.add((Component)this.scrollPane, "Center");
    }

    protected void updateColumnHeader() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
        int n = this.table.getFontMetrics(this.table.getFont()).stringWidth("888/88/88 88:88:88 8888");
        for (int i = 0; i < this.lineModels.length; ++i) {
            tableColumnModel.getColumn(i).setHeaderRenderer(new EtherPortTableHeaderRenderer());
            PortModel portModel = null;
            try {
                portModel = (PortModel)this.lineModels[i].getPortModel();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            tableColumnModel.getColumn(i).setHeaderValue(portModel);
            tableColumnModel.getColumn(i).setPreferredWidth(n);
        }
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        defaultTableColumnModel.addColumn(this.colZero);
        this.table2.setColumnModel(defaultTableColumnModel);
        this.table2.setPreferredScrollableViewportSize(new Dimension(this.colZero.getPreferredWidth() + this.table2.getColumnModel().getColumnMargin(), 0));
        this.table2.getTableHeader().setReorderingAllowed(false);
        this.scrollPane.setRowHeaderView((Component)this.table2);
        this.scrollPane.setCorner("UPPER_LEFT_CORNER", (Component)this.table2.getTableHeader());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshPB) {
            this.refreshNow();
        } else if (object == this.baselinePB) {
            this.baselineStats();
        } else if (object == this.zeroPB) {
            this.clearStats();
        } else if (db.on()) {
            db.println("actionPerformed by unknown component");
        }
    }

    protected String getAllPortsBaseLineTitle() {
        return null;
    }

    private void baselineStats() {
        int[] nArray = this.table.getSelectedColumns();
        int n = nArray.length > 0 ? nArray[0] + 1 : -1;
        BaselineStatsDialog baselineStatsDialog = new BaselineStatsDialog(this.uiToolkit.getApplicationFrame(), this.getPortNums(n));
        baselineStatsDialog.setAllPortRadioButtonTitle(this.getAllPortsBaseLineTitle());
        baselineStatsDialog.setVisible(true);
        int n2 = baselineStatsDialog.getChoice();
        if (n2 != 0) {
            if ((n2 & 4) != 0) {
                if ((n2 & 2) != 0) {
                    this.dataModel.setBaseline();
                } else {
                    this.dataModel.setBaseline(n);
                }
            } else if ((n2 & 2) != 0) {
                this.dataModel.resetBaseline();
            } else {
                this.dataModel.resetBaseline(n);
            }
        }
        baselineStatsDialog.dispose();
    }

    protected String getAllPortsClearStatsTitle() {
        return null;
    }

    private void clearStats() {
        int n;
        String string = null;
        int[] nArray = this.table.getSelectedColumns();
        int n2 = nArray.length > 0 ? nArray[0] + 1 : -1;
        int[] nArray2 = this.getPortNums(n2);
        ClearStatsDialog clearStatsDialog = new ClearStatsDialog(this.uiToolkit.getApplicationFrame(), nArray2, false);
        clearStatsDialog.setAllPortRadioButtonTitle(this.getAllPortsClearStatsTitle());
        clearStatsDialog.setVisible(true);
        switch (clearStatsDialog.getChoice()) {
            case 0: {
                if (!db.on()) break;
                db.println("CLEAR_NONE");
                break;
            }
            case 1: {
                if (db.on()) {
                    db.println("CLEAR SELECTED");
                }
                string = CLEAR_CURRENT_MSG + (nArray.length > 1 ? "s " : " ");
                for (n = 0; n < nArray.length; ++n) {
                    nArray[n] = nArray[n] + 1;
                    string = string + nArray[n] + (n < nArray.length - 1 ? ", " : "");
                }
                string = string + ")?";
                break;
            }
            case 2: {
                String string2 = PortHelper.getConcatenatedString((int[])nArray2);
                if (db.on()) {
                    db.println("CLEAR PORT " + string2);
                }
                string = CLEAR_PORT_MSG + string2 + "?";
                nArray = new int[]{n2};
                break;
            }
            case 3: {
                if (db.on()) {
                    db.println("CLEAR ALL PORTS");
                }
                string = CLEAR_CARD_MSG;
                nArray = new int[this.lineModels.length];
                for (int i = 1; i <= this.lineModels.length; ++i) {
                    nArray[i - 1] = i;
                }
                break;
            }
            default: {
                if (!db.on()) break;
                db.println("NOTHING SELECTED!");
            }
        }
        clearStatsDialog.dispose();
        if (string != null && CerentDialog.yesNoDialog((Component)((Object)this), (String)string, (String)"Zero Data")) {
            if (db.on()) {
                db.print("calling dataModel.clearStats( [");
                for (n = 0; n < nArray.length; ++n) {
                    db.print(nArray[n] + (n < nArray.length - 1 ? "," : ""));
                }
                db.println("] )");
            }
            this.dataModel.clearStats(nArray);
            this.refreshNow();
        }
    }

    private int[] getPortNums(int n) {
        int[] nArray = new int[]{n};
        InterfaceModel interfaceModel = null;
        if (n > 0 && n <= this.lineModels.length) {
            interfaceModel = this.lineModels[n - 1];
        }
        if (interfaceModel != null) {
            PortModel portModel;
            block5: {
                portModel = null;
                try {
                    portModel = (PortModel)interfaceModel.getPortModel();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!EtherPmStatPane.db.on) break block5;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            if (portModel != null) {
                nArray = portModel.getPortNum();
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshNow() {
        try {
            this.setCursor(3);
            if (this.dataModel != null) {
                this.refreshPB.setEnabled(false);
                this.dataModel.refreshData(this);
            } else if (db.on()) {
                db.println("  The dataModel is null!!");
            }
            this.dateLB.setText("Retrieving Statistics ...");
        }
        catch (Exception exception) {
            db.println("Caught exception in EtherPmStatPane.refreshNow: " + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            this.setCursor(0);
        }
    }

    public void enteringPage() {
        this.enteringPage = true;
        if (!this.inited) {
            this.init();
        }
        this.secModel.addObserver(this.pmClearObserver);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        if (this.table.getColumnCount() > 0) {
            this.table.addColumnSelectionInterval(0, 0);
        }
        int n = Preferences.instance().getInt(AUTOREFRESH_PREF, AUTOREFRESH_KEY, 0);
        if (null != this.refreshComboBox) {
            int n2 = this.getIndexForMillis(n);
            this.refreshComboBox.setSelectedIndex(n2);
            if (null != this.refreshTimer) {
                if (0 == n2) {
                    if (db.on()) {
                        db.println("Stopping auto-refresh timer.A");
                    }
                    this.refreshTimer.stop();
                } else if (!this.refreshTimer.isRunning()) {
                    if (db.on()) {
                        db.println("Starting auto-refresh timer.B delay = " + this.refreshTimer.getDelay());
                    }
                    this.refreshTimer.start();
                } else if (db.on()) {
                    db.println("refreshTimer was already running with delay = " + this.refreshTimer.getDelay());
                }
            }
        }
        if (!this.inited) {
            this.refreshNow();
            this.inited = true;
        }
        this.enteringPage = false;
    }

    public void leavingPage() {
        this.secModel.deleteObserver(this.pmClearObserver);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (null != this.refreshComboBox) {
            this.saveAutoRefreshPref();
        }
        if (null != this.refreshTimer) {
            if (db.on()) {
                db.println("Stopping auto-refresh timer.B");
            }
            this.refreshTimer.stop();
        }
        this.dataModel.resetBaseline();
    }

    private int getIndexForMillis(int n) {
        int n2 = 0;
        for (int i = 0; i < rates.length; ++i) {
            if (rates[i] != n) continue;
            n2 = i;
        }
        return n2;
    }

    private void saveAutoRefreshPref() {
        if (null != this.refreshComboBox) {
            int n = this.refreshComboBox.getSelectedIndex();
            int n2 = rates[n];
            Preferences.instance().setInt(AUTOREFRESH_PREF, AUTOREFRESH_KEY, n2);
        }
    }

    public void refresh() {
    }

    public void updateTimeLabel() {
        String string = "Retrieved: " + EtherPmStatPane.getFormattedDateTime();
        if (this.dataModel.isNeTimestampPresent()) {
            try {
                sTime sTime2 = this.nodeModel.getTime();
                GregorianCalendar gregorianCalendar = new GregorianCalendar(sTime2.year, sTime2.month - 1, sTime2.day, sTime2.hour, sTime2.minute, sTime2.second);
                string = string + "  (NE Time:" + DateFormat.getDateTimeInstance(1, 1).format(gregorianCalendar.getTime()) + ")";
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                // empty catch block
            }
        }
        this.dateLB.setText(string);
    }

    private JPanel getButtonBar() {
        JPanel jPanel = EtherPmStatPane.createHorizontalPanel(null);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 20));
        this.refreshPB = new JButton(REFRESH);
        this.refreshPB.addActionListener(this);
        this.refreshPB.setAlignmentY(0.5f);
        JPanel jPanel2 = new JPanel();
        this.refreshComboBox = new UComboBox((Object[])rateStrs);
        this.refreshComboBox.addItemListener((ItemListener)new RefreshComboBoxListener());
        jPanel2.add(new JLabel("Auto-refresh:"));
        jPanel2.add((Component)this.refreshComboBox);
        this.baselinePB = new JButton(BASELINE);
        this.baselinePB.addActionListener(this);
        this.baselinePB.setToolTipText(BASELINE_TOOLTIP);
        this.enableComponent(this.baselinePB);
        jPanel.add(Box.createHorizontalStrut(4));
        jPanel.add(this.refreshPB);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jPanel2);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.baselinePB);
        this.zeroPB = new JButton(ZERO);
        this.pmClearObserver = new Observer(){

            public void update(Observable observable, Object object) {
                EtherPmStatPane.this.enableZeroPB();
            }
        };
        this.secModel = (SecurityModel)this.nodeModel.getSecurityModel();
        this.enableZeroPB();
        if (this.dataModel.isPmClearingSupported()) {
            this.zeroPB.setAlignmentY(0.5f);
            this.zeroPB.setToolTipText(ZERO_TOOLTIP);
            this.zeroPB.setVisible(true);
            this.zeroPB.addActionListener(this);
            jPanel.add(Box.createHorizontalStrut(4));
            jPanel.add(this.zeroPB);
        }
        jPanel.add(Box.createHorizontalStrut(4));
        jPanel.add(new CSHelpButton(CSHelpConst.EtherPmStatPane));
        jPanel.add(Box.createHorizontalStrut(4));
        return jPanel;
    }

    public void dispose() {
        if (this.table != null && this.table.getTableHeader() != null) {
            this.table.getTableHeader().removeMouseListener(this.headerListener);
        }
        if (this.dataModel != null) {
            this.dataModel.dispose();
        }
        super.dispose();
    }

    public void asyncUpdate(Object object, JobStatus jobStatus) {
        this.statusString = (String)object;
        this.jobStatus = jobStatus;
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        if (this.jobStatus == JobStatus.JOB_COMPLETE) {
            this.updateTimeLabel();
            this.refreshPB.setEnabled(true);
        } else if (this.statusString != null) {
            this.dateLB.setText("Retrieving " + this.statusString + "...");
        }
    }

    protected boolean isInited() {
        return this.inited;
    }

    protected Runnable getColumnHeaderRefreshThread() {
        return new Runnable(){

            public void run() {
                EtherPmStatPane.this.updateColumnHeader();
            }
        };
    }

    private void enableZeroPB() {
        super.enableComponent(this.zeroPB, this.secModel, SecurityLevel.from_int((int)this.secModel.getPmClearingPrivilege().value()));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RefreshTimerListener
    implements ActionListener {
        private RefreshTimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EtherPmStatPane.this.refreshNow();
        }
    }

    private class RefreshComboBoxListener
    implements ItemListener {
        private RefreshComboBoxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (1 == itemEvent.getStateChange()) {
                int n = EtherPmStatPane.this.refreshComboBox.getSelectedIndex();
                if (!EtherPmStatPane.this.enteringPage) {
                    IgnorableDialog.infoDialog((Component)EtherPmStatPane.this.getParentView(), (String)"The selected auto-refresh value will be applied to all\nperformance monitoring for the current user. ", (String)"Notice", (String)"IgnoreAutoRefreshMessage", (String)"Warn auto refresh affects all performance monitoring for user");
                }
                if (n == 0) {
                    if (EtherPmStatPane.this.refreshTimer.isRunning()) {
                        if (db.on()) {
                            db.println("Stopping auto-refresh timer.C");
                        }
                        EtherPmStatPane.this.refreshTimer.stop();
                    }
                } else if (n > 0 && n < rates.length) {
                    if (null != EtherPmStatPane.this.refreshTimer) {
                        if (db.on()) {
                            db.println("Stopping auto-refresh timer.D");
                        }
                        EtherPmStatPane.this.refreshTimer.stop();
                    }
                    EtherPmStatPane.this.refreshTimer = null;
                    EtherPmStatPane.this.refreshTimer = new Timer(rates[n], EtherPmStatPane.this.refreshTimerListener);
                    if (db.on()) {
                        db.println("Starting auto-refresh timer.A");
                    }
                    EtherPmStatPane.this.refreshTimer.start();
                } else {
                    if (db.on()) {
                        db.println("Stopping auto-refresh timer.E");
                    }
                    EtherPmStatPane.this.refreshTimer.stop();
                }
                EtherPmStatPane.this.saveAutoRefreshPref();
            }
        }
    }
}

