/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ether;

import cerent.cms.model.EtherBridgeModel;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.EtherLineUpdate;
import cerent.cms.model.EtherPmModel;
import cerent.cms.model.EtherPmStatsSeries;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ether.EtherPmUtilTableModel;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.TransmitReceivePercentCellRenderer;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class EtherPmUtilPane
extends AbstractPane
implements ActionListener,
Observer {
    private int[] widths = new int[]{150, 80};
    private JButton retrieveButton;
    private JLabel retrievalTime;
    private UComboBox seriesCB;
    private EtherPmModel etherPmModel;
    protected EtherPmUtilTableModel dataModel;
    protected EtherLineModel[] lineModels;
    private EtherPmStatsSeries[] etherPmStatsSeriesList = new EtherPmStatsSeries[0];
    private ObservableManager obsMgr = null;
    private static final SDebug db = new SDebug("EtherPmUtilPane");
    static /* synthetic */ Class class$cerent$util$gui$TransmitReceive;

    public EtherPmUtilPane(String string, TabbedView tabbedView, ModuleModel moduleModel, EtherLineModel[] etherLineModelArray) {
        super(string, tabbedView);
        Serializable serializable;
        this.etherPmModel = ((EtherBridgeModel)moduleModel.getNodeModel().getEtherBridgeModel()).getEtherPmModel();
        this.setLayout(new BorderLayout());
        this.lineModels = etherLineModelArray;
        this.dataModel = new EtherPmUtilTableModel(this, moduleModel, etherLineModelArray);
        this.retrievalTime = new JLabel(" ");
        this.retrievalTime.setHorizontalAlignment(0);
        this.table = new UTable((TableModel)this.dataModel);
        this.table.getTableHeader().setUpdateTableInRealTime(true);
        this.table.setDefaultRenderer(class$cerent$util$gui$TransmitReceive == null ? (class$cerent$util$gui$TransmitReceive = EtherPmUtilPane.class$("cerent.util.gui.TransmitReceive")) : class$cerent$util$gui$TransmitReceive, new TransmitReceivePercentCellRenderer());
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        UTable uTable = new UTable((TableModel)this.dataModel);
        uTable.setExportable(false);
        uTable.getTableHeader().setUpdateTableInRealTime(false);
        uTable.setDefaultRenderer(class$cerent$util$gui$TransmitReceive == null ? (class$cerent$util$gui$TransmitReceive = EtherPmUtilPane.class$("cerent.util.gui.TransmitReceive")) : class$cerent$util$gui$TransmitReceive, new TransmitReceivePercentCellRenderer());
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        this.table.setRowHeight(new JTextArea().getPreferredSize().height * 2 + 1);
        uTable.setRowHeight(new JTextArea().getPreferredSize().height * 2 + 1);
        for (int i = 0; i < this.dataModel.getFixedColumnCount(); ++i) {
            serializable = tableColumnModel.getColumn(0);
            tableColumnModel.removeColumn((TableColumn)serializable);
            ((TableColumn)serializable).setPreferredWidth(this.widths[i]);
            ((TableColumn)serializable).setResizable(false);
            ((TableColumn)serializable).setMinWidth(this.widths[i]);
            ((TableColumn)serializable).setMaxWidth(this.widths[i]);
            defaultTableColumnModel.addColumn((TableColumn)serializable);
        }
        this.table.setColumnModel(tableColumnModel);
        uTable.setColumnModel(defaultTableColumnModel);
        uTable.setPreferredScrollableViewportSize(uTable.getPreferredSize());
        uTable.getTableHeader().setReorderingAllowed(false);
        uTable.setAutoCreateColumnsFromModel(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(false);
        uTable.setCellSelectionEnabled(false);
        uTable.setRowSelectionAllowed(false);
        uScrollPane.setRowHeaderView((Component)uTable);
        uScrollPane.setCorner("UPPER_LEFT_CORNER", (Component)uTable.getTableHeader());
        JPanel jPanel = EtherPmUtilPane.createVerticalPanel(null);
        this.retrievalTime.setAlignmentX(0.0f);
        uScrollPane.setAlignmentX(0.0f);
        serializable = EtherPmUtilPane.createHorizontalPanel(null);
        ((Container)serializable).setLayout(new FlowLayout(0, 5, 5));
        ((Container)serializable).add(this.retrievalTime);
        jPanel.add(this.makeControlPanel());
        jPanel.add((Component)serializable);
        this.add(jPanel, "South");
        this.add((Component)uScrollPane, "Center");
        this.registerWithModel();
    }

    public void fixedUpColumn() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < this.dataModel.getFixedColumnCount(); ++i) {
            tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
        }
        this.table.repaint();
    }

    private JPanel makeControlPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = EtherPmUtilPane.createHorizontalPanel(null);
        this.etherPmStatsSeriesList = this.etherPmModel.getEtherPmStatsSeries();
        this.seriesCB = new UComboBox(this.statsSeriesToVector(this.etherPmStatsSeriesList));
        if (this.etherPmStatsSeriesList != null && this.etherPmStatsSeriesList.length > 0) {
            this.seriesCB.setSelectedIndex(0);
            this.dataModel.refreshCols(this.etherPmStatsSeriesList[this.seriesCB.getSelectedIndex()]);
        }
        this.retrieveButton = new JButton("Refresh");
        this.retrieveButton.addActionListener(this);
        jPanel2.add(new JLabel("Interval:"));
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)this.seriesCB);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this.retrieveButton);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(new CSHelpButton(CSHelpConst.EtherPmUtilPane));
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 50, 5, 50));
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)new JLabel(), "East");
        return jPanel;
    }

    private Vector statsSeriesToVector(EtherPmStatsSeries[] etherPmStatsSeriesArray) {
        Vector<String> vector = new Vector<String>();
        if (etherPmStatsSeriesArray != null) {
            for (int i = 0; i < etherPmStatsSeriesArray.length; ++i) {
                vector.add(etherPmStatsSeriesArray[i].getSeriesDescription());
            }
        }
        return vector;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.retrieveButton) {
            this.refreshNow();
        }
    }

    public void enteringPage() {
        this.getObsMgr().setPassing(true);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.refreshNow();
    }

    public void leavingPage() {
        this.getObsMgr().setPassing(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
    }

    public void refresh() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshNow() {
        try {
            this.setCursor(3);
            if (this.seriesCB.getSelectedIndex() != -1) {
                EtherPmStatsSeries etherPmStatsSeries = this.etherPmStatsSeriesList[this.seriesCB.getSelectedIndex()];
                this.dataModel.refresh(etherPmStatsSeries);
                String string = this.dataModel.getLastIntervalTimeStamp();
                if (string.length() > 0) {
                    this.retrievalTime.setText("The " + etherPmStatsSeries.getSeriesDescription() + " interval labeled \"PREV\" ended " + string);
                } else {
                    this.retrievalTime.setText(" ");
                }
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            if (db.on()) {
                db.println("Caught exception in EtherPmUtilPane.refreshNow: " + (Object)((Object)noSuchInterface));
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        catch (Exception exception) {
            db.println("Caught exception in EtherPmUtilPane.refreshNow: " + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            this.setCursor(0);
        }
    }

    public void changeMessage(Observable observable, Object object) {
        if (db.on()) {
            db.println("Got an Update Message for " + observable);
        }
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                EtherPmUtilPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        if (null != this.lineModels) {
            int n = Arrays.asList(this.lineModels).indexOf(observable);
            if (n != -1 && this.dataModel != null) {
                if (db.on()) {
                    db.println("Refreshing Line " + n);
                }
                this.dataModel.refreshLineFromModel(n);
            } else if (db.on()) {
                db.println("refreshLine: unable to locate " + observable);
            }
        } else if (db.on()) {
            db.println("refreshLine: lineModels is null!!");
        }
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof EtherLineUpdate) {
            this.lineModels = ((EtherLineUpdate)object).getEtherLineModels();
            this.getObsMgr().setObservable((Observable[])this.lineModels);
            db.fine("refreshMyLines(): refreshing lines, ether lines= " + this.lineModels.length);
            this.dataModel.refreshMyLines(this.lineModels);
            this.refreshNow();
        } else if (db.on()) {
            db.println("refreshMyLines(): received " + object);
        }
    }

    protected void registerWithModel() {
        super.registerWithModel();
        this.getObsMgr().setObservable((Observable[])this.lineModels);
    }

    protected ObservableManager getObsMgr() {
        if (this.obsMgr == null) {
            this.obsMgr = new ObservableManager(this, true);
        }
        return this.obsMgr;
    }

    public void dispose() {
        if (this.obsMgr != null) {
            this.obsMgr.removeObservable((Observable[])this.lineModels);
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.dispose();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

