/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ether;

import cerent.cms.idl.Epos.eCardMode;
import cerent.cms.idl.Epos.xNoMoreSpanningTree;
import cerent.cms.idl.Epos.xVlanHardwareViolation;
import cerent.cms.idl.Epos.xVlanSpanningTreeViolation;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElAttributeMaps;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EtherBridgeModel;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.EtherModuleModel;
import cerent.cms.model.EtherPortModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InvalidMauType;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ether.EtherPortTableModel;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class EtherPortProvPane
extends NodeProvPane
implements TableModelListener {
    private EtherPortTableModel dataModel;
    private EtherPortModel[] portModels;
    private EtherLineModel[] lineModels;
    private EtherBridgeModel bridgeModel;
    private TableColumn column = null;
    private EtherModuleModel eqpmtModel = null;
    private int numLines = 0;
    private int numPorts = 0;
    private ArrayList hiddenColumns = new ArrayList();
    protected static final int PRIORITY_INDEX = 5;
    private static final int STP_ENABLED_INDEX = 6;
    private static final int STP_STATE_INDEX = 7;
    protected static final int ENCAPSULATION_INDEX = 8;
    eCardMode curCardMode = eCardMode.MULTI_CARD_SWITCH;
    private static final SDebug db = new SDebug("EtherProvPane");
    static /* synthetic */ Class class$cerent$cms$idl$EtherMedia$eMauType;

    public EtherPortProvPane(String string, TabbedView tabbedView, EtherLineModel[] etherLineModelArray, EtherPortModel[] etherPortModelArray) {
        super(string, tabbedView);
        Attribute[] attributeArray = null;
        this.portModels = etherPortModelArray;
        this.lineModels = etherLineModelArray;
        this.numLines = etherLineModelArray == null ? 0 : etherLineModelArray.length;
        this.numPorts = etherPortModelArray == null ? 0 : etherPortModelArray.length;
        this.bridgeModel = this.numPorts > 0 ? (EtherBridgeModel)etherPortModelArray[0].getNodeModelDelegate().getEtherBridgeModel() : null;
        if (this.getParentView().getUiModel() instanceof EtherModuleModel) {
            this.eqpmtModel = (EtherModuleModel)this.getParentView().getUiModel();
        } else if (db.on()) {
            db.println("Equipment Model is not EtherModuleModel");
        }
        this.dataModel = new EtherPortTableModel(etherPortModelArray, etherLineModelArray, this.eqpmtModel);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        this.column = this.table.getColumn(this.dataModel.columnNames[0]);
        this.column.setCellEditor(new DefaultCellEditor(new JTextField()));
        this.column.setPreferredWidth(50);
        this.column.setCellRenderer(PORT_CELL_RENDERER);
        this.column = this.table.getColumn(this.dataModel.columnNames[1]);
        this.column.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        this.column.setPreferredWidth(150);
        this.column = this.table.getColumn(this.dataModel.columnNames[2]);
        try {
            List list = null;
            if (this.eqpmtModel == null) {
                if (db.on()) {
                    db.println("Equipment Model is null");
                }
                throw new NoSuchElementException();
            }
            list = this.getAttributeList(class$cerent$cms$idl$EtherMedia$eMauType == null ? (class$cerent$cms$idl$EtherMedia$eMauType = EtherPortProvPane.class$("cerent.cms.idl.EtherMedia.eMauType")) : class$cerent$cms$idl$EtherMedia$eMauType, this.eqpmtModel.getEqType());
            attributeArray = list.toArray(new Attribute[0]);
        }
        catch (NoSuchElementException noSuchElementException) {
            if (db.on()) {
                db.println("In no such element exc");
            }
            attributeArray = null;
            this.table.removeColumn(this.column);
        }
        if (attributeArray != null) {
            this.column.setCellEditor(new DefaultCellEditor((JComboBox<?>)this.getComboBoxFor(attributeArray)));
            this.column.sizeWidthToFit();
        }
        this.column = this.table.getColumn(this.dataModel.columnNames[5]);
        try {
            attributeArray = this.getAttributeArray("EtherPriority");
        }
        catch (NoSuchElementException noSuchElementException) {
            if (db.on()) {
                db.println("In no such element exc");
            }
            attributeArray = null;
            this.table.removeColumn(this.column);
        }
        if (attributeArray != null) {
            this.column.setCellEditor(new DefaultCellEditor((JComboBox<?>)this.getComboBoxFor(attributeArray)));
            this.column.sizeWidthToFit();
        }
        boolean bl = this.eqpmtModel.getNodeModel().getNeType().equals("15327");
        this.column = this.table.getColumn(this.dataModel.columnNames[8]);
        if (!bl) {
            this.table.removeColumn(this.column);
        } else {
            try {
                attributeArray = this.getAttributeArray("EtherEncapsulation");
            }
            catch (NoSuchElementException noSuchElementException) {
                if (db.on()) {
                    db.println("In no such element exc");
                }
                attributeArray = null;
                this.table.removeColumn(this.column);
            }
        }
        if (attributeArray != null) {
            this.column.setCellEditor(new DefaultCellEditor((JComboBox<?>)this.getComboBoxFor(attributeArray)));
            this.column.sizeWidthToFit();
        }
        this.table.sizeColumnsToFit(-1);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.registerForUpdates();
        this.add((Component)uScrollPane);
        this.hiddenColumns.clear();
    }

    private UComboBox getComboBoxFor(Attribute[] attributeArray) {
        UComboBox uComboBox = new UComboBox((Object[])attributeArray);
        uComboBox.setEditable(false);
        return uComboBox;
    }

    protected ElAttributeMaps getAttributeMap() {
        IModel iModel = this.uiModel;
        return ElementDefaults.getAttributeMap(iModel);
    }

    protected Attribute[] getAttributeArray(String string) {
        return this.getAttributeMap().getAttributeArray("ETHER." + string);
    }

    protected List getAttributeList(Class clazz, int n) {
        List list = null;
        switch (n) {
            case 14: {
                list = this.getAttributeMap().getAttributeList("ETHER100." + clazz.getName());
                break;
            }
            case 15: {
                list = this.getAttributeMap().getAttributeList("ETHER1000." + clazz.getName());
                break;
            }
            default: {
                list = this.getAttributeMap().getAttributeList("ETHER." + clazz.getName());
            }
        }
        return list;
    }

    private void registerForUpdates() {
        if (this.portModels == null) {
            return;
        }
        for (int i = 0; i < this.numPorts; ++i) {
            this.portModels[i].addObserver((Observer)((Object)this));
        }
    }

    private void unregisterForUpdates() {
        if (this.portModels == null) {
            return;
        }
        for (int i = 0; i < this.numPorts; ++i) {
            this.portModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                EtherPortProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        if (this.portModels != null) {
            int n = Arrays.asList(this.portModels).indexOf(observable);
            if (n != -1 && this.dataModel != null) {
                if (db.on()) {
                    db.println(" Refreshing Line " + n);
                }
                this.dataModel.refreshLineFromModel(n);
            } else if (db.on()) {
                db.println("In EtherPortProvPane changeMessage cannot find Model " + observable);
            }
        } else if (db.on()) {
            db.println("refreshLine: portModels is null!!");
        }
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.unregisterForUpdates();
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.destroy();
            this.dataModel = null;
        }
        this.portModels = null;
        this.lineModels = null;
        super.destroy();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (db.on()) {
            db.println(">>> tableChanged()");
        }
        if (this.numPorts == 0) {
            return;
        }
        int n = tableModelEvent.getLastRow() > this.numPorts ? this.numPorts - 1 : tableModelEvent.getLastRow();
        for (int i = tableModelEvent.getFirstRow(); i <= n; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void applyChangesToModel() throws InvalidMauType, xNoMoreSpanningTree, xVlanSpanningTreeViolation, NoSuchInterface, AnnotatedException {
        try {
            boolean bl;
            int n;
            this.setCursor(3);
            boolean bl2 = false;
            boolean bl3 = this.eqpmtModel.getNodeModel().getNeType().equals("15327");
            boolean bl4 = false;
            for (n = 0; n < this.numPorts; ++n) {
                if (this.dataModel.isRowDirty(n)) {
                    bl = true;
                    boolean bl5 = true;
                    boolean bl6 = bl5 = !this.dataModel.getPortAdminInfo((int)n).portEnabled;
                    if (bl5 && (bl = this.portModels[n].getBridgePortAdminInfo().portEnabled)) {
                        bl2 = true;
                        break;
                    }
                }
                if (!bl3 || this.dataModel.getPortAdminInfo((int)n).encapType == this.portModels[n].getBridgePortAdminInfo().encapType) continue;
                bl4 = true;
            }
            if (bl4 && !CerentDialog.yesNoDialog((Component)((Object)this), (String)(EMC.WID_ENCAP_TYPE_CHANGE + "\n\nApply changes?"), (String)"Confirmation Dialog")) {
                return;
            }
            if (bl2) {
                bl = false;
                bl = CerentDialog.yesNoDialog((Component)((Object)this), (String)"Some lines are being disabled. Apply changes?", (String)"Confirmation Dialog");
                if (!bl) {
                    return;
                }
            }
            for (n = 0; n < this.numPorts; ++n) {
                if (!this.dataModel.isRowDirty(n)) continue;
                if (db.on()) {
                    db.println("Setting row " + n);
                }
                this.lineModels[n].setAlias(this.dataModel.getPortName(n));
                this.portModels[n].setBridgePortAdminInfoNoProv(this.dataModel.getPortAdminInfo(n));
                this.lineModels[n].setLineAdminInfoNoProv(this.dataModel.getLineAdminInfo(n));
            }
            this.dataModel.resetRowDirty();
            if (this.bridgeModel != null) {
                this.bridgeModel.finalizePortProvisioning();
            }
        }
        catch (xVlanHardwareViolation xVlanHardwareViolation2) {
            throw new AnnotatedException("This card does not allow more than one\nenabled port to be a member of the same VLAN.\n\nPut the ports in different VLANs before enabling them.\n", (Exception)((Object)xVlanHardwareViolation2));
        }
        finally {
            this.setCursor(0);
        }
    }

    protected void displayErrorDialog(Pane pane, Exception exception, EID eID) {
        if (exception instanceof xVlanSpanningTreeViolation) {
            EtherPortProvPane.displayVlanStpError(this.bridgeModel.getNodeModel(), pane, EMC.EID_STP_ENABLE_FAILED);
        } else {
            super.displayErrorDialog(pane, exception, eID);
        }
    }

    public static void displayVlanStpError(INodeModel iNodeModel, Pane pane, EID eID) {
        Object[] objectArray;
        JDialog jDialog = null;
        IUiToolkit iUiToolkit = iNodeModel.getUiToolkit();
        if (iUiToolkit != null) {
            objectArray = new Object[]{iNodeModel};
            jDialog = iUiToolkit.getGuestDialog(1, (Component)pane, objectArray);
        }
        String string = "Close";
        objectArray = jDialog != null ? new String[]{"View Table", string} : new String[]{string};
        String string2 = ErrorMsg.getString((EID)eID);
        int n = CerentDialog.errorDialog((Component)pane, (String)string2, (String)"VLAN/Spanning Tree Violation", (Object[])objectArray, (Object)string);
        if (n == 0 && objectArray.length > 1) {
            jDialog.show();
        }
    }

    public void refreshFromModel() {
        eCardMode eCardMode2 = null;
        Object var2_2 = null;
        if (this.dataModel != null) {
            block8: {
                try {
                    eCardMode2 = this.eqpmtModel.getEtherCardMode();
                }
                catch (xNoSuchEquipment xNoSuchEquipment2) {
                    if (!EtherPortProvPane.db.on) break block8;
                    db.println("Error in getting connectionList " + (Object)((Object)xNoSuchEquipment2));
                    SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
                }
            }
            this.dataModel.refresh();
            this.dataModel.resetRowDirty();
            if (eCardMode2 != this.curCardMode) {
                if (eCardMode2 == eCardMode.LINEAR_NO_SWITCH) {
                    TableColumn tableColumn = this.table.getColumn(this.dataModel.columnNames[5]);
                    TableColumn tableColumn2 = this.table.getColumn(this.dataModel.columnNames[6]);
                    TableColumn tableColumn3 = this.table.getColumn(this.dataModel.columnNames[7]);
                    this.hiddenColumns.add(tableColumn);
                    this.hiddenColumns.add(tableColumn2);
                    this.hiddenColumns.add(tableColumn3);
                    this.table.removeColumn(tableColumn);
                    this.table.removeColumn(tableColumn2);
                    this.table.removeColumn(tableColumn3);
                } else if (this.curCardMode == eCardMode.LINEAR_NO_SWITCH) {
                    for (int i = this.hiddenColumns.size() - 1; i >= 0; --i) {
                        TableColumn tableColumn = (TableColumn)this.hiddenColumns.get(i);
                        this.table.addColumn(tableColumn);
                        this.hiddenColumns.remove(i);
                    }
                    this.table.sizeColumnsToFit(-1);
                }
                this.curCardMode = eCardMode2;
            }
        }
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.EtherPortProvPane;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

