/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ether;

import cerent.cms.idl.Epos.eCardMode;
import cerent.cms.idl.Epos.eEncapsulationType;
import cerent.cms.idl.Epos.sBridgePortAdminInfo_2_2;
import cerent.cms.idl.Epos.sBridgePortInfo;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.EtherMedia.eMauType;
import cerent.cms.idl.EtherMedia.sLineAdminInfo;
import cerent.cms.idl.EtherMedia.sLineInfo;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.EtherModuleModel;
import cerent.cms.model.EtherPortModel;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.util.SDebug;
import java.awt.Frame;
import javax.swing.table.AbstractTableModel;

public class EtherPortTableModel
extends AbstractTableModel {
    private static final SDebug db = new SDebug("EtherPortTableModel");
    private EtherPortModel[] models;
    private EtherLineModel[] lineModels;
    private EtherModuleModel eqpmtModel;
    private boolean[] rowDirty;
    private int numLines;
    private int numPorts;
    private sBridgePortAdminInfo_2_2[] portAdminInfo;
    private sBridgePortInfo[] portInfo;
    private sLineAdminInfo[] lineAdminInfo;
    private sLineInfo[] lineInfo;
    private Attribute[] defaultMauType;
    private Attribute[] mauType;
    private Attribute[] portState;
    private Attribute[] prior;
    private IVlanModel[] vlan;
    private String[] portNames;
    protected String[] columnNames = new String[]{"Port", "Port Name", "Mode", "Status", "Enabled", "Priority", "Stp Enabled", "Stp State", "Encapsulation"};
    protected static final int LINENUMBER_INDEX = 0;
    protected static final int PORTNAME_INDEX = 1;
    protected static final int MODE_INDEX = 2;
    private static final int STATUS_INDEX = 3;
    private static final int ENABLED_INDEX = 4;
    protected static final int PRIORITY_INDEX = 5;
    private static final int STP_ENABLED_INDEX = 6;
    private static final int STP_STATE_INDEX = 7;
    protected static final int ENCAPSULATION_INDEX = 8;
    private static final int MAX_PRIORITY_VAL = 7;
    private static final int HIGH_PRIORITY = 1;
    private static final int NORMAL_PRIORITY = 0;
    private static final int LOW_PRIORITY = 4;
    private static final int LOWEST_PRIORITY = 6;
    private static final String PREFIX = "ETHER.";
    private static final String PREFIX10 = "ETHER10.";
    private static final String PREFIX100 = "ETHER100.";
    private static final String PREFIX1000 = "ETHER1000.";
    static /* synthetic */ Class class$cerent$cms$idl$EtherMedia$eMauType;
    static /* synthetic */ Class class$cerent$cms$idl$Epos$eBridgePortState;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;

    public EtherPortTableModel(EtherPortModel[] etherPortModelArray, EtherLineModel[] etherLineModelArray, EtherModuleModel etherModuleModel) {
        this.models = etherPortModelArray;
        this.lineModels = etherLineModelArray;
        this.numPorts = etherPortModelArray == null ? 0 : etherPortModelArray.length;
        this.numLines = etherLineModelArray == null ? 0 : etherLineModelArray.length;
        this.eqpmtModel = etherModuleModel;
        this.portNames = new String[this.numPorts];
        this.rowDirty = new boolean[this.numPorts];
        this.portAdminInfo = new sBridgePortAdminInfo_2_2[this.numPorts];
        this.portInfo = new sBridgePortInfo[this.numPorts];
        this.lineInfo = new sLineInfo[this.numPorts];
        this.lineAdminInfo = new sLineAdminInfo[this.numPorts];
        this.defaultMauType = new Attribute[this.numPorts];
        this.mauType = new Attribute[this.numPorts];
        this.portState = new Attribute[this.numPorts];
        this.vlan = new IVlanModel[this.numPorts];
        this.resetRowDirty();
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl;
        block3: {
            bl = false;
            try {
                bl = this.eqpmtModel.getEtherCardMode() == eCardMode.LINEAR_NO_SWITCH;
            }
            catch (xNoSuchEquipment xNoSuchEquipment2) {
                if (!EtherPortTableModel.db.on) break block3;
                db.println("Error in getting connectionList " + (Object)((Object)xNoSuchEquipment2));
                SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
            }
        }
        if (this.models != null && this.numPorts > 0 && AbstractPane.isUserAuthorized(this.models[0], SecurityLevel.PROVISIONING)) {
            return n2 == 5 || n2 == 4 || n2 == 2 || n2 == 6 || n2 == 1 || bl && n2 == 8;
        }
        return false;
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    public sBridgePortAdminInfo_2_2 getPortAdminInfo(int n) {
        if (this.portAdminInfo[n] == null) {
            try {
                this.portAdminInfo[n] = this.models[n].getBridgePortAdminInfo();
            }
            catch (Exception exception) {
                db.println("Caught exception in EtherPortTableModel:getPortAdminInfo");
                SDebug.printStackTrace((Throwable)exception);
                return null;
            }
        }
        if (db.on()) {
            db.println("getPortAdminInfo: returning values...\nportEnabled = " + this.portAdminInfo[n].portEnabled + "\nstpPriority = " + this.portAdminInfo[n].stpPriority + "\nstpPathCost = " + this.portAdminInfo[n].stpPathCost + "\nqueuingPriority = " + this.portAdminInfo[n].queuingPriority + "\nbroadcastLimit = " + this.portAdminInfo[n].broadcastLimit + "\nstpEnabled = " + this.portAdminInfo[n].stpEnabled);
        }
        return this.portAdminInfo[n];
    }

    public sBridgePortInfo getPortInfo(int n) {
        if (this.portInfo[n] == null) {
            try {
                this.portInfo[n] = this.models[n].getBridgePortInfo();
            }
            catch (Exception exception) {
                db.println("Caught exception in EtherPortTableModel:getPortInfo");
                SDebug.printStackTrace((Throwable)exception);
                return null;
            }
        }
        return this.portInfo[n];
    }

    public sLineInfo getLineInfo(int n) {
        if (this.lineInfo[n] == null) {
            try {
                this.lineInfo[n] = this.lineModels[n].getLineInfo();
            }
            catch (Exception exception) {
                db.println("Caught exception in EtherPortTableModel:getLineInfo");
                SDebug.printStackTrace((Throwable)exception);
                return null;
            }
        }
        return this.lineInfo[n];
    }

    public sLineAdminInfo getLineAdminInfo(int n) {
        if (this.lineAdminInfo[n] == null) {
            try {
                this.lineAdminInfo[n] = this.lineModels[n].getLineAdminInfo();
            }
            catch (Exception exception) {
                db.println("Caught exception in EtherPortTableModel:getLineAdminInfo");
                SDebug.printStackTrace((Throwable)exception);
                return null;
            }
        }
        return this.lineAdminInfo[n];
    }

    private Frame getFrame() {
        return this.eqpmtModel.getNodeModel().getUiToolkit().getApplicationFrame();
    }

    private int getPriorityFromRange(int n) {
        if (n == 1 || n == 2) {
            return 1;
        }
        if (n == 0 || n == 3) {
            return 0;
        }
        if (n == 4 || n == 5) {
            return 4;
        }
        return 6;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    private Attribute getAttributeFor(String string, int n, EtherModuleModel etherModuleModel) {
        String string2 = null;
        try {
            switch (etherModuleModel.getEqType()) {
                case 14: {
                    string2 = PREFIX100;
                    break;
                }
                case 15: {
                    string2 = PREFIX1000;
                    break;
                }
                default: {
                    string2 = PREFIX;
                    break;
                }
            }
        }
        catch (Exception exception) {
            string2 = PREFIX;
        }
        return ElementDefaults.getAttributeMap(etherModuleModel).getAttributeForVal(string2 + string, n);
    }

    private Attribute getAttributeFor(String string, int n) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeForVal(PREFIX + string, n);
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    private Integer getLineNumberFor(int n) {
        return new Integer(n + 1);
    }

    private Attribute getDefaultMauTypeFor(int n) {
        if (this.defaultMauType[n] == null || this.lineAdminInfo[n] == null) {
            this.getLineAdminInfo(n);
            this.defaultMauType[n] = this.getAttributeFor((class$cerent$cms$idl$EtherMedia$eMauType == null ? (class$cerent$cms$idl$EtherMedia$eMauType = EtherPortTableModel.class$("cerent.cms.idl.EtherMedia.eMauType")) : class$cerent$cms$idl$EtherMedia$eMauType).getName(), this.lineAdminInfo[n].mauDefaultType.value(), this.eqpmtModel);
        }
        return this.defaultMauType[n];
    }

    private Attribute getMauTypeFor(int n) {
        if (this.lineInfo[n] == null) {
            this.getLineInfo(n);
            this.mauType[n] = this.getAttributeFor((class$cerent$cms$idl$EtherMedia$eMauType == null ? (class$cerent$cms$idl$EtherMedia$eMauType = EtherPortTableModel.class$("cerent.cms.idl.EtherMedia.eMauType")) : class$cerent$cms$idl$EtherMedia$eMauType).getName(), this.lineInfo[n].mauType.value(), this.eqpmtModel);
        }
        return this.mauType[n];
    }

    private Attribute getEncapsulationTypeFor(int n) {
        return this.getAttributeFor("EtherEncapsulation", this.portAdminInfo[n].encapType.value());
    }

    private Attribute getPriorityFor(int n) {
        if (this.portAdminInfo[n] == null) {
            this.getPortAdminInfo(n);
        }
        if (this.portAdminInfo[n] != null) {
            return this.getAttributeFor("EtherPriority", this.portAdminInfo[n].queuingPriority);
        }
        return null;
    }

    private Integer getPortIdFor(int n) {
        if (this.portInfo[n] == null) {
            this.getPortInfo(n);
        }
        if (this.portInfo[n] != null) {
            return new Integer(this.portInfo[n].portId);
        }
        return null;
    }

    private Attribute getPortStateFor(int n) {
        if (this.portInfo[n] == null) {
            this.getPortInfo(n);
        }
        if (this.portInfo[n] != null) {
            this.portState[n] = this.getAttributeFor((class$cerent$cms$idl$Epos$eBridgePortState == null ? (class$cerent$cms$idl$Epos$eBridgePortState = EtherPortTableModel.class$("cerent.cms.idl.Epos.eBridgePortState")) : class$cerent$cms$idl$Epos$eBridgePortState).getName(), this.portInfo[n].portState.value());
        }
        return this.portState[n];
    }

    public IVlanModel getVlanFor(int n) throws AbstractCmsIOException {
        if (this.vlan[n] == null) {
            IVlanModel[] iVlanModelArray = this.models[n].getBridgePortVlans();
            if (iVlanModelArray.length == 0) {
                if (db.on()) {
                    db.println("No Vlans");
                }
                return null;
            }
            this.vlan[n] = iVlanModelArray[0];
        }
        return this.vlan[n];
    }

    public IVlanModel[] getVlanArrayFor(int n) throws AbstractCmsIOException {
        IVlanModel[] iVlanModelArray = new IVlanModel[]{this.getVlanFor(n)};
        return iVlanModelArray;
    }

    private Boolean getPortEnabledStateFor(int n) {
        if (this.portAdminInfo[n] == null) {
            this.getPortAdminInfo(n);
        }
        if (this.portAdminInfo[n] != null) {
            return new Boolean(this.portAdminInfo[n].portEnabled);
        }
        if (db.on()) {
            db.println("PortAdminInfo is null " + n);
        }
        return null;
    }

    private Boolean getPortStpEnabledStateFor(int n) {
        if (this.portAdminInfo[n] == null) {
            this.getPortAdminInfo(n);
        }
        if (this.portAdminInfo[n] != null) {
            return new Boolean(this.portAdminInfo[n].stpEnabled);
        }
        if (db.on()) {
            db.println("PortAdminInfo is null " + n);
        }
        return null;
    }

    public int getRowCount() {
        return this.numPorts;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 4: 
            case 6: {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = EtherPortTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = EtherPortTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getLineNumberFor(n);
                }
                case 1: {
                    return this.getPortName(n);
                }
                case 2: {
                    return this.getDefaultMauTypeFor(n);
                }
                case 3: {
                    return this.getMauTypeFor(n);
                }
                case 4: {
                    return this.getPortEnabledStateFor(n);
                }
                case 5: {
                    return this.getPriorityFor(n);
                }
                case 6: {
                    return this.getPortStpEnabledStateFor(n);
                }
                case 7: {
                    return this.getPortStateFor(n);
                }
                case 8: {
                    return this.getEncapsulationTypeFor(n);
                }
            }
            return null;
        }
        catch (Exception exception) {
            db.println("Caught exception in getValueAt");
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public String getPortName(int n) throws NoSuchInterface {
        if (this.portNames[n] == null) {
            this.portNames[n] = this.models[n].getInterfaceModel().getAlias();
        }
        return this.portNames[n];
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return;
                }
                case 1: {
                    this.portNames[n] = (String)object;
                    break;
                }
                case 2: {
                    if (!(object instanceof Attribute)) break;
                    this.lineAdminInfo[n].mauDefaultType = eMauType.from_int(((Attribute)object).getIntValue());
                    this.defaultMauType[n] = (Attribute)object;
                    break;
                }
                case 4: {
                    if (!(object instanceof Boolean)) break;
                    this.portAdminInfo[n].portEnabled = (Boolean)object;
                    break;
                }
                case 5: {
                    if (!(object instanceof Attribute)) break;
                    this.portAdminInfo[n].queuingPriority = (byte)((Attribute)object).getIntValue();
                    break;
                }
                case 6: {
                    if (!(object instanceof Boolean)) break;
                    this.portAdminInfo[n].stpEnabled = (Boolean)object;
                    break;
                }
                case 8: {
                    if (!(object instanceof Attribute)) break;
                    int n3 = ((Attribute)object).getIntValue();
                    this.portAdminInfo[n].encapType = eEncapsulationType.from_int(n3);
                    break;
                }
                default: {
                    return;
                }
            }
            this.rowDirty[n] = true;
            this.fireTableCellUpdated(n, n2);
        }
        catch (Exception exception) {
            db.println("Caught exception in setValueAt");
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public void resetRowDirty() {
        for (int i = 0; i < this.numPorts; ++i) {
            this.rowDirty[i] = false;
        }
    }

    public sBridgePortAdminInfo_2_2 getPortAdminInfoFor(int n) {
        return this.portAdminInfo[n];
    }

    public void refreshLineFromModel(int n) {
        this.portNames[n] = null;
        this.portAdminInfo[n] = null;
        this.portInfo[n] = null;
        this.lineInfo[n] = null;
        this.lineAdminInfo[n] = null;
        this.defaultMauType[n] = null;
        this.mauType[n] = null;
        this.portState[n] = null;
        this.vlan[n] = null;
        this.fireTableRowsUpdated(n, n);
    }

    public void refresh() {
        for (int i = 0; i < this.numPorts; ++i) {
            this.portNames[i] = null;
            this.portAdminInfo[i] = null;
            this.portInfo[i] = null;
            this.lineInfo[i] = null;
            this.lineAdminInfo[i] = null;
            this.defaultMauType[i] = null;
            this.mauType[i] = null;
            this.portState[i] = null;
            this.vlan[i] = null;
        }
        this.fireTableRowsUpdated(0, this.numPorts - 1);
    }

    public static void main(String[] stringArray) {
    }

    public static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    public void destroy() {
        int n;
        this.models = null;
        this.lineModels = null;
        this.eqpmtModel = null;
        this.rowDirty = null;
        for (n = 0; n < this.portNames.length; ++n) {
            this.portNames[n] = null;
        }
        for (n = 0; n < this.portAdminInfo.length; ++n) {
            this.portAdminInfo[n] = null;
        }
        this.portAdminInfo = null;
        for (n = 0; n < this.portInfo.length; ++n) {
            this.portInfo[n] = null;
        }
        this.portInfo = null;
        for (n = 0; n < this.lineAdminInfo.length; ++n) {
            this.lineAdminInfo[n] = null;
        }
        this.lineAdminInfo = null;
        for (n = 0; n < this.lineInfo.length; ++n) {
            this.lineInfo[n] = null;
        }
        this.lineInfo = null;
        for (n = 0; n < this.vlan.length; ++n) {
            this.vlan[n] = null;
        }
        this.vlan = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

