/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ether;

import cerent.cms.idl.EtherMedia.sLineInfo;
import cerent.cms.idl.Rmon.sTimedStatsPair;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BridgePortAssociation;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EtherMediaModel;
import cerent.cms.model.EtherPmStatsSeries;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.HoConnectionModel;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchStatsSeries;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.shelf.SmpEtherStatsPane;
import cerent.util.HoLoHelper;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.IFixedColumnsTableModel;
import cerent.util.gui.TransmitReceive;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;

public class EtherStatsTableModel
extends AbstractTableModel
implements IFixedColumnsTableModel {
    public static final int FIXED_COLUMNS = 3;
    private static final SDebug db = new SDebug("EtherStatsTableModel");
    private sLineInfo[] lineInfo;
    private NodeModelDelegate nodeModel;
    private int numLines;
    private boolean refresh = false;
    private SmpEtherStatsPane parent;
    private int nCols;
    private String[] colNames;
    private ArrayList etherPmStatsList;
    private ArrayList circuitNameList;
    private String lastIntervalTimeStamp;
    private SimpleDateFormat timeFmt;
    private EventUtilities eventUtilities;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$cerent$util$gui$TransmitReceive;

    public EtherStatsTableModel(SmpEtherStatsPane smpEtherStatsPane, NodeModelDelegate nodeModelDelegate) {
        this.nodeModel = nodeModelDelegate;
        this.parent = smpEtherStatsPane;
        this.lineInfo = null;
        this.refresh = false;
        this.nCols = 0;
        this.colNames = new String[0];
        this.etherPmStatsList = new ArrayList(0);
        this.lastIntervalTimeStamp = "";
        this.timeFmt = new SimpleDateFormat("MM/dd/yyyy hh:mm aaa");
        this.eventUtilities = EventUtilities.getInstance(nodeModelDelegate);
    }

    public Object getValueAt(int n, int n2) {
        EtherPmStats etherPmStats = (EtherPmStats)this.etherPmStatsList.get(n);
        sTimedStatsPair[] sTimedStatsPairArray = etherPmStats.getTimedStats();
        if (n2 == 0) {
            return etherPmStats.getCircuitName();
        }
        if (n2 == 1) {
            return etherPmStats.getCircuitSize();
        }
        if (n2 == 2) {
            return etherPmStats.getSlotPortHo();
        }
        if (this.refresh && n2 < sTimedStatsPairArray.length + 3) {
            return new TransmitReceive(sTimedStatsPairArray[n2 - 3]);
        }
        return "";
    }

    public void refreshCols(EtherPmStatsSeries etherPmStatsSeries) {
        this.setDisplayCols(etherPmStatsSeries);
        this.fireTableStructureChanged();
        this.parent.fixedUpColumn();
    }

    public void refresh(EtherPmStatsSeries etherPmStatsSeries) throws NoSuchStatsSeries, NoSuchInterface {
        this.refresh = false;
        this.refreshPmStats(etherPmStatsSeries);
        this.setDisplayCols(etherPmStatsSeries);
        this.fireTableStructureChanged();
        this.parent.fixedUpColumn();
        this.refresh = true;
    }

    private void refreshPmStats(EtherPmStatsSeries etherPmStatsSeries) throws NoSuchStatsSeries, NoSuchInterface {
        this.etherPmStatsList = new ArrayList(0);
        ConnectionModelsDelegate connectionModelsDelegate = (ConnectionModelsDelegate)this.nodeModel.getConnectionModels();
        IHoConnectionModel[] iHoConnectionModelArray = connectionModelsDelegate.getHoConnectionModels();
        this.circuitNameList = new ArrayList(0);
        this.lastIntervalTimeStamp = "";
        if (iHoConnectionModelArray == null) {
            return;
        }
        for (int i = 0; i < iHoConnectionModelArray.length; ++i) {
            HoConnectionModel hoConnectionModel = (HoConnectionModel)iHoConnectionModelArray[i];
            EtherPmStats[] etherPmStatsArray = this.getEtherBackendPortInfo(hoConnectionModel);
            if (etherPmStatsArray == null || etherPmStatsArray.length <= 0) continue;
            for (int j = 0; j < etherPmStatsArray.length; ++j) {
                this.circuitNameList.add(etherPmStatsArray[j].getCircuitName());
                EtherPmStats etherPmStats = etherPmStatsArray[j];
                etherPmStats.refreshPmStats(etherPmStatsSeries);
                this.etherPmStatsList.add(etherPmStats);
                if (this.lastIntervalTimeStamp.length() != 0 || etherPmStats.getTimedStats().length <= 0) continue;
                this.lastIntervalTimeStamp = this.eventUtilities.convertSecondsToFormattedTimeZoneString(etherPmStats.getTimedStats()[0].txStat.timeStamp);
            }
        }
        this.sortByCircuitName();
    }

    private void sortByCircuitName() {
        String[] stringArray = this.circuitNameList.toArray(new String[0]);
        EtherPmStats[] etherPmStatsArray = this.etherPmStatsList.toArray(new EtherPmStats[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            String string = stringArray[i];
            EtherPmStats etherPmStats = etherPmStatsArray[i];
            for (int j = i; j > 0 && stringArray[j - 1].compareTo(string) > 0; --j) {
                stringArray[j] = stringArray[j - 1];
                etherPmStatsArray[j] = etherPmStatsArray[j - 1];
            }
            stringArray[j] = string;
            etherPmStatsArray[j] = etherPmStats;
        }
        this.etherPmStatsList = new ArrayList<EtherPmStats>(Arrays.asList(etherPmStatsArray));
    }

    public String getLastIntervalTimeStamp() {
        return this.lastIntervalTimeStamp;
    }

    private EtherPmStats[] getEtherBackendPortInfo(HoConnectionModel hoConnectionModel) {
        ArrayList<EtherPmStats> arrayList = new ArrayList<EtherPmStats>(0);
        BridgePortAssociation[] bridgePortAssociationArray = hoConnectionModel.getBridgePortAssociations();
        if (bridgePortAssociationArray == null || bridgePortAssociationArray.length == 0) {
            return null;
        }
        for (int i = 0; i < bridgePortAssociationArray.length; ++i) {
            EntityModel entityModel;
            BridgePortAssociation bridgePortAssociation = bridgePortAssociationArray[i];
            EtherMediaModel etherMediaModel = bridgePortAssociation.getEtherBackPlane();
            if (etherMediaModel == null) continue;
            try {
                entityModel = (EntityModel)bridgePortAssociation.getPool().getEntityModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("Caught exception inEtherStatsTableModel.getEtherBackendPortInfo: " + (Object)((Object)abstractCmsNoSuchEntityException));
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                entityModel = null;
            }
            if (entityModel == null || !(entityModel instanceof IPortModel)) continue;
            int n = entityModel.getSlot();
            String string = "Unknown";
            string = ((ConnectionModelsDelegate)this.nodeModel.getConnectionModels()).getCircuitName(hoConnectionModel.getCircuitId());
            EtherPmStats etherPmStats = new EtherPmStats(etherMediaModel, string == null ? "Unknown" : string, hoConnectionModel.getPathWidth(), n, (IPortModel)entityModel, bridgePortAssociation.getStartingHo());
            arrayList.add(etherPmStats);
        }
        return arrayList.toArray(new EtherPmStats[0]);
    }

    private void setDisplayCols(EtherPmStatsSeries etherPmStatsSeries) {
        this.nCols = this.getStatsColCount(etherPmStatsSeries);
        this.colNames = new String[this.nCols];
        for (int i = 0; i < this.nCols; ++i) {
            this.colNames[i] = i > 0 ? "Prev-" + i : "Prev";
        }
    }

    private int getStatsColCount(EtherPmStatsSeries etherPmStatsSeries) {
        try {
            return etherPmStatsSeries.getMaxBuckets();
        }
        catch (Exception exception) {
            return 1;
        }
    }

    public Class getColumnClass(int n) {
        if (n < 3) {
            return class$java$lang$String == null ? (class$java$lang$String = EtherStatsTableModel.class$("java.lang.String")) : class$java$lang$String;
        }
        return class$cerent$util$gui$TransmitReceive == null ? (class$cerent$util$gui$TransmitReceive = EtherStatsTableModel.class$("cerent.util.gui.TransmitReceive")) : class$cerent$util$gui$TransmitReceive;
    }

    public int getColumnCount() {
        return 3 + this.nCols;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Circuit Name";
        }
        if (n == 1) {
            return "Size";
        }
        if (n == 2) {
            TDMTerminology tDMTerminology = this.nodeModel.getTDMTerminology();
            return "Slot/Port/" + tDMTerminology.getGeneralTerms(0);
        }
        return this.colNames[n - 3];
    }

    public int getRowCount() {
        return this.etherPmStatsList.size();
    }

    public int getFixedColumnCount() {
        return 3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class EtherPmStats {
        private EtherMediaModel model;
        private String cktName;
        private int pathWidth;
        private IPortModel portModel;
        private int slotNo;
        private IHoNum startingHo;
        private sTimedStatsPair[] timedStats;

        public EtherPmStats(EtherMediaModel etherMediaModel, String string, int n, int n2, IPortModel iPortModel, IHoNum iHoNum) {
            this.model = etherMediaModel;
            this.cktName = string;
            this.pathWidth = n;
            this.slotNo = n2;
            this.portModel = iPortModel;
            this.startingHo = iHoNum;
            this.timedStats = new sTimedStatsPair[0];
        }

        public String getCircuitName() {
            return this.cktName;
        }

        public String getCircuitSize() {
            ICircuitSize iCircuitSize = CircuitSize.width2sizeOfHoCircuit((int)this.pathWidth, (int)EtherStatsTableModel.this.nodeModel.getFramingType());
            return iCircuitSize.getCircuitSizeString();
        }

        public String getSlotPortHo() {
            try {
                EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
                String string = HoLoHelper.getDisplay(this.startingHo, true);
                return "s" + this.slotNo + "/p" + entityCellRenderer.getPortString((IEntityModel)this.portModel, false, true) + "/S" + string;
            }
            catch (Exception exception) {
                if (db.on) {
                    db.println("Error in getSlotPortHo() " + exception);
                }
                return null;
            }
        }

        public sTimedStatsPair[] getTimedStats() {
            return this.timedStats;
        }

        public void refreshPmStats(EtherPmStatsSeries etherPmStatsSeries) throws NoSuchStatsSeries, NoSuchInterface {
            this.timedStats = this.model.getTxRxUtilizationSeries(etherPmStatsSeries);
        }
    }
}

