/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.event;

import cerent.cms.model.IModel;
import cerent.cms.model.event.AbstractEventStore;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.event.EventPanel;
import cerent.cms.ui.event.IEventPanelController;
import cerent.util.Preferences;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public abstract class EventPane
extends AbstractPane
implements ActionListener,
PropertyChangeListener {
    private static final String TT_FILTER = "<html>Show Alarm Filter<P>Allows filtering of alarms</html>";
    public static final String NODE_TAB = "Node";
    public static final String CARD_TAB = "Card";
    private final ImageIcon FILTER_ENABLE_IMG = new ImageIcon(this.getClass().getResource("/images/icons/Toolbar-Filter.gif"));
    private final ImageIcon FILTER_DISABLE_IMG = new ImageIcon(this.getClass().getResource("/images/icons/Toolbar-Filter-Gray.gif"));
    protected AbstractEventStore eventStore;
    private EventPanel evtPanel;
    private IEventPanelController myController;
    private JButton filterButton;
    private JToggleButton filterIndicator;
    private static final String[] DEF_HIDECOL = new String[]{"Num", "Ref"};

    public EventPane(String string, IModel iModel, TabbedView tabbedView, AbstractEventStore abstractEventStore, IEventPanelController iEventPanelController) {
        super(string, iModel, tabbedView);
        this.eventStore = abstractEventStore;
        this.myController = iEventPanelController;
        this.eventStore.getEventFilter().setType(3);
        this.eventStore.getEventFilter().addObserver((Observer)((Object)this));
        Preferences.instance().addPropertyChangeListener((PropertyChangeListener)this);
    }

    private JPanel createCommandPanel() {
        this.filterIndicator = new JToggleButton(this.FILTER_DISABLE_IMG);
        this.filterIndicator.setSelectedIcon(this.FILTER_ENABLE_IMG);
        this.filterIndicator.setFocusPainted(false);
        this.filterIndicator.setPreferredSize(new Dimension(27, 25));
        this.filterIndicator.setToolTipText("Turn on/off alarm filter");
        this.filterIndicator.addActionListener(this);
        this.filterButton = new JButton("Filter...");
        this.filterButton.setToolTipText(TT_FILTER);
        this.filterButton.addActionListener(this);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.filterButton);
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(this.filterIndicator);
        CSHelpID cSHelpID = this.getHelpID();
        if (cSHelpID != null) {
            jPanel2.add(new CSHelpButton(cSHelpID));
        }
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "West");
        jPanel3.add((Component)jPanel2, "East");
        return jPanel3;
    }

    protected abstract EventPanel createEventPanel(IEventPanelController var1);

    protected abstract void showFilterDialog();

    public void enteringPage() throws Exception {
        if (this.evtPanel == null) {
            this.setLayout(new BorderLayout());
            this.evtPanel = this.createEventPanel(this.myController);
            this.add(this.evtPanel, "Center");
            this.add(this.createCommandPanel(), "South");
            this.table = this.evtPanel.getTable();
            int n = this.table.getColumn("Date").getModelIndex();
            int[] nArray = new int[]{n};
            boolean[] blArray = new boolean[nArray.length];
            if (this.evtPanel.getModel() instanceof SortableRowTableModel) {
                ((SortableRowTableModel)((Object)this.evtPanel.getModel())).setDefaultColSetting(nArray, blArray, DEF_HIDECOL);
            }
        }
        this.eventStore.getEventFilter().refreshCriteria();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
    }

    public void refresh() {
    }

    public void update(Observable observable, Object object) {
        if (this.filterIndicator != null && object instanceof Boolean) {
            this.filterIndicator.setSelected((Boolean)object);
        }
        super.update(observable, object);
    }

    private void setFilterActive(boolean bl) {
        if (this.eventStore.getEventFilter().isEnabled()) {
            this.eventStore.getEventFilter().setActive(bl);
            this.eventStore.setFilterActive(bl);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (this.isShowing() && (string.equals("useNeTimeZone") || string.equals("dateFormat"))) {
            this.repaint();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.filterButton) {
            this.showFilterDialog();
        } else if (object == this.filterIndicator) {
            this.setFilterActive(this.filterIndicator.isSelected());
        }
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (this.evtPanel != null) {
            this.evtPanel.dispose();
            this.evtPanel = null;
            this.filterIndicator.removeActionListener(this);
            this.filterIndicator = null;
            this.filterButton.removeActionListener(this);
            this.filterButton = null;
        }
        this.eventStore.getEventFilter().deleteObserver((Observer)((Object)this));
        Preferences.instance().removePropertyChangeListener((PropertyChangeListener)this);
        super.destroy();
    }

    public CSHelpID getHelpID() {
        return null;
    }
}

