/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.fcmr;

import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.CircuitExists;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.IModel;
import cerent.cms.model.InvalidState;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.fcmr.FcmrPortDistExtensionTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.SpinCellEditor;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class FcmrPortDistExtensionPane
extends NodeProvPane
implements TableModelListener,
PropertyChangeListener {
    protected FcmrPortDistExtensionTableModel dataModel = null;
    protected FcmrLineModel[] lineModels = null;
    private static final SDebug db = new SDebug("FcmrPortDistExtensionPane");

    public FcmrPortDistExtensionPane(String string, TabbedView tabbedView, FcmrLineModel[] fcmrLineModelArray) {
        super(string, tabbedView);
        this.lineModels = fcmrLineModelArray;
        super.registerWithModel();
    }

    private void init() {
        this.setDataModel();
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.customizedProvPane();
        this.registerWithModel();
        this.add((Component)uScrollPane);
    }

    public void enteringPage() throws Exception {
        if (this.dataModel == null) {
            this.init();
        }
        super.enteringPage();
        if (db.on()) {
            db.println("FcmrPortProvPane::enteringPage!");
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("FcmrPortLineProvPane::leavingPage!");
        }
        super.leavingPage();
    }

    protected void customizedProvPane() {
        TableColumn tableColumn = null;
        Object var2_2 = null;
        int n = 75;
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[0]);
        tableColumn.setPreferredWidth(n * 2);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[1]);
        tableColumn.setPreferredWidth(n);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[2]);
        tableColumn.setPreferredWidth(n);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[3]);
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.setPreferredWidth(n);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[4]);
        tableColumn.setPreferredWidth(n);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[5]);
        tableColumn.setCellEditor(new SpinCellEditor(this, 16, 16, 1200));
        tableColumn.setPreferredWidth(n);
    }

    protected void setDataModel() {
        this.dataModel = new FcmrPortDistExtensionTableModel((JPanel)((Object)this), this.lineModels);
        this.dataModel.addTableModelListener(this);
    }

    private UComboBox getComboBoxFor(Attribute[] attributeArray) {
        UComboBox uComboBox = new UComboBox((Object[])attributeArray);
        uComboBox.setEditable(false);
        return uComboBox;
    }

    protected AttributeMaps getAttributeMap() {
        IModel iModel = this.uiModel;
        return ElementDefaults.getAttributeMap(iModel);
    }

    protected Attribute[] getAttributeArray(String string) {
        return this.getAttributeMap().getAttributeArray(string);
    }

    protected void registerWithModel() {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    protected void unRegisterWithModel() {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    protected void changeMessage(Observable observable, Object object) {
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                FcmrPortDistExtensionPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In FcmrPortProvPane change Message cannot find Model " + observable);
        }
    }

    public void destroy() {
        this.unRegisterWithModel();
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.destroy();
            this.dataModel = null;
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void applyChangesToModel() throws Exception {
        block8: {
            StringBuffer stringBuffer = new StringBuffer();
            if (stringBuffer.length() != 0) {
                stringBuffer.append("Service may be affected.\n\nApply changes?");
                if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog")) {
                    return;
                }
            }
            try {
                this.dataModel.applyToModel();
                this.resetDirty();
            }
            catch (CircuitExists circuitExists) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_PORT_RATE_PROV_ERROR);
                if (FcmrPortDistExtensionPane.db.on) {
                    SDebug.printStackTrace((Throwable)circuitExists);
                }
            }
            catch (InvalidState invalidState) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CURR_PORT_STATE_DISALLOWS_CHANGE);
                if (FcmrPortDistExtensionPane.db.on) {
                    SDebug.printStackTrace((Throwable)invalidState);
                }
            }
            catch (Exception exception) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_CHANGES, exception.getMessage());
                if (!FcmrPortDistExtensionPane.db.on) break block8;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    protected void setAttrCellEditor(int n, String string) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.columnNames[n]);
        Attribute[] attributeArray = this.getAttributeArray(string);
        tableColumn.setCellEditor(new DefaultCellEditor((JComboBox<?>)this.getComboBoxFor(attributeArray)));
        tableColumn.sizeWidthToFit();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.FcmrPortDistExtensionPane;
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof DwdmLineUpdate) {
            DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
            if (db.on()) {
                db.println("Received DwdmLineUpdate...");
            }
            FcmrLineModel[] fcmrLineModelArray = dwdmLineUpdate.getFcmrLineModels();
            if (this.dataModel != null) {
                this.unRegisterWithModel();
                this.lineModels = fcmrLineModelArray;
                this.registerWithModel();
                this.dataModel.refreshMyLines(fcmrLineModelArray);
            } else {
                this.lineModels = fcmrLineModelArray;
            }
        } else if (db.on()) {
            db.println("refreshMyLines received " + object);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }
}

