/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.fcmr;

import cerent.cms.idl.FCMedia.eFCMediaType;
import cerent.cms.idl.FCMedia.sFCLineAdminInfo;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AdminState;
import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.IgnorableDialog;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;

public class FcmrPortDistExtensionTableModel
extends AbstractTableModel {
    private JPanel parent = null;
    private FcmrLineModel[] lineModels = null;
    protected boolean[][] isDirty = null;
    protected int numLines = 0;
    private sFCLineAdminInfo[] lineAdminInfo = null;
    protected EntityCellRenderer myPortRenderer;
    public String[] columnNames;
    public static final String[] fcmrColumnNames = new String[]{"Port", "Enable Distance Extension", "Auto Detect Credits", "Credits Available", "Autoadjust GFP Buffer Threshold", "GFP Buffers Available"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int ENABLE_DE = 1;
    public static final int AUTO_DETECT_CREDIT = 2;
    public static final int NUM_CREDITS = 3;
    public static final int AUTO_GFP_BUFFER = 4;
    public static final int GFP_BUFFERS_AVAILABLE = 5;
    public static final short MIN_CREDITS = 2;
    public static final short MAX_CREDITS = 256;
    public static final short MIN_GFP_BUFFERS = 16;
    public static final short MAX_GFP_BUFFERS = 1200;
    public static final short GFP_BUFFERS_INCREMENT = 16;
    private static final SDebug db = new SDebug("FcmrPortDistExtTableModel");
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;

    public FcmrPortDistExtensionTableModel(JPanel jPanel, FcmrLineModel[] fcmrLineModelArray) {
        this.parent = jPanel;
        this.myPortRenderer = new EntityCellRenderer(false);
        this.init(fcmrLineModelArray);
    }

    private void init(FcmrLineModel[] fcmrLineModelArray) {
        this.lineModels = fcmrLineModelArray;
        this.numLines = this.lineModels.length;
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.columnNames = fcmrColumnNames;
        this.lineAdminInfo = new sFCLineAdminInfo[this.numLines];
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl;
        boolean bl2;
        block10: {
            bl2 = false;
            bl = false;
            try {
                bl2 = this.getLineAdminInfo((int)n).creditAutoDetect;
                bl = this.getLineAdminInfo((int)n).gfpBufferAutoThreshold;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (db.on()) {
                    db.println("No Such Interface");
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!db.on()) break block10;
                db.println("Wrong Interface");
            }
        }
        if (this.lineModels != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.lineModels[0], SecurityLevel.PROVISIONING)) {
            switch (n2) {
                case 1: 
                case 2: 
                case 4: {
                    return true;
                }
                case 3: {
                    return !bl2;
                }
                case 5: {
                    return !bl;
                }
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private eFCMediaType getPortMediaType(int n) {
        eFCMediaType eFCMediaType2;
        block8: {
            eFCMediaType2 = null;
            if (this.lineAdminInfo[n] == null) {
                try {
                    this.getLineAdminInfo(n);
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (db.on()) {
                        db.println("No Such Interface");
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!db.on()) break block8;
                    db.println("Wrong Interface");
                }
            }
        }
        if (this.lineAdminInfo[n] == null) return eFCMediaType2;
        sFCLineAdminInfo[] sFCLineAdminInfoArray = this.lineAdminInfo;
        synchronized (this.lineAdminInfo) {
            return this.lineAdminInfo[n].portMediaType;
        }
    }

    private boolean isPortLinkRecoveryEnabled(int n) {
        block4: {
            try {
                return this.getLineAdminInfo((int)n).portLinkRecovery;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (db.on()) {
                    db.println("No Such Interface");
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!db.on()) break block4;
                db.println("Wrong Interface");
            }
        }
        return true;
    }

    public boolean isCellDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    private sFCLineAdminInfo getLineAdminInfo(int n) throws NoSuchInterface, WrongInterfaceType {
        block5: {
            if (this.lineAdminInfo[n] == null) {
                try {
                    this.lineAdminInfo[n] = this.lineModels[n].getFcLineAdminInfo();
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (db.on()) {
                        db.println("noSuch Interface");
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!db.on()) break block5;
                    db.println("wrong Interface");
                }
            }
        }
        return this.lineAdminInfo[n];
    }

    public int getColumnCount() {
        return fcmrColumnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Boolean getDistanceExtension(int n) throws NoSuchInterface, WrongInterfaceType {
        return new Boolean(this.getLineAdminInfo((int)n).portDistanceExtension);
    }

    public Short getNumberOfCredits(int n) throws NoSuchInterface, WrongInterfaceType {
        return new Short(this.getLineAdminInfo((int)n).numCredits);
    }

    public Boolean getGfpBufferAutoThreshold(int n) throws NoSuchInterface, WrongInterfaceType {
        return new Boolean(this.getLineAdminInfo((int)n).gfpBufferAutoThreshold);
    }

    public Short getGfpBuffersAvailable(int n) throws NoSuchInterface, WrongInterfaceType {
        return new Short(this.getLineAdminInfo((int)n).gfpNumBuffers);
    }

    public Boolean getAutoDetectCredit(int n) throws NoSuchInterface, WrongInterfaceType {
        return new Boolean(this.getLineAdminInfo((int)n).creditAutoDetect);
    }

    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        if (n == 2 || n == 1 || n == 4) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = FcmrPortDistExtensionTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = FcmrPortDistExtensionTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public Object getValueAt(int n, int n2) {
        block10: {
            try {
                switch (n2) {
                    case 0: {
                        return this.getPortDescriptionFor(n);
                    }
                    case 1: {
                        return this.getDistanceExtension(n);
                    }
                    case 2: {
                        return this.getAutoDetectCredit(n);
                    }
                    case 4: {
                        return this.getGfpBufferAutoThreshold(n);
                    }
                    case 5: {
                        return this.getGfpBuffersAvailable(n);
                    }
                    case 3: {
                        return this.getNumberOfCredits(n);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block10;
                db.println("Error in getValueAt in FcmrPortTableModel " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    protected boolean setGfpBuffers(String string, int n) {
        short s;
        String string2 = Short.toString((short)16);
        String string3 = Short.toString((short)1200);
        String string4 = Short.toString((short)16);
        try {
            s = Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMsg.displayError(this.parent, EMC.EID_FCMR_INVALID_GFP_THRESHOLDS_PARAM_3, string2, string3, string4);
            return false;
        }
        if (s < 16 || s > 1200 || s % 16 != 0) {
            ErrorMsg.displayError(this.parent, EMC.EID_FCMR_INVALID_GFP_THRESHOLDS_PARAM_3, string2, string3, string4);
            return false;
        }
        if (this.lineAdminInfo[n].gfpNumBuffers == s) {
            return false;
        }
        this.lineAdminInfo[n].gfpNumBuffers = s;
        return true;
    }

    protected boolean setNumCredits(String string, int n) {
        short s;
        String string2 = Short.toString((short)2);
        String string3 = Short.toString((short)256);
        try {
            s = Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMsg.displayError(this.parent, EMC.EID_FCMR_INVALID_NUM_CREDITS_PARAM_2, string2, string3);
            return false;
        }
        if (s < 2 || s > 256) {
            ErrorMsg.displayError(this.parent, EMC.EID_FCMR_INVALID_NUM_CREDITS_PARAM_2, string2, string3);
            return false;
        }
        if (this.lineAdminInfo[n].numCredits == s) {
            return false;
        }
        this.lineAdminInfo[n].numCredits = s;
        return true;
    }

    public void setValueAt(Object object, int n, int n2) {
        boolean bl = false;
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                eFCMediaType eFCMediaType2;
                if (!this.adminStateSanityCheck(n)) {
                    return;
                }
                boolean bl2 = (Boolean)object;
                if (!(bl2 || (eFCMediaType2 = this.getPortMediaType(n)) != eFCMediaType.FCMR_FICON_1GIG && eFCMediaType2 != eFCMediaType.FCMR_FICON_2GIG)) {
                    ErrorMsg.displayError((Component)this.parent, (EID)EMC.EID_FCMR_INVALID_MODE_FOR_PORT);
                    return;
                }
                if (this.isPortLinkRecoveryEnabled(n)) {
                    ErrorMsg.displayError(this.parent, EMC.EID_FCMR_INVALID_MODE_CHANGE_PARAM_2, " Distance Extension", " Link Recovery");
                    return;
                }
                this.lineAdminInfo[n].portDistanceExtension = bl2;
                bl = true;
                break;
            }
            case 2: {
                if (!this.adminStateSanityCheck(n)) {
                    return;
                }
                boolean bl3 = (Boolean)object;
                if (!bl3) {
                    IgnorableDialog.warningDialog((String)ErrorMsg.getString((EID)EMC.WID_FCMR_AUTODETECT_DISABLE_WARNING), (String)"AutoDetectCredit", (String)"AutoDetect Disable warning");
                }
                this.lineAdminInfo[n].creditAutoDetect = bl3;
                bl = true;
                break;
            }
            case 3: {
                if (!this.adminStateSanityCheck(n) || object == null) {
                    return;
                }
                if (this.setNumCredits((String)object, n)) break;
                return;
            }
            case 4: {
                if (!this.adminStateSanityCheck(n)) {
                    return;
                }
                boolean bl4 = (Boolean)object;
                if (!bl4) {
                    IgnorableDialog.warningDialog((String)ErrorMsg.getString((EID)EMC.WID_FCMR_GFPBUFFER_DISABLE_WARNING), (String)"GFPBuffer", (String)"GFPBuffer Disable Warning");
                }
                this.lineAdminInfo[n].gfpBufferAutoThreshold = bl4;
                bl = true;
                break;
            }
            case 5: {
                if (this.adminStateSanityCheck(n) && this.setGfpBuffers((String)object, n)) break;
                return;
            }
            default: {
                return;
            }
        }
        this.isDirty[n][n2] = bl ? !this.isDirty[n][n2] : true;
        this.fireTableCellUpdated(n, n2);
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            int n = this.getColumnCount();
            for (int j = 0; j < n; ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRowDirty(int n) {
        int n2 = this.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (!this.isDirty[n][i]) continue;
            return true;
        }
        return false;
    }

    public void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void resetRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.fireTableRowsUpdated(n, n);
    }

    public void destroy() {
        this.lineModels = null;
        this.isDirty = null;
        this.lineAdminInfo = null;
    }

    public void applyToModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            this.lineModels[i].setFcLineAdminInfo(this.getLineAdminInfo(i));
            this.resetRowDirty(i);
        }
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    protected void resetLineCache(int n) {
        this.lineAdminInfo[n] = null;
        this.resetRowDirty(n);
    }

    private boolean adminStateSanityCheck(int n) {
        try {
            if (AdminState.isFormOfIS(this.getLineAdminInfo((int)n).portState)) {
                ErrorMsg.displayError((Component)this.parent, (EID)EMC.EID_NO_PORT_PROV_WHILE_IS);
                return false;
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            if (db.on()) {
                db.println("No Such Interface");
            }
            return false;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            if (db.on()) {
                db.println("Wrong Interface Type");
            }
            return false;
        }
        return true;
    }

    public void refreshMyLines(FcmrLineModel[] fcmrLineModelArray) {
        this.init(fcmrLineModelArray);
        this.fireTableDataChanged();
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.lineModels[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

