/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.l2sc;

import cerent.cms.idl.EtherMedia.sL2scEtherPortInfo;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.L2scEtherPortModel;
import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.L2scPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.util.SDebug;
import javax.swing.table.AbstractTableModel;

public class L2scEtherPortInfoTableModel
extends AbstractTableModel {
    private L2scModuleModel eqpmtModel = null;
    private L2scPortModel[] portModels = null;
    private EtherLineModel[] lineModels = null;
    private boolean[] rowDirty = null;
    private int numLines = 0;
    private int numPorts = 0;
    private sL2scEtherPortInfo[] l2scEtherPortInfo = null;
    private String[] portName = null;
    public static String[] columnNames = new String[]{"Port", "Port Name", "Admin State", "Link State", "MTU", "Speed", "Duplex", "Flow Control", "Optics"};
    public static final int PORT_NUMBER_INDEX = 0;
    public static final int PORT_NAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int LINK_STATE_INDEX = 3;
    public static final int MTU_INDEX = 4;
    public static final int SPEED_INDEX = 5;
    public static final int DUPLEX_INDEX = 6;
    public static final int FLOW_CONTROL_INDEX = 7;
    public static final int OPTICS_INDEX = 8;
    private static final SDebug db = new SDebug("L2scEtherPortInfoTableModel");
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public L2scEtherPortInfoTableModel(L2scModuleModel l2scModuleModel, L2scPortModel[] l2scPortModelArray, EtherLineModel[] etherLineModelArray) {
        this.portModels = l2scPortModelArray;
        this.lineModels = etherLineModelArray;
        this.numPorts = l2scPortModelArray == null ? 0 : l2scPortModelArray.length;
        this.numLines = etherLineModelArray == null ? 0 : etherLineModelArray.length;
        this.eqpmtModel = l2scModuleModel;
        this.rowDirty = new boolean[this.numPorts];
        this.l2scEtherPortInfo = new sL2scEtherPortInfo[this.numPorts];
        this.portName = new String[this.numPorts];
        this.resetRowDirty();
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (n2 == 1) {
            bl = AbstractPane.isUserAuthorized(this.eqpmtModel, SecurityLevel.PROVISIONING);
        }
        return bl;
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    public sL2scEtherPortInfo getL2scEtherPortInfo(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.l2scEtherPortInfo[n] == null && this.portModels[n] instanceof L2scEtherPortModel) {
            L2scEtherPortModel l2scEtherPortModel = (L2scEtherPortModel)this.portModels[n];
            this.l2scEtherPortInfo[n] = l2scEtherPortModel.getL2scEtherPortInfo();
        }
        if (L2scEtherPortInfoTableModel.db.on) {
            db.finest("\ngetL2scEtherPortInfo(" + n + ") was called.");
            db.finest("   adminState:" + this.l2scEtherPortInfo[n].adminState);
            db.finest("   linkProtocolState:" + this.l2scEtherPortInfo[n].linkProtocolState);
            db.finest("   mtu:" + this.l2scEtherPortInfo[n].mtu);
            db.finest("   duplex:" + this.l2scEtherPortInfo[n].duplex.value());
            db.finest("   flowControlNegotiated:" + this.l2scEtherPortInfo[n].flowControlNegotiated.value());
            db.finest("   opticsType:" + this.l2scEtherPortInfo[n].opticsType.value());
        }
        return this.l2scEtherPortInfo[n];
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    private String getLineNumberFor(int n) {
        try {
            L2scPortModel l2scPortModel = this.portModels[n];
            return String.valueOf(l2scPortModel.getPort());
        }
        catch (Exception exception) {
            if (L2scEtherPortInfoTableModel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return "unknown";
        }
    }

    public int getRowCount() {
        return this.numPorts;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 1: {
                return class$java$lang$String == null ? (class$java$lang$String = L2scEtherPortInfoTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = L2scEtherPortInfoTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    private String getPortName(int n) {
        String string = "";
        if (this.portName[n] == null) {
            if (null == this.lineModels[n]) {
                string = "lineModels is null";
            } else {
                try {
                    this.portName[n] = string = this.lineModels[n].getAlias();
                }
                catch (Exception exception) {
                    if (L2scEtherPortInfoTableModel.db.on) {
                        db.println("Exception caught accessing port name: " + exception);
                    }
                    string = exception.toString();
                }
            }
        }
        return this.portName[n];
    }

    private void setPortName(int n, String string) {
        this.getPortName(n);
        try {
            if (null != this.lineModels[n] && null != string) {
                this.portName[n] = string;
                this.rowDirty[n] = true;
            }
        }
        catch (Exception exception) {
            if (L2scEtherPortInfoTableModel.db.on) {
                db.println("Exception caught setting port name: " + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private String getAdminState(int n) {
        String string = "";
        try {
            this.getL2scEtherPortInfo(n);
            boolean bl = this.l2scEtherPortInfo[n].adminState;
            string = bl ? "Up" : "Down";
        }
        catch (Exception exception) {
            if (L2scEtherPortInfoTableModel.db.on) {
                db.println("Exception caught accessing admin state: " + exception);
            }
            string = exception.toString();
        }
        return string;
    }

    private String getLinkState(int n) {
        String string = "";
        try {
            this.getL2scEtherPortInfo(n);
            boolean bl = this.l2scEtherPortInfo[n].linkProtocolState;
            string = bl ? "Up" : "Down";
        }
        catch (Exception exception) {
            if (L2scEtherPortInfoTableModel.db.on) {
                db.println("Exception caught accessing link state: " + exception);
            }
            string = exception.toString();
        }
        return string;
    }

    private String getMTU(int n) {
        String string = "";
        try {
            this.getL2scEtherPortInfo(n);
            string = new Integer(this.l2scEtherPortInfo[n].mtu).toString();
        }
        catch (Exception exception) {
            if (L2scEtherPortInfoTableModel.db.on) {
                db.println("Exception caught accessing mtu: " + exception);
            }
            string = exception.toString();
        }
        return string;
    }

    private String getDuplex(int n) {
        String string = "";
        try {
            this.getL2scEtherPortInfo(n);
            int n2 = this.l2scEtherPortInfo[n].duplex.value();
            switch (n2) {
                case 2: {
                    string = "Auto";
                    break;
                }
                case 0: {
                    string = "Full";
                    break;
                }
                case 1: {
                    string = "Half";
                    break;
                }
                default: {
                    string = "Unknown";
                    break;
                }
            }
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        return string;
    }

    private String getSpeed(int n) {
        String string = "";
        try {
            this.getL2scEtherPortInfo(n);
            int n2 = this.l2scEtherPortInfo[n].speed.value();
            switch (n2) {
                case 0: {
                    string = "10 Mbps";
                    break;
                }
                case 1: {
                    string = "100 Mbps";
                    break;
                }
                case 2: {
                    string = "1 Gbps";
                    break;
                }
                case 3: {
                    string = "Auto";
                    break;
                }
                default: {
                    string = "Unknown";
                    break;
                }
            }
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        return string;
    }

    private String getFlowControl(int n) {
        String string = "";
        try {
            this.getL2scEtherPortInfo(n);
            int n2 = this.l2scEtherPortInfo[n].flowControlNegotiated.value();
            switch (n2) {
                case 1: {
                    string = "Asymmetric";
                    break;
                }
                case 2: {
                    string = "Asymmetric local";
                    break;
                }
                case 0: {
                    string = "None";
                    break;
                }
                case 3: {
                    string = "Symmetric";
                    break;
                }
                default: {
                    string = "Unknown";
                    break;
                }
            }
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        return string;
    }

    private String getOpticsType(int n) {
        String string = "";
        try {
            this.getL2scEtherPortInfo(n);
            int n2 = this.l2scEtherPortInfo[n].opticsType.value();
            switch (n2) {
                case 2: {
                    string = "1000 LX";
                    break;
                }
                case 1: {
                    string = "1000 SX";
                    break;
                }
                case 3: {
                    string = "1000 ZX";
                    break;
                }
                case 0: {
                    string = "Unknown";
                    break;
                }
                case 4: {
                    string = "Unplugged";
                    break;
                }
                default: {
                    string = "REALLY_UNKNOWN";
                    break;
                }
            }
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        return string;
    }

    public Object getValueAt(int n, int n2) {
        String string;
        block13: {
            string = "";
            try {
                switch (n2) {
                    case 0: {
                        return this.getLineNumberFor(n);
                    }
                    case 1: {
                        return this.getPortName(n);
                    }
                    case 2: {
                        return this.getAdminState(n);
                    }
                    case 3: {
                        return this.getLinkState(n);
                    }
                    case 4: {
                        return this.getMTU(n);
                    }
                    case 5: {
                        return this.getSpeed(n);
                    }
                    case 6: {
                        return this.getDuplex(n);
                    }
                    case 7: {
                        return this.getFlowControl(n);
                    }
                    case 8: {
                        return this.getOpticsType(n);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block13;
                db.println("Error in getValueAt in L2scEtherPortInfoTableModel " + exception);
                SDebug.printStackTrace((Throwable)exception);
                string = exception.toString();
            }
        }
        return string;
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                if (!(object instanceof String)) break;
                String string = (String)object;
                this.setPortName(n, string);
                break;
            }
            case 2: {
                return;
            }
            case 3: {
                return;
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
            case 6: {
                return;
            }
            case 7: {
                return;
            }
            case 8: {
                return;
            }
            default: {
                return;
            }
        }
        this.rowDirty[n] = true;
        this.fireTableCellUpdated(n, n2);
    }

    public void resetRowDirty() {
        for (int i = 0; i < this.numPorts; ++i) {
            this.rowDirty[i] = false;
        }
    }

    public void refreshLineFromModel(int n) {
        this.l2scEtherPortInfo[n] = null;
        this.portName[n] = null;
        this.fireTableRowsUpdated(n, n);
    }

    public void applyToModels() {
        for (int i = 0; i < this.portModels.length; ++i) {
            if (!this.rowDirty[i]) continue;
            try {
                this.lineModels[i].setAlias(this.portName[i]);
                continue;
            }
            catch (Exception exception) {
                if (L2scEtherPortInfoTableModel.db.on) {
                    db.println("Exception caught trying to set port name : " + exception);
                }
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.resetRowDirty();
    }

    public void refresh() {
        for (int i = 0; i < this.numLines; ++i) {
            this.l2scEtherPortInfo[i] = null;
            this.portName[i] = null;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void destroy() {
        this.portModels = null;
        this.lineModels = null;
        this.eqpmtModel = null;
        this.rowDirty = null;
        for (int i = 0; i < this.l2scEtherPortInfo.length; ++i) {
            this.l2scEtherPortInfo[i] = null;
            this.portName[i] = null;
        }
        this.l2scEtherPortInfo = null;
        this.portName = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

