/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.model.ML2EtherLineModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ML2PosLineModel;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ml2.ML2EtherPortPmPane;
import cerent.cms.ui.ml2.ML2PosPortPmPane;
import cerent.util.SDebug;
import java.awt.Component;
import javax.swing.JLabel;

public class ML2PmPane
extends NodeProvPane
implements ITabName {
    private ML2ModuleModel eqpmtModel;
    private ML2EtherLineModel[] etherLineModels = null;
    private ML2PosLineModel[] posLineModels = null;
    private static final SDebug db = new SDebug("ML2PmPane");

    public ML2PmPane(String string, TabbedView tabbedView, ML2ModuleModel mL2ModuleModel) {
        super(string, tabbedView);
        this.eqpmtModel = mL2ModuleModel;
        this.etherLineModels = mL2ModuleModel.getEtherLineModels();
        this.posLineModels = mL2ModuleModel.getPosLineModels();
        if (this.etherLineModels == null || this.posLineModels == null) {
            db.println("ERROR: Ether Line or Pos Line Models are null!");
            this.add(new JLabel("This pane is unimplemented."));
            return;
        }
        this.subTabs = new SubTabbedView(mL2ModuleModel, tabbedView);
        this.subTabs.addTab("Ether Ports", (Component)this.getEtherPortPmTab());
        this.subTabs.addTab("POS Ports", (Component)this.getPosPortPmTab());
        this.subTabs.setTabPlacement(2);
        this.add((Component)this.subTabs);
    }

    private Pane getEtherPortPmTab() {
        return new ML2EtherPortPmPane("Ether Ports", this.getParentView(), this.etherLineModels);
    }

    private Pane getPosPortPmTab() {
        return new ML2PosPortPmPane("POS Ports", this.getParentView(), this.posLineModels);
    }

    public boolean hasSubTabs() {
        return true;
    }
}

