/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.model.EntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.L2scEtherPortModel;
import cerent.cms.model.L2scPosPortModel;
import cerent.cms.model.ML2EtherLineModel;
import cerent.cms.model.ML2PosLineModel;
import cerent.cms.model.PortModel;
import cerent.cms.ui.shelf.CardView;
import cerent.cms.ui.shelf.GenericPortGraphic;
import cerent.util.SDebug;

public class MLPortGraphic
extends GenericPortGraphic {
    private static final String UP = "Up";
    private static final String DOWN = "Down";
    private static final SDebug db = new SDebug("MLPortGraphic");

    public MLPortGraphic(CardView cardView, EntityModel entityModel, int n) {
        super(cardView, entityModel, n);
    }

    protected String getStatusLabel() {
        return "Link State: ";
    }

    protected synchronized void showState() {
        IModuleModel iModuleModel;
        int n;
        if (db.on()) {
            db.println("showState");
        }
        if ((n = (iModuleModel = this.model.getModuleModel()).getEqType()) == 163 || n == 187) {
            super.showState();
            return;
        }
        int n2 = 1;
        try {
            n2 = ((PortModel)this.model).getAdminState();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        if (n == 102 || n == 103) {
            this.statusString = this.getMLPortStateString();
        } else if (n == 164) {
            this.statusString = this.getML2PortStateString();
        }
        this.updateToolTip();
        this.setCurrentState(n2);
        this.setCurrentColor(MLPortGraphic.getPortColorByAdminStateAndSeverity(n2, this.currentSeverity));
        this.repaint();
    }

    private String getMLPortStateString() {
        String string = "Unknown";
        try {
            if (this.model instanceof L2scEtherPortModel) {
                L2scEtherPortModel l2scEtherPortModel = (L2scEtherPortModel)this.model;
                boolean bl = l2scEtherPortModel.getL2scEtherPortInfo().linkProtocolState;
                string = bl ? UP : DOWN;
            } else if (this.model instanceof L2scPosPortModel) {
                L2scPosPortModel l2scPosPortModel = (L2scPosPortModel)this.model;
                boolean bl = l2scPosPortModel.getL2scPosPortInfo().linkProtocolState;
                string = bl ? UP : DOWN;
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    private String getML2PortStateString() {
        String string = "Unknown";
        try {
            IInterfaceModel iInterfaceModel = ((PortModel)this.model).getInterfaceModel();
            if (iInterfaceModel instanceof ML2EtherLineModel) {
                ML2EtherLineModel mL2EtherLineModel = (ML2EtherLineModel)iInterfaceModel;
                boolean bl = mL2EtherLineModel.getML2EtherLineInfo().linkUp;
                string = bl ? UP : DOWN;
            } else if (iInterfaceModel instanceof ML2PosLineModel) {
                ML2PosLineModel mL2PosLineModel = (ML2PosLineModel)iInterfaceModel;
                boolean bl = mL2PosLineModel.getML2PosPortInfo().linkUp;
                string = bl ? UP : DOWN;
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }
}

