/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.muxdemux;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.OpticsAmplifiedLineModel;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsMultiplexSectionModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.muxdemux.MuxDmuxOpticalThresholdTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class MuxDmuxOpticalThresholdProvPane
extends NodeProvPane
implements TableModelListener {
    protected AbstractOpticsLineModel[] models;
    protected MuxDmuxOpticalThresholdTableModel dataModel;
    protected int numLines;
    protected int thresholdLayer;
    private boolean notInited = true;
    protected static final SDebug db = new SDebug("OpticalThresholdProvPane");

    public MuxDmuxOpticalThresholdProvPane(String string, TabbedView tabbedView, AbstractOpticsLineModel[] abstractOpticsLineModelArray, int n) {
        super(string, tabbedView);
        this.models = abstractOpticsLineModelArray;
        this.thresholdLayer = n;
    }

    protected void init() {
        this.numLines = this.models.length;
        this.dataModel = this.getDataModel(this.thresholdLayer);
        this.dataModel.addTableModelListener(this);
        this.table = new JTable(this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        TableColumn tableColumn = this.table.getColumn(MuxDmuxOpticalThresholdTableModel.columnNames[0]);
        tableColumn.setPreferredWidth(150);
        this.registerWithModel();
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.table.setAutoResizeMode(0);
        this.notInited = false;
    }

    protected void registerWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.models[i] == null) continue;
            this.models[i].addObserver((Observer)((Object)this));
        }
    }

    public void dispose() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.models[i] == null) continue;
            this.models[i].deleteObserver((Observer)((Object)this));
        }
    }

    public void leavingPage() throws Exception {
        if (this.table != null) {
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        }
        super.leavingPage();
    }

    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
        this.dataModel.refreshFromModel();
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.notInited = true;
        super.destroy();
    }

    protected void removeColumn(int n) {
        String string = MuxDmuxOpticalThresholdTableModel.columnNames[n];
        TableColumn tableColumn = this.table.getColumn(string);
        this.table.removeColumn(tableColumn);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                MuxDmuxOpticalThresholdProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.models).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            try {
                this.dataModel.refreshLineFromModel(n);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_ROW_PARAM_1, (Object)Integer.toString(n + 1));
            }
        } else if (db.on()) {
            db.println("changeMessage cannot find Model " + observable);
        }
    }

    public void applyChangesToModel() throws Exception, ConfigError {
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    protected MuxDmuxOpticalThresholdTableModel getDataModel(int n) {
        return new MuxDmuxOpticalThresholdTableModel(this.models, n);
    }

    public CSHelpID getHelpID() {
        if (this.models != null && this.models.length > 0) {
            if (this.models[0] instanceof OpticsLineModel) {
                return CSHelpConst.MuxDmuxLineThresholdProvPane;
            }
            if (this.models[0] instanceof OpticsMultiplexSectionModel) {
                return CSHelpConst.MuxDmuxBandThresholdProvPane;
            }
            if (this.models[0] instanceof OpticsChannelModel) {
                return CSHelpConst.MuxDmuxChannelThresholdProvPane;
            }
            if (this.models[0] instanceof OpticsAmplifiedLineModel) {
                return CSHelpConst.MuxDmuxAmpliLineThresholdProvPane;
            }
            return null;
        }
        return CSHelpConst.MuxDmuxLineThresholdProvPane;
    }
}

