/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.muxdemux;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsMultiplexSectionModel;
import cerent.cms.model.ParserIfName;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.muxdemux.MuxDmuxOCHParametersProvPane;
import cerent.cms.ui.muxdemux.MuxDmuxOMSParametersProvPane;
import cerent.cms.ui.muxdemux.MuxDmuxOTSParametersProvPane;
import cerent.cms.ui.muxdemux.MuxDmuxOpticalThresholdPane;
import java.awt.Component;
import java.util.Vector;

public class MuxDmuxProvPane
extends NodeProvPane
implements ITabName {
    ModuleModel eqpmtModel = null;
    private OpticsModuleModel model = (OpticsModuleModel)this.getUiModel();
    private OpticsChannelModel[] chModels;
    private OpticsMultiplexSectionModel[] omsModels = this.model.getOpticsOMSModels();
    private OpticsLineModel[] otsModels = this.model.getOpticsLineModels();

    public MuxDmuxProvPane(String string, TabbedView tabbedView, ModuleModel moduleModel) {
        super(string, tabbedView);
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.model.getNodeModel();
        this.eqpmtModel = moduleModel;
        this.subTabs = new SubTabbedView(moduleModel, tabbedView);
        if (191 == moduleModel.getEqType()) {
            OpticsChannelModel[][] opticsChannelModelArray = this.getOpticsChannelModelsByOptConn(this.model.getOpticsChannelModels());
            this.subTabs.addTab("<html>Optical Chn:<br>Optical Connector 1<html>", (Component)this.getOCHTabs(this.subTabs, opticsChannelModelArray[0]));
            this.subTabs.addTab("<html>Optical Chn:<br>Optical Connector 2<html>", (Component)this.getOCHTabs(this.subTabs, opticsChannelModelArray[1]));
            this.subTabs.addTab("<html>Optical Chn:<br>Optical Connector 3<html>", (Component)this.getOCHTabs(this.subTabs, opticsChannelModelArray[2]));
            this.subTabs.addTab("<html>Optical Chn:<br>Optical Connector 4<html>", (Component)this.getOCHTabs(this.subTabs, opticsChannelModelArray[3]));
        } else {
            this.chModels = this.model.getOpticsChannelModels();
            this.subTabs.addTab("Optical Chn", (Component)this.getOCHTabs(this.subTabs, this.chModels));
        }
        if (133 == moduleModel.getEqType()) {
            this.subTabs.addTab("Optical Band", (Component)this.getOMSTabs(this.subTabs, this.omsModels));
        } else {
            this.subTabs.addTab("Optical Line", (Component)this.getOtsTabs(this.subTabs, this.otsModels));
        }
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, false));
        this.subTabs.setTabPlacement(2);
        this.add((Component)this.subTabs);
    }

    private OpticsChannelModel[][] getOpticsChannelModelsByOptConn(OpticsChannelModel[] opticsChannelModelArray) {
        Vector<OpticsChannelModel> vector = new Vector<OpticsChannelModel>();
        Vector<OpticsChannelModel> vector2 = new Vector<OpticsChannelModel>();
        Vector<OpticsChannelModel> vector3 = new Vector<OpticsChannelModel>();
        Vector<OpticsChannelModel> vector4 = new Vector<OpticsChannelModel>();
        for (int i = 0; i < opticsChannelModelArray.length; ++i) {
            ParserIfName parserIfName = new ParserIfName(opticsChannelModelArray[i].getIfIndex());
            if (parserIfName.isPTport()) continue;
            try {
                switch ((opticsChannelModelArray[i].getPortNumber() - 1) / 8) {
                    case 0: {
                        vector.add(opticsChannelModelArray[i]);
                        vector.add(opticsChannelModelArray[i + 32]);
                        break;
                    }
                    case 1: {
                        vector2.add(opticsChannelModelArray[i]);
                        vector2.add(opticsChannelModelArray[i + 32]);
                        break;
                    }
                    case 2: {
                        vector3.add(opticsChannelModelArray[i]);
                        vector3.add(opticsChannelModelArray[i + 32]);
                        break;
                    }
                    case 3: {
                        vector4.add(opticsChannelModelArray[i]);
                        vector4.add(opticsChannelModelArray[i + 32]);
                    }
                }
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                // empty catch block
            }
        }
        OpticsChannelModel[][] opticsChannelModelArray2 = new OpticsChannelModel[][]{vector.toArray(new OpticsChannelModel[0]), vector2.toArray(new OpticsChannelModel[0]), vector3.toArray(new OpticsChannelModel[0]), vector4.toArray(new OpticsChannelModel[0])};
        return opticsChannelModelArray2;
    }

    protected Pane getOtsTabs(TabbedView tabbedView, OpticsLineModel[] opticsLineModelArray) {
        return new MuxDmuxOTSProvPane(tabbedView, opticsLineModelArray);
    }

    protected Pane getOMSTabs(TabbedView tabbedView, OpticsMultiplexSectionModel[] opticsMultiplexSectionModelArray) {
        return new MuxDmuxOMSProvPane(tabbedView, opticsMultiplexSectionModelArray);
    }

    protected Pane getOCHTabs(TabbedView tabbedView, OpticsChannelModel[] opticsChannelModelArray) {
        return new MuxDmuxOCHProvPane(tabbedView, opticsChannelModelArray);
    }

    protected Pane getOMSParametersProvTab(OpticsMultiplexSectionModel[] opticsMultiplexSectionModelArray) {
        return new MuxDmuxOMSParametersProvPane("Parameters", this.getParentView(), opticsMultiplexSectionModelArray);
    }

    protected Pane getOCHParametersProvTab(OpticsChannelModel[] opticsChannelModelArray) {
        return new MuxDmuxOCHParametersProvPane("Parameters", this.getParentView(), opticsChannelModelArray);
    }

    protected Pane getOTSParametersProvTab(OpticsLineModel[] opticsLineModelArray) {
        return new MuxDmuxOTSParametersProvPane("Parameters", this.getParentView(), opticsLineModelArray);
    }

    protected Pane getOptThresholdsTab(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        return new MuxDmuxOpticalThresholdPane("Optics Thresholds", this.getParentView(), abstractOpticsLineModelArray);
    }

    public boolean hasSubTabs() {
        return true;
    }

    private class MuxDmuxOCHProvPane
    extends NodeProvPane {
        public MuxDmuxOCHProvPane(TabbedView tabbedView, OpticsChannelModel[] opticsChannelModelArray) {
            super("MuxDmuxProvPane", tabbedView);
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            this.subTabs.addTab("Parameters", (Component)MuxDmuxProvPane.this.getOCHParametersProvTab(opticsChannelModelArray));
            this.subTabs.addTab("Optics Thresholds", (Component)MuxDmuxProvPane.this.getOptThresholdsTab(opticsChannelModelArray));
            this.add((Component)this.subTabs);
        }

        public boolean hasSubTabs() {
            return true;
        }
    }

    private class MuxDmuxOMSProvPane
    extends NodeProvPane {
        public MuxDmuxOMSProvPane(TabbedView tabbedView, OpticsMultiplexSectionModel[] opticsMultiplexSectionModelArray) {
            super("MaxDmaxOMSProvPane", tabbedView);
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            this.subTabs.addTab("Parameters", (Component)MuxDmuxProvPane.this.getOMSParametersProvTab(opticsMultiplexSectionModelArray));
            this.subTabs.addTab("Optics Thresholds", (Component)MuxDmuxProvPane.this.getOptThresholdsTab(opticsMultiplexSectionModelArray));
            this.add((Component)this.subTabs);
        }

        public boolean hasSubTabs() {
            return true;
        }
    }

    private class MuxDmuxOTSProvPane
    extends NodeProvPane {
        public MuxDmuxOTSProvPane(TabbedView tabbedView, OpticsLineModel[] opticsLineModelArray) {
            super("MuxDmuxOTSProvPane", tabbedView);
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            this.subTabs.addTab("Parameters", (Component)MuxDmuxProvPane.this.getOTSParametersProvTab(opticsLineModelArray));
            this.subTabs.addTab("Optics Thresholds", (Component)MuxDmuxProvPane.this.getOptThresholdsTab(opticsLineModelArray));
            this.add((Component)this.subTabs);
        }

        public boolean hasSubTabs() {
            return true;
        }
    }
}

