/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nedefaults;

import cerent.cms.model.CTCUserException;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.nedefaults.DefaultsManager;
import cerent.cms.model.nedefaults.IDefaultsElement;
import cerent.cms.model.nedefaults.IDefaultsNode;
import cerent.launcher.CmsClassLoader;
import cerent.util.BuildInfo;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.SortableProperties;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedLogDialog;
import cerent.util.gui.PersistentFileChooserDialog;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class DefaultsHelper {
    private static final String PROP_PREF = "ctc.defaults";
    private static final String PROP_SCOPE = "scope";
    private IDefaultsNode droot;
    private NodeModelDelegate nodeModel;
    private Component parent;

    public DefaultsHelper(Component component, NodeModelDelegate nodeModelDelegate) {
        this.nodeModel = nodeModelDelegate;
        this.parent = component;
    }

    public IDefaultsNode getDefaultsRoot(boolean bl) throws Exception {
        if (this.droot == null || bl) {
            this.droot = this.nodeModel.getDefaultsManager().getDefaultsTree();
        }
        return this.droot;
    }

    public String importDefaults() {
        File file = this.getFile(false);
        if (file == null) {
            return null;
        }
        DefaultsManager defaultsManager = this.nodeModel.getDefaultsManager();
        try {
            if (defaultsManager.importDefaults(file, this.getDefaultsRoot(false), new ConfirmImport())) {
                return file.getAbsolutePath();
            }
            ErrorMsg.displayError((Component)this.parent, (EID)EMC.EID_FILE_LOAD_PARAM_1, (Object)file.getAbsolutePath());
        }
        catch (CTCUserException cTCUserException) {
            SDebug.printStackTrace((Throwable)cTCUserException);
            ErrorMsg.displayError((Component)this.parent, (EID)EMC.EID_FILE_LOAD_PARAM_1, (Object)file.getAbsolutePath());
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)this.parent, (EID)EMC.EID_NODE_PROP_LOAD);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String exportDefaults() {
        File file = this.getFile(true);
        if (file == null) return null;
        FileOutputStream fileOutputStream = null;
        Properties properties = this.getDefaultsProperties();
        ClassLoader classLoader = this.getClass().getClassLoader();
        String string = "unknown";
        if (classLoader instanceof CmsClassLoader) {
            string = BuildInfo.sanitize(((CmsClassLoader)classLoader).getSwVersion());
        }
        String string2 = "NE Defaults from build=" + string;
        fileOutputStream = new FileOutputStream(file);
        properties.store(fileOutputStream, string2);
        String string3 = file.getAbsolutePath();
        Object var9_10 = null;
        if (fileOutputStream == null) return string3;
        try {
            fileOutputStream.close();
            return string3;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string3;
        {
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)this.parent, (EID)EMC.EID_FAIL_SAVE_DEFAULTS_PARAM_1, (Object)file.getAbsolutePath());
                Object var9_11 = null;
                if (fileOutputStream == null) return null;
                try {
                    fileOutputStream.close();
                    return null;
                }
                catch (Exception exception2) {}
                return null;
                {
                    catch (Exception exception3) {
                        SDebug.printStackTrace((Throwable)exception3);
                        ErrorMsg.displayError((Component)this.parent, (EID)EMC.EID_NODE_DEFAULT_LOAD);
                        Object var9_12 = null;
                        if (fileOutputStream == null) return null;
                        try {
                            fileOutputStream.close();
                            return null;
                        }
                        catch (Exception exception4) {}
                        return null;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    if (fileOutputStream == null) throw throwable;
                    try {
                        fileOutputStream.close();
                        throw throwable;
                    }
                    catch (Exception exception5) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    private File getFile(boolean bl) {
        byte by;
        String string;
        String string2;
        if (bl) {
            string2 = "Export defaults to file";
            string = "Select the file where defaults should be exported to";
            by = 3;
        } else {
            string2 = "Import defaults from file";
            string = "Select the file from where defaults should be imported";
            by = 1;
        }
        return PersistentFileChooserDialog.getFile((Component)this.parent, (String)string2, (Object)string, (byte)by, (String)"ctc", (String)"defaults.history", (int)20);
    }

    private Properties getDefaultsProperties() throws Exception {
        SortableProperties sortableProperties = new SortableProperties(new Properties());
        HashMap hashMap = new HashMap();
        this.fillMap(hashMap, this.getDefaultsRoot(false));
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            IDefaultsElement iDefaultsElement = (IDefaultsElement)hashMap.get(string);
            sortableProperties.setProperty(string, iDefaultsElement.getValue());
        }
        sortableProperties.setSortedKeys(true);
        return sortableProperties;
    }

    public void fillMap(Map map, IDefaultsNode iDefaultsNode) {
        IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsNode iDefaultsNode2 = iDefaultsNodeArray[i];
            if (iDefaultsNode2 instanceof IDefaultsElement) {
                map.put(((IDefaultsElement)iDefaultsNode2).getFullName(), iDefaultsNode2);
                continue;
            }
            this.fillMap(map, iDefaultsNode2);
        }
    }

    private class ConfirmImport
    implements DefaultsManager.IValidity {
        private ConfirmImport() {
        }

        public boolean doCancel(int n, DetailedLog detailedLog) {
            if (detailedLog != null) {
                String string = "Accepted " + n + " defaults with valid values\n" + detailedLog.getDesc() + ".\n" + "Continue importing this file anyway? (Invalid entries will be ignored)";
                DetailedLogDialog detailedLogDialog = new DetailedLogDialog(JOptionPane.getFrameForComponent(DefaultsHelper.this.parent), "Import Defaults", (Icon)CerentDialog.FATAL_ICON, string, detailedLog, true, 3);
                detailedLogDialog.show();
                return detailedLogDialog.isCancelled();
            }
            return false;
        }
    }
}

