/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nedefaults;

import cerent.cms.model.Attribute;
import cerent.cms.model.nedefaults.IDefaultsElement;
import cerent.cms.ui.shelf.SppDefaultsEditorPane;
import cerent.util.gui.AbstractCellEditor;
import cerent.util.gui.HtmlLabelEditor;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DefaultsTableCellEditor
extends AbstractCellEditor
implements ItemListener {
    private JTextField textField = new JTextField();
    private JTextArea textArea = new JTextArea();
    private JComboBox comboBox = new JComboBox();
    private JScrollPane scrollTextArea = new JScrollPane(this.textArea);
    private HtmlLabelEditor htmlEditor;
    private boolean isHtml;
    private int selector;
    private SppDefaultsEditorPane defaultEditorPane = null;

    public DefaultsTableCellEditor(SppDefaultsEditorPane sppDefaultsEditorPane) {
        this.defaultEditorPane = sppDefaultsEditorPane;
        this.comboBox.addItemListener(this);
        this.textArea.setLineWrap(true);
        this.scrollTextArea.setHorizontalScrollBarPolicy(31);
    }

    public boolean stopCellEditing() {
        Object object = null;
        switch (this.selector) {
            case 0: {
                object = this.textField.getText();
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                object = this.comboBox.getSelectedItem();
                break;
            }
            case 1: {
                object = this.textArea.getText();
                break;
            }
            case 5: {
                object = this.htmlEditor.getText();
                break;
            }
            default: {
                object = null;
            }
        }
        this.setCellEditorValue(object);
        return super.stopCellEditing();
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        JComponent jComponent = null;
        IDefaultsElement iDefaultsElement = (IDefaultsElement)object;
        this.selector = iDefaultsElement.getDefElemClass();
        switch (this.selector) {
            case 0: {
                this.textField.setText(iDefaultsElement.getValue());
                jComponent = this.textField;
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                Object[] objectArray = iDefaultsElement.getValidEnumValues();
                this.comboBox.setModel(new DefaultComboBoxModel<Object>(objectArray));
                Object object2 = iDefaultsElement.getValue();
                if (objectArray != null & objectArray.length > 0 && objectArray[0] instanceof Attribute) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        Attribute attribute = (Attribute)objectArray[i];
                        if (!attribute.getKey().equals(object2)) continue;
                        object2 = attribute;
                        break;
                    }
                }
                this.comboBox.setSelectedItem(object2);
                jComponent = this.comboBox;
                break;
            }
            case 1: {
                this.textArea.setText(iDefaultsElement.getValue());
                jComponent = this.scrollTextArea;
                break;
            }
            case 5: {
                if (this.htmlEditor == null) {
                    this.htmlEditor = new HtmlLabelEditor();
                }
                this.htmlEditor.setText(iDefaultsElement.getValue());
                jComponent = this.htmlEditor;
                break;
            }
            default: {
                jComponent = null;
            }
        }
        return jComponent;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.defaultEditorPane.setDirty(true);
        }
    }
}

