/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oscm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.SonetMedia.sSectionThresholds;
import cerent.cms.model.FramingType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.sonet.TdmSectionPmThresholdsTableModel;
import cerent.util.AnnotatedException;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class OscmOcSectionPmThresholdsPane
extends NodeProvPane
implements TableModelListener {
    TdmSectionPmThresholdsTableModel dataModel = null;
    TdmLineModel[] lineModels = null;
    OpticsModuleModel eqpmtModel = null;
    eIntervalType intervalType = null;
    boolean nearEnd = false;
    protected int numLines = 0;
    private static final SDebug db = new SDebug("TdmSectionPmThresholdsPane");

    public OscmOcSectionPmThresholdsPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray, eIntervalType eIntervalType2, boolean bl) {
        super(string, tabbedView);
        TableColumn tableColumn = null;
        this.lineModels = tdmLineModelArray;
        this.numLines = this.lineModels == null ? 0 : 1;
        this.intervalType = eIntervalType2;
        this.nearEnd = bl;
        INodeModel iNodeModel = tabbedView.getUiModel().getNodeModel();
        int n = iNodeModel.getFramingType();
        this.dataModel = new TdmSectionPmThresholdsTableModel(iNodeModel, this.lineModels, this.intervalType, bl);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[0]);
        tableColumn.setPreferredWidth(150);
        if (FramingType.getFramingType((int)n).isSdh()) {
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(5));
            this.table.removeColumn(tableColumn);
        } else {
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
            this.table.removeColumn(tableColumn);
        }
        this.registerWithModel();
        this.add((Component)uScrollPane);
    }

    protected void registerWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    public void dispose() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                OscmOcSectionPmThresholdsPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In TdmSectionPmThresholdsPane changeMessage cannot find Model " + observable);
        }
    }

    public void applyChangesToModel() throws Exception {
        int n = 0;
        try {
            for (n = 0; n < this.numLines; ++n) {
                if (db.on()) {
                    db.println("setting at iteration " + n);
                }
                if (!this.dataModel.isRowDirty(n)) continue;
                this.printThresholds(this.dataModel.getThresholdsVal(n));
                this.lineModels[n].setSectionPmThresholds(this.intervalType, this.nearEnd, this.dataModel.getThresholdsVal(n));
            }
            this.dataModel.resetDirtyBits();
        }
        catch (Exception exception) {
            throw new AnnotatedException("Error applying changes to row " + (n + 1), exception);
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        int n;
        if (this.lineModels == null) {
            return;
        }
        int n2 = n = tableModelEvent.getLastRow() > this.numLines - 1 ? this.numLines - 1 : tableModelEvent.getLastRow();
        if (db.on()) {
            db.println("Got a table changed message val = " + n);
        }
        for (int i = tableModelEvent.getFirstRow(); i <= n; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    private void printThresholds(sSectionThresholds sSectionThresholds2) {
        if (db.on()) {
            db.println("===============================================");
            db.println("Near End = " + this.nearEnd + " Interval Type = " + EnumStrings.getString((Object)this.intervalType, (int)this.intervalType.value()));
            db.println("CV " + sSectionThresholds2.cv);
            db.println("ES " + sSectionThresholds2.es);
            db.println("SES " + sSectionThresholds2.ses);
            db.println("BBE " + sSectionThresholds2.bbe);
            db.println("SEFS " + sSectionThresholds2.sefs);
            db.println("===============================================");
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.OscmOcSectionPmThresholdsPane;
    }
}

