/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.SonetMedia.sLineStats600;
import cerent.cms.idl.SonetMedia.sPhysicalStats600;
import cerent.cms.idl.SonetMedia.sSectionStats600;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmRendererStat;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.util.SDebug;

public class PmLayerSonetLinePhys
extends PmLayer {
    protected sLineStats600[] lineStatsVal;
    protected sSectionStats600[] sectionStatsVal;
    protected sPhysicalStats600[] physicalStatsVal;
    protected TdmLineModel model;
    protected int numRegisters;
    protected static final String[] parmNames = new String[]{"CV-L", "ES-L", "SES-L", "UAS-L", "FC-L", "CV-S", "ES-S", "SES-S", "SEFS-S", "PSC", "PSD", "PSC-W", "PSD-W", "LBC", "OPT", "OPR"};
    protected static final int CV_L_INDEX = 0;
    protected static final int ES_L_INDEX = 1;
    protected static final int SES_L_INDEX = 2;
    protected static final int UAS_L_INDEX = 3;
    protected static final int FC_L_INDEX = 4;
    protected static final int CV_S_INDEX = 5;
    protected static final int ES_S_INDEX = 6;
    protected static final int SES_S_INDEX = 7;
    protected static final int SEFS_S_INDEX = 8;
    protected static final int PSC_INDEX = 9;
    protected static final int PSD_INDEX = 10;
    protected static final int PSCW_INDEX = 11;
    protected static final int PSDW_INDEX = 12;
    protected static final int LBC_INDEX = 13;
    protected static final int OPT_INDEX = 14;
    protected static final int OPR_INDEX = 15;
    protected static final int PSCS_INDEX = 16;
    protected static final int PSDS_INDEX = 17;
    protected static final int PSCR_INDEX = 18;
    protected static final int PSDR_INDEX = 19;
    private static final SDebug db = new SDebug("PmLayerSonetLinePhys");

    public PmLayerSonetLinePhys(PmTableModel pmTableModel, TdmLineModel tdmLineModel, int n, boolean bl) {
        super(pmTableModel, tdmLineModel, bl);
        this.model = tdmLineModel;
        this.numRegisters = n;
        this.lineStatsVal = new sLineStats600[this.numRegisters];
        this.sectionStatsVal = new sSectionStats600[this.numRegisters];
        this.physicalStatsVal = new sPhysicalStats600[this.numRegisters];
    }

    public PmLayerSonetLinePhys(PmTableModel pmTableModel, TdmLineModel tdmLineModel, int n) {
        this(pmTableModel, tdmLineModel, n, true);
    }

    public void clearStats() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.model.clearLineStats(this.nearEnd, this.intervalType);
    }

    public void clearStats(String[] stringArray) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.model.clearStatsPerParam(this.nearEnd, this.intervalType, stringArray);
    }

    public void clearAllStatsForLine() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.model.clearAllStatsForLine();
    }

    public void clearAllStatsForCard() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.model.clearAllStatsForCard();
    }

    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        sPmStat sPmStat2 = PM_STATS_INVALID;
        this.refreshPmStats(n2);
        switch (n) {
            case 8: {
                if (!this.nearEnd) break;
                sPmStat2 = this.sectionStatsVal[n2].sefs;
                break;
            }
            case 7: {
                if (!this.nearEnd) break;
                sPmStat2 = this.sectionStatsVal[n2].ses;
                break;
            }
            case 6: {
                if (!this.nearEnd) break;
                sPmStat2 = this.sectionStatsVal[n2].es;
                break;
            }
            case 5: {
                if (!this.nearEnd) break;
                sPmStat2 = this.sectionStatsVal[n2].cv;
                break;
            }
            case 0: {
                sPmStat2 = this.lineStatsVal[n2].cv;
                break;
            }
            case 1: {
                sPmStat2 = this.lineStatsVal[n2].es;
                break;
            }
            case 2: {
                sPmStat2 = this.lineStatsVal[n2].ses;
                break;
            }
            case 3: {
                sPmStat2 = this.lineStatsVal[n2].uas;
                break;
            }
            case 4: {
                sPmStat2 = this.lineStatsVal[n2].fc;
                break;
            }
            case 9: {
                if (!this.nearEnd) break;
                sPmStat2 = this.lineStatsVal[n2].psc;
                break;
            }
            case 10: {
                if (!this.nearEnd) break;
                sPmStat2 = this.lineStatsVal[n2].psd;
                break;
            }
            case 11: {
                if (!this.nearEnd) break;
                sPmStat2 = this.lineStatsVal[n2].pscw;
                break;
            }
            case 12: {
                if (!this.nearEnd) break;
                sPmStat2 = this.lineStatsVal[n2].psdw;
                break;
            }
            case 16: {
                if (!this.nearEnd) break;
                sPmStat2 = this.lineStatsVal[n2].pscs;
                break;
            }
            case 17: {
                if (!this.nearEnd) break;
                sPmStat2 = this.lineStatsVal[n2].psds;
                break;
            }
            case 18: {
                if (!this.nearEnd) break;
                sPmStat2 = this.lineStatsVal[n2].pscr;
                break;
            }
            case 19: {
                if (!this.nearEnd) break;
                sPmStat2 = this.lineStatsVal[n2].psdr;
                break;
            }
            case 13: {
                if (!this.nearEnd) break;
                sPmStat2 = this.physicalStatsVal[n2].lbc;
                break;
            }
            case 14: {
                if (!this.nearEnd) break;
                sPmStat2 = this.physicalStatsVal[n2].opt;
                break;
            }
            case 15: {
                if (!this.nearEnd) break;
                sPmStat2 = this.physicalStatsVal[n2].opr;
                break;
            }
        }
        return new PmRendererStat(sPmStat2);
    }

    public String layerLabel() {
        return "Port";
    }

    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (this.lineStatsVal[n] == null) {
            if (db.on()) {
                db.println("calling getLineStats in PmLayerSonetLinePhys");
            }
            int n2 = this.intervalType == eIntervalType.INTERVAL_15_MIN ? this.numRegisters : this.numRegisters - 4;
            sLineStats600[] sLineStats600Array = new sLineStats600[n2];
            sSectionStats600[] sSectionStats600Array = new sSectionStats600[n2];
            sPhysicalStats600[] sPhysicalStats600Array = new sPhysicalStats600[n2];
            for (int i = 0; i < n2; ++i) {
                this.lineStatsVal[i] = new sLineStats600(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID);
                this.sectionStatsVal[i] = new sSectionStats600(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID);
                this.physicalStatsVal[i] = new sPhysicalStats600(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID);
                sLineStats600Array[i] = this.lineStatsVal[i];
                sSectionStats600Array[i] = this.sectionStatsVal[i];
                sPhysicalStats600Array[i] = this.physicalStatsVal[i];
            }
            this.model.getLineStats(this.nearEnd, this.intervalType, (short)-1, sLineStats600Array, sSectionStats600Array, sPhysicalStats600Array);
        }
    }

    public String parmName(int n) {
        return parmNames[n];
    }

    public int parmCount() {
        return parmNames.length;
    }

    public void setModel(InterfaceModel interfaceModel) {
        this.model = (TdmLineModel)interfaceModel;
    }

    public void tossData() {
        for (int i = 0; i < this.numRegisters; ++i) {
            this.lineStatsVal[i] = null;
            this.sectionStatsVal[i] = null;
            this.physicalStatsVal[i] = null;
        }
    }
}

