/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ppm;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.ui.helper.EqTypeHelper;
import cerent.cms.ui.helper.PluggableHelper;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.MultiLineLabelUI;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.LabelUI;

public class ChangePpmPortRateDialog
extends UDialog
implements ActionListener,
Observer {
    public static final String TITLE = "Edit Port Rate";
    public static final String CONFIRM_TITLE = "Confirm Port Rate Change";
    private JButton okButton;
    private JButton cancelButton;
    protected JComboBox portTypeCB;
    ArrayList portTypeList;
    protected PortModel portModel;
    protected IModuleModel module;
    private static final SDebug db = new SDebug("ChangePpmPortRateDialog");
    static /* synthetic */ Class class$cerent$cms$ui$ppm$ChangePpmPortRateDialog;

    public static ChangePpmPortRateDialog instance(Component component, Object object) {
        Frame frame = JOptionPane.getFrameForComponent(component);
        ChangePpmPortRateDialog changePpmPortRateDialog = (ChangePpmPortRateDialog)ChangePpmPortRateDialog.getRecycledDialog((Frame)frame, (String)TITLE, (Class)(class$cerent$cms$ui$ppm$ChangePpmPortRateDialog == null ? (class$cerent$cms$ui$ppm$ChangePpmPortRateDialog = ChangePpmPortRateDialog.class$("cerent.cms.ui.ppm.ChangePpmPortRateDialog")) : class$cerent$cms$ui$ppm$ChangePpmPortRateDialog), (Object)object);
        if (changePpmPortRateDialog == null) {
            changePpmPortRateDialog = new ChangePpmPortRateDialog(frame, object);
        }
        return changePpmPortRateDialog;
    }

    private ChangePpmPortRateDialog(Frame frame, Object object) {
        super(frame, TITLE, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        IEntityModel[] iEntityModelArray = (IEntityModel[])object;
        this.module = (IModuleModel)iEntityModelArray[0];
        this.portModel = (PortModel)iEntityModelArray[1];
        this.portTypeList = new ArrayList();
        jPanel.add((Component)this.getCreatePanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
        this.registerWithModel();
        this.enableUI();
    }

    public void dispose() {
        this.unRegisterWithModel();
        this.module = null;
        this.portModel = null;
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                if (this.apply()) {
                    this.dispose();
                }
            }
            catch (Exception exception) {
                db.fine("unexpected exception changing port rate");
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_CHANGES, exception.toString());
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    protected boolean apply() throws Exception {
        boolean bl = false;
        try {
            bl = this.confirmPortRateChange();
            if (bl) {
                this.applyChangesToModel();
            }
        }
        catch (Exception exception) {
            if (exception instanceof AbstractCmsObjectNotExistException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CHANGE_PORT_RATE_FAILED);
                this.refreshFromModel();
            }
            throw exception;
        }
        return bl;
    }

    private void enableUI() {
        boolean bl = this.portTypeCB.getModel().getSize() > 0;
        this.portTypeCB.setEnabled(bl);
        this.okButton.setEnabled(bl);
    }

    private JPanel getCreatePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        String string = PortHelper.getPortNumString((IPortModel)this.portModel);
        String string2 = this.getPortRateStr(this.portModel.getEqTypeEnum());
        String string3 = "\nYou are about to change the provisioning of Port " + string + ".\nThe port rate is currently provisioned for " + string2 + ".\n \nTo continue, select a new port rate below:";
        JLabel jLabel = new JLabel(string3);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add((Component)jLabel, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        this.portTypeCB = new JComboBox();
        if (this.module != null) {
            this.updatePortTypeList();
            this.portTypeCB.setModel(new DefaultComboBoxModel<eEqType>(this.getAllPortTypes()));
            this.portTypeCB.setRenderer(new PortTypeListCellRenderer());
            UComboBox.setPreferredWidth((JComboBox)this.portTypeCB, (int)(this.portTypeCB.getPreferredSize().width + 10));
        }
        jPanel2.add(new JLabel("Change to: "));
        jPanel2.add(this.portTypeCB);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    protected eEqType[] getPpmPortTypes() {
        eEqType[] eEqTypeArray;
        block3: {
            eEqTypeArray = new eEqType[]{};
            try {
                PpmModel ppmModel = (PpmModel)this.portModel.getParent();
                eEqTypeArray = ppmModel.getPortTypeList(this.portModel.getPositionInParent());
            }
            catch (Exception exception) {
                db.fine("Exception while calling getPortTypeList()");
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (db.on()) {
            db.println("getPpmPortTypes: number port types= " + eEqTypeArray.length);
        }
        return eEqTypeArray;
    }

    protected eEqType[] getAllPortTypes() {
        eEqType[] eEqTypeArray;
        block3: {
            eEqTypeArray = new eEqType[]{};
            try {
                PpmModel ppmModel = (PpmModel)this.portModel.getParent();
                eEqType[] eEqTypeArray2 = ppmModel.getAllPPMPortTypeList(this.portModel.getPositionInParent());
                ArrayList<eEqType> arrayList = new ArrayList<eEqType>(Arrays.asList(eEqTypeArray2));
                arrayList.remove(this.portModel.getEqTypeEnum());
                eEqTypeArray = arrayList.toArray(new eEqType[0]);
            }
            catch (Exception exception) {
                db.fine("Exception while calling getAllPPMPortTypeList()");
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (db.on()) {
            db.println("getAllPortTypes: number port types= " + eEqTypeArray.length);
        }
        return eEqTypeArray;
    }

    protected void refreshFromModel() {
        this.updatePortTypeList();
        this.portTypeCB.setModel(new DefaultComboBoxModel<eEqType>(this.getAllPortTypes()));
        this.enableUI();
    }

    private void updatePortTypeList() {
        this.portTypeList.clear();
        eEqType[] eEqTypeArray = this.getPpmPortTypes();
        for (int i = 0; i < eEqTypeArray.length; ++i) {
            this.portTypeList.add(eEqTypeArray[i]);
        }
    }

    private boolean isSupportedPortType(eEqType eEqType2) {
        return this.portTypeList.contains(eEqType2);
    }

    private String getPortRateStr(eEqType eEqType2) {
        return EqTypeHelper.getPortRateString((TDMTerminology)this.module.getNodeModel().getTDMTerminology(), (int)eEqType2.value());
    }

    public void applyChangesToModel() throws Exception {
        Object object;
        if (this.module != null && (object = this.portTypeCB.getSelectedItem()) instanceof eEqType) {
            try {
                PpmModel ppmModel = (PpmModel)this.portModel.getParent();
                ppmModel.changePPMPortType(this.portModel, (eEqType)object);
            }
            catch (ProvisionError provisionError) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_GENERIC_PROV_ERROR, provisionError.toString());
            }
            catch (ResourceInUse resourceInUse) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_PORT_IS_IN_USE, resourceInUse.toString());
            }
            catch (Exception exception) {
                throw exception;
            }
        }
    }

    private boolean confirmPortRateChange() throws Exception {
        boolean bl = false;
        Object object = this.portTypeCB.getSelectedItem();
        if (object instanceof eEqType) {
            PpmModel ppmModel = null;
            String string = null;
            String string2 = null;
            String string3 = this.getPortRateStr((eEqType)object);
            ppmModel = (PpmModel)this.portModel.getParent();
            string = PortHelper.getPortNumString((IPortModel)this.portModel);
            string2 = this.getPortRateStr(this.portModel.getEqTypeEnum());
            String string4 = this.module.getEqType() == 146 ? "All provisioning on Port " + string + " must be removed for the\nport rate change to succeed.\n \n" : "Changing the port rate may result in traffic loss on port " + string + ".\n \n";
            String string5 = "Change the rate of Port " + string + " from " + string2 + " to " + string3 + "?";
            if (this.isSupportedPortType((eEqType)object)) {
                bl = CerentDialog.yesNoDialog((Component)((Object)this), (String)(string4 + string5), (String)CONFIRM_TITLE);
            } else {
                String string6 = PluggableHelper.getHierarchyNumString(ppmModel.getHierarchyNums(), '-');
                String string7 = "The selected port rate, " + string3 + " is not supported by PPM " + string6 + ".\n A PPM that supports " + string3 + " must be installed.\n \n";
                String string8 = "You can change the port rate. However, an MEA alarm will be raised.\nThe alarm will clear after the compatible PPM is installed.\n \n";
                bl = CerentDialog.yesNoDialog((Component)((Object)this), (String)(string7 + string8 + string4 + string5), (String)CONFIRM_TITLE);
            }
        }
        return bl;
    }

    protected void registerWithModel() {
        this.module.addObserver((Observer)this);
    }

    protected void unRegisterWithModel() {
        this.module.deleteObserver((Observer)this);
    }

    public void update(Observable observable, Object object) {
        Integer n = (Integer)object;
        if (observable instanceof PluggableCarrierModel && n.equals(ModelUpdateType.DELETED)) {
            this.dispose();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PortTypeListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public PortTypeListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof eEqType) {
                StringBuffer stringBuffer = new StringBuffer();
                eEqType eEqType2 = (eEqType)object;
                String string = ChangePpmPortRateDialog.this.getPortRateStr(eEqType2);
                if ((eEqType2.value() == 166 || eEqType2.value() == 165 || eEqType2.value() == 104 || eEqType2.value() == 105) && (n = string.indexOf("_")) > 0) {
                    string = string.substring(n + 1, string.length());
                }
                stringBuffer.append(" ");
                stringBuffer.append(string);
                if (!ChangePpmPortRateDialog.this.isSupportedPortType((eEqType)object)) {
                    stringBuffer.append(" (requires new PPM)");
                }
                this.setText(stringBuffer.toString());
            }
            this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }

    class PpmPortListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public PpmPortListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof PortModel) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(" ");
                stringBuffer.append(PortHelper.getPortNumString((IPortModel)((PortModel)object)));
                stringBuffer.append(" (");
                stringBuffer.append(PortHelper.getPortTypeString((IEntityModel)((PortModel)object)));
                stringBuffer.append(") ");
                this.setText(stringBuffer.toString());
            }
            this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }
}

