/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ppm;

import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.MutablePortsPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ppm.PpmPane;
import cerent.util.SDebug;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class PpmProvPane
extends AbstractPane
implements ITabName {
    protected static final SDebug _db = new SDebug("PpmProvPane");
    private boolean _inited = false;
    private PpmPane _ppmPane = null;
    private MutablePortsPane _portsPane = null;

    public PpmProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(5, 5));
    }

    private void init() {
        this._inited = true;
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagPanel.fillBoth();
        gridBagPanel.add((Component)this.createPpmPane(), 0, 1);
        gridBagPanel.fillBoth();
        gridBagPanel.add((Component)this.createPortsPane(), 1, 1);
        this.add((Component)new UScrollPane((Component)gridBagPanel));
    }

    private JPanel createPpmPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(150, 10));
        jPanel.setBorder(BorderFactory.createTitledBorder("Pluggable Port Modules"));
        this._ppmPane = new PpmPane("Pluggable Port Modules", this.getParentView(), ((PluggableCarrierModel)this.getUiModel()).getPpmModels());
        jPanel.add((Component)((Object)this._ppmPane), "Center");
        return jPanel;
    }

    private JPanel createPortsPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this._portsPane = new MutablePortsPane("Pluggable Ports", this.getParentView(), ((PluggableCarrierModel)this.getUiModel()).getPpmModels(), 150, CSHelpConst.PpmPortPane, _db);
        jPanel.setPreferredSize(new Dimension(150, 10));
        jPanel.setBorder(BorderFactory.createTitledBorder("Pluggable Ports"));
        jPanel.add((Component)((Object)this._portsPane), "Center");
        return jPanel;
    }

    public void refresh() throws Exception {
    }

    public void enteringPage() throws Exception {
        this._ppmPane.enteringPage();
        this._portsPane.enteringPage();
    }

    public void leavingPage() throws Exception {
        this._ppmPane.leavingPage();
        this._portsPane.leavingPage();
    }

    public void setShowing(boolean bl) throws Exception {
        if (!this._inited) {
            this.init();
        }
        this._ppmPane.setShowing(bl);
        this._portsPane.setShowing(bl);
        super.setShowing(bl);
    }

    public void dispose() {
        if (this._inited) {
            this._ppmPane.destroy();
            this._portsPane.destroy();
            this._inited = false;
        }
        super.dispose();
    }
}

