/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.rmon;

import cerent.cms.model.IRmonModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.RmonLineUpdate;
import cerent.cms.model.RmonThresholdManager;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.rmon.RmonThresholdCreateDialog;
import cerent.cms.ui.rmon.RmonThresholdDataSource;
import cerent.cms.ui.rmon.RmonThresholdTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class RmonThresholdPane
extends AbstractPane
implements ActionListener,
ItemListener,
ListSelectionListener {
    private static final String CREATE = "Create...";
    private static final String DELETE = "Delete...";
    private JButton createButton = new JButton("Create...");
    private JButton deleteButton = new JButton("Delete...");
    private static final String SHOW_ALL_THRESHOLDS = "Show all RMON Thresholds";
    private JCheckBox showAllCheckBox;
    private RmonThresholdTableModel dataModel;
    private RmonThresholdDataSource dataSource;
    private boolean initialized = true;
    private int[] sortCols = new int[]{0};
    private boolean[] sortDir = new boolean[]{true};
    private static final SDebug db = new SDebug("RmonThresholdPane");
    private PortModel[] validPorts;
    private ModuleModel moduleM = (ModuleModel)this.getUiModel();

    public RmonThresholdPane(String string, TabbedView tabbedView, PortModel[] portModelArray) {
        super(string, tabbedView);
        this.validPorts = portModelArray;
        this.registerWithModel();
    }

    public RmonThresholdPane(String string, TabbedView tabbedView) {
        this(string, tabbedView, null);
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof RmonLineUpdate) {
            RmonLineUpdate rmonLineUpdate = (RmonLineUpdate)object;
            this.validPorts = this.linesToPorts(rmonLineUpdate.getRmonModels());
            if (this.portsCanSupportRMON()) {
                this.enableComponent(this.createButton, this.moduleM, SecurityLevel.PROVISIONING);
            } else {
                this.createButton.setEnabled(false);
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length != 0) {
            this.enableComponent(this.deleteButton, this.moduleM, SecurityLevel.PROVISIONING);
        } else {
            this.deleteButton.setEnabled(false);
        }
    }

    private void init() {
        if (db.on()) {
            db.println("init");
        }
        this.setLayout(new BorderLayout());
        this.dataSource = new RmonThresholdDataSource(this.moduleM);
        this.dataModel = new RmonThresholdTableModel(this.dataSource, this.sortCols, this.sortDir);
        this.table = new UTable((TableModel)((Object)this.dataModel));
        ((RmonThresholdTableModel)((Object)this.table.getModel())).initTable(this.table);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.add(this.makeControlPanel(), "South");
        this.add((Component)new UScrollPane((Component)this.table), "Center");
    }

    private JPanel makeControlPanel() {
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.RmonThresholdPane);
        this.createButton.addActionListener(this);
        cSHelpButtonPane.addLeft(this.createButton);
        this.deleteButton.addActionListener(this);
        cSHelpButtonPane.addLeft(this.deleteButton);
        if (!this.moduleM.getNodeModelDelegate().getPlatform().is310cl()) {
            this.showAllCheckBox = new JCheckBox(SHOW_ALL_THRESHOLDS, false);
            this.showAllCheckBox.addItemListener(this);
            cSHelpButtonPane.addLeft(this.showAllCheckBox);
        }
        this.enableComponent(this.createButton, this.moduleM, SecurityLevel.PROVISIONING);
        this.deleteButton.setEnabled(false);
        return cSHelpButtonPane;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof JCheckBox && object == this.showAllCheckBox) {
            int n = itemEvent.getStateChange();
            if (n == 1) {
                this.dataSource.setFiltered(false);
            } else {
                this.dataSource.setFiltered(true);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.createButton) {
            RmonThresholdCreateDialog rmonThresholdCreateDialog = new RmonThresholdCreateDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), this.moduleM, this.dataModel, this.validPorts);
        } else if (object == this.deleteButton) {
            int[] nArray = this.table.getSelectedRows();
            if (nArray.length == 0) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NOT_SELECTED_PARAM_1, (Object)"RMON Thresholds");
                return;
            }
            if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)"Really delete selected RMON Thresholds?", (String)"Delete Threshold")) {
                return;
            }
            this.dataModel.deleteThreshold(nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.dataSource == null) {
                this.init();
            }
            if (this.initialized) {
                this.dataSource.getRmonThresholdList();
                this.initialized = false;
            }
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
            Object var2_1 = null;
            if (this.uiToolkit == null) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.uiToolkit == null) throw throwable;
            this.uiToolkit.setCursor(0);
            throw throwable;
        }
        this.uiToolkit.setCursor(0);
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
    }

    public void refresh() {
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
        if (this.dataSource != null) {
            this.dataSource.dispose();
            this.dataSource = null;
        }
    }

    private boolean portsCanSupportRMON() {
        boolean bl = false;
        ArrayList<PortModel> arrayList = new ArrayList<PortModel>(Arrays.asList(this.validPorts));
        PortModel[] portModelArray = arrayList.iterator();
        while (portModelArray.hasNext()) {
            Object e = portModelArray.next();
            if (e instanceof PortModel) continue;
            portModelArray.remove();
        }
        portModelArray = arrayList.toArray(new PortModel[arrayList.size()]);
        for (int i = 0; i < portModelArray.length; ++i) {
            PortModel portModel = portModelArray[i];
            try {
                RmonThresholdManager.getInstance((NodeModelDelegate)this.moduleM.getNodeModel()).getStatsIdList(portModel.getIndex());
                bl = true;
                break;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                bl = false;
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                bl = false;
            }
        }
        return bl;
    }

    private PortModel[] linesToPorts(IRmonModel[] iRmonModelArray) {
        ArrayList<PortModel> arrayList = new ArrayList<PortModel>();
        for (int i = 0; i < iRmonModelArray.length; ++i) {
            try {
                arrayList.add(iRmonModelArray[i].getPortModel());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList.toArray(new PortModel[arrayList.size()]);
    }
}

