/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eQualityLevel;
import cerent.cms.idl.Ds123Media.eLineCoding;
import cerent.cms.idl.Synchronization.eBits;
import cerent.cms.idl.Synchronization.sBitsConfig;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractSppTimingBitsPane;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;

public abstract class AbstractBitsProvPane
extends AbstractPane
implements ActionListener {
    protected static final int BITS_IN = 0;
    protected static final int BITS_OUT = 1;
    protected static AttributeMaps attrMap;
    protected AbstractSppTimingBitsPane parent;
    protected eBits bitsPort;
    protected boolean isAISThresholdProvisionable;
    protected IPlatform pci;
    protected JComboBox stateBitsInCB;
    protected JComboBox codingBitsInCB;
    protected JComboBox framingBitsInCB;
    protected JCheckBox ssmEnabledBitsInCB;
    protected JComboBox adminSsmBitsInCB;
    protected JComboBox sabitBitsInCB;
    protected JComboBox stateBitsOutCB;
    protected JComboBox codingBitsOutCB;
    protected JComboBox framingBitsOutCB;
    protected JComboBox qualityCB;
    protected JComboBox lboCB;
    protected JComboBox sabitBitsOutCB;
    protected static final SDebug db;

    public abstract String[] getBitsInChoices();

    public abstract String[] getBitsOutChoices();

    protected abstract String[] getStateChoices();

    protected abstract String[] getCodingChoices();

    protected abstract String[] getFramingChoices();

    public abstract Attribute[] getQualityChoices();

    public abstract void applyChangesToModel() throws Exception;

    public abstract void refreshFromModel() throws Exception;

    protected abstract boolean isSyncMsgFraming(int var1);

    public AbstractBitsProvPane(String string, TabbedView tabbedView, AbstractSppTimingBitsPane abstractSppTimingBitsPane, eBits eBits2) {
        super(string, tabbedView);
        this.parent = abstractSppTimingBitsPane;
        this.bitsPort = eBits2;
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.pci = ((NodeModelDelegate)this.getUiModel()).getPlatform();
        this.isAISThresholdProvisionable = this.pci.isAISThresholdProvisionable();
        attrMap = ElementDefaults.getAttributeMap((IModel)this.getUiModel().getNodeModel());
    }

    public JComboBox createBitsInState() {
        this.stateBitsInCB = new JComboBox<String>(this.getStateChoices());
        this.stateBitsInCB.setName("BITS State");
        this.stateBitsInCB.addActionListener(this);
        this.enableComponent(this.stateBitsInCB);
        return this.stateBitsInCB;
    }

    public JComboBox createBitsOutState() {
        this.stateBitsOutCB = new JComboBox<String>(this.getStateChoices());
        this.stateBitsOutCB.setName("BITS State");
        this.stateBitsOutCB.addActionListener(this);
        this.enableComponent(this.stateBitsOutCB);
        return this.stateBitsOutCB;
    }

    public JComboBox createBitsInCoding() {
        this.codingBitsInCB = new JComboBox<String>(this.getCodingChoices());
        this.codingBitsInCB.setName("Coding");
        this.codingBitsInCB.addActionListener(this);
        this.enableComponent(this.codingBitsInCB);
        return this.codingBitsInCB;
    }

    public JComboBox createBitsOutCoding() {
        this.codingBitsOutCB = new JComboBox<String>(this.getCodingChoices());
        this.codingBitsOutCB.setName("Coding");
        this.codingBitsOutCB.addActionListener(this);
        this.enableComponent(this.codingBitsOutCB);
        return this.codingBitsOutCB;
    }

    public JComboBox createBitsInFraming() {
        this.framingBitsInCB = new JComboBox<String>(this.getFramingChoices());
        this.framingBitsInCB.setName("Framing");
        this.framingBitsInCB.addActionListener(this);
        this.enableComponent(this.framingBitsInCB);
        return this.framingBitsInCB;
    }

    public JComboBox createBitsOutFraming() {
        this.framingBitsOutCB = new JComboBox<String>(this.getFramingChoices());
        this.framingBitsOutCB.setName("Framing");
        this.framingBitsOutCB.addActionListener(this);
        this.enableComponent(this.framingBitsOutCB);
        return this.framingBitsOutCB;
    }

    public JCheckBox createBitsInSsmToggle() {
        this.ssmEnabledBitsInCB = new JCheckBox("Enabled", true);
        this.ssmEnabledBitsInCB.addActionListener(this);
        this.enableComponent(this.ssmEnabledBitsInCB);
        return this.ssmEnabledBitsInCB;
    }

    public JComboBox createBitsInAdminSsm() {
        this.adminSsmBitsInCB = new JComboBox<Attribute>(this.getQualityChoices());
        this.adminSsmBitsInCB.setName("AdminSsm");
        this.adminSsmBitsInCB.addActionListener(this);
        this.enableComponent(this.adminSsmBitsInCB);
        return this.adminSsmBitsInCB;
    }

    public JComboBox createBitsOutAisTh() {
        this.qualityCB = new JComboBox<Attribute>(this.getQualityChoices());
        this.qualityCB.setName("AIS Threshold");
        this.qualityCB.addActionListener(this);
        this.enableComponent(this.qualityCB);
        return this.qualityCB;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.framingBitsInCB) {
            if (!this.isSyncMsgFraming(0)) {
                this.ssmEnabledBitsInCB.setSelected(false);
                this.ssmEnabledBitsInCB.setEnabled(false);
                if (this.adminSsmBitsInCB != null) {
                    this.enableComponent(this.adminSsmBitsInCB);
                }
            } else {
                this.enableComponent(this.ssmEnabledBitsInCB);
                this.ssmEnabledBitsInCB.setSelected(true);
                if (this.adminSsmBitsInCB != null) {
                    this.adminSsmBitsInCB.setEnabled(false);
                }
            }
        } else if (object == this.ssmEnabledBitsInCB && this.adminSsmBitsInCB != null) {
            if (this.ssmEnabledBitsInCB.isSelected()) {
                this.adminSsmBitsInCB.setEnabled(false);
            } else {
                this.enableComponent(this.adminSsmBitsInCB);
            }
        } else if (object == this.framingBitsOutCB) {
            if (!this.isSyncMsgFraming(1)) {
                if (this.qualityCB != null) {
                    this.enableComponent(this.qualityCB);
                }
            } else if (this.qualityCB != null) {
                this.qualityCB.setEnabled(false);
            }
        }
        this.parent.setDirty();
    }

    public void enteringPage() {
    }

    public void leavingPage() throws Exception {
    }

    public void refresh() {
    }

    public void dumpData(sBitsConfig sBitsConfig2) {
        if (db.on()) {
            db.println("\n============== BITS IN ================");
            db.println("config.facilityType = " + sBitsConfig2.facilityType.value());
            db.println("config.adminState = " + sBitsConfig2.adminState.value());
            db.println("config.coding = " + sBitsConfig2.coding.value());
            db.println("config.framing = " + sBitsConfig2.framing.value());
            db.println("config.syncMessageIn = " + sBitsConfig2.syncMessageIn);
            db.println("config.assumedQuality = " + sBitsConfig2.assumedQuality.value());
            db.println("config.saBit = " + sBitsConfig2.saBit.value());
            db.println("\n============== BITS OUT ================");
            db.println("config.facilityTypeBitsOut = " + sBitsConfig2.facilityTypeBitsOut.value());
            db.println("config.adminStateBitsOut = " + sBitsConfig2.adminStateBitsOut.value());
            db.println("config.codingBitsOut = " + sBitsConfig2.codingBitsOut.value());
            db.println("config.framingBitsOut = " + sBitsConfig2.framingBitsOut.value());
            db.println("config.aisThreshold = " + sBitsConfig2.aisThreshold.value());
            db.println("config.cableSelection = " + sBitsConfig2.cableSelection.value());
            db.println("config.bitsLBO = " + sBitsConfig2.bitsLBO.value());
            db.println("config.saBit = " + sBitsConfig2.saBit.value());
        }
    }

    public void updateBitsInValues() {
        this.enableBitsInComponents();
    }

    public void updateBitsOutValues() {
        this.enableBitsOutComponents();
    }

    public void enableBitsInComponents() {
        if (this.parent.isLineMode()) {
            this.enableComponent(this.stateBitsInCB);
            this.codingBitsInCB.setEnabled(false);
            this.framingBitsInCB.setEnabled(false);
            this.ssmEnabledBitsInCB.setEnabled(false);
            if (this.adminSsmBitsInCB != null) {
                this.adminSsmBitsInCB.setEnabled(false);
            }
            if (this.sabitBitsInCB != null) {
                this.sabitBitsInCB.setEnabled(false);
            }
        } else if (this.parent.isBits64K(0) || this.parent.isBits2M(0)) {
            this.enableComponent(this.stateBitsInCB);
            this.codingBitsInCB.setEnabled(false);
            this.framingBitsInCB.setEnabled(false);
            this.ssmEnabledBitsInCB.setEnabled(false);
            if (this.adminSsmBitsInCB != null) {
                this.enableComponent(this.adminSsmBitsInCB);
            }
            if (this.sabitBitsInCB != null) {
                this.enableComponent(this.sabitBitsInCB);
            }
        } else {
            this.enableComponent(this.stateBitsInCB);
            this.enableComponent(this.codingBitsInCB);
            this.enableComponent(this.framingBitsInCB);
            if (this.isSyncMsgFraming(0)) {
                this.enableComponent(this.ssmEnabledBitsInCB);
                if (this.adminSsmBitsInCB != null) {
                    if (this.ssmEnabledBitsInCB.isSelected()) {
                        this.adminSsmBitsInCB.setEnabled(false);
                    } else {
                        this.enableComponent(this.adminSsmBitsInCB);
                    }
                }
            } else {
                this.ssmEnabledBitsInCB.setEnabled(false);
                if (this.adminSsmBitsInCB != null) {
                    this.enableComponent(this.adminSsmBitsInCB);
                }
            }
            if (this.sabitBitsInCB != null) {
                this.enableComponent(this.sabitBitsInCB);
            }
        }
    }

    public void enableBitsOutComponents() {
        if (this.parent.getBitsOutFacilityType() == 0) {
            if (this.parent.getBitsInFacilityType() == 0) {
                if (this.parent.isLineMode()) {
                    this.enableComponent(this.codingBitsOutCB);
                    this.enableComponent(this.framingBitsOutCB);
                } else {
                    this.codingBitsOutCB.setEnabled(false);
                    this.framingBitsOutCB.setEnabled(false);
                }
                if (this.qualityCB != null && this.isAISThresholdProvisionable) {
                    if (this.isSyncMsgFraming(1)) {
                        this.qualityCB.setEnabled(false);
                    } else {
                        this.enableComponent(this.qualityCB);
                    }
                }
            } else {
                this.enableComponent(this.codingBitsOutCB);
                this.enableComponent(this.framingBitsOutCB);
                if (!this.isSyncMsgFraming(1)) {
                    if (this.qualityCB != null && this.isAISThresholdProvisionable) {
                        this.enableComponent(this.qualityCB);
                    }
                } else if (this.qualityCB != null && this.isAISThresholdProvisionable) {
                    this.qualityCB.setEnabled(false);
                }
            }
        } else {
            this.codingBitsOutCB.setEnabled(false);
            this.framingBitsOutCB.setEnabled(false);
            if (this.qualityCB != null && this.isAISThresholdProvisionable) {
                this.enableComponent(this.qualityCB);
            }
        }
    }

    protected int getAdminStateIndex(eAdminState eAdminState2) {
        return eAdminState2 == eAdminState.ADMIN_IS ? 1 : 0;
    }

    protected int getCodingIndex(eLineCoding eLineCoding2) {
        return eLineCoding2 == eLineCoding.AMI ? 1 : 0;
    }

    protected eQualityLevel getQualitySelection(Attribute attribute) {
        return eQualityLevel.from_int(attribute.getIntValue());
    }

    public void destroy() {
        this.destroy(this.stateBitsInCB);
        this.destroy(this.codingBitsInCB);
        this.destroy(this.framingBitsInCB);
        this.destroy(this.ssmEnabledBitsInCB);
        this.destroy(this.adminSsmBitsInCB);
        this.destroy(this.sabitBitsInCB);
        this.destroy(this.stateBitsOutCB);
        this.destroy(this.codingBitsOutCB);
        this.destroy(this.framingBitsOutCB);
        this.destroy(this.qualityCB);
        this.destroy(this.lboCB);
        this.destroy(this.sabitBitsOutCB);
        super.destroy();
    }

    private void destroy(JComboBox jComboBox) {
        if (jComboBox != null) {
            jComboBox.removeActionListener(this);
            jComboBox = null;
        }
    }

    private void destroy(JCheckBox jCheckBox) {
        if (jCheckBox != null) {
            jCheckBox.removeActionListener(this);
            jCheckBox = null;
        }
    }

    static {
        db = new SDebug((KDebug)AbstractSppTimingBitsPane.db, "BitsProvPane");
    }
}

