/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SlotModel;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.ChangeCardDialog;
import cerent.cms.ui.shelf.OadmPortGraphic;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Observable;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public abstract class AbstractOadmCard
extends CardGraphic
implements ActionListener {
    private static final String CHANGE_CARD_TYPE = "Change Card...";
    protected OadmPortGraphic[] portGraphics = null;
    protected int Y_Init_Point;

    protected AbstractOadmCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug) {
        super(entityModel, abstractShelfLayout, sDebug);
        if (entityModel instanceof ModuleModel) {
            List list = entityModel.getChildren();
            int n = list.size();
            this.portGraphics = new OadmPortGraphic[n];
            int n2 = this.cardPainter.getMiniPortHeight();
            int n3 = this.cardPainter.getMiniPortWidth();
            int n4 = this.cardPainter.getMultiPortOpticonXOffset();
            int n5 = this.cardPainter.getMiniOpticonYSpacing();
            int n6 = this.cardPainter.getMiniOpticonYOffset();
            int n7 = this.cardPainter.getOpticonXSpacing();
            if (n < 7) {
                int n8;
                int n9 = 0;
                for (n8 = 0; n8 < n; n8 += 2) {
                    this.Y_Init_Point = n8 > 1 ? 9 : 20;
                    n9 = n8 > 1 ? (n5 - n2) * 17 : 0;
                    this.portGraphics[n8] = new OadmPortGraphic((CardGraphic)this, n4 + n7 * n8 - 6, n6 + this.Y_Init_Point + ((n5 - 7) * n8 + n9), n3, n2, (OpticsPortModel)list.get(n8));
                }
                n9 = 0;
                n8 = 0;
                for (int i = 1; i < n; i += 2) {
                    this.Y_Init_Point = i > 2 ? 9 : 20;
                    n9 = i > 2 ? (n5 - n2) * 17 : 0;
                    this.portGraphics[i] = new OadmPortGraphic((CardGraphic)this, n4 + n7 * i + 6, n6 + this.Y_Init_Point + ((n5 - 7) * n8 + n9), n3, n2, (OpticsPortModel)list.get(i));
                    n8 += 2;
                }
            } else if (n < 9) {
                int n10;
                int n11 = 0;
                for (n10 = 0; n10 < n; n10 += 2) {
                    this.Y_Init_Point = n10 > 3 ? 10 : 20;
                    n11 = n10 > 3 ? (n5 - n2) * 10 : 0;
                    this.portGraphics[n10] = new OadmPortGraphic((CardGraphic)this, n4 + n7 * n10 - 6, n6 + this.Y_Init_Point + ((n5 - 7) * n10 + n11), n3, n2, (OpticsPortModel)list.get(n10));
                }
                n11 = 0;
                n10 = 0;
                for (int i = 1; i < n; i += 2) {
                    this.Y_Init_Point = i > 4 ? 10 : 20;
                    n11 = i > 4 ? (n5 - n2) * 10 : 0;
                    this.portGraphics[i] = new OadmPortGraphic((CardGraphic)this, n4 + n7 * i + 6, n6 + this.Y_Init_Point + ((n5 - 7) * n10 + n11), n3, n2, (OpticsPortModel)list.get(i));
                    n10 += 2;
                }
            } else {
                int n12;
                int n13 = 0;
                for (n12 = 0; n12 < n; n12 += 2) {
                    this.portGraphics[n12] = new OadmPortGraphic((CardGraphic)this, n4 + n7 * n12 - 6, n6 + ((n5 - 7) * n12 + n13), n3, n2, (OpticsPortModel)list.get(n12));
                }
                n13 = 0;
                n12 = 0;
                for (int i = 1; i < n; i += 2) {
                    this.portGraphics[i] = new OadmPortGraphic((CardGraphic)this, n4 + n7 * i + 6, n6 + ((n5 - 7) * n12 + n13), n3, n2, (OpticsPortModel)list.get(i));
                    n12 += 2;
                }
            }
            if (this.hasProvisionedCard()) {
                this.alarmStore.enablePortAlarmsStatus((ModuleModel)entityModel);
                this.update(this.alarmStore.getAlarmStatusObservable(), this.alarmStore.getAlarmStatus());
            }
        }
    }

    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (!this.portGraphics[i].contains(mouseEvent.getPoint())) continue;
                return this.portGraphics[i].getTooltipText();
            }
            return super.getTooltipText(mouseEvent);
        }
        catch (Exception exception) {
            this.db.println("exception in getTooltipText: " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (object instanceof AlarmStatus && this.portGraphics != null) {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (this.portGraphics[i] == null) continue;
                this.portGraphics[i].update(observable, this.alarmStore);
            }
        }
    }

    public void dispose() {
        if (this.hasProvisionedCard()) {
            this.alarmStore.disablePortAlarmsStatus();
        }
        super.dispose();
        if (this.portGraphics != null) {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (this.portGraphics[i] == null) continue;
                this.portGraphics[i].dispose();
                this.portGraphics[i] = null;
            }
            this.portGraphics = null;
        }
    }

    protected void addCustomMenuItems(JPopupMenu jPopupMenu) {
        SlotModel slotModel;
        ModuleModel moduleModel;
        IEntityModel iEntityModel;
        IEntityModel iEntityModel2 = this.getModel();
        if (iEntityModel2 != null && iEntityModel2 instanceof ModuleModel && (iEntityModel = (moduleModel = (ModuleModel)iEntityModel2).getParent()) instanceof SlotModel && (slotModel = (SlotModel)iEntityModel).getListOfValidChangeType(eEqType.from_int(moduleModel.getEqType())).size() > 0) {
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.makeMenuAction(CHANGE_CARD_TYPE, AbstractPane.isUserAuthorized(moduleModel, SecurityLevel.PROVISIONING)));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            if (actionEvent.getActionCommand().equals(CHANGE_CARD_TYPE)) {
                new ChangeCardDialog(JOptionPane.getFrameForComponent(this.parent), (ModuleModel)this.getModel());
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    protected String getStateString() {
        return ElementDefaults.eqStateToString(this.eqState);
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintIcon(component, graphics2D, n, n2);
        if (this.pci.is600()) {
            return;
        }
        for (int i = 0; i < this.portGraphics.length; ++i) {
            this.portGraphics[i].drawOnlyOneConnector(graphics2D, true, false);
        }
    }
}

