/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AbstractTermConnectionModel;
import cerent.cms.model.Busy;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.InvalidOhTerm;
import cerent.cms.model.OhMaxConnections;
import cerent.cms.model.PortModel;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.TdmPortModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.EntityComparator;
import cerent.cms.ui.shelf.AbstractTermPane;
import cerent.util.AnnotatedException;
import cerent.util.EMC;
import cerent.util.SDebug;
import cerent.util.gui.UDialog;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractTermCreationDialog
extends UDialog
implements ActionListener,
ListSelectionListener {
    protected JButton okButton;
    protected JButton cancelButton;
    protected JCheckBox donotAdvertiseOspfButton;
    protected JCheckBox farEndForeign;
    protected JRadioButton asIs;
    protected JRadioButton toIS;
    protected JRadioButton OOStoAINS;
    protected JRadioButton OOStoMT;
    protected ButtonGroup adminStateGroup;
    protected AbstractTermConnectionModel connTable;
    protected DefaultListModel termListModel;
    protected JList termList;
    protected String terminationType;
    protected static final SDebug db = new SDebug("TermCreationDialog");

    protected AbstractTermCreationDialog(Frame frame, String string, String string2, Object object) {
        super(frame, string, true, object);
        this.terminationType = string2;
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.connTable = (AbstractTermConnectionModel)object;
        this.setSize(new Dimension(300, 300));
        jPanel.add((Component)this.getListPanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public void dispose() {
        this.connTable = null;
        ((DefaultListModel)this.termList.getModel()).removeAllElements();
        super.dispose();
    }

    protected JComponent getListPanel() {
        this.termListModel = new DefaultListModel();
        IEntityModel[] iEntityModelArray = this.connTable.getTermCandidates();
        Arrays.sort(iEntityModelArray, new EntityComparator());
        this.termListModel.setSize(iEntityModelArray.length);
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            this.termListModel.setElementAt(iEntityModelArray[i], i);
        }
        this.termList = new JList(this.termListModel);
        this.termList.setCellRenderer(new EntityCellRenderer("slot "));
        this.termList.setVisibleRowCount(10);
        this.termList.addListSelectionListener(this);
        this.termList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && AbstractTermCreationDialog.this.termList.getSelectedValue() != null) {
                    AbstractTermCreationDialog.this.ok();
                }
            }
        });
        return new UScrollPane((Component)this.termList);
    }

    protected abstract JPanel getButtonPanel();

    protected JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.ok();
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    protected abstract void createTermination(IEntityModel var1) throws Exception;

    private void createTerms(Object[] objectArray, int n) {
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = n != -1 ? new ArrayList() : null;
        EntityCellRenderer entityCellRenderer = new EntityCellRenderer("slot ");
        for (int i = 0; i < objectArray.length; ++i) {
            IEntityModel iEntityModel = (IEntityModel)objectArray[i];
            try {
                this.createTermination(iEntityModel);
                arrayList.add(iEntityModel);
            }
            catch (InvalidOhTerm invalidOhTerm) {
                AbstractTermPane.addFailureReason(EMC.EID_INVALID_OH_TERM, iEntityModel, entityCellRenderer, arrayList2);
                continue;
            }
            catch (Busy busy) {
                AbstractTermPane.addFailureReason(EMC.EID_TERM_TYPE_IN_USE_PARAM_1, this.terminationType, iEntityModel, entityCellRenderer, arrayList2);
                continue;
            }
            catch (ResourceInUse resourceInUse) {
                AbstractTermPane.addFailureReason(EMC.EID_OH_TERM_PORT_IN_USE_PARAM_1, this.terminationType, iEntityModel, entityCellRenderer, arrayList2);
                continue;
            }
            catch (OhMaxConnections ohMaxConnections) {
                AbstractTermPane.addFailureReason(EMC.EID_OH_MAX_CONNECTIONS, iEntityModel, entityCellRenderer, arrayList2);
                continue;
            }
            catch (Exception exception) {
                AbstractTermPane.addFailureReason(EMC.EID_TERM_TYPE_CREATE_FAIL_PARAM_2, this.terminationType, AnnotatedException.getString((Exception)exception), iEntityModel, entityCellRenderer, arrayList2);
                continue;
            }
            if (n == -1 || !(iEntityModel instanceof TdmPortModel) && !(iEntityModel instanceof DwdmPortModel)) continue;
            PortModel portModel = (PortModel)iEntityModel;
            AbstractTermPane.maybeSetAdminState(portModel, n, arrayList3, entityCellRenderer, db);
        }
        AbstractTermPane.handleFailures((Component)((Object)this), this.terminationType, "create", arrayList, arrayList2, arrayList3, entityCellRenderer);
    }

    protected void ok() {
        Object[] objectArray = this.termList.getSelectedValues();
        int n = -1;
        if (!this.asIs.isSelected()) {
            if (this.toIS.isSelected()) {
                n = 0;
            } else if (this.OOStoAINS.isSelected()) {
                n = 3;
            } else if (this.OOStoMT.isSelected()) {
                n = 2;
            }
        }
        this.createTerms(objectArray, n);
        this.dispose();
    }
}

