/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.SonetTopology.eBlsrChannelState;
import cerent.cms.idl.SonetTopology.sBlsrProvision;
import cerent.cms.idl.SonetTopology.sRingMapEntry;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.BlsrProtectionOpFactory;
import cerent.cms.model.BlsrSpanSwitched;
import cerent.cms.model.DuplicateNodeId;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IBlsrProtectionOp;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.RevertiveBehaviorFactory;
import cerent.cms.ui.AbstractProvTableModel;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.BlockingModeController;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Frame;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Set;

public class BlsrTableModel
extends AbstractProvTableModel
implements BlockingModeController {
    private static SDebug db = new SDebug("BlsrTableModel");
    private static final String TYPE_STRING = "blsrType";
    private static final String STATE_STRING = "blsrChannelState";
    private static final String OP_STRING = "blsrOp.apsClear";
    private static final String ERROR_STRING = "<error>";
    private ElementModelsDelegate eltModels;
    private BlsrModel[] models;
    private Attribute[] ringType;
    private String[] lineRate;
    private String[] ringId;
    private Integer[] nodeId;
    private IRevertiveBehavior[] ringReversion;
    private IRevertiveBehavior[] spanReversion;
    private String[] westLine;
    private Attribute[] westOp;
    private String[] eastLine;
    private Attribute[] eastOp;
    private String blsrTerm;
    private boolean[][] cellDirty;
    private int userSecurityLevel;
    private static final int NEEDS_REFRESH = 1;
    private static final int NEEDS_RESET = 2;
    public static final int RING_TYPE_INDEX = 0;
    public static final int LINE_RATE_INDEX = 1;
    public static final int RING_ID_INDEX = 2;
    public static final int NODE_ID_INDEX = 3;
    public static final int RING_REV_INDEX = 4;
    public static final int SPAN_REV_INDEX = 5;
    public static final int WEST_LINE_INDEX = 6;
    public static final int WEST_OP_INDEX = 7;
    public static final int EAST_LINE_INDEX = 8;
    public static final int EAST_OP_INDEX = 9;
    public static final int MAINTENANCE = 0;
    public static final int PROVISIONING = 1;
    public static final String NO_SWITCH = "NO COMMAND";
    private static AttributeMaps attrMap;
    private int[] columnSecurityLevel;
    private static final int[][] columnSecurityLevels;
    static /* synthetic */ Class class$cerent$cms$model$IRevertiveBehavior;
    static /* synthetic */ Class class$java$lang$Object;

    public BlsrTableModel(NodeModelDelegate nodeModelDelegate, int n) {
        super(new Model[0], true, null);
        TDMTerminology tDMTerminology = nodeModelDelegate.getTDMTerminology();
        attrMap = ElementDefaults.getAttributeMap(nodeModelDelegate);
        this.blsrTerm = tDMTerminology.getRingTerms(1);
        this.columnSecurityLevel = columnSecurityLevels[n];
        this.eltModels = nodeModelDelegate.getElementModelsDelegate();
        this.columnNames = new String[]{"Type", "Rate", "Ring Name", "Node ID", "Ring Reversion", "Span Reversion", "West Line", "West Switch", "East Line", "East Switch"};
        this.userSecurityLevel = nodeModelDelegate.getSecurityLevel().value();
        BlsrTableModel.println("userSecurityLevel = " + this.userSecurityLevel);
        this.observableManager.setBlockingModeController((BlockingModeController)this);
    }

    protected TDMTerminology getTDMTerminology() {
        return this.eltModels.getNodeModel().getTDMTerminology();
    }

    public AttributeMaps getAttributeMap() {
        return attrMap;
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = this.enabled && this.userSecurityLevel >= this.columnSecurityLevel[n2] && (n2 != 5 || this.ringType[n].getIntValue() == 3);
        return bl;
    }

    public Class getColumnClass(int n) {
        Class clazz = n == 4 || n == 5 ? (class$cerent$cms$model$IRevertiveBehavior == null ? (class$cerent$cms$model$IRevertiveBehavior = BlsrTableModel.class$("cerent.cms.model.IRevertiveBehavior")) : class$cerent$cms$model$IRevertiveBehavior) : (class$java$lang$Object == null ? (class$java$lang$Object = BlsrTableModel.class$("java.lang.Object")) : class$java$lang$Object);
        return clazz;
    }

    public BlsrModel getBlsrModel(int n) {
        return this.models[n];
    }

    protected int getRowFor(BlsrModel blsrModel) {
        int n = 0;
        boolean bl = false;
        while (n < this.models.length && !bl) {
            if (this.models[n] == blsrModel) {
                bl = true;
                continue;
            }
            ++n;
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    public Object getValueAt(int n, int n2) {
        if (n < 0 || n >= this.models.length) {
            BlsrTableModel.println("getValueAt(" + n + "," + n2 + "): bad row");
            return "";
        }
        switch (n2) {
            case 0: {
                return this.ringType[n];
            }
            case 1: {
                return this.lineRate[n];
            }
            case 2: {
                return this.ringId[n].toUpperCase();
            }
            case 3: {
                return this.nodeId[n];
            }
            case 4: {
                return this.ringReversion[n];
            }
            case 5: {
                return this.spanReversion[n];
            }
            case 6: {
                return this.westLine[n];
            }
            case 7: {
                return this.westOp[n];
            }
            case 8: {
                return this.eastLine[n];
            }
            case 9: {
                return this.eastOp[n];
            }
        }
        BlsrTableModel.println("getValueAt(" + n + "," + n2 + "): bad column");
        return "";
    }

    public void setValueAt(Object object, int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        Attribute attribute = (Attribute)this.getValueAt(n, 9);
        Attribute attribute2 = (Attribute)this.getValueAt(n, 7);
        String string = attribute.getKey();
        String string2 = attribute2.getKey();
        if (object == null) {
            BlsrTableModel.println("setValueAt(" + n + "," + n2 + "): null value");
            return;
        }
        if (n < 0 || n >= this.models.length) {
            BlsrTableModel.println("setValueAt(" + n + "," + n2 + "): bad row");
            return;
        }
        switch (n2) {
            case 2: {
                if (this.ringIdSanityCheck(((String)object).toUpperCase())) {
                    this.ringId[n] = ((String)object).toUpperCase();
                    break;
                }
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_BLSR_UNIQUE_RING_ID);
                break;
            }
            case 3: {
                this.nodeId[n] = (Integer)object;
                break;
            }
            case 4: {
                this.ringReversion[n] = (IRevertiveBehavior)object;
                break;
            }
            case 5: {
                this.spanReversion[n] = (IRevertiveBehavior)object;
                break;
            }
            case 7: {
                if (!this.cellDirty[n][9] || string.equals(NO_SWITCH)) {
                    this.westOp[n] = (Attribute)object;
                    break;
                }
                bl2 = true;
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ONE_PROT_CHG);
                break;
            }
            case 9: {
                if (!this.cellDirty[n][7] || string2.equals(NO_SWITCH)) {
                    this.eastOp[n] = (Attribute)object;
                    break;
                }
                bl = true;
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ONE_PROT_CHG);
                break;
            }
            default: {
                BlsrTableModel.println("setValueAt(" + n + "," + n2 + "): bad column");
                return;
            }
        }
        this.rowDirty[n] = true;
        if (n2 == 9 && bl) {
            this.cellDirty[n][n2] = false;
        } else if (n2 == 7 && bl2) {
            this.cellDirty[n][n2] = false;
        } else {
            this.cellDirty[n][n2] = true;
            this.fireTableRowsUpdated(n, n);
        }
    }

    protected String getLineRateString(TDMTerminology tDMTerminology, BlsrModel blsrModel) {
        String string = "INCONSISTENT";
        try {
            int n;
            if (blsrModel.getWestEntityModel().getEqType() == blsrModel.getEastEntityModel().getEqType() && (n = (string = EntityModel.eqType2Name(tDMTerminology, blsrModel.getWestEntityModel().getEqType())).indexOf(95)) > -1) {
                string = string.substring(0, n);
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            db.println("getLineRateString(" + blsrModel + ") encountered exception:");
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        if (db.on()) {
            db.println("eqString is " + string);
        }
        return string;
    }

    protected void refreshSingleModel(int n, boolean bl) throws Exception {
        TDMTerminology tDMTerminology = this.getTDMTerminology();
        sBlsrProvision sBlsrProvision2 = this.models[n].getProvision();
        this.ringType[n] = attrMap.getAttributeForVal(TYPE_STRING, this.models[n].getTypeEnum().value());
        this.lineRate[n] = this.getLineRateString(tDMTerminology, this.models[n]);
        this.ringId[n] = sBlsrProvision2.ringName;
        this.nodeId[n] = new Integer(sBlsrProvision2.nodeId);
        this.ringReversion[n] = this.models[n].getRingReversion();
        this.spanReversion[n] = this.ringType[n].getIntValue() == 3 ? this.models[n].getSpanReversion() : null;
        this.westLine[n] = this.getLineString(this.models[n].getWestEntityModel(), this.models[n].getWestProtectEntityModel(), eBlsrChannelState.from_int(this.models[n].getWestMainState()), eBlsrChannelState.from_int(this.models[n].getWestProtState()));
        this.westOp[n] = this.models[n].getWestProtectionOp().kOp.value() == 0 ? new Attribute(NO_SWITCH, 0) : attrMap.getAttributeForVal(OP_STRING, this.models[n].getWestProtectionOp().kOp.value());
        this.eastLine[n] = this.getLineString(this.models[n].getEastEntityModel(), this.models[n].getEastProtectEntityModel(), eBlsrChannelState.from_int(this.models[n].getEastMainState()), eBlsrChannelState.from_int(this.models[n].getEastProtState()));
        this.eastOp[n] = this.models[n].getEastProtectionOp().kOp.value() == 0 ? new Attribute(NO_SWITCH, 0) : attrMap.getAttributeForVal(OP_STRING, this.models[n].getEastProtectionOp().kOp.value());
        for (int i = 0; i <= 9; ++i) {
            this.cellDirty[n][i] = false;
        }
        if (bl) {
            this.fireTableDataChanged();
        }
    }

    public void refreshFromModel() throws Exception {
        BlsrTableModel.println("refreshFromModel()");
        this.resetFromElementModels();
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshSingleModel(i, false);
        }
        super.refreshFromModel();
    }

    private String getLineString(IEntityModel iEntityModel, IEntityModel iEntityModel2, eBlsrChannelState eBlsrChannelState2, eBlsrChannelState eBlsrChannelState3) {
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append("s");
        stringBuffer.append(iEntityModel.getSlot());
        stringBuffer.append("/p");
        stringBuffer.append(PortHelper.getPortNumString((IPortModel)((IPortModel)iEntityModel)));
        int n = stringBuffer.length();
        stringBuffer.append(" (Work/");
        stringBuffer.append(attrMap.getAttributeForVal(STATE_STRING, eBlsrChannelState2.value()));
        stringBuffer.append(")\n");
        if (iEntityModel2 != null) {
            stringBuffer.append("s");
            stringBuffer.append(iEntityModel2.getSlot());
            stringBuffer.append("/p");
            stringBuffer.append(PortHelper.getPortNumString((IPortModel)((IPortModel)iEntityModel2)));
        } else {
            stringBuffer.append(stringBuffer.substring(0, n));
        }
        stringBuffer.append(" (Prot/");
        stringBuffer.append(attrMap.getAttributeForVal(STATE_STRING, eBlsrChannelState3.value()));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private boolean ignoreProtectionSwitch(BlsrModel blsrModel) {
        boolean bl = true;
        if (null != blsrModel) {
            short s = blsrModel.getEastProtState().shortValue();
            short s2 = blsrModel.getWestProtState().shortValue();
            if (s != 1 || s2 != 1) {
                String string = ErrorMsg.getString((EID)EMC.WID_BLSR_PROTECT_OP_PRESENT);
                bl = CerentDialog.yesNoWarningDialog((Component)this.getFrame(), (String)string, (String)("Confirm " + this.blsrTerm + " Operation"));
            }
        }
        return bl;
    }

    public boolean validateData() {
        int n;
        String string = "A reversion time of 0.0 is no longer supported.\n";
        String string2 = "Changing a reversion time from 0.0 can't be undone later.\n";
        String string3 = "\nOK to continue?";
        String string4 = "Traffic may not switch away from this span.\nVerify proper switch of traffic before performing\npotentially service-affecting work on this span.\n\nOK to continue?\n";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = true;
        try {
            String string5;
            HashSet<String> hashSet;
            for (n = 0; n < this.numLines; ++n) {
                hashSet = null;
                if (this.nodeId[n] == null) {
                    hashSet = "NodeId on row " + n + " is null.";
                } else if (this.models[n] == null) {
                    hashSet = "The model in row " + n + " is null.";
                } else if (this.westOp[n] == null) {
                    hashSet = "The west op in row " + n + " is null.";
                } else if (this.eastOp[n] == null) {
                    hashSet = "The east op in row " + n + " is null.";
                } else if (this.ringReversion[n] == null) {
                    hashSet = "The ring reversion in row " + n + " is null.";
                }
                if (hashSet != null) {
                    ErrorMsg.displayDetailed((Component)this.getFrame(), EMC.EID_CANNOT_VALIDATE_DATA_PARAM_1, Integer.toString(n), (String)((Object)hashSet));
                    return false;
                }
                if (this.nodeId[n].shortValue() != this.models[n].getProvision().nodeId && this.ringId[n].compareTo(this.models[n].getProvision().ringName) == 0) {
                    short s = this.nodeId[n].shortValue();
                    sRingMapEntry[] sRingMapEntryArray = this.models[n].getRingMap();
                    for (int i = 0; i < sRingMapEntryArray.length; ++i) {
                        if (sRingMapEntryArray[i].nodeId != s) continue;
                        ErrorMsg.displayError(this.getFrame(), EMC.EID_BLSR_DUP_NODE_ID_PARAM_3, this.nodeId[n], this.ringId[n], InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(sRingMapEntryArray[i].ipAddr)));
                        bl6 = false;
                    }
                }
                if (this.westOp[n].getIntValue() != this.models[n].getWestProtectionOp().kOp.value()) {
                    if (bl6 && this.westOp[n].getIntValue() != 0) {
                        bl6 = this.ignoreProtectionSwitch(this.models[n]);
                    }
                    if (this.westOp[n].getIntValue() == 5) {
                        bl = true;
                    } else if (this.westOp[n].getIntValue() == 3) {
                        bl3 = true;
                    } else if (this.westOp[n].getIntValue() == 1) {
                        bl4 = true;
                    } else {
                        bl2 = true;
                    }
                }
                if (this.eastOp[n].getIntValue() != this.models[n].getEastProtectionOp().kOp.value()) {
                    if (bl6 && this.eastOp[n].getIntValue() != 0) {
                        bl6 = this.ignoreProtectionSwitch(this.models[n]);
                    }
                    if (this.eastOp[n].getIntValue() == 5) {
                        bl = true;
                    } else if (this.eastOp[n].getIntValue() == 3) {
                        bl3 = true;
                    } else if (this.eastOp[n].getIntValue() == 1) {
                        bl4 = true;
                    } else {
                        bl2 = true;
                    }
                }
                if (!((string5 = this.models[n].getRingReversion()).getReversionTime() != 0 || string5.getReversionMode() != 2 || this.ringReversion[n].getReversionTime() == 0 && this.ringReversion[n].getReversionMode() == 2 || CerentDialog.yesNoDialog((Component)this.getFrame(), (String)(string + string2 + string3), (String)"Zero Reversion Time Not Supported"))) {
                    bl6 = false;
                }
                if ((!this.cellDirty[n][4] || this.ringReversion[n].getReversionMode() != 1) && (!this.cellDirty[n][5] || this.spanReversion[n].getReversionMode() != 1) || !this.models[n].hasPCAConnections()) continue;
                bl5 = true;
            }
            if (!bl6) {
                return false;
            }
            hashSet = new HashSet<String>(Arrays.asList(this.ringId));
            if (hashSet.size() != this.ringId.length) {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_BLSR_UNIQUE_RING_ID);
                return false;
            }
            if ((bl || bl3) && !CerentDialog.yesNoDialog((Component)this.getFrame(), (String)string4, (String)("Confirm " + this.blsrTerm + " Operation"))) {
                return false;
            }
            if (bl3 || bl4 ? !CerentDialog.yesNoDialog((Component)this.getFrame(), (String)"Applying FORCE or LOCKOUT operations may result in traffic loss\nOK to continue?", (String)("Confirm " + this.blsrTerm + " Operation")) : bl2 && !CerentDialog.yesNoDialog((Component)this.getFrame(), (String)("Modifying " + this.blsrTerm + " line operations;\n" + "OK to continue?"), (String)("Confirm " + this.blsrTerm + " Operation"))) {
                return false;
            }
            if (bl5) {
                string5 = ErrorMsg.getString((EID)EMC.WID_PCA_NON_REVERTIVE_WARN_PARAM_1, (Object)this.blsrTerm);
                if (!CerentDialog.yesNoWarningDialog((Component)this.getFrame(), (String)string5, (String)"PCA circuit warning")) {
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_CANNOT_VALIDATE_DATA_PARAM_1, (Object)Integer.toString(n));
            SDebug.printStackTrace((Throwable)exception);
            return false;
        }
    }

    private Frame getFrame() {
        return this.eltModels.getNodeModel().getUiToolkit().getApplicationFrame();
    }

    public void applyToModel() throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        for (int i = 0; i < this.numLines; ++i) {
            Attribute attribute;
            IBlsrProtectionOp iBlsrProtectionOp;
            if (!this.rowDirty[i]) continue;
            BlsrTableModel.println("applyToModel: commiting row " + i);
            if (this.cellDirty[i][2]) {
                if (this.ringId[i].trim().length() == 0) {
                    throw new IllegalArgumentException("Ring name must not be empty.");
                }
                if (this.ringId[i].trim().equalsIgnoreCase("all")) {
                    throw new Exception("'All' is a TL1 keyword and can not be used as the ring name");
                }
                try {
                    this.models[i].setRingName(this.ringId[i]);
                    this.cellDirty[i][2] = false;
                }
                catch (BlsrSpanSwitched blsrSpanSwitched) {
                    throw new Exception(ErrorMsg.getString((EID)EMC.EID_BLSR_SWITCH_ACTIVE_CAN_NOT_CHANGE_RING_NAME_PARAM_1, (Object)this.blsrTerm));
                }
            }
            if (this.cellDirty[i][3]) {
                try {
                    this.models[i].setNodeId(this.nodeId[i].shortValue());
                    this.cellDirty[i][3] = false;
                }
                catch (DuplicateNodeId duplicateNodeId) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)duplicateNodeId);
                    }
                    throw new Exception("Node Id " + this.nodeId[i] + " is already in use.");
                }
                catch (BlsrSpanSwitched blsrSpanSwitched) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)blsrSpanSwitched);
                    }
                    throw new Exception(ErrorMsg.getString((EID)EMC.EID_BLSR_SWITCH_ACTIVE_CAN_NOT_CHANGE_NODE_ID_PARAM_1, (Object)this.blsrTerm));
                }
            }
            if (this.cellDirty[i][4]) {
                this.models[i].setRingReversion(RevertiveBehaviorFactory.getRevertiveBehavior(this.ringReversion[i]));
                this.cellDirty[i][4] = false;
            }
            if (this.cellDirty[i][5]) {
                this.models[i].setSpanReversion(RevertiveBehaviorFactory.getRevertiveBehavior(this.spanReversion[i]));
                this.cellDirty[i][5] = false;
            }
            if (this.cellDirty[i][7]) {
                try {
                    iBlsrProtectionOp = BlsrProtectionOpFactory.getIBlsrProtectionOp(this.models[i].getWestProtectionOp());
                    attribute = this.westOp[i];
                    if (attribute == null) {
                        throw new InvalidProtectionOp("value is null");
                    }
                    iBlsrProtectionOp.setKOp(attribute.getIntValue());
                    this.models[i].setWestProtectionOp(BlsrProtectionOpFactory.getBlsrProtectionOp(iBlsrProtectionOp));
                    this.cellDirty[i][7] = false;
                }
                catch (InvalidProtectionOp invalidProtectionOp) {
                    string = "West";
                    bl = true;
                }
            }
            if (this.cellDirty[i][9]) {
                try {
                    iBlsrProtectionOp = BlsrProtectionOpFactory.getIBlsrProtectionOp(this.models[i].getEastProtectionOp());
                    attribute = this.eastOp[i];
                    if (attribute == null) {
                        throw new InvalidProtectionOp("value is null");
                    }
                    iBlsrProtectionOp.setKOp(attribute.getIntValue());
                    this.models[i].setEastProtectionOp(BlsrProtectionOpFactory.getBlsrProtectionOp(iBlsrProtectionOp));
                    this.cellDirty[i][9] = false;
                }
                catch (InvalidProtectionOp invalidProtectionOp) {
                    string = "East";
                    bl2 = true;
                }
            }
            if (bl && bl2) {
                throw new UnableToSwitchException("Unable to switch, a higher priority request may be present.");
            }
            if (!bl && !bl2) continue;
            throw new UnableToSwitchException("Unable to switch " + string + " Line, " + "a higher priority request may be present.");
        }
    }

    private void resetFromElementModels() {
        BlsrTableModel.println("resetFromElementModels");
        Set set = this.eltModels.getBlsrElements();
        this.models = set.toArray(new BlsrModel[set.size()]);
        Arrays.sort(this.models, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = ((BlsrModel)object).getBlsrProvision().getRingName();
                String string2 = ((BlsrModel)object2).getBlsrProvision().getRingName();
                return string.compareTo(string2);
            }
        });
        int n = this.models.length;
        this.ringType = new Attribute[n];
        this.lineRate = new String[n];
        this.ringId = new String[n];
        this.nodeId = new Integer[n];
        this.ringReversion = new IRevertiveBehavior[n];
        this.spanReversion = new IRevertiveBehavior[n];
        this.westLine = new String[n];
        this.westOp = new Attribute[n];
        this.eastLine = new String[n];
        this.eastOp = new Attribute[n];
        this.cellDirty = new boolean[n][];
        for (int i = 0; i < n; ++i) {
            this.cellDirty[i] = new boolean[10];
        }
        this.setModels(this.models);
        this.observableManager.addObservable((Observable)((Object)this.eltModels));
    }

    public void update(Observable observable, Object object) {
        try {
            if (observable == this.eltModels && object == ModelUpdateType.DELETED) {
                BlsrTableModel.println("update: ElementModels deleted, ignoring");
                return;
            }
            if (observable instanceof BlsrModel && object == ModelUpdateType.CHANGED) {
                int n = this.getRowFor((BlsrModel)((Object)observable));
                if (n >= 0) {
                    BlsrTableModel.println("update: calling refreshSingleRow(" + n + ")");
                    this.refreshSingleModel(n, true);
                } else {
                    BlsrTableModel.println("update: row not found for BlsrModel - " + observable);
                    BlsrTableModel.println("update: fall back on calling refreshFromModel()");
                    this.refreshFromModel();
                }
            } else {
                BlsrTableModel.println("update: calling refreshFromModel()");
                this.refreshFromModel();
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            BlsrTableModel.println("update: caught an AbstractCmsIOExecption");
            if (BlsrTableModel.db.on) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
        catch (Exception exception) {
            BlsrTableModel.println("update: caught an execption");
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_BLSR_REFRESH_ERROR_PARAM_1, (Object)this.blsrTerm);
        }
    }

    public int processBlockedEvent(Observable observable, Object object, int n) {
        if (observable == this.eltModels) {
            BlsrTableModel.println("processBlockedEvent: returning NEEDS_RESET");
            return 2;
        }
        if (n == 0) {
            BlsrTableModel.println("processBlockedEvent: returning NEEDS_REFRESH");
            return 1;
        }
        BlsrTableModel.println("processBlockedEvent: returning previous state: " + n);
        return n;
    }

    private static void println(String string) {
        if (BlsrTableModel.db.on) {
            db.println(string);
        }
    }

    private boolean ringIdSanityCheck(String string) {
        boolean bl = true;
        Iterator iterator = this.eltModels.getBlsrElements().iterator();
        while (iterator.hasNext()) {
            if (((BlsrModel)iterator.next()).getProvision().ringName != string) continue;
            bl = false;
            break;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        columnSecurityLevels = new int[][]{{4, 4, 4, 4, 4, 4, 4, 1, 4, 1}, {4, 4, 2, 2, 2, 2, 4, 4, 4, 4}};
    }

    public class UnableToSwitchException
    extends Exception {
        public UnableToSwitchException(String string) {
            super(string);
        }

        public String toString() {
            return this.getMessage();
        }
    }
}

