/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.SonetTopology.eElementType;
import cerent.cms.model.Attribute;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractProvTablePane;
import cerent.cms.ui.RevertiveBehaviorCellEditor;
import cerent.cms.ui.RevertiveBehaviorRenderer;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.BlsrTableModel;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.LetterOrDigitTextField;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class BlsrTablePane
extends AbstractProvTablePane {
    public static final int EAST_OP = 0;
    public static final int WEST_OP = 1;
    protected String blsrTerm;
    protected String STS_TERM;
    private boolean allowForceAndLockout = this.isUserAuthorized(SecurityLevel.PROVISIONING);
    private static DefaultCellEditor ringIdEditor = new DefaultCellEditor(new LetterOrDigitTextField(6));
    private static DefaultCellEditor nodeIdEditor = BlsrTablePane.getIntegerRangeCellEditor(0, 31);
    private static DefaultCellEditor revertEditor = new RevertiveBehaviorCellEditor(true);
    private static DefaultTableCellRenderer centeredRenderer = new DefaultTableCellRenderer();
    private static RevertiveBehaviorRenderer revertRenderer;
    private static TableCellRenderer lineRenderer;
    private static final SDebug db;

    public BlsrTablePane(String string, TabbedView tabbedView, int n) {
        super(string, tabbedView, new BlsrTableModel((NodeModelDelegate)tabbedView.getUiModel(), n), n == 1);
        BlsrOpEditor blsrOpEditor = new BlsrOpEditor(this.allowForceAndLockout, 1);
        BlsrOpEditor blsrOpEditor2 = new BlsrOpEditor(this.allowForceAndLockout, 0);
        INodeModel iNodeModel = (INodeModel)tabbedView.getUiModel();
        TDMTerminology tDMTerminology = iNodeModel.getTDMTerminology();
        this.blsrTerm = tDMTerminology.getRingTerms(1);
        this.STS_TERM = tDMTerminology.getGeneralTerms(0);
        this.setBorder(BorderFactory.createTitledBorder(this.blsrTerm));
        BlsrTableModel blsrTableModel = (BlsrTableModel)this.dataModel;
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        this.setColumnCellEditor(2, ringIdEditor);
        this.setColumnCellEditor(3, nodeIdEditor);
        this.setColumnCellEditor(4, revertEditor);
        this.setColumnCellEditor(5, revertEditor);
        this.setColumnCellEditor(7, blsrOpEditor);
        this.setColumnCellEditor(9, blsrOpEditor2);
        this.setColumnAttributes(0, 50, true, centeredRenderer);
        this.setColumnAttributes(1, 50, true, centeredRenderer);
        this.setColumnAttributes(2, 50, true, centeredRenderer);
        this.setColumnAttributes(3, 50, true, centeredRenderer);
        this.setColumnAttributes(4, 100, true, revertRenderer);
        this.setColumnAttributes(5, 100, true, revertRenderer);
        this.setColumnAttributes(6, 110, true, lineRenderer);
        this.setColumnAttributes(7, 90, true, centeredRenderer);
        this.setColumnAttributes(8, 110, true, lineRenderer);
        this.setColumnAttributes(9, 90, true, centeredRenderer);
        this.table.sizeColumnsToFit(-1);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(n == 1);
    }

    public String getBlsrTerm() {
        return this.blsrTerm;
    }

    public String getStsTerm() {
        return this.STS_TERM;
    }

    protected Attribute[] getAttributes(String string) {
        BlsrTableModel blsrTableModel = (BlsrTableModel)this.dataModel;
        return blsrTableModel.getAttributeMap().getAttributeArray(string);
    }

    static {
        centeredRenderer.setHorizontalAlignment(0);
        revertRenderer = new RevertiveBehaviorRenderer();
        lineRenderer = new TextAreaRenderer();
        db = new SDebug("BlsrTablePane");
    }

    protected static class TextAreaRenderer
    extends JTextArea
    implements TableCellRenderer {
        public TextAreaRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 0, 0));
            this.setFont(new JLabel().getFont());
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText(String.valueOf(object));
            this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            int n3 = this.getPreferredSize().height;
            if (n3 > jTable.getRowHeight()) {
                jTable.setRowHeight(n3);
            }
            return this;
        }
    }

    protected class BlsrOpEditor
    extends DefaultCellEditor {
        private DefaultComboBoxModel choices2F;
        private DefaultComboBoxModel choices4F;
        private int eastWest;

        public BlsrOpEditor(boolean bl, int n) {
            super(new JComboBox());
            if (bl) {
                this.choices2F = new DefaultComboBoxModel<Attribute>(BlsrTablePane.this.getAttributes("blsrOp.2F.full"));
                this.choices4F = new DefaultComboBoxModel<Attribute>(BlsrTablePane.this.getAttributes("blsrOp.4F.full"));
            } else {
                this.choices2F = new DefaultComboBoxModel<Attribute>(BlsrTablePane.this.getAttributes("blsrOp.2F.min"));
                this.choices4F = new DefaultComboBoxModel<Attribute>(BlsrTablePane.this.getAttributes("blsrOp.4F.min"));
            }
            this.eastWest = n;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            BlsrTablePane.this.allowForceAndLockout = BlsrTablePane.this.isUserAuthorized(SecurityLevel.PROVISIONING);
            BlsrTableModel blsrTableModel = (BlsrTableModel)jTable.getModel();
            BlsrModel blsrModel = blsrTableModel.getBlsrModel(n);
            if (this.eastWest == 1) {
                bl2 = blsrModel.getWestProtectionOp().kOp.value() == 0 || blsrModel.getWestProtectionOp().kOp.value() == 8;
            } else if (this.eastWest == 0) {
                bl2 = blsrModel.getEastProtectionOp().kOp.value() == 0 || blsrModel.getEastProtectionOp().kOp.value() == 8;
            }
            bl3 = this.eastWest == 1 && blsrModel.getWestProtectionOp().kOp.value() == 6 || this.eastWest == 0 && blsrModel.getEastProtectionOp().kOp.value() == 6;
            bl4 = this.eastWest == 1 && blsrModel.getWestProtectionOp().kOp.value() == 7 || this.eastWest == 0 && blsrModel.getEastProtectionOp().kOp.value() == 7;
            bl5 = this.eastWest == 1 && blsrModel.getWestProtectionOp().kOp.value() == 4 || this.eastWest == 0 && blsrModel.getEastProtectionOp().kOp.value() == 4;
            bl6 = this.eastWest == 1 && blsrModel.getWestProtectionOp().kOp.value() == 5 || this.eastWest == 0 && blsrModel.getEastProtectionOp().kOp.value() == 5;
            bl7 = this.eastWest == 1 && blsrModel.getWestProtectionOp().kOp.value() == 2 || this.eastWest == 0 && blsrModel.getEastProtectionOp().kOp.value() == 2;
            bl8 = this.eastWest == 1 && blsrModel.getWestProtectionOp().kOp.value() == 3 || this.eastWest == 0 && blsrModel.getEastProtectionOp().kOp.value() == 3;
            boolean bl10 = true;
            try {
                bl10 = ((BlsrTableModel)jTable.getModel()).getBlsrModel(n).getTypeEnum() == eElementType.BLSR_2_WIRE;
            }
            catch (Exception exception) {
                db.finer("Exception/NOP, assuming 2-fiber " + exception);
            }
            DefaultComboBoxModel<Attribute> defaultComboBoxModel = bl2 ? (bl10 ? this.choices2F : this.choices4F) : (bl3 ? (BlsrTablePane.this.allowForceAndLockout ? new DefaultComboBoxModel<Attribute>(BlsrTablePane.this.getAttributes("blsrOp.4F.exerSpan.full")) : new DefaultComboBoxModel<Attribute>(BlsrTablePane.this.getAttributes("blsrOp.4F.exerSpan.min"))) : (bl4 ? (bl10 ? (BlsrTablePane.this.allowForceAndLockout ? new DefaultComboBoxModel<Attribute>(BlsrTablePane.this.getAttributes("blsrOp.2F.exerRing.full")) : new DefaultComboBoxModel<Attribute>(BlsrTablePane.this.getAttributes("blsrOp.2F.exerRing.min"))) : (BlsrTablePane.this.allowForceAndLockout ? new DefaultComboBoxModel<Attribute>(BlsrTablePane.this.getAttributes("blsrOp.4F.exerRing.full")) : new DefaultComboBoxModel<Attribute>(BlsrTablePane.this.getAttributes("blsrOp.4F.exerRing.min")))) : (bl5 ? (BlsrTablePane.this.allowForceAndLockout ? new DefaultComboBoxModel<Attribute>(BlsrTablePane.this.getAttributes("blsrOp.4F.manSpan.full")) : new DefaultComboBoxModel<Attribute>(BlsrTablePane.this.getAttributes("blsrOp.4F.manSpan.min"))) : (bl6 ? (bl10 ? (BlsrTablePane.this.allowForceAndLockout ? new DefaultComboBoxModel<Attribute>(BlsrTablePane.this.getAttributes("blsrOp.2F.manRing.full")) : new DefaultComboBoxModel<Attribute>(BlsrTablePane.this.getAttributes("blsrOp.2F.manRing.min"))) : (BlsrTablePane.this.allowForceAndLockout ? new DefaultComboBoxModel<Attribute>(BlsrTablePane.this.getAttributes("blsrOp.4F.manRing.full")) : new DefaultComboBoxModel<Attribute>(BlsrTablePane.this.getAttributes("blsrOp.4F.manRing.min")))) : (bl7 && BlsrTablePane.this.allowForceAndLockout ? new DefaultComboBoxModel<Attribute>(BlsrTablePane.this.getAttributes("blsrOp.4F.forceSpan.full")) : (bl8 && BlsrTablePane.this.allowForceAndLockout ? (bl10 ? new DefaultComboBoxModel<Attribute>(BlsrTablePane.this.getAttributes("blsrOp.2F.forceRing.full")) : new DefaultComboBoxModel<Attribute>(BlsrTablePane.this.getAttributes("blsrOp.4F.forceRing.full"))) : new DefaultComboBoxModel<Attribute>(BlsrTablePane.this.getAttributes("blsrOp.clear"))))))));
            ((JComboBox)this.getComponent()).setModel(defaultComboBoxModel);
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
    }
}

