/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Optics.eRingDirection;
import cerent.cms.idl.OpticsTopology.sOscPort;
import cerent.cms.idl.OpticsTopology.sOscRingParams;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.DwdmRingModelDelegate;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhTermModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.shelf.DwdmRingPane;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class DwdmRingCreationDialog
extends UDialog
implements ActionListener,
DocumentListener {
    public static final String TITLE = "Create DWDM Ring ID";
    public static final String ED_TITLE = "Edit DWDM Ring ID";
    public static final int WEST = eRingDirection.WEST_EAST.value();
    public static final int EAST = eRingDirection.EAST_WEST.value();
    private JButton okButton;
    private JButton cancelButton;
    private JTextField ringIdTF;
    private JComboBox westLineCB;
    private JComboBox eastLineCB;
    private DwdmRingModelDelegate dwdmRingModel;
    private boolean editFlag = false;
    private sOscRingParams editItem;
    private static final SDebug db = new SDebug("DwdmRingCreationDialog");

    public static DwdmRingCreationDialog instance(DwdmRingPane dwdmRingPane, DwdmRingModelDelegate dwdmRingModelDelegate) {
        Frame frame = JOptionPane.getFrameForComponent((Component)((Object)dwdmRingPane));
        return new DwdmRingCreationDialog(frame, TITLE, dwdmRingModelDelegate);
    }

    public static DwdmRingCreationDialog instance(DwdmRingPane dwdmRingPane, DwdmRingModelDelegate dwdmRingModelDelegate, sOscRingParams sOscRingParams2) {
        Frame frame = JOptionPane.getFrameForComponent((Component)((Object)dwdmRingPane));
        DwdmRingCreationDialog dwdmRingCreationDialog = new DwdmRingCreationDialog(frame, ED_TITLE, dwdmRingModelDelegate);
        dwdmRingCreationDialog.initEditDlg(sOscRingParams2);
        return dwdmRingCreationDialog;
    }

    private DwdmRingCreationDialog(Frame frame, String string, DwdmRingModelDelegate dwdmRingModelDelegate) {
        super(frame, string, true, (Object)dwdmRingModelDelegate);
    }

    public void initEditDlg(sOscRingParams sOscRingParams2) {
        this.editItem = sOscRingParams2;
        TdmPortModel[] tdmPortModelArray = new TdmPortModel[2];
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.dwdmRingModel.getNodeModel();
        this.editFlag = true;
        this.ringIdTF.setText(sOscRingParams2.ringName);
        try {
            tdmPortModelArray[0] = (TdmPortModel)nodeModelDelegate.getEntityTable().getEntityModelByIndex(sOscRingParams2.westPort);
            this.westLineCB.setSelectedItem(tdmPortModelArray[0]);
            tdmPortModelArray[1] = (TdmPortModel)nodeModelDelegate.getEntityTable().getEntityModelByIndex(sOscRingParams2.eastPort);
            this.eastLineCB.setSelectedItem(tdmPortModelArray[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initContentPane(JPanel jPanel, Object object) {
        this.dwdmRingModel = (DwdmRingModelDelegate)object;
        this.setSize(new Dimension(500, 500));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.getComboPanel(), "Center");
        jPanel.add((Component)this.getLabelPanel(), "West");
        jPanel.add((Component)this.getButtonPanel(), "South");
        this.initCombosRenderers();
        IConnectionModel[] iConnectionModelArray = this.getNmd().getOscTermConnectionModel().getTermModels();
        this.updateCB(WEST, iConnectionModelArray);
        this.updateCB(EAST, iConnectionModelArray);
        this.enableOk(false);
        Document document = this.ringIdTF.getDocument();
        document.addDocumentListener(this);
        this.westLineCB.addActionListener(this);
        this.eastLineCB.addActionListener(this);
    }

    public void dispose() {
        super.dispose();
    }

    private JPanel getButtonsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.getComboPanel(), "North");
        jPanel.add((Component)this.getButtonPanel(), "South");
        return jPanel;
    }

    private JPanel getLabelPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.add(new JLabel("Ring ID : "));
        jPanel.add(new JLabel("West Line : "));
        jPanel.add(new JLabel("East Line : "));
        return jPanel;
    }

    private JPanel getComboPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        this.ringIdTF = new JTextField();
        jPanel.add(this.ringIdTF);
        this.westLineCB = new JComboBox();
        jPanel.add(this.westLineCB);
        this.eastLineCB = new JComboBox();
        jPanel.add(this.eastLineCB);
        return jPanel;
    }

    private void initCombosRenderers() {
        this.westLineCB.setRenderer(new EntityCellRenderer("slot "));
        this.eastLineCB.setRenderer(new EntityCellRenderer("slot "));
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (!this.editFlag) {
                this.apply();
            } else {
                try {
                    this.apply();
                }
                catch (Exception exception) {
                    this.showErr(exception);
                }
            }
            this.dispose();
        } else if (object == this.cancelButton) {
            this.dispose();
        } else if (object == this.westLineCB || object == this.eastLineCB) {
            // empty if block
        }
    }

    private void apply() {
        String string = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        string = this.ringIdTF.getText();
        n = this.getCBPortIndex(EAST);
        n2 = this.getCBPortIndex(WEST);
        n3 = string.compareToIgnoreCase("all");
        if (string.length() > 6) {
            Exception exception = new Exception(ErrorMsg.getString((EID)EMC.EID_DWDM_RING_NAME_TOO_LONG));
            this.showErr(exception);
        } else if (n3 == 0) {
            Exception exception = new Exception(ErrorMsg.getString((EID)EMC.EID_DWDM_RING_ILLEGAL_NAME));
            this.showErr(exception);
        } else if (n == 0 && n2 == 0) {
            Exception exception = new Exception(ErrorMsg.getString((EID)EMC.EID_DWDM_RING_WRONG_LINE_SELECTION));
            this.showErr(exception);
        } else {
            try {
                this.dwdmRingModel.createRingId(string, n, n2);
            }
            catch (FeatureUnsupported featureUnsupported) {
                this.showErr((Exception)((Object)featureUnsupported));
            }
            catch (CannotPerform cannotPerform) {
                this.showErr((Exception)((Object)cannotPerform));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void showErr(Exception exception) {
        ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_ERROR_RING_ID, AnnotatedException.getString((Exception)exception));
    }

    private void updateCB(int n, IConnectionModel[] iConnectionModelArray) {
        int n2 = 0;
        IEntityModel iEntityModel = null;
        List list = this.getOc3PortBySide(eRingDirection.from_int(n));
        JComboBox jComboBox = n == WEST ? this.westLineCB : this.eastLineCB;
        jComboBox.removeAllItems();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            n2 = ((sOscPort)iterator.next()).oscPort;
            for (int i = 0; i < iConnectionModelArray.length; ++i) {
                if (!(iConnectionModelArray[i] instanceof OhTermModel) || (iEntityModel = ((OhTermModel)iConnectionModelArray[i]).getOpticalPortModel()).getIndex() != n2) continue;
                jComboBox.addItem(iEntityModel);
            }
        }
    }

    private NodeModelDelegate getNmd() {
        return (NodeModelDelegate)this.dwdmRingModel.getNodeModel();
    }

    private List getOc3PortBySide(eRingDirection eRingDirection2) {
        ArrayList<sOscPort> arrayList = new ArrayList<sOscPort>();
        try {
            sOscPort[] sOscPortArray = this.getNmd().getDwdmOpticalSetupModel().getOscPortList();
            for (int i = 0; i < sOscPortArray.length; ++i) {
                if (sOscPortArray[i].direction.value() != eRingDirection2.value()) continue;
                arrayList.add(sOscPortArray[i]);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return arrayList;
    }

    private int getCBPortIndex(int n) {
        int n2 = 0;
        try {
            n2 = n == EAST ? ((TdmPortModel)this.eastLineCB.getSelectedItem()).getIndex() : ((TdmPortModel)this.westLineCB.getSelectedItem()).getIndex();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    private void enableOk(boolean bl) {
        this.okButton.setEnabled(bl);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        String string = this.ringIdTF.getText();
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetterOrDigit(string.charAt(i))) continue;
            this.enableOk(false);
            return;
        }
        this.enableOk(true);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.ringIdTF.getText().length() == 0) {
            this.enableOk(false);
        } else {
            this.insertUpdate(documentEvent);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }
}

