/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.model.HdGeLineModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.PortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.shelf.AbstractPortGraphic;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.G1000CardView;
import cerent.cms.ui.shelf.ICardPainter;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.CubicCurve2D;
import java.util.Observable;
import java.util.Observer;

public class HdGePortGraphic
extends Rectangle
implements Observer {
    public int portNo;
    public int slotNo;
    private PortModel portModel;
    private InterfaceModel ifModel;
    private CardGraphic parent;
    private String statusString = "";
    private String alarmProfileString = "";
    private Color currentColor = Color.gray;
    protected EntityCellRenderer myPortRenderer = new EntityCellRenderer();
    private int currentSeverity = 0;
    private TDMTerminology terms;
    private int currentAdminState = -1;
    private int currentServiceStateType = -1;
    private boolean is327 = false;
    private int connector1XOffset;
    private int connector2XOffset;
    private int connector1YOffset;
    private int connector2YOffset;
    private Rectangle connector1;
    private Rectangle connector2;
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfLayout.db, "HdGePortGraphic");

    public HdGePortGraphic(CardGraphic cardGraphic, int n, int n2, PortModel portModel) {
        super(n, n2, 1, 1);
        this.parent = cardGraphic;
        this.portModel = portModel;
        this.terms = this.portModel.getNodeModel().getTDMTerminology();
        IPlatform iPlatform = portModel.getNodeModelDelegate().getPlatform();
        ICardPainter iCardPainter = cardGraphic.getCardPainter();
        this.resize(iCardPainter.getPortWidth(), iCardPainter.getPortHeight());
        this.connector1XOffset = n + iCardPainter.getPortConn1X();
        this.connector2XOffset = n + iCardPainter.getPortConn2X();
        this.connector1YOffset = n2 + iCardPainter.getPortConn1Y();
        this.connector2YOffset = n2 + iCardPainter.getPortConn2Y();
        this.connector1 = new Rectangle(this.connector1XOffset, this.connector1YOffset, 2, 2);
        this.connector2 = new Rectangle(this.connector2XOffset, this.connector2YOffset, 2, 2);
        this.slotNo = this.portModel.getSlot();
        this.portNo = this.portModel.getPort();
        Thread thread = new Thread("HdGePort Init:" + this.slotNo + ":" + this.portNo){

            public void run() {
                HdGePortGraphic.this.setIfModel((InterfaceModel)HdGePortGraphic.this.portModel.getInterfaceModel());
                HdGePortGraphic.this.registerWithModel();
                HdGePortGraphic.this.updateCurrentState();
            }
        };
        thread.start();
        this.is327 = iPlatform.is327();
    }

    private void setIfModel(InterfaceModel interfaceModel) {
        this.ifModel = interfaceModel;
    }

    public PortModel getPortModel() {
        return this.portModel;
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got state changed message ");
            }
            this.updateCurrentState();
        }
    }

    protected String getPortDescription() {
        StringBuffer stringBuffer = new StringBuffer("Port ");
        stringBuffer.append(this.myPortRenderer.getPortString(this.portModel, false));
        stringBuffer.append(", ");
        return stringBuffer.toString();
    }

    public String getTooltipText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getPortDescription());
        try {
            stringBuffer.append(this.statusString);
            stringBuffer.append(", Alarm Profile: ");
            stringBuffer.append(this.alarmProfileString);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Failed trying to generate tooltip string: " + exception.getMessage());
                SDebug.printStackTrace((Throwable)exception);
            }
            stringBuffer = new StringBuffer("");
        }
        return stringBuffer.toString();
    }

    public void dispose() {
        if (this.ifModel != null) {
            if (db.on()) {
                db.println("Deleting observer " + this.ifModel + " Slot " + this.slotNo);
            }
            this.ifModel.deleteObserver(this);
        }
        if (this.portModel != null) {
            if (db.on()) {
                db.println("Deleting observer " + this.portModel + " Slot " + this.slotNo);
            }
            this.portModel.deleteObserver(this);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof HdGePortGraphic) {
            return object == this;
        }
        return super.equals(object);
    }

    protected void setAlarmState(int n) {
        if (db.on()) {
            db.println("set alrm st=" + n);
        }
        if (this.currentSeverity != n) {
            this.currentSeverity = n;
            if (this.currentAdminState == 0) {
                this.currentColor = AbstractPortGraphic.getPortColorByAdminStateAndSeverity(this.currentAdminState, n);
                this.parent.repaint();
            }
        }
    }

    private void updateCurrentState() {
        int n;
        int n2;
        block7: {
            try {
                this.alarmProfileString = this.portModel.getAlarmProfileName();
            }
            catch (Exception exception) {
                this.alarmProfileString = "(Error Retrieving)";
            }
            n2 = -1;
            n = -1;
            try {
                if (this.ifModel != null) {
                    n2 = this.ifModel.getAdminState();
                    n = this.ifModel.getServiceSt().getType();
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) break block7;
                db.println("Caught exception in updateCurrentState");
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        if (this.currentServiceStateType != n) {
            this.currentServiceStateType = n;
            this.statusString = this.terms.getTermForServiceState(this.currentServiceStateType);
        }
        if (n2 != this.currentAdminState) {
            this.currentAdminState = n2;
            this.currentColor = AbstractPortGraphic.getPortColorByAdminStateAndSeverity(this.currentAdminState, this.currentSeverity);
        }
        this.parent.repaint();
    }

    protected Color getCurrentColor() {
        return this.currentColor;
    }

    private void registerWithModel() {
        if (this.ifModel != null) {
            if (db.on()) {
                db.println("registering with " + this.ifModel);
            }
            this.ifModel.addObserver(this);
        }
        if (db.on()) {
            db.println("registering with " + this.portModel);
        }
        this.portModel.addObserver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void draw(Graphics2D graphics2D) {
        int n;
        block16: {
            double d8 = this.connector1XOffset;
            double d7 = this.connector1YOffset;
            double d6 = this.connector2XOffset;
            double d5 = this.connector2YOffset;
            double d4 = Math.min(d7, d5);
            double d3 = Math.max(d7, d5);
            double d2 = Math.min(d8, d6);
            double d = Math.max(d8, d6);
            CubicCurve2D.Double double_ = null;
            graphics2D.setColor(this.getCurrentColor());
            graphics2D.fill(this);
            graphics2D.setColor(Color.black);
            graphics2D.draw(this);
            graphics2D.fill(this.connector1);
            graphics2D.fill(this.connector2);
            if (this.isFacilityLoopback()) {
                double_ = this.is327 ? new CubicCurve2D.Double(d8, d7, d2 + (d - d2) / 5.0, d7 + this.getHeight() / 1.7, d - (d - d2) / 100.0, d5 + this.getHeight() / 1.7, d6, d5) : new CubicCurve2D.Double(d8, d7, d8 - this.getWidth() / 2.25, Math.abs(d7 - d5) / 100.0 + d4, d6 - this.getWidth() / 2.25, d3 - Math.abs(d7 - d5) / 100.0, d6, d5);
                G1000CardView.drawArrow(graphics2D, this, true, true, this.is327, Color.gray);
                Color color = graphics2D.getColor();
                graphics2D.setColor(Color.gray);
                graphics2D.draw(double_);
                graphics2D.setColor(color);
                return;
            }
            if (this.isTerminalLoopback()) {
                double_ = this.is327 ? new CubicCurve2D.Double(d8, d7, (d - d2) / 5.0 + d2, d7 - this.getHeight() / 2.5, d - (d - d2) / 100.0, d5 - this.getHeight() / 2.5, d6, d5) : new CubicCurve2D.Double(d8, d7, d8 + this.getWidth() / 2.25, Math.abs(d7 - d5) / 100.0 + d4, d6 + this.getWidth() / 2.25, d3 - Math.abs(d7 - d5) / 100.0, d6, d5);
                Color color = graphics2D.getColor();
                graphics2D.setColor(Color.black);
                graphics2D.draw(double_);
                graphics2D.setColor(color);
                return;
            }
            HdGeLineModel hdGeLineModel = (HdGeLineModel)this.ifModel;
            n = 0;
            Throwable throwable = null;
            try {
                try {
                    n = hdGeLineModel.getGmacLineAdminInfo_4_01().mode.value();
                }
                catch (NoSuchInterface noSuchInterface) {
                    throwable = noSuchInterface;
                    Object var24_17 = null;
                    if (throwable != null && db.on()) {
                        SDebug.printStackTrace((Throwable)throwable);
                    }
                    break block16;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    throwable = wrongInterfaceType;
                    Object var24_18 = null;
                    if (throwable != null && db.on()) {
                        SDebug.printStackTrace((Throwable)throwable);
                    }
                    break block16;
                }
                Object var24_16 = null;
                if (throwable == null) break block16;
            }
            catch (Throwable throwable2) {
                Object var24_19 = null;
                if (throwable == null) throw throwable2;
                if (!db.on()) throw throwable2;
                SDebug.printStackTrace((Throwable)throwable);
                throw throwable2;
            }
            if (db.on()) {
                SDebug.printStackTrace((Throwable)throwable);
            }
        }
        switch (n) {
            case 2: {
                G1000CardView.drawArrow(graphics2D, this, true, true, this.is327, Color.black);
                return;
            }
            case 4: {
                G1000CardView.drawArrow(graphics2D, this, false, true, this.is327, Color.black);
                return;
            }
            case 3: {
                G1000CardView.drawArrow(graphics2D, this, true, false, this.is327, Color.black);
                return;
            }
            case 1: {
                G1000CardView.drawArrow(graphics2D, this, true, true, this.is327, Color.black);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isLoopback(int n) {
        boolean bl = false;
        Throwable throwable = null;
        if (!(this.ifModel instanceof HdGeLineModel)) return bl;
        HdGeLineModel hdGeLineModel = (HdGeLineModel)this.ifModel;
        try {
            try {
                bl = hdGeLineModel.getGmacLineAdminInfo_4_01().loopback.value() == n;
            }
            catch (NoSuchInterface noSuchInterface) {
                throwable = noSuchInterface;
                Object var7_6 = null;
                if (throwable == null) return bl;
                if (!db.on()) return bl;
                SDebug.printStackTrace((Throwable)throwable);
                return bl;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                throwable = wrongInterfaceType;
                Object var7_7 = null;
                if (throwable == null) return bl;
                if (!db.on()) return bl;
                SDebug.printStackTrace((Throwable)throwable);
                return bl;
            }
            Object var7_5 = null;
            if (throwable == null) return bl;
        }
        catch (Throwable throwable2) {
            Object var7_8 = null;
            if (throwable == null) throw throwable2;
            if (!db.on()) throw throwable2;
            SDebug.printStackTrace((Throwable)throwable);
            throw throwable2;
        }
        if (!db.on()) return bl;
        SDebug.printStackTrace((Throwable)throwable);
        return bl;
    }

    public boolean isFacilityLoopback() {
        return this.isLoopback(2);
    }

    public boolean isTerminalLoopback() {
        return this.isLoopback(1);
    }
}

