/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OpticsTopology.sAPCLastModification;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ParserIfName;
import cerent.cms.model.PortModel;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class MaintApcTableColumnRenderer
extends AbstractColumnRenderer {
    public static final int SLOT_INDEX = 0;
    public static final int PORT_INDEX = 1;
    public static final int CARD_INDEX = 2;
    public static final int LASTMOD_INDEX = 3;
    public static final int LASTCHECK_INDEX = 4;
    private static final int COLUMN_NO = 5;
    private static AttributeMaps attributeMap = new AttributeMaps();
    private JLabel label;
    private NodeModelDelegate nm;
    private EventUtilities eventutilities;
    private Color[] status_color = new Color[]{Color.black};

    public MaintApcTableColumnRenderer(NodeModelDelegate nodeModelDelegate, String string, int n, boolean bl, int n2) {
        super(string, n, bl, n2);
        this.nm = nodeModelDelegate;
        this.eventutilities = EventUtilities.getInstance(nodeModelDelegate);
        this.label = new JLabel();
        this.label.setHorizontalAlignment(n2);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        sAPCLastModification sAPCLastModification2;
        String string = "";
        long l = 0L;
        String string2 = "";
        JLabel jLabel = this.label;
        try {
            sAPCLastModification2 = (sAPCLastModification)object;
        }
        catch (Exception exception) {
            this.label.setText("");
            return jLabel;
        }
        Color color = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        switch (n2) {
            case 0: {
                string = this.getSlot(this.nm, sAPCLastModification2.index);
                break;
            }
            case 2: {
                string = this.getCardString(this.nm, sAPCLastModification2.index);
                break;
            }
            case 1: {
                string = this.getPortName(sAPCLastModification2.index);
                break;
            }
            case 3: {
                if (sAPCLastModification2.lastModification > 0) {
                    l = this.eventutilities.convertSecondsToMilliSeconds(sAPCLastModification2.lastModification);
                    string = this.eventutilities.formatAbsoluteNeTimeasCtcTimeZoneString(l);
                    break;
                }
                string = new String("N/A");
                break;
            }
            case 4: {
                if (sAPCLastModification2.lastChecked > 0) {
                    l = this.eventutilities.convertSecondsToMilliSeconds(sAPCLastModification2.lastChecked);
                    string = this.eventutilities.formatAbsoluteNeTimeasCtcTimeZoneString(l);
                    break;
                }
                string = new String("N/A");
            }
        }
        this.label.setToolTipText("");
        this.label.setText(string);
        ((Component)jLabel).setBackground(color);
        return jLabel;
    }

    private String getSlot(NodeModelDelegate nodeModelDelegate, int n) {
        int n2 = MaintApcTableColumnRenderer.getSlotInt(nodeModelDelegate, n);
        if (n2 == -1) {
            return "unknown";
        }
        return String.valueOf(n2);
    }

    private String getCardString(NodeModelDelegate nodeModelDelegate, int n) {
        EntityModel entityModel = null;
        try {
            entityModel = (EntityModel)nodeModelDelegate.getEntityTableModel().getEntityModelByIndex(n);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return null;
        }
        IModuleModel iModuleModel = entityModel.getModuleModel();
        return iModuleModel.getEqTypeName();
    }

    static int getSlotInt(NodeModelDelegate nodeModelDelegate, int n) {
        EntityModel entityModel = null;
        try {
            entityModel = (EntityModel)nodeModelDelegate.getEntityTableModel().getEntityModelByIndex(n);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return -1;
        }
        if (entityModel != null && entityModel instanceof PortModel) {
            return entityModel.getSlot();
        }
        return -1;
    }

    private String getPortName(int n) {
        return new ParserIfName(n).getAID();
    }

    static ColumnRenderer[] createTableRenderers(NodeModelDelegate nodeModelDelegate) {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[5];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = MaintApcTableColumnRenderer.createColumnRenderer(nodeModelDelegate, i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(NodeModelDelegate nodeModelDelegate, int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "Slot Id";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 2: {
                string = "Card";
                n3 = 300;
                bl = true;
                n2 = 2;
                break;
            }
            case 1: {
                string = "Port";
                n3 = 120;
                bl = true;
                n2 = 2;
                break;
            }
            case 3: {
                string = "Last Modification";
                n3 = 200;
                bl = true;
                n2 = 2;
                break;
            }
            case 4: {
                string = "Last Check";
                n3 = 200;
                bl = true;
                n2 = 2;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = false;
                n2 = 2;
            }
        }
        return new MaintApcTableColumnRenderer(nodeModelDelegate, string, n3, bl, n2);
    }
}

