/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.EntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardView;
import cerent.cms.ui.shelf.GenericPortGraphic;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Arrays;
import javax.swing.JLabel;

public class OadmCardView
extends CardView {
    private static final SDebug db;
    private JLabel[] labels;
    private static final String[] RX_LABELS;
    private static final String[] TX_LABELS;
    private static final String[] AD4_LABELS;
    private static final String[] AD4B_LABELS;
    private static final String[] AD2_LABELS;
    private static final String[] AD1_LABELS;
    private static final String[] AD1B_LABELS;
    private static final String[] OPT_PRE_LABELS;
    private static final String[] OPT_BST_LABELS;
    private static final String[] MD_4_LABELS;
    private static JLabel[] rxLabels;
    private static JLabel[] txLabels;
    private static JLabel[] AD4Labels;
    private static JLabel[] AD2Labels;
    private static JLabel[] AD1Labels;
    private static JLabel[] AD1BLabels;
    private static JLabel[] AD4BLabels;
    private static JLabel[] OPTPRELabels;
    private static JLabel[] OPTBSTLabels;
    private static JLabel[] MD4Labels;

    public OadmCardView(ModuleModel moduleModel) {
        super(moduleModel);
        if (moduleModel instanceof OpticsModuleModel) {
            this.removeOriginalPorts();
            OpticsModuleModel opticsModuleModel = (OpticsModuleModel)moduleModel;
            this.portModels = Arrays.asList(opticsModuleModel.getOpticsChildren());
            this.numPorts = this.portModels.size();
            this.addPorts();
            this.addLabels();
            this.refreshAlarmInfo();
        }
    }

    protected void removeOriginalPorts() {
        for (int i = 0; i < this.ports.length; ++i) {
            if (this.ports[i] == null) continue;
            this.ports[i].dispose();
        }
        this.removeAll();
        this.portModels.clear();
        this.numPorts = 0;
    }

    protected void addLabels() {
        int n;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(2, 3, 2, 2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        for (n = 0; n < this.numPorts; n += 2) {
            this.labels = rxLabels;
        }
        for (n = 0; n < this.numPorts; n += 2) {
            gridBagConstraints.gridy = n;
            this.add((Component)this.labels[n], gridBagConstraints);
        }
        for (n = 0; n < this.numPorts; n += 2) {
            this.labels = txLabels;
        }
        for (n = 1; n < this.numPorts; n += 2) {
            gridBagConstraints.gridy = n - 1;
            gridBagConstraints.gridx = 2;
            this.add((Component)this.labels[n], gridBagConstraints);
        }
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        Insets insets2 = new Insets(2, 3, 2, 2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = insets;
        gridBagConstraints2.fill = 2;
        if (this.model.getEqType() == 136) {
            this.labels = AD4Labels;
        } else if (this.model.getEqType() == 138) {
            this.labels = AD4BLabels;
        } else if (this.model.getEqType() == 135) {
            this.labels = AD2Labels;
        } else if (this.model.getEqType() == 134) {
            this.labels = AD1Labels;
        } else if (this.model.getEqType() == 137) {
            this.labels = AD1BLabels;
        } else if (this.model.getEqType() == 129) {
            this.labels = OPTPRELabels;
        } else if (this.model.getEqType() == 130) {
            this.labels = OPTBSTLabels;
        } else if (this.model.getEqType() == 196) {
            this.labels = OPTBSTLabels;
        } else if (this.model.getEqType() == 133) {
            this.labels = MD4Labels;
        }
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        for (int i = 0; i < this.labels.length; ++i) {
            this.add((Component)this.labels[i], gridBagConstraints2);
            ++gridBagConstraints2.gridy;
        }
    }

    protected void addPorts() {
        Object object;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(2, 3, 2, 2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        for (int i = 0; i < this.numPorts; i += 2) {
            if (!(this.portModels.get(i) instanceof PortModel)) continue;
            this.labels = rxLabels;
            object = (PortModel)this.portModels.get(i);
            this.ports[i] = new GenericPortGraphic(this, (EntityModel)object, ((EntityModel)object).getPort(), ((PortModel)object).isSpecial());
            if (this.pci.positionPortsVertically()) {
                gridBagConstraints.gridy = i + 1;
            } else {
                gridBagConstraints.gridx = i + 1;
            }
            this.add((Component)this.ports[i], gridBagConstraints);
        }
        this.numPorts = this.ports.length;
        this.repaint();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        object = new Insets(2, 3, 2, 2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = insets;
        for (int i = 1; i < this.numPorts; i += 2) {
            if (!(this.portModels.get(i) instanceof PortModel)) continue;
            this.labels = txLabels;
            PortModel portModel = (PortModel)this.portModels.get(i);
            this.ports[i] = new GenericPortGraphic(this, portModel, portModel.getPort(), portModel.isSpecial());
            if (this.pci.positionPortsVertically()) {
                gridBagConstraints2.gridy = i - 1 + 1;
                gridBagConstraints2.gridx = 2;
            } else {
                gridBagConstraints2.gridy = i + 1;
            }
            this.add((Component)this.ports[i], gridBagConstraints2);
        }
        this.numPorts = this.ports.length;
        this.repaint();
    }

    static {
        int n;
        db = new SDebug("OadmCardView");
        RX_LABELS = new String[]{"RX", "RX", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
        TX_LABELS = new String[]{"TX", "TX", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
        AD4_LABELS = new String[]{"", "CHAN:", "", "CHAN:", "", "CHAN:", "", "CHAN:", "", "EXP:", "", "COM:"};
        AD4B_LABELS = new String[]{"", "BAND:", "", "BAND:", "", "BAND:", "", "BAND:", "", "EXP:", "", "COM:"};
        AD2_LABELS = new String[]{"", "CHAN:", "", "CHAN:", "", "EXP:", "", "COM:"};
        AD1_LABELS = new String[]{"", "CHAN:", "", "EXP:", "", "COM:"};
        AD1B_LABELS = new String[]{"", "BAND:", "", "EXP:", "", "COM:"};
        OPT_PRE_LABELS = new String[]{"", "COM:", "", "DC:"};
        OPT_BST_LABELS = new String[]{"", "COM:", "", "OSC:", "", "LINE:"};
        MD_4_LABELS = new String[]{"", "CHAN:", "", "CHAN:", "", "CHAN:", "", "CHAN:", "", "COM:"};
        rxLabels = new JLabel[RX_LABELS.length];
        txLabels = new JLabel[TX_LABELS.length];
        AD4Labels = new JLabel[AD4_LABELS.length];
        AD2Labels = new JLabel[AD2_LABELS.length];
        AD1Labels = new JLabel[AD1_LABELS.length];
        AD1BLabels = new JLabel[AD1B_LABELS.length];
        AD4BLabels = new JLabel[AD4B_LABELS.length];
        OPTPRELabels = new JLabel[OPT_PRE_LABELS.length];
        OPTBSTLabels = new JLabel[OPT_BST_LABELS.length];
        MD4Labels = new JLabel[MD_4_LABELS.length];
        for (n = 0; n < RX_LABELS.length; ++n) {
            OadmCardView.rxLabels[n] = AbstractShelfLayout.formatLabel(new JLabel(RX_LABELS[n], 2));
        }
        for (n = 0; n < TX_LABELS.length; ++n) {
            OadmCardView.txLabels[n] = AbstractShelfLayout.formatLabel(new JLabel(TX_LABELS[n], 2));
        }
        for (n = 0; n < AD4_LABELS.length; ++n) {
            OadmCardView.AD4Labels[n] = AbstractShelfLayout.formatLabel(new JLabel(AD4_LABELS[n], 2));
        }
        for (n = 0; n < AD4B_LABELS.length; ++n) {
            OadmCardView.AD4BLabels[n] = AbstractShelfLayout.formatLabel(new JLabel(AD4B_LABELS[n], 2));
        }
        for (n = 0; n < AD2_LABELS.length; ++n) {
            OadmCardView.AD2Labels[n] = AbstractShelfLayout.formatLabel(new JLabel(AD2_LABELS[n], 2));
        }
        for (n = 0; n < AD1_LABELS.length; ++n) {
            OadmCardView.AD1Labels[n] = AbstractShelfLayout.formatLabel(new JLabel(AD1_LABELS[n], 2));
        }
        for (n = 0; n < AD1B_LABELS.length; ++n) {
            OadmCardView.AD1BLabels[n] = AbstractShelfLayout.formatLabel(new JLabel(AD1B_LABELS[n], 2));
        }
        for (n = 0; n < OPT_PRE_LABELS.length; ++n) {
            OadmCardView.OPTPRELabels[n] = AbstractShelfLayout.formatLabel(new JLabel(OPT_PRE_LABELS[n], 2));
        }
        for (n = 0; n < OPT_BST_LABELS.length; ++n) {
            OadmCardView.OPTBSTLabels[n] = AbstractShelfLayout.formatLabel(new JLabel(OPT_BST_LABELS[n], 2));
        }
        for (n = 0; n < MD_4_LABELS.length; ++n) {
            OadmCardView.MD4Labels[n] = AbstractShelfLayout.formatLabel(new JLabel(MD_4_LABELS[n], 2));
        }
    }
}

