/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.OhXconModel;
import cerent.cms.model.OhXcons;
import cerent.cms.ui.RoDataSourceControl;
import cerent.cms.ui.shelf.OhXConnectionPane;
import cerent.cms.ui.shelf.OhXConnectionRowObject;
import cerent.util.IObservableManager;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class OhXConnectionDataSource
extends AbstractRowDataSource
implements Observer,
RoDataSourceControl {
    private List ohXcons = new ArrayList();
    private ObservableManager observableManager;
    private OhXcons ohXconsObj;
    private static final SDebug db = new SDebug((KDebug)OhXConnectionPane.db, "OhXConnectionDataSource");

    public OhXConnectionDataSource(INodeModel iNodeModel) {
        if (db.on()) {
            db.finer("<init>");
        }
        OhConnectionModelsDelegate ohConnectionModelsDelegate = (OhConnectionModelsDelegate)iNodeModel.getOhConnectionModels();
        this.ohXconsObj = ohConnectionModelsDelegate.getOhXcons();
        Observable[] observableArray = new Observable[]{ohConnectionModelsDelegate, this.ohXconsObj};
        this.observableManager = new ObservableManager(this, true, observableArray);
        this.observableManager.setPassing(true);
    }

    private void deleteModel(OhXconModel ohXconModel) {
        if (db.on()) {
            db.fine("deleteModel - " + ohXconModel);
        }
        this.observableManager.removeObservable((Observable)((Object)ohXconModel));
        Iterator iterator = this.ohXcons.iterator();
        while (iterator.hasNext()) {
            OhXConnectionRowObject ohXConnectionRowObject = (OhXConnectionRowObject)iterator.next();
            if (!ohXConnectionRowObject.getOhXconModel().equals(ohXconModel)) continue;
            if (db.on()) {
                db.fine("Find model - " + ohXconModel);
            }
            this.ohXcons.remove(ohXConnectionRowObject);
            return;
        }
    }

    public void refreshFromModel() {
        if (db.on()) {
            db.println("refreshFromModel");
        }
        this.addModels();
        this.fireDataSourceChanged();
    }

    private void addModels() {
        if (db.on()) {
            db.fine("addNewModels");
        }
        HashSet hashSet = new HashSet(this.ohXconsObj.getConnectionModels());
        HashSet<OhXconModel> hashSet2 = new HashSet<OhXconModel>();
        Iterator iterator = this.ohXcons.iterator();
        while (iterator.hasNext()) {
            hashSet2.add(((OhXConnectionRowObject)iterator.next()).getOhXconModel());
        }
        hashSet.removeAll(hashSet2);
        if (db.on()) {
            db.fine("find " + hashSet.size() + " new OhXcons");
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            OhXconModel ohXconModel = (OhXconModel)iterator.next();
            this.ohXcons.add(new OhXConnectionRowObject(ohXconModel));
            this.observableManager.addObservable((Observable)((Object)ohXconModel));
            if (!db.on()) continue;
            db.println("Add new model - " + ohXconModel);
        }
    }

    public void refreshFromModel(int n) throws Exception {
        this.refreshFromModel();
    }

    public IObservableManager getObservableManager() {
        return this.observableManager;
    }

    public void disposeDataSource() {
        if (this.ohXcons != null) {
            this.ohXcons.clear();
        }
    }

    public Object getObjectAtRow(int n) {
        return this.ohXcons.get(n);
    }

    public int getRowCount() {
        return this.ohXcons.size();
    }

    public Collection getAllObjects() {
        return this.ohXcons;
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.info("update: src = " + observable + ", evt = " + object);
        }
        try {
            if (observable instanceof OhXcons && object == ModelUpdateType.ADDED) {
                this.addModels();
            }
            if (observable instanceof OhXconModel && object == ModelUpdateType.DELETED) {
                this.deleteModel((OhXconModel)((Object)observable));
            }
            if (observable instanceof OhConnectionModelsDelegate && object != ModelUpdateType.CHANGED) {
                return;
            }
            this.fireDataSourceChanged();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }
}

