/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AbstractTermConnectionModel;
import cerent.cms.model.Busy;
import cerent.cms.model.IOhTermModel;
import cerent.cms.model.LANAccessMode;
import cerent.cms.model.OhTermModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.SecurityModel;
import cerent.cms.ui.shelf.AbstractOscPane;
import cerent.cms.ui.shelf.AbstractTermPane;
import cerent.cms.ui.shelf.OscTermCreationDialog;
import cerent.cms.ui.shelf.SppOscPane;
import cerent.util.ComparisonUtil;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.PluralisationUtil;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class OscPane
extends AbstractOscPane {
    protected static final SDebug dbg = new SDebug((KDebug)SppOscPane.db, "OscPane");

    public OscPane(String string, AbstractTermConnectionModel abstractTermConnectionModel) {
        super(string, abstractTermConnectionModel, dbg);
    }

    public void enteringPage() {
        super.enteringPage();
        this.editPB.setVisible(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.createPB) {
            OscTermCreationDialog.instance(this).show();
        } else if (object == this.deletePB) {
            int n;
            int[] nArray = this.table.getSelectedRows();
            Object[] objectArray = new OhTermModel[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                n = nArray[i];
                if (n >= this.tableDataList.size()) continue;
                objectArray[i] = (OhTermModel)this.tableDataList.get(n);
            }
            if (objectArray.length > 0) {
                OSCTermConfirmDialog oSCTermConfirmDialog = new OSCTermConfirmDialog(objectArray);
                if (this.tableDataList.size() == objectArray.length) {
                    if (((SecurityModel)this.getUiModel().getNodeModel().getSecurityModel()).getLANAccess() == LANAccessMode.DCC_ONLY) {
                        oSCTermConfirmDialog.showWithLanWarning();
                    } else {
                        oSCTermConfirmDialog.show();
                    }
                } else {
                    oSCTermConfirmDialog.show();
                }
                if (oSCTermConfirmDialog.isOk()) {
                    n = 0;
                    for (int i = 0; i < objectArray.length; ++i) {
                        try {
                            Object object2 = objectArray[i];
                            PortModel portModel = (PortModel)((OhTermModel)object2).getOpticalPortModel();
                            this.localDelete((OhTermModel)object2);
                            this.connTableModel.deleteTermination((IOhTermModel)object2);
                            continue;
                        }
                        catch (Busy busy) {
                            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_OSC_TERMINATION);
                            n = 1;
                            continue;
                        }
                        catch (Exception exception) {
                            SDebug.printStackTrace((Throwable)exception);
                            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_DELETING_OSC_TERM);
                            n = 1;
                        }
                    }
                    if (n != 0) {
                        this.refresh();
                    }
                }
            } else {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_SELECT_OSC_TERM);
            }
        }
    }

    protected Comparator createComparator() {
        return new OscComparator();
    }

    protected void prepareColumns() {
        this.table.getColumn("Port").setCellRenderer(new OscPaneRenderer());
        this.table.getColumn("Service State").setCellRenderer(new OscPaneRenderer());
    }

    protected String getOhTermType() {
        return "OSC";
    }

    protected AbstractTermPane.OhTermTableModel createTableModel() {
        return new OscTermTableModel();
    }

    protected class OSCTermConfirmDialog {
        protected boolean ok = false;
        protected Object[] termsToDelete;

        public OSCTermConfirmDialog(Object[] objectArray) {
            this.termsToDelete = objectArray;
        }

        public boolean isOk() {
            return this.ok;
        }

        public void showWithLanWarning() {
            String string = "This node is provisioned to have no LAN Access.\nDeleting the last OSC may lead to loss of communication\nwith the Node. Continue?";
            if (CerentDialog.yesNoDialog((Component)((Object)OscPane.this), (String)string, (String)("Delete OSC " + PluralisationUtil.s("Termination", this.termsToDelete.length)))) {
                this.ok = true;
            }
        }

        public void show() {
            String string = "Really delete selected OSC " + PluralisationUtil.s("Termination", this.termsToDelete.length) + "?";
            if (CerentDialog.yesNoDialog((Component)((Object)OscPane.this), (String)string, (String)("Delete OSC " + PluralisationUtil.s("Termination", this.termsToDelete.length)))) {
                this.ok = true;
            }
        }
    }

    private static class OscComparator
    implements Comparator {
        private OscComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            return ComparisonUtil.compare(((IOhTermModel)object).getOpticalPortIndex(), ((IOhTermModel)object2).getOpticalPortIndex());
        }
    }

    private class OscPaneRenderer
    extends DefaultTableCellRenderer {
        private OscPaneRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            switch (n2) {
                case 0: {
                    PortModel portModel = (PortModel)object;
                    object = AbstractTermPane.entityCellRenderer.getString(portModel, "slot ");
                    break;
                }
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private class OscTermTableModel
    extends AbstractOscPane.GenericOscTableModel {
        public static final int SRV_STATE_INDEX = 1;
        public final String[] columnNames = new String[]{"Port", "Service State"};

        public OscTermTableModel() {
            super(OscPane.this);
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            if (OscPane.this.tableDataList != null && n < OscPane.this.tableDataList.size()) {
                OhTermModel ohTermModel = (OhTermModel)OscPane.this.tableDataList.get(n);
                PortModel portModel = null;
                try {
                    portModel = (PortModel)ohTermModel.getOpticalPortModel();
                }
                catch (NullPointerException nullPointerException) {
                    OscPane.this.db.fine("Null value in renderer");
                    return null;
                }
                switch (n2) {
                    case 0: {
                        return portModel;
                    }
                    case 1: {
                        return this.getServiceState(portModel);
                    }
                }
            }
            return null;
        }
    }
}

