/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Common.sRevertiveBehavior;
import cerent.cms.idl.SonetTopology.eDetectionGuardTimer;
import cerent.cms.idl.SonetTopology.eOnePlusOneType;
import cerent.cms.idl.SonetTopology.eRecoveryGuardTimer;
import cerent.cms.idl.SonetTopology.eVerifyGuardTimer;
import cerent.cms.idl.SonetTopology.sOnePlusOneProvision;
import cerent.cms.idl.SonetTopology.sYCableProvision;
import cerent.cms.model.Busy;
import cerent.cms.model.DropsExceedMax;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoMoreVtCapableSts;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.RevertiveBehavior;
import cerent.cms.model.RevertiveBehaviorFactory;
import cerent.cms.ui.RevertiveBehaviorPanel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.PgAttrsPane;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import org.omg.CORBA.BAD_PARAM;

public class PgCreatePane
extends PgAttrsPane {
    boolean failedApply = false;
    private static final SDebug db = new SDebug("PgCreatePane");

    public PgCreatePane(NodeModelDelegate nodeModelDelegate) {
        super("CreatePane", nodeModelDelegate, (TabbedView)null);
    }

    boolean failedApply() {
        return this.failedApply;
    }

    public void applyChangesToModel() throws AnnotatedException {
        IRevertiveBehavior iRevertiveBehavior = this.protType == 3 ? new RevertiveBehavior(1, ((RevertiveBehaviorPanel.ReversionTime)this.reversionTimer.getSelectedItem()).getTime()) : this.rbPanel.getRevertiveBehavior();
        sRevertiveBehavior sRevertiveBehavior2 = RevertiveBehaviorFactory.getRevertiveBehavior(iRevertiveBehavior);
        StringBuffer stringBuffer = new StringBuffer("Unable to create protection group:");
        ElementModelsDelegate elementModelsDelegate = this.nodeModel.getElementModelsDelegate();
        try {
            this.failedApply = true;
            switch (this.protType) {
                case 0: 
                case 1: {
                    this.doProvPgModel(sRevertiveBehavior2);
                    this.failedApply = false;
                    break;
                }
                case 2: 
                case 3: {
                    this.doCreate1Plus1(sRevertiveBehavior2, this.protType == 3);
                    this.failedApply = false;
                    break;
                }
                case 4: {
                    this.doCreateYCable(sRevertiveBehavior2);
                    this.failedApply = false;
                    break;
                }
                default: {
                    db.println("ERROR: Update switch statement in PgCreatePane.java");
                    break;
                }
            }
        }
        catch (BAD_PARAM bAD_PARAM) {
            stringBuffer.append("\nbad parameter, please try again.\n");
            throw new AnnotatedException(stringBuffer.toString(), (Exception)((Object)bAD_PARAM));
        }
        catch (ProvisionError provisionError) {
            switch (this.protType) {
                case 4: {
                    stringBuffer.append("\nThe working and protect cards must\n");
                    stringBuffer.append("1) not be part of a regeneration group (for TXP cards only).\n");
                    stringBuffer.append("2) have the same payload data type and termination mode.\n");
                    stringBuffer.append("3) have G.709 OTN enabled (for MXP_2.5_10G/E cards only).\n");
                    break;
                }
                default: {
                    stringBuffer.append("\ncheck if the ports are supporting UPSR circuits.\n");
                }
            }
            throw new AnnotatedException(stringBuffer.toString(), (Exception)((Object)provisionError));
        }
        catch (Busy busy) {
            Boolean bl = busy.usedAsClockSource();
            if (bl != null && bl.booleanValue()) {
                stringBuffer.append("\ncheck if any timing reference is used");
                stringBuffer.append("\non the same card where the protect port resides.\n");
            } else {
                stringBuffer.append("\ncheck if the protect port is supporting ");
                stringBuffer.append("circuits,\na timing reference, Sonet DCC, orderwire, or a test access point.\n");
            }
            throw new AnnotatedException(stringBuffer.toString(), (Exception)((Object)busy));
        }
        catch (NoMoreVtCapableSts noMoreVtCapableSts) {
            stringBuffer.append("\nthe working port is supporting VT circuits,");
            stringBuffer.append("\nbut the VT cross-connect has no more capacity");
            stringBuffer.append("\nto add the protect port.\n");
            throw new AnnotatedException(stringBuffer.toString(), (Exception)((Object)noMoreVtCapableSts));
        }
        catch (DropsExceedMax dropsExceedMax) {
            stringBuffer.append("\nthe number of allowed drops will be exceeded.\n");
            throw new AnnotatedException(stringBuffer.toString(), (Exception)((Object)dropsExceedMax));
        }
    }

    public void dispose() {
        this.uiModel = null;
        this.nodeModel = null;
        this.entityTableModel = null;
    }

    private void doProvPgModel(sRevertiveBehavior sRevertiveBehavior2) throws AnnotatedException {
        Object[] objectArray = new ModuleModel[this.mainListModel.getSize()];
        this.mainListModel.copyInto(objectArray);
        StringBuffer stringBuffer = new StringBuffer("Unable to create protection group:");
        try {
            this.nodeModel.getEntityTableModel().provisionProtectionGroupModel(this.nameTF.getText(), this.getProtectionType(), sRevertiveBehavior2.reversionMode, sRevertiveBehavior2.reversionTime, (ModuleModel)this.protectCB.getSelectedItem(), (IModuleModel[])objectArray);
        }
        catch (ProvisionError provisionError) {
            stringBuffer.append("\nprovisioning error, please try again.\n");
            throw new AnnotatedException(stringBuffer.toString(), (Exception)((Object)provisionError));
        }
        catch (ResourceInUse resourceInUse) {
            stringBuffer.append("\ncheck if the protect card is supporting circuits or a test access point.\n");
            throw new AnnotatedException(stringBuffer.toString(), (Exception)((Object)resourceInUse));
        }
    }

    private void doCreate1Plus1(sRevertiveBehavior sRevertiveBehavior2, boolean bl) throws Busy, ProvisionError, NoMoreVtCapableSts, DropsExceedMax {
        eDetectionGuardTimer eDetectionGuardTimer2;
        eRecoveryGuardTimer eRecoveryGuardTimer2;
        eVerifyGuardTimer eVerifyGuardTimer2;
        boolean bl2;
        eOnePlusOneType eOnePlusOneType2;
        EntityModel entityModel = (EntityModel)this.mainList.getModel().getElementAt(0);
        EntityModel entityModel2 = (EntityModel)this.protectCB.getSelectedItem();
        if (bl) {
            eOnePlusOneType2 = eOnePlusOneType.ONEPLUSONE_OPTIMIZED;
            bl2 = true;
            eVerifyGuardTimer2 = eVerifyGuardTimer.from_int(this.vgTimer.getSelectedIndex());
            eRecoveryGuardTimer2 = eRecoveryGuardTimer.from_int(this.rgTimer.getSelectedIndex());
            eDetectionGuardTimer2 = eDetectionGuardTimer.from_int(this.dgTimer.getSelectedIndex());
        } else {
            eOnePlusOneType2 = eOnePlusOneType.ONEPLUSONE_STANDARD;
            bl2 = this.bidirCB.isSelected();
            eVerifyGuardTimer2 = eVerifyGuardTimer.from_int(0);
            eRecoveryGuardTimer2 = eRecoveryGuardTimer.from_int(0);
            eDetectionGuardTimer2 = eDetectionGuardTimer.from_int(0);
        }
        this.nodeModel.getElementModelsDelegate().createOnePlusOne(new sOnePlusOneProvision(entityModel.getEntityIndex(), entityModel2.getEntityIndex(), sRevertiveBehavior2, bl2, eOnePlusOneType2, eVerifyGuardTimer2, eRecoveryGuardTimer2, eDetectionGuardTimer2), this.nameTF.getText());
    }

    private void doCreateYCable(sRevertiveBehavior sRevertiveBehavior2) throws Busy, NoMoreVtCapableSts, ProvisionError, DropsExceedMax {
        EntityModel entityModel = (EntityModel)this.mainList.getModel().getElementAt(0);
        EntityModel entityModel2 = (EntityModel)this.protectCB.getSelectedItem();
        this.nodeModel.getElementModelsDelegate().createYCable(new sYCableProvision(entityModel.getEntityIndex(), entityModel2.getEntityIndex(), sRevertiveBehavior2, this.bidirCB.isSelected()), this.nameTF.getText());
    }
}

