/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.shelf.PgCreatePane;
import cerent.cms.ui.shelf.SppProtectionPane;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PgCreationDialog
extends UDialog
implements ActionListener {
    private static final SDebug db = new SDebug("PgCreationDialog");
    public static final String TITLE = "Create Protection Group";
    private JButton okButton;
    private JButton cancelButton;
    private NodeModelDelegate node;
    PgCreatePane createPane;

    public static PgCreationDialog instance(SppProtectionPane sppProtectionPane) {
        Frame frame = JOptionPane.getFrameForComponent((Component)((Object)sppProtectionPane));
        IModel iModel = sppProtectionPane.getUiModel();
        PgCreationDialog pgCreationDialog = new PgCreationDialog(frame, TITLE, iModel);
        pgCreationDialog.node = (NodeModelDelegate)sppProtectionPane.getUiModel();
        return pgCreationDialog;
    }

    private PgCreationDialog(Frame frame, String string, Object object) {
        super(frame, string, true, object);
        this.setSize(new Dimension(575, 350));
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.node = (NodeModelDelegate)object;
        jPanel.add((Component)this.getCreatePanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public void dispose() {
        this.node = null;
        this.createPane.dispose();
        this.createPane = null;
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                this.apply();
                if (!this.createPane.failedApply()) {
                    this.dispose();
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_PROT_GROUP_CREATE, exception.getMessage());
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    private void apply() throws Exception {
        this.createPane.validateFields();
        if (this.createPane.protType < 2 && !CerentDialog.yesNoDialog((Component)((Object)this), (String)"Protect card will be reset to defaults.\nPort settings will be reset and loopbacks\nwill be removed.\nAre you sure you want to continue?", (String)"Confirm Provisioning Change")) {
            throw new Exception("User did not confirm provisioning change.");
        }
        this.createPane.apply();
    }

    private JPanel getCreatePanel() {
        this.createPane = new PgCreatePane(this.node);
        return this.createPane;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        jPanel.add(new CSHelpButton(CSHelpConst.PgCreationDialog));
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }
}

