/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IIpAddr;
import cerent.cms.model.ILanRipConfig;
import cerent.cms.model.ILanRipConfigModel;
import cerent.cms.model.IRipAddressSummary;
import cerent.cms.model.IRipAddressSummaryModel;
import cerent.cms.model.LanRipConfigModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.RipAddressSummary;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AuthEditDialog;
import cerent.cms.ui.shelf.AuthKeyDialog;
import cerent.cms.ui.shelf.RipAddressSummaryPane;
import cerent.util.Debug;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.TextPanel;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class RipPane
extends NodeProvPane
implements ActionListener,
DocumentListener {
    private static final Debug db = new Debug("RipPane");
    JComboBox ripVersionCB;
    JButton authButton;
    JCheckBox adminCB;
    JTextField ripMetricTF;
    TabbedView parent;
    NodeModelDelegate nodeModel;
    ILanRipConfigModel ripConfigModel;
    protected int authTypeInt;
    protected String authKeyStr;
    protected int lastOkRipVersion;
    boolean adminDirty;
    boolean ripVersionDirty;
    boolean authTypeDirty;
    boolean authStringDirty;
    boolean ripMetricDirty;
    public static String[] ripChoices = new String[]{"RIP Version 1", "RIP Version 2"};
    public static String NO_AUTHENTICATION = "No Authentication";
    public static String SIMPLE_PASS = "Simple Password";
    public static String[] authChoices = new String[]{NO_AUTHENTICATION, SIMPLE_PASS};
    private static String adminString = "ADMIN";
    private static String authTypeString = "AUTHTYPE";
    private static String ripVersionString = "RIP_VERSION";
    RipAddressSummaryPane rasPane;

    public RipPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.parent = tabbedView;
    }

    private void init() {
        this.nodeModel = (NodeModelDelegate)this.getUiModel();
        boolean bl = true;
        if (this.nodeModel != null && this.nodeModel.getPlatform().isSecureModeSupported() && this.nodeModel.isSecureMode()) {
            bl = this.isUserAuthorized(SecurityLevel.SUPERUSER);
        }
        this.ripConfigModel = this.nodeModel.getLanRipConfigModel();
        ((LanRipConfigModel)this.ripConfigModel).addObserver((Observer)((Object)this));
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        this.add((Component)uScrollPane);
        JPanel jPanel2 = RipPane.createHorizontalPanel(null);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        this.adminCB = new JCheckBox("RIP Active");
        this.adminCB.setActionCommand(adminString);
        this.adminCB.addActionListener(this);
        this.ripVersionCB = new JComboBox<String>(ripChoices);
        this.ripVersionCB.setActionCommand(ripVersionString);
        this.ripVersionCB.addActionListener(this);
        this.authButton = new JButton();
        this.authButton.setActionCommand(authTypeString);
        this.authButton.addActionListener(this);
        JPanel jPanel3 = RipPane.createVerticalPanel(null);
        JPanel jPanel4 = RipPane.createHorizontalPanel(null);
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        jPanel4.add(Box.createHorizontalStrut(5));
        jPanel4.add(this.adminCB);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add(new JLabel("RIP Type: "));
        jPanel4.add(this.ripVersionCB);
        jPanel4.add(new JLabel("            "));
        this.ripMetricTF = this.getTextField(jPanel4, " Metric: ", 4, null, null);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add(Box.createHorizontalStrut(5));
        jPanel3.add(jPanel4);
        JPanel jPanel5 = RipPane.createHorizontalPanel("Authentication");
        jPanel5.add(Box.createHorizontalStrut(5));
        jPanel5.add(new JLabel("Authentication Type: "));
        jPanel5.add(this.authButton);
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add(Box.createHorizontalStrut(5));
        jPanel3.add(jPanel5);
        jPanel.add(jPanel3);
        jPanel.add(Box.createVerticalStrut(5));
        if (bl) {
            JPanel jPanel6 = RipPane.createHorizontalPanel("RIP Address Summary");
            jPanel6.setPreferredSize(new Dimension(300, 150));
            this.rasPane = new RipAddressSummaryPane("", this.parent);
            jPanel6.add((Component)((Object)this.rasPane));
            this.table = this.rasPane.getTable();
            jPanel.add(jPanel6);
        }
        jPanel.add(new JPanel(new BorderLayout()));
        this.enableComponent(this.adminCB);
        this.enableComponent(this.ripVersionCB);
        this.enableComponent(this.ripMetricTF);
        this.enableComponent(this.authButton);
        this.registerWithModel();
    }

    private JTextField getTextField(JPanel jPanel, String string, int n, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        TextPanel textPanel = new TextPanel(string, n);
        JTextField jTextField = textPanel.getTextField();
        if (gridBagLayout != null && gridBagConstraints != null) {
            gridBagLayout.setConstraints(textPanel, gridBagConstraints);
        }
        jPanel.add(textPanel);
        if (this.isUserAuthorized()) {
            jTextField.getDocument().addDocumentListener(this);
        } else {
            jTextField.setEditable(false);
        }
        return jTextField;
    }

    protected IRipAddressSummary createSummaryRoute() {
        try {
            IRipAddressSummaryModel iRipAddressSummaryModel = this.nodeModel.getRipAddressSummaryModel();
            IRipAddressSummary[] iRipAddressSummaryArray = iRipAddressSummaryModel.getRipAddressSummaryTable();
            if (iRipAddressSummaryArray.length <= 0) {
                RipAddressSummary ripAddressSummary = new RipAddressSummary();
                short s = this.nodeModel.getIpConfig().getNetMaskPrefixLength();
                int n = InetUtil.makeNetMask(s);
                int n2 = InetUtil.makeIpV4(this.nodeModel.getIpConfig().getIpAddress());
                int n3 = n2 & n;
                IIpAddr iIpAddr = InetUtil.makeIpAddr(n3);
                short s2 = 1;
                ripAddressSummary.setSummaryAddress(iIpAddr);
                ripAddressSummary.setMaskLength(s);
                ripAddressSummary.setCost(s2);
                iRipAddressSummaryModel.setRipAddressSummary((IRipAddressSummary)ripAddressSummary);
                CerentDialog.infoDialog((Component)((Object)this), (String)("Created a default RIP Address Summary of " + InetUtil.makeDottedString(iIpAddr) + "."), (String)"Created Default RIP Address Summary");
                return ripAddressSummary;
            }
            db.println("Did not add default summary, because " + iRipAddressSummaryArray.length + " entries already exist.");
        }
        catch (Exception exception) {
            db.println("Failed to create default summary address:");
            Debug.printStackTrace((Throwable)exception);
        }
        return null;
    }

    public void applyChangesToModel() throws Exception {
        int n;
        ILanRipConfig iLanRipConfig = this.ripConfigModel.getLanRipConfig();
        boolean bl = false;
        if (this.adminDirty) {
            iLanRipConfig.setIfAdminStat(this.adminCB.isSelected());
            bl = true;
        }
        if (this.ripMetricDirty) {
            n = Integer.parseInt(this.ripMetricTF.getText());
            iLanRipConfig.setDefaultMetric((short)n);
            bl = true;
        }
        if (this.authTypeDirty) {
            iLanRipConfig.setAuthType(this.authTypeInt);
            bl = true;
        }
        if (this.authStringDirty) {
            iLanRipConfig.setAuthKey(this.authKeyStr);
            bl = true;
        }
        if (this.ripVersionDirty) {
            n = this.ripVersionCB.getSelectedIndex();
            iLanRipConfig.setRipVersionType(n);
            if (n == 0) {
                iLanRipConfig.setAuthType(0);
                iLanRipConfig.setAuthKey("");
            }
            bl = true;
        }
        if (bl) {
            IRipAddressSummary iRipAddressSummary;
            try {
                this.ripConfigModel.setLanRipConfig(iLanRipConfig);
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_RIP_OSPF_ACTIVE_ON_LAN, (Object)exception.getMessage());
                return;
            }
            if (this.adminDirty && this.adminCB.isSelected() && (iRipAddressSummary = this.createSummaryRoute()) != null) {
                this.nodeModel.getRipAddressSummaryModel().setRipAddressSummary(iRipAddressSummary);
            }
        }
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshFromModel()");
        }
        ILanRipConfig iLanRipConfig = this.ripConfigModel.getLanRipConfig();
        if (this.nodeModel.isSecureMode()) {
            this.adminCB.setSelected(false);
            this.adminCB.setEnabled(false);
        } else {
            this.adminCB.setSelected(iLanRipConfig.getIfAdminStat());
            this.enableComponent(this.adminCB);
        }
        this.lastOkRipVersion = iLanRipConfig.getRipVersionType();
        this.ripVersionCB.removeActionListener(this);
        this.ripVersionCB.setSelectedIndex(this.lastOkRipVersion);
        this.ripVersionCB.addActionListener(this);
        this.enableVersion(this.adminCB);
        this.authTypeInt = iLanRipConfig.getAuthType();
        this.authButton.setText(authChoices[this.authTypeInt]);
        this.authKeyStr = iLanRipConfig.getAuthKey();
        this.ripMetricTF.setText(String.valueOf(iLanRipConfig.getDefaultMetric()));
        this.ripMetricDirty = false;
        this.authStringDirty = false;
        this.authTypeDirty = false;
        this.ripVersionDirty = false;
        this.adminDirty = false;
        this.disableRas(!this.adminCB.isSelected());
        this.enableMetric(this.adminCB.isSelected());
    }

    public boolean onValidate() {
        if (this.ripMetricDirty) {
            try {
                int n = Integer.parseInt(this.ripMetricTF.getText());
                if (n < 1 || n > 15) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_RIP_METRIC_RANGE);
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_RIP_METRIC_INVALID);
                return false;
            }
        }
        return true;
    }

    protected boolean authCheckSucceeded() {
        boolean bl;
        block8: {
            bl = false;
            if (this.isUserAuthorized(SecurityLevel.SUPERUSER)) {
                return true;
            }
            try {
                if (this.authTypeInt == 0) {
                    return true;
                }
                if (this.authKeyStr.equals("")) {
                    return true;
                }
                JPasswordField jPasswordField = new JPasswordField();
                Object[] objectArray = new Object[]{"Enter Existing Authentication Key:", jPasswordField};
                String string = "OK";
                String string2 = "Cancel";
                Object[] objectArray2 = new Object[]{string, string2};
                JOptionPane jOptionPane = new JOptionPane(objectArray, -1, 0, null, objectArray2, objectArray2[0]);
                ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
                arrayList.add(jOptionPane);
                arrayList.add(jPasswordField);
                AuthKeyDialog authKeyDialog = AuthKeyDialog.instance((Component)((Object)this), true, "Authentication Key Entry", arrayList);
                try {
                    authKeyDialog.show();
                    if (!jOptionPane.getValue().equals(string)) break block8;
                    String string3 = new String(jPasswordField.getPassword());
                    if (string3.equals(this.authKeyStr)) {
                        bl = true;
                        break block8;
                    }
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_AUTH_KEY_MISMATCH);
                }
                catch (Exception exception) {
                    Debug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_AUTH_ERROR);
                }
            }
            catch (Exception exception) {
                Debug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_AUTH_ERROR);
            }
        }
        return bl;
    }

    private void disableRas(boolean bl) {
        if (this.rasPane != null) {
            this.rasPane.disableAllButtons(bl);
        }
    }

    private void enableMetric(boolean bl) {
        if (!bl) {
            this.ripMetricTF.setEnabled(false);
        } else {
            this.enableComponent(this.ripMetricTF);
        }
    }

    private void enableVersion(JCheckBox jCheckBox) {
        if (jCheckBox.isSelected()) {
            this.ripVersionCB.setEnabled(false);
        } else {
            this.ripVersionCB.setEnabled(this.isUserAuthorized());
        }
        this.authButton.setEnabled(this.ripVersionCB.getSelectedIndex() == 1 && this.isUserAuthorized());
    }

    protected void documentModified(DocumentEvent documentEvent) {
        this.setDirty();
        Document document = documentEvent.getDocument();
        if (document == this.ripMetricTF.getDocument()) {
            this.ripMetricDirty = true;
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(adminString)) {
            this.setDirty();
            this.adminDirty = true;
            this.disableRas(!this.adminCB.isSelected());
            this.enableMetric(this.adminCB.isSelected());
            if (this.ripMetricTF.isEnabled()) {
                this.ripMetricTF.setText("8");
            }
        } else if (string.equals(ripVersionString)) {
            if (this.authCheckSucceeded()) {
                this.setDirty();
                this.ripVersionDirty = true;
                this.lastOkRipVersion = this.ripVersionCB.getSelectedIndex();
                if (this.lastOkRipVersion == 0) {
                    this.authTypeInt = 0;
                    this.authKeyStr = "";
                    this.authStringDirty = true;
                    this.authTypeDirty = true;
                    this.authButton.setText(authChoices[this.authTypeInt]);
                    this.authButton.setEnabled(false);
                } else {
                    this.authButton.setEnabled(this.isUserAuthorized());
                }
            } else {
                this.ripVersionCB.setSelectedIndex(this.lastOkRipVersion);
            }
        } else if (string.equals(authTypeString)) {
            if (this.authCheckSucceeded()) {
                try {
                    final JPasswordField jPasswordField = new JPasswordField();
                    final JPasswordField jPasswordField2 = new JPasswordField();
                    final JComboBox<String> jComboBox = new JComboBox<String>(authChoices);
                    jComboBox.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            boolean bl;
                            boolean bl2 = bl = jComboBox.getSelectedIndex() == 0;
                            if (bl) {
                                jPasswordField.setText("");
                                jPasswordField2.setText("");
                            }
                            jPasswordField.setEnabled(!bl);
                            jPasswordField2.setEnabled(!bl);
                        }
                    });
                    jComboBox.setSelectedIndex(this.authTypeInt);
                    jPasswordField.setText("");
                    Object[] objectArray = new Object[]{"Authentication Type", jComboBox, "Enter Authentication Key", jPasswordField, "Confirm Authentication Key", jPasswordField2};
                    String string2 = "OK";
                    String string3 = "Cancel";
                    Object[] objectArray2 = new Object[]{string2, string3};
                    JOptionPane jOptionPane = new JOptionPane(objectArray, -1, 0, null, objectArray2, objectArray2[0]);
                    ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
                    arrayList.add(jOptionPane);
                    arrayList.add(jPasswordField);
                    arrayList.add(jPasswordField2);
                    arrayList.add(jComboBox);
                    AuthEditDialog authEditDialog = AuthEditDialog.instance((Component)((Object)this), true, "Edit Authentication Key", arrayList);
                    authEditDialog.setMaxDocLength(16);
                    try {
                        authEditDialog.show();
                        if (jOptionPane.getValue().equals(string2)) {
                            this.authTypeInt = jComboBox.getSelectedIndex();
                            this.authKeyStr = String.valueOf(jPasswordField.getPassword());
                            this.authButton.setText(authChoices[this.authTypeInt]);
                            this.setDirty();
                            this.authTypeDirty = true;
                            this.authStringDirty = true;
                        }
                    }
                    catch (Exception exception) {
                        Debug.printStackTrace((Throwable)exception);
                    }
                }
                catch (Exception exception) {
                    db.println("auth check succeeded, but setting failed.");
                    Debug.printStackTrace((Throwable)exception);
                }
            } else {
                db.println("Authentication failed.");
            }
        }
    }

    public void destroy() {
        if (this.ripConfigModel != null) {
            ((LanRipConfigModel)this.ripConfigModel).deleteObserver((Observer)((Object)this));
        }
        if (this.rasPane != null) {
            this.rasPane.destroy();
            this.rasPane = null;
        }
        super.destroy();
        this.nodeModel = null;
    }

    public void enteringPage() throws Exception {
        if (this.ripVersionCB == null) {
            this.init();
        }
        if (this.rasPane != null) {
            this.rasPane.enteringPage();
        }
        super.enteringPage();
    }

    public void leavingPage() throws Exception {
        if (this.rasPane != null) {
            this.rasPane.leavingPage();
        }
        super.leavingPage();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.RipPane;
    }
}

