/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.model.ElAttributeMaps;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IAlarmModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IStringTag;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PluggableModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractProvTableModel;
import cerent.util.AnnotatedException;
import cerent.util.BlockingModeController;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.List;
import java.util.Observable;

public class ShelfProvAlarmsTableModel
extends AbstractProvTableModel
implements BlockingModeController {
    static final int CARDNUMBER_INDEX = 0;
    static final int CARDTYPE_INDEX = 1;
    static final int PROFILE_INDEX = 2;
    static final int SUPPRESS_INDEX = 3;
    private static final int NEEDS_REFRESH = 1;
    private static final int NEEDS_RESET = 2;
    private static SDebug db = new SDebug("ShelfProvAlarmsTableModel");
    String[] availableProfileNames;
    protected INodeModel nodeModel;
    protected IAlarmModel alarmModel;
    protected IEntityModel chassisModel;
    protected List entities;
    protected int[] portsOverridden;
    protected String[] profileNames;
    protected String shelfProfileName;
    protected Boolean[] suppressFlags;
    protected Boolean shelfSuppressFlag;
    protected String[] modulePositions;
    protected boolean shelfProfileDirty;
    int numProvObjects;
    protected IPlatform pci;
    static /* synthetic */ Class class$java$lang$Boolean;

    ShelfProvAlarmsTableModel(boolean bl, INodeModel iNodeModel) {
        super(new PluggableModel[0], true, "");
        if (db.on()) {
            db.println("<init>");
        }
        this.shelfProfileDirty = false;
        this.columnNames = new String[]{"Location", "Eqpt Type", "Profile", "Suppress Alarms"};
        this.nodeModel = iNodeModel;
        this.alarmModel = iNodeModel.getAlarmModel();
        this.chassisModel = iNodeModel.getChassis();
        this.pci = ((NodeModelDelegate)iNodeModel).getPlatform();
    }

    protected void init() {
        this.refreshFromNode();
        this.observableManager.setBlockingModeController((BlockingModeController)this);
    }

    public void refreshFromNode() {
        int n;
        if (ShelfProvAlarmsTableModel.db.on) {
            db.println("Refresh from Node...");
        }
        this.getProfiles();
        this.observableManager.setObservable(null);
        this.observableManager.addObservable((Observable)this.alarmModel);
        this.observableManager.addObservable((Observable)this.nodeModel);
        this.observableManager.addObservable((Observable)this.chassisModel);
        List list = null;
        if (this.nodeModel != null) {
            this.entities = this.chassisModel.getDescendantsOfClassType(6);
            this.entities.addAll(this.chassisModel.getDescendantsOfClassType(1));
            if (this.pci.isFanTrayAlarmable()) {
                this.entities.addAll(this.chassisModel.getDescendantsOfClassType(4));
            }
            list = this.chassisModel.getDescendantsOfClassType(2);
        }
        this.numProvObjects = 0;
        if (this.entities == null || this.entities.size() == 0) {
            if (db.on()) {
                db.println("cannot get mfgd entities!");
            }
        } else {
            for (n = 0; n < this.entities.size(); ++n) {
                if (db.on()) {
                    db.println(n + "... " + this.entities.get(n) + "... " + this.entities.get(n).getClass());
                }
                ++this.numProvObjects;
                this.observableManager.addObservable((Observable)((Object)((Model)this.entities.get(n))));
                if (!(this.entities.get(n) instanceof PluggableModel)) continue;
                List list2 = ((MfgEntityModel)this.entities.get(n)).getDescendantsOfClassType(6);
                list2.addAll(((MfgEntityModel)this.entities.get(n)).getDescendantsOfClassType(7));
                Object[] objectArray = list2.toArray();
                if (objectArray == null || objectArray.length <= 0) continue;
                for (int i = 0; i < objectArray.length; ++i) {
                    this.observableManager.addObservable((Observable)((Object)((EntityModel)objectArray[i])));
                }
            }
        }
        if (list == null || list.size() == 0) {
            if (db.on()) {
                db.println("cannot get slots!");
            }
        } else {
            for (n = 0; n < list.size(); ++n) {
                this.observableManager.addObservable((Observable[])list.toArray(new Model[list.size()]));
            }
        }
        this.profileNames = new String[this.numProvObjects];
        this.suppressFlags = new Boolean[this.numProvObjects];
        this.numLines = this.entities.size();
        this.rowDirty = new boolean[this.numLines];
        this.portsOverridden = new int[this.numProvObjects];
        this.updateOverridingChildren(false);
        this.modulePositions = new String[this.numProvObjects];
        for (n = 0; n < this.numProvObjects; ++n) {
            this.modulePositions[n] = ((MfgEntityModel)this.entities.get(n)).getLocation();
        }
    }

    protected String getEqTypeStringFor(int n) {
        MfgEntityModel mfgEntityModel = (MfgEntityModel)this.entities.get(n);
        TDMTerminology tDMTerminology = mfgEntityModel.getNodeModel().getTDMTerminology();
        return EntityModel.eqType2Name(tDMTerminology, mfgEntityModel.getEqType());
    }

    public String[] getProfileNames() {
        return this.availableProfileNames;
    }

    public String getShelfProfileName() {
        return this.shelfProfileName;
    }

    public Boolean getShelfSuppressFlag() {
        return this.shelfSuppressFlag;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 3: {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = ShelfProvAlarmsTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        }
        return super.getColumnClass(n);
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            switch (n2) {
                case 2: {
                    String string = (String)object;
                    if (this.profileNames[n].equals(string)) {
                        return;
                    }
                    this.profileNames[n] = string;
                    break;
                }
                case 3: {
                    Boolean bl = (Boolean)object;
                    if (this.suppressFlags[n].equals(bl)) {
                        return;
                    }
                    this.suppressFlags[n] = bl;
                    break;
                }
                default: {
                    return;
                }
            }
            this.rowDirty[n] = true;
            this.fireTableCellUpdated(n, n2);
        }
        catch (ClassCastException classCastException) {
            SDebug.printStackTrace((Throwable)classCastException);
        }
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.numLines > 0) {
            try {
                MfgEntityModel mfgEntityModel = (MfgEntityModel)this.entities.get(n);
                if (AbstractPane.isUserAuthorized((EntityModel)this.entities.get(n), SecurityLevel.PROVISIONING) && (n2 == 2 || n2 == 3)) {
                    return true;
                }
            }
            catch (Exception exception) {
                db.finer("Exception in isCellEditable() " + exception);
            }
        }
        return false;
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                if (this.modulePositions[n].equals("Chassis")) {
                    return "Backplane";
                }
                return this.modulePositions[n];
            }
            case 1: {
                String string = this.getEqTypeStringFor(n);
                if (this.pci.is600()) {
                    if (string.startsWith("BACKPLANE_")) {
                        return "All Non-card Objects";
                    }
                    return string;
                }
                if (this.modulePositions[n].equals("Chassis")) {
                    return "All non-card objects";
                }
                return string;
            }
            case 2: {
                return this.getAlarmProfileName(n);
            }
            case 3: {
                return this.getSuppressAlarm(n);
            }
        }
        return "ERROR: INDEX OF " + n2;
    }

    public int getNumOverriddenPorts(int n) {
        if (n > -1 && n < this.getRowCount()) {
            return this.portsOverridden[n];
        }
        return -1;
    }

    public void refreshFromModel(int n) throws Exception {
        if (n == -1 || n == 2) {
            if (db.on()) {
                db.println("refresh from model, mode " + n);
            }
            this.refreshFromNode();
        }
        this.refreshFromModel();
    }

    public void refreshFromModel() {
        if (db.on()) {
            db.println("refreshFromModel");
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.profileNames[i] = null;
            this.suppressFlags[i] = null;
            this.rowDirty[i] = false;
        }
        this.shelfProfileDirty = false;
        this.shelfProfileName = this.chassisModel.getAlarmProfileName();
        this.shelfSuppressFlag = new Boolean(this.chassisModel.getSuppressAlarms());
        this.fireTableDataChanged();
    }

    public void applyToModel() throws Exception {
        if (db.on()) {
            db.println("applyToModel");
        }
        int n = 0;
        this.observableManager.setPassing(false);
        try {
            for (n = 0; n < this.numLines; ++n) {
                if (!this.rowDirty[n]) continue;
                ((MfgEntityModel)this.entities.get(n)).setAlarmProfileName(this.getAlarmProfileName(n));
                ((MfgEntityModel)this.entities.get(n)).setSuppressAlarms(this.getSuppressAlarm(n));
                this.rowDirty[n] = false;
            }
            if (this.shelfProfileDirty) {
                this.chassisModel.setAlarmProfileName(this.shelfProfileName);
                this.chassisModel.setSuppressAlarms(this.shelfSuppressFlag.booleanValue());
                this.shelfProfileDirty = false;
            }
        }
        catch (Exception exception) {
            this.observableManager.setPassing(true);
            throw new AnnotatedException("Error applying changes to row " + (n + 1), exception);
        }
        this.observableManager.setPassing(true);
    }

    public boolean isDirty() {
        boolean bl = false;
        for (int i = 0; i < this.rowDirty.length; ++i) {
            if (!this.rowDirty[i] && !this.shelfProfileDirty) continue;
            bl = true;
            break;
        }
        if (db.on()) {
            db.println("isDirty( ) -> " + bl);
        }
        return bl;
    }

    public void triggerShelfProfileChanged(Object object) {
        if (db.on()) {
            db.println("triggerShelfProfileChanged( " + this.shelfProfileName + " )");
        }
        this.shelfProfileName = (String)object;
        this.shelfProfileDirty = true;
        this.fireTableDataChanged();
    }

    public void triggerSuppressChanged(Boolean bl) {
        if (db.on()) {
            db.println("triggerSuppressChanged( " + bl + " )");
        }
        this.shelfSuppressFlag = bl;
        this.shelfProfileDirty = true;
        this.fireTableDataChanged();
    }

    public void updateOverridingChildren(boolean bl) {
        for (int i = 0; i < this.entities.size(); ++i) {
            List list;
            Object[] objectArray;
            int n = 0;
            if (this.entities.get(i) instanceof PluggableModel && (objectArray = (list = ((MfgEntityModel)this.entities.get(i)).getDescendantsOfClassType(7)).toArray()) != null && objectArray.length > 0) {
                for (int j = 0; j < objectArray.length; ++j) {
                    String string = ((EntityModel)objectArray[j]).getAlarmProfileName();
                    if (string.equals("None") || string.equals("Inherited")) continue;
                    ++n;
                }
            }
            if (this.portsOverridden[i] == n) continue;
            this.portsOverridden[i] = n;
            if (!bl) continue;
            this.fireTableCellUpdated(i, 2);
        }
    }

    protected void getProfiles() {
        IStringTag[] iStringTagArray = this.alarmModel.getAlarmProfileList();
        this.availableProfileNames = new String[iStringTagArray.length];
        for (int i = 0; i < iStringTagArray.length; ++i) {
            this.availableProfileNames[i] = iStringTagArray[i].getFirst();
        }
    }

    public ElAttributeMaps getAttributeMap() {
        TDMTerminology tDMTerminology = this.nodeModel.getTDMTerminology();
        int n = this.nodeModel.getFramingType();
        return ElementDefaults.getAttributeMap(n, tDMTerminology);
    }

    public void update(Observable observable, Object object) {
        int n;
        if (db.on()) {
            db.println("XXXX Intercept a model change in ShelfProvAlarms!" + object);
            db.println("Source is " + observable + " (" + observable.getClass() + ")");
        }
        if ((n = this.entities.indexOf(observable)) != -1 && object != ModelUpdateType.DELETED && (observable instanceof PortModel || observable instanceof PluggableModel)) {
            if (db.on()) {
                db.println("(Portmodel/PluggableModel change...)");
            }
            this.updateOverridingChildren(true);
            return;
        }
        if (n == -1 || object == ModelUpdateType.DELETED || object == ModelUpdateType.ADDED) {
            this.refreshFromNode();
        }
        this.refreshFromModel();
        super.update(observable, object);
    }

    public void disposeDataSource() {
        if (this.entities != null) {
            this.entities.clear();
        }
        super.disposeDataSource();
    }

    public int processBlockedEvent(Observable observable, Object object, int n) {
        int n2;
        if (ShelfProvAlarmsTableModel.db.on) {
            db.println("processBlockedEvent: src " + observable + ", event = " + object + ", previousState = " + n);
        }
        if ((n2 = this.entities.indexOf(observable)) == -1 || object == ModelUpdateType.DELETED) {
            return 2;
        }
        if (n == 0) {
            return 1;
        }
        return n;
    }

    private String getAlarmProfileName(int n) {
        if (this.profileNames[n] == null) {
            String string = ((MfgEntityModel)this.entities.get(n)).getAlarmProfileName();
            if (string == null) {
                string = "";
            }
            this.profileNames[n] = string;
        }
        return this.profileNames[n];
    }

    private Boolean getSuppressAlarm(int n) {
        if (this.suppressFlags[n] == null) {
            this.suppressFlags[n] = new Boolean(((MfgEntityModel)this.entities.get(n)).getSuppressAlarms());
        }
        return this.suppressFlags[n];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

