/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.model.event.ElementEventStore;
import cerent.cms.ui.IGuestPaneFactory;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.MainTabbedView;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.event.NodeAlarmPane;
import cerent.cms.ui.event.NodeConditionsPane;
import cerent.cms.ui.event.NodeHistoryPane;
import cerent.cms.ui.shelf.ShelfInventoryPane;
import cerent.util.EID;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.Observable;

public class ShelfTabbedView
extends MainTabbedView
implements ITabName {
    private ElementAlarmStore alarmStore;
    private ElementEventStore eventStore;
    private IEventPanelController myController;
    private IGuestPaneFactory gpf;
    protected static final SDebug db = new SDebug("ShelfTabbedView");
    private IPlatform pci;

    public Pane getAlarmTab() {
        return new NodeAlarmPane("Alarms", (NodeModelDelegate)this.uiModel, (TabbedView)this, this.alarmStore, this.myController);
    }

    public Pane getEventTab() {
        return new NodeHistoryPane("History", this, this.eventStore, this.myController);
    }

    public Pane getCircuitTab() {
        return (Pane)this.gpf.getGuestPane(1, (TabbedView)this);
    }

    public ShelfTabbedView(NodeModelDelegate nodeModelDelegate, IEventPanelController iEventPanelController, IGuestPaneFactory iGuestPaneFactory) throws NullPointerException {
        super(nodeModelDelegate);
        this.alarmStore = (ElementAlarmStore)nodeModelDelegate.getElementAlarmStore();
        this.eventStore = (ElementEventStore)nodeModelDelegate.getElementEventStore();
        this.myController = iEventPanelController;
        this.gpf = iGuestPaneFactory;
        this.pci = nodeModelDelegate.getPlatform();
        if (nodeModelDelegate == null) {
            throw new NullPointerException("ShelfTabbedView: model must be non-null");
        }
        this.addTab("Alarms", (Component)this.getAlarmTab());
        this.addTab("Conditions", (Component)this.getConditionsTab());
        this.addTab("History", (Component)this.getEventTab());
        this.addTab("Circuits", (Component)this.getCircuitTab());
        this.addTab("Provisioning", (Component)this.getProvisioningTab());
        this.addTab("Inventory", (Component)this.getInventoryTab());
        this.addTab("Maintenance", (Component)this.getMaintenanceTab());
    }

    public Pane getProvisioningTab() {
        return this.pci.getShelfProvPane("Provisioning", this, this.gpf);
    }

    public Pane getInventoryTab() {
        return new ShelfInventoryPane("Inventory", this);
    }

    public Pane getMaintenanceTab() {
        return this.pci.getShelfMaintenancePane("Maintenance", this);
    }

    public Pane getConditionsTab() {
        return new NodeConditionsPane("Conditions", (NodeModelDelegate)this.uiModel, this, this.myController);
    }

    public void update(Observable observable, Object object) {
    }

    public void destroy() {
        this.alarmStore = null;
        this.eventStore = null;
        this.myController = null;
        this.gpf = null;
        super.destroy();
    }

    public void displayErrorDialog(TabbedView tabbedView, Exception exception, EID eID) {
    }
}

