/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.model.AuditTrail;
import cerent.cms.model.AuditTrailArchiveJob;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.event.AuditStore;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.event.AuditPanel;
import cerent.cms.ui.shelf.AbstractShelfMaintenancePane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UFileChooser;
import cerent.util.gui.UTable;
import cerent.util.gui.row.RowDataSource;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobListener;
import cerent.util.job.IJobProgressControl;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobProgressDialog;
import cerent.util.job.JobStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SmpAuditPane
extends AbstractPane
implements ActionListener,
IJobListener,
PropertyChangeListener {
    private boolean inited;
    public static final String ARCHIVED_LABEL = "Archived: ";
    private JButton retrieveB;
    private JButton archiveB;
    private JLabel getLabel;
    private AuditPanel auditPanel;
    private AuditStore auditStore;
    private int minSequenceNumber;
    private static File dir;
    private JobProgressDialog progressDlg;
    private static final SDebug db;
    private final int MAX_CMS_AUDIT_EVENTS;

    public SmpAuditPane(String string, TabbedView tabbedView, IPlatform iPlatform) {
        super(string, tabbedView);
        dir = null;
        this.progressDlg = null;
        this.inited = false;
        this.MAX_CMS_AUDIT_EVENTS = iPlatform.getMaxCmsAuditEvents();
    }

    private void init() {
        this.inited = true;
        if (db.on()) {
            db.println("init: start");
        }
        this.minSequenceNumber = 0;
        this.setLayout(new BorderLayout());
        this.auditStore = new AuditStore("Audit");
        this.auditPanel = new AuditPanel((RowDataSource)this.auditStore);
        this.add(this.auditPanel, "Center");
        this.table = this.auditPanel.getTable();
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.SmpAuditPane);
        this.retrieveB = new JButton("Retrieve");
        this.archiveB = new JButton("Archive");
        this.getLabel = new JLabel("");
        cSHelpButtonPane.addLeft(this.retrieveB);
        cSHelpButtonPane.addLeft(this.archiveB);
        if (this.isUserAuthorized()) {
            this.retrieveB.addActionListener(this);
        } else {
            ((UTable)this.table).setExportable(false);
            this.retrieveB.setEnabled(false);
        }
        if (this.isUserAuthorized(SecurityLevel.PROVISIONING)) {
            this.archiveB.addActionListener(this);
        } else {
            this.archiveB.setEnabled(false);
        }
        cSHelpButtonPane.addRight(this.getLabel);
        this.add(cSHelpButtonPane, "South");
        if (db.on()) {
            db.println("init: finish");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent actionEvent) {
        block16: {
            block15: {
                if (db.on()) {
                    db.println("actionPerformed " + actionEvent);
                }
                Object object = actionEvent.getSource();
                NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
                try {
                    try {
                        if (object == this.retrieveB) {
                            int n;
                            AuditTrail[] auditTrailArray;
                            if (this.uiToolkit != null) {
                                this.uiToolkit.setCursor(3);
                            }
                            int n2 = (auditTrailArray = nodeModelDelegate.getAuditTrailList(this.minSequenceNumber)) != null ? auditTrailArray.length : 0;
                            int n3 = n = this.auditStore != null ? this.auditStore.size() : 0;
                            if (n2 + n > this.MAX_CMS_AUDIT_EVENTS) {
                                if (this.minSequenceNumber > 0 || n > 0) {
                                    this.auditStore.dispose();
                                    this.minSequenceNumber = 0;
                                    this.actionPerformed(actionEvent);
                                }
                                Object var10_8 = null;
                                if (this.uiToolkit == null) return;
                                break block15;
                            }
                            int n4 = 0;
                            if (n2 - n4 > this.MAX_CMS_AUDIT_EVENTS - n) {
                                n4 = n2 - (this.MAX_CMS_AUDIT_EVENTS - n);
                            }
                            if (n4 < n2) {
                                for (int i = 0; i < n2; ++i) {
                                    this.auditStore.storeEvent(auditTrailArray[i]);
                                }
                                this.minSequenceNumber = auditTrailArray[n2 - 1].getSequenceNumber() + 1;
                                this.auditStore.updateView();
                            }
                            this.getLabel.setText("Retrieved: " + SmpAuditPane.getFormattedDateTime());
                            break block16;
                        }
                        if (object == this.archiveB) {
                            if (this.uiToolkit != null) {
                                this.uiToolkit.setCursor(3);
                            }
                            this.getTargetFileAndSpawnArchiveJob();
                        }
                        break block16;
                    }
                    catch (Exception exception) {
                        SDebug.printStackTrace((Throwable)exception);
                        ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_COMMUNICATION_ERROR_PARAM_1, (Object)exception.getMessage());
                        Object var10_10 = null;
                        if (this.uiToolkit == null) return;
                        this.uiToolkit.setCursor(0);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (this.uiToolkit == null) throw throwable;
                    this.uiToolkit.setCursor(0);
                    throw throwable;
                }
            }
            this.uiToolkit.setCursor(0);
            return;
        }
        Object var10_9 = null;
        if (this.uiToolkit == null) return;
        this.uiToolkit.setCursor(0);
    }

    public void enteringPage() {
        if (db.on()) {
            db.println("enteringPage");
        }
        if (!this.inited) {
            this.init();
        }
        Preferences.instance().addPropertyChangeListener((PropertyChangeListener)this);
        if (this.table != null) {
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        }
    }

    public void leavingPage() throws Exception {
        if (db.on()) {
            db.println("leavingPage");
        }
        Preferences.instance().removePropertyChangeListener((PropertyChangeListener)this);
        if (this.table != null) {
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("dateFormat")) {
            this.repaint();
        }
    }

    public void refresh() {
    }

    public void destroy() {
        if (db.on()) {
            db.println("destroy");
        }
        if (this.table != null) {
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        }
        if (this.auditPanel != null) {
            this.auditPanel.dispose();
        }
        if (this.auditStore != null) {
            this.auditStore.dispose();
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTargetFileAndSpawnArchiveJob() {
        UFileChooser uFileChooser = new UFileChooser();
        uFileChooser.setDialogTitle("Archive Audit Trail");
        try {
            if (dir != null) {
                uFileChooser.setCurrentDirectory(dir);
            }
            if (uFileChooser.showSaveDialog((Component)((Object)this)) != 0) {
                return;
            }
            dir = uFileChooser.getCurrentDirectory();
            String string = uFileChooser.getName(uFileChooser.getSelectedFile());
            File file = new File(dir.getAbsolutePath(), string);
            String string2 = file.getAbsolutePath();
            if (db.on()) {
                db.println("archiveFile.exists(): " + file.exists());
                db.println("archiveFile.isFile(): " + file.isFile());
                db.println("archiveFile.canWrite(): " + file.canWrite());
            }
            if (file.exists()) {
                if (!file.isFile()) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NOT_NORMAL_FILE_PARAM_1, (Object)string2);
                    return;
                }
                if (!file.canWrite()) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NOT_WRITEABLE_FILE_PARAM_1, (Object)string2);
                    return;
                }
                if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)("The file " + string2 + " already exists.\nDo you want to replace it?"), (String)"Archive Audit Trail")) {
                    return;
                }
            }
            this.archiveAuditTrail(string2);
        }
        finally {
            uFileChooser.dispose();
        }
    }

    private void archiveAuditTrail(String string) {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        this.progressDlg = new JobProgressDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), "Archive Audit Trail", "Archiving audit trail...", false, true);
        JobController jobController = JobControllerFactory.createJC((int)1);
        AuditTrailArchiveJob auditTrailArchiveJob = new AuditTrailArchiveJob(nodeModelDelegate, string, (IJobProgressControl)this.progressDlg);
        this.progressDlg.setJob((IJobControl)auditTrailArchiveJob);
        this.progressDlg.setProgressText(nodeModelDelegate.getName() + ": Archiving audit trail ...");
        jobController.submitJob(new JobGroup((IJobControl)auditTrailArchiveJob, (IJobListener)this, (Object)jobController));
    }

    public void jobWaiting(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobRunning(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobFinished(JobGroup jobGroup, IJobControl iJobControl, final JobStatus jobStatus, final Object object) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SmpAuditPane.this.finishJob(jobStatus, (JobController)object);
            }
        });
    }

    private void finishJob(JobStatus jobStatus, JobController jobController) {
        String string = this.progressDlg.getTitle();
        this.progressDlg.dispose();
        this.progressDlg = null;
        if (jobStatus.value() == 3) {
            CerentDialog.infoDialog((Component)((Object)this), (String)(string + " aborted"), (String)string);
        } else if (jobStatus.value() == 2) {
            Exception exception = (Exception)jobStatus.getResult();
            if (exception != null) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_JOB_FAIL_EXCEPTION_PARAM_1, (Object)exception.toString());
            }
        } else {
            CerentDialog.infoDialog((Component)((Object)this), (String)(string + " complete"), (String)string);
            this.getLabel.setText(ARCHIVED_LABEL + SmpAuditPane.getFormattedDateTime());
        }
        if (jobController != null && jobController.isIdle()) {
            JobControllerFactory.disposeJC((JobController)jobController);
        }
    }

    static {
        db = new SDebug((KDebug)AbstractShelfMaintenancePane.db, "SmpAuditPane");
    }
}

