/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractSmpDiagnosticPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobListener;
import cerent.util.job.IJobProgressControl;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobProgressDialog;
import cerent.util.job.JobStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.omg.CORBA.BAD_OPERATION;

public class SmpDiagnosticPane
extends AbstractSmpDiagnosticPane {
    private static final String LAMPTEST_TT = "Perform Lamp Test";
    private JButton lampTestButton;

    public SmpDiagnosticPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    protected void init() {
        if (db.on()) {
            db.println("init: start");
        }
        super.init();
        JPanel jPanel = SmpDiagnosticPane.createVerticalPanel(null);
        this.add(jPanel);
        this.diagnosticButton = new JButton("Retrieve Tech Support Log...");
        this.diagnosticButton.addActionListener(this);
        this.diagnosticButton.setDefaultCapable(false);
        this.diagnosticButton.setToolTipText("Request a diagnostic file from the " + this.nodeModel.getPlatform().getControlCardName());
        this.diagnosticButton.setAlignmentX(0.5f);
        jPanel.add(this.diagnosticButton);
        jPanel.add(Box.createVerticalStrut(10));
        this.lampTestButton = new JButton("Lamp Test");
        this.lampTestButton.addActionListener(this);
        this.lampTestButton.setDefaultCapable(false);
        this.lampTestButton.setToolTipText(LAMPTEST_TT);
        this.lampTestButton.setAlignmentX(0.5f);
        jPanel.add(this.lampTestButton);
        SecurityLevel securityLevel = this.nodeModel.supportsSecureMode() && this.nodeModel.isSecureMode() ? SecurityLevel.SUPERUSER : SecurityLevel.PROVISIONING;
        this.enableComponent(this.diagnosticButton, this.uiModel, securityLevel);
        this.enableComponent(this.lampTestButton, this.uiModel, SecurityLevel.MAINTENANCE);
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        jPanel2.add(jPanel);
        this.setLayout(new BorderLayout());
        this.add(jPanel2, "North");
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.SmpDiagnosticPane);
        this.add(Box.createVerticalGlue(), "Center");
        this.add(cSHelpButtonPane, "South");
        if (db.on()) {
            db.println("init: finish");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.lampTestButton) {
            try {
                this.nodeModel.getEntityTableModel().doLampTest();
                CerentDialog.infoDialog((Component)((Object)this), (String)"The lamp test has been run.\n All module LEDs should illuminate for several seconds then revert to pre-test state.", (String)"Lamp Test Run");
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_LAMP_TEST_NOT_SUPPORTED);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_COMMUNICATION_ERROR_PARAM_1, (Object)abstractCmsIOException.getMessage());
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void enteringPage() {
        if (this.diagnosticButton == null) {
            this.init();
        }
        super.enteringPage();
    }

    public void leavingPage() throws Exception {
        super.leavingPage();
        this.diagnosticButton.setSelected(false);
        this.lampTestButton.setSelected(false);
    }

    private void getDiagnostics(NodeModelDelegate nodeModelDelegate, String string) {
        block2: {
            this.diagnosticButton.setEnabled(false);
            try {
                this.progressDlg = new JobProgressDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), "Retrieve Tech Support Log", "Retrieving log...", false, true);
                JobController jobController = JobControllerFactory.createJC((int)1);
                IJobControl iJobControl = nodeModelDelegate.createDataTransferJob(string, 6, (IJobProgressControl)this.progressDlg);
                this.progressDlg.setJob(iJobControl);
                this.progressDlg.setProgressText(nodeModelDelegate.getName() + ": Retrieving log ...");
                jobController.submitJob(new JobGroup(iJobControl, (IJobListener)this, (Object)jobController));
            }
            catch (Exception exception) {
                this.enableComponent(this.diagnosticButton);
                if (!SmpDiagnosticPane.db.on) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void jobWaiting(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobRunning(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobFinished(JobGroup jobGroup, IJobControl iJobControl, final JobStatus jobStatus, final Object object) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SmpDiagnosticPane.this.finishJob(jobStatus, (JobController)object);
            }
        });
    }

    private void finishJob(JobStatus jobStatus, JobController jobController) {
        String string = this.progressDlg.getTitle();
        this.progressDlg.dispose();
        this.progressDlg = null;
        if (jobStatus.value() == 3) {
            CerentDialog.infoDialog((Component)((Object)this), (String)(string + " aborted"), (String)string);
        } else if (jobStatus.value() == 2) {
            Exception exception = (Exception)jobStatus.getResult();
            if (exception != null) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DIAGS_EXCEPTION_OCCURRED_PARAM_1, (Object)exception.toString());
            }
        } else {
            CerentDialog.infoDialog((Component)((Object)this), (String)(string + " complete"), (String)string);
        }
        this.enableComponent(this.diagnosticButton);
        if (jobController != null && jobController.isIdle()) {
            JobControllerFactory.disposeJC((JobController)jobController);
        }
    }
}

