/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Epos.eCardMode;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EtherBridgeModel;
import cerent.cms.model.EtherModuleModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ether.EtherMacAddrTableModel;
import cerent.cms.ui.ether.MacAddrClrDialog;
import cerent.cms.ui.ether.MacAddrDataSource;
import cerent.cms.ui.shelf.AbstractShelfMaintenancePane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;

public class SmpMacAddrPane
extends AbstractPane
implements ActionListener {
    private static final String BROADCAST_DOMAIN = "Layer 2 Domain:";
    private static final String RETRIEVE = "Retrieve";
    private static final String CLEAR = "Clear...";
    private static final String CLEAR_ALL = "Clear All...";
    private static final String DATEFORMAT = "MM/dd/yy HH:mm:ss";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
    private MacAddrDataSource dataSource;
    private JButton retrieveButton;
    private JButton clearButton;
    private JButton clearAllButton;
    private JComboBox domainCB = null;
    private JLabel retrievalTime;
    private EtherBridgeModel etherBridgeModel;
    private NodeModelDelegate nodeModel;
    private Layer2Domain lastUsedDomain = null;
    private Vector observableList = new Vector();
    private static final SDebug db = new SDebug((KDebug)AbstractShelfMaintenancePane.db, "SmpMacAddrPane");

    public SmpMacAddrPane(String string, TabbedView tabbedView, NodeModelDelegate nodeModelDelegate) {
        super(string, tabbedView);
        this.nodeModel = nodeModelDelegate;
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    private void init() {
        if (db.on()) {
            db.println("init: start");
        }
        this.etherBridgeModel = (EtherBridgeModel)this.nodeModel.getEtherBridgeModel();
        this.dataSource = new MacAddrDataSource();
        this.table = new UTable((TableModel)((Object)new EtherMacAddrTableModel(this.dataSource, this.nodeModel)));
        ((EtherMacAddrTableModel)((Object)this.table.getModel())).initTable(this.table);
        this.setDefaultPrivilegeLevel(SecurityLevel.RETRIEVE);
        this.setLayout(new BorderLayout());
        JPanel jPanel = SmpMacAddrPane.createVerticalPanel(null);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        uScrollPane.setAlignmentX(0.0f);
        jPanel.add((Component)uScrollPane);
        this.add(jPanel, "Center");
        this.add(this.makeButtonPanel(), "South");
        if (db.on()) {
            db.println("init: finish");
        }
    }

    private JScrollPane makeButtonPanel() {
        this.retrieveButton = this.makeActionButton(RETRIEVE);
        this.clearButton = this.makeActionButton(CLEAR);
        this.clearAllButton = this.makeActionButton(CLEAR_ALL);
        this.clearButton.setEnabled(false);
        this.clearAllButton.setEnabled(false);
        this.enableComponent(this.clearButton, this.nodeModel, SecurityLevel.MAINTENANCE);
        this.enableComponent(this.clearAllButton, this.nodeModel, SecurityLevel.MAINTENANCE);
        this.domainCB = new JComboBox(this.getLayer2Domains());
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.SmpMacAddrPane);
        cSHelpButtonPane.addLeft(new JLabel(BROADCAST_DOMAIN));
        cSHelpButtonPane.addLeft(this.domainCB);
        cSHelpButtonPane.addLeft(this.retrieveButton);
        cSHelpButtonPane.addLeft(this.clearButton);
        cSHelpButtonPane.addLeft(this.clearAllButton);
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 0));
        this.retrievalTime = new JLabel("Retrieved (never)");
        jPanel.add(this.retrievalTime);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)cSHelpButtonPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel2);
        uScrollPane.setVerticalScrollBarPolicy(21);
        return uScrollPane;
    }

    private void refreshLayer2Domain() {
        if (this.domainCB == null) {
            return;
        }
        if (this.domainCB.getItemCount() > 0) {
            this.domainCB.removeAllItems();
        }
        Vector vector = this.getLayer2Domains();
        for (int i = 0; i < vector.size(); ++i) {
            this.domainCB.addItem(vector.get(i));
            String string = ((Layer2Domain)vector.get(i)).getName();
            if (this.lastUsedDomain == null || !this.lastUsedDomain.getName().equals(string)) continue;
            this.domainCB.setSelectedIndex(i);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (db.on()) {
            db.println("actionPerformed " + actionEvent);
        }
        Object object = actionEvent.getSource();
        if (this.domainCB.getSelectedIndex() == -1) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_L2_DOMAIN_NOT_SELECTED);
            return;
        }
        if (object == this.retrieveButton) {
            Layer2Domain layer2Domain = (Layer2Domain)this.domainCB.getSelectedItem();
            ((EtherMacAddrTableModel)((Object)this.table.getModel())).setModel(layer2Domain.getModel());
            this.lastUsedDomain = layer2Domain;
            this.getMacAddressList();
        } else if (object == this.clearButton) {
            this.clearSelectedAddresses();
        } else if (object == this.clearAllButton) {
            this.clearAllLearnedAddresses();
        }
    }

    private void clearSelectedAddresses() {
        MacAddrClrDialog macAddrClrDialog = new MacAddrClrDialog(this.uiToolkit.getApplicationFrame(), this.table);
    }

    private void clearAllLearnedAddresses() {
        if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)"Really clear all learned MAC addresses?", (String)"Clear All")) {
            return;
        }
        ((EtherMacAddrTableModel)((Object)this.table.getModel())).clearLearnedAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMacAddressList() {
        try {
            this.setCursor(3);
            ((EtherMacAddrTableModel)((Object)this.table.getModel())).getLearnedAddressList();
            this.retrievalTime.setText("Retrieved from " + this.lastUsedDomain.getName() + " at " + DateFormat.getDateTimeInstance(1, 1).format(new Date()));
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_RTRV_MAC_ADDR);
        }
        catch (Exception exception) {
            db.println("Caught Unknown Exception " + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            this.setCursor(0);
        }
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    private Vector getLayer2Domains() {
        Vector<Layer2Domain> vector = new Vector<Layer2Domain>();
        boolean bl = false;
        EntityModel entityModel = (EntityModel)this.nodeModel.getChassis();
        if (entityModel == null) {
            return vector;
        }
        List list = entityModel.getChildrenOfType(eClass.BACKPLANE);
        List list2 = ((EntityModel)list.get(0)).getChildren();
        for (int i = 0; i < list2.size(); ++i) {
            Object e;
            EntityModel entityModel2 = (EntityModel)list2.get(i);
            this.register((Observable)((Object)entityModel2));
            List list3 = entityModel2.getChildren();
            if (list3.size() <= 0 || !((e = list3.get(0)) instanceof ModuleModel)) continue;
            int n = ((ModuleModel)e).getEqType();
            eEqState eEqState2 = ((ModuleModel)e).getState();
            if (n != 14 && n != 15) continue;
            EtherModuleModel etherModuleModel = (EtherModuleModel)e;
            this.register((Observable)((Object)etherModuleModel));
            if (eEqState2.value() != 5) continue;
            try {
                if (etherModuleModel.getEtherCardMode() == eCardMode.LINEAR_NO_SWITCH) continue;
                if (etherModuleModel.getEtherCardMode() == eCardMode.SINGLE_CARD_SWITCH) {
                    String string = EntityModel.eqType2Name(etherModuleModel.getNodeModel().getTDMTerminology(), n);
                    if (SmpMacAddrPane.db.on) {
                        db.println("discovered " + (i + 1) + " (" + string + ")");
                    }
                    vector.add(new Layer2Domain(i + 1 + " (" + string + ")", etherModuleModel));
                    continue;
                }
                if (bl) continue;
                bl = true;
                if (SmpMacAddrPane.db.on) {
                    db.println("discovered Ethergroup");
                }
                vector.add(new Layer2Domain("Ethergroup", etherModuleModel));
                continue;
            }
            catch (xNoSuchEquipment xNoSuchEquipment2) {
                // empty catch block
            }
        }
        return vector;
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            if (n.equals(ModelUpdateType.CHANGED)) {
                if (db.on()) {
                    db.println("change message");
                } else if (n.equals(ModelUpdateType.DELETED)) {
                    if (db.on()) {
                        db.println("delete message");
                    }
                    this.unRegister(observable);
                } else if (n.equals(ModelUpdateType.ADDED) && db.on()) {
                    db.println("structure changed message");
                }
            }
            this.refreshLayer2Domain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.dataSource == null) {
                this.init();
            }
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
            Object var2_1 = null;
            if (this.uiToolkit == null) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.uiToolkit == null) throw throwable;
            this.uiToolkit.setCursor(0);
            throw throwable;
        }
        this.uiToolkit.setCursor(0);
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
    }

    public void refresh() {
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.unRegisterAll();
        super.destroy();
    }

    private void register(Observable observable) {
        boolean bl = false;
        for (int i = 0; i < this.observableList.size(); ++i) {
            Observable observable2 = (Observable)this.observableList.get(i);
            if (observable2 == null || observable2 != observable) continue;
            bl = true;
            break;
        }
        if (!bl) {
            observable.addObserver((Observer)((Object)this));
            this.observableList.add(observable);
        }
    }

    private void unRegister(Observable observable) {
        for (int i = 0; i < this.observableList.size(); ++i) {
            Observable observable2 = (Observable)this.observableList.get(i);
            if (observable2 == null || observable2 != observable) continue;
            observable2.deleteObserver((Observer)((Object)this));
            this.observableList.remove(observable2);
            break;
        }
    }

    private void unRegisterAll() {
        for (int i = 0; i < this.observableList.size(); ++i) {
            Observable observable = (Observable)this.observableList.get(i);
            if (observable == null) continue;
            observable.deleteObserver((Observer)((Object)this));
        }
        this.observableList.clear();
    }

    class Layer2Domain {
        private String name;
        private EtherModuleModel model;

        public Layer2Domain(String string, EtherModuleModel etherModuleModel) {
            this.name = string;
            this.model = etherModuleModel;
        }

        public EtherModuleModel getModel() {
            return this.model;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

