/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eModuleOp;
import cerent.cms.idl.Equipment.eProtectionState;
import cerent.cms.idl.Equipment.eProtectionType;
import cerent.cms.idl.SonetTopology.eOnePlusOneType;
import cerent.cms.idl.SonetTopology.eProtectionOp;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AlreadyLocked;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.Busy;
import cerent.cms.model.DuplexLocked;
import cerent.cms.model.DuplexUnlocked;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ForceToPrimaryNotAllowed;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InterfaceModels;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.InvalidState;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OnePlusOneModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProtectActive;
import cerent.cms.model.ProtectFailedOrMissing;
import cerent.cms.model.ProtectLocked;
import cerent.cms.model.ProtectionGroupModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.WorkingFailedOrMissing;
import cerent.cms.model.WorkingLocked;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.YCableModel;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.ObserverPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfMaintenancePane;
import cerent.cms.ui.shelf.PgComparator;
import cerent.cms.ui.shelf.PgListCellRenderer;
import cerent.cms.ui.shelf.PgMemberCellRenderer;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SmpProtectionPane
extends ObserverPane
implements ActionListener,
ListSelectionListener {
    public static final String OPERATION = "Operation: ";
    public static final String APPLY = "Apply";
    public static final Attribute MANUAL = new Attribute("Manual", 0);
    public static final Attribute FORCE = new Attribute("Force", 1);
    private static final String ATTR = "attribute";
    private DefaultListModel pgListModel;
    private DefaultListModel pgMembersModel;
    protected JList pgList;
    protected JList pgMembers;
    protected JComboBox operationCB;
    protected JButton clearPB;
    protected JButton switchPB;
    protected JButton forcePB;
    protected JButton unlockPB;
    protected JButton lockoutPB;
    protected JButton lockonPB;
    protected JPanel membersPanel;
    protected GridBagPanel buttonBar;
    protected AttributeMaps attrMap;
    public Attribute CLEAR;
    public Attribute SWITCH;
    public Attribute UNLOCK;
    public Attribute LOCKOUT;
    public Attribute LOCKON;
    private JPanel warningPanel;
    static final int NONE = 0;
    static final int MODULE = 1;
    static final int ELEMENT = 2;
    protected int opTargetType;
    protected Object opTarget;
    List obsContainers;
    List obsGroups;
    List obsMembers;
    boolean neverEntered = true;
    NodeModelDelegate nodeModel = null;
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfMaintenancePane.db, "SmpProtectionPane");

    public SmpProtectionPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDataSourceControl(new InnerDsc());
        this.setDefaultPrivilegeLevel(SecurityLevel.MAINTENANCE);
        this.nodeModel = (NodeModelDelegate)this.getUiModel().getNodeModel();
        this.attrMap = ElementDefaults.getAttributeMap(this.nodeModel);
        this.CLEAR = this.attrMap.getAttributeForVal("moduleOp", 1);
        this.SWITCH = this.attrMap.getAttributeForVal("moduleOp", 4);
        this.UNLOCK = this.attrMap.getAttributeForVal("moduleOp", 7);
        this.LOCKOUT = this.attrMap.getAttributeForVal("moduleOp", 2);
        this.LOCKON = this.attrMap.getAttributeForVal("moduleOp", 3);
    }

    protected void init() {
        if (db.on()) {
            db.println("init: start");
        }
        this.nodeModel = (NodeModelDelegate)this.getUiModel().getNodeModel();
        this.obsContainers = new ArrayList(2);
        this.obsContainers.add(this.nodeModel.getProtectionGroupModels());
        this.obsContainers.add(this.nodeModel.getElementModelsDelegate());
        GridBagPanel gridBagPanel = new GridBagPanel();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Protection Groups"));
        jPanel.setLayout(new BorderLayout());
        this.pgListModel = new DefaultListModel();
        this.pgList = new JList(this.pgListModel);
        this.pgList.setName("Protection Groups");
        this.pgList.setCellRenderer(new PgListCellRenderer());
        this.pgList.setSelectionMode(0);
        this.pgList.setVisibleRowCount(6);
        this.pgList.addListSelectionListener(this);
        jPanel.add((Component)new UScrollPane((Component)this.pgList), "Center");
        gridBagPanel.fillBoth(40, 100);
        gridBagPanel.add((Component)jPanel, 0, 0);
        this.membersPanel = new JPanel();
        this.membersPanel.setBorder(BorderFactory.createTitledBorder("Selected Group"));
        this.membersPanel.setLayout(new BorderLayout(5, 5));
        this.pgMembersModel = new DefaultListModel();
        this.pgMembers = new JList(this.pgMembersModel);
        this.pgMembers.setName("Selected Group");
        this.pgMembers.setCellRenderer(new PgMemberCellRenderer());
        this.pgMembers.setSelectionMode(0);
        this.pgMembers.setVisibleRowCount(6);
        this.pgMembers.addListSelectionListener(this);
        this.membersPanel.add((Component)new UScrollPane((Component)this.pgMembers), "Center");
        this.buttonBar = this.getButtonBar();
        gridBagPanel.add((Component)this.membersPanel, 1, 0);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1));
        jPanel2.add(gridBagPanel);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 5, 5));
        jPanel3.add(new CSHelpButton(CSHelpConst.SmpProtectionPane));
        this.setLayout(new BorderLayout());
        this.add(jPanel2, "Center");
        this.add(jPanel3, "South");
        if (this.nodeModel.getPlatform().is327()) {
            this.warningPanel = new JPanel(new GridLayout(0, 1));
            this.warningPanel.add(new JLabel("WARNING: Only common ports will be Protected"));
            this.warningPanel.add(new JLabel("if mismatching XTC cards are used"));
            this.membersPanel.add((Component)this.warningPanel, "North");
            this.warningPanel.setVisible(false);
        }
        if (db.on()) {
            db.println("init: finish");
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            Object object = listSelectionEvent.getSource();
            if (object == this.pgList) {
                if (SmpProtectionPane.db.on) {
                    db.println("valueChanged: pgList");
                }
                this.setSelectedModel(this.pgList.getSelectedValue());
            } else if (object == this.pgMembers) {
                if (SmpProtectionPane.db.on) {
                    db.println("valueChanged: pgMembers");
                }
                this.enableButtons(this.pgMembers.getSelectedValue());
            }
        }
    }

    protected void setSelectedModel(Object object) {
        Object object2;
        boolean bl = false;
        if (object == null) {
            if (db.on()) {
                db.println("setSelectedModel: model is null");
            }
            this.pgMembersModel.setSize(0);
            this.setOpTargetType(0);
        } else if (object instanceof ProtectionGroupModel) {
            String string;
            if (db.on()) {
                db.println("setSelectedModel: model is a PG");
            }
            object2 = (ProtectionGroupModel)object;
            ModuleModel[] moduleModelArray = (ModuleModel[])((ProtectionGroupModel)object2).getMainModuleModels();
            this.pgMembersModel.setSize(moduleModelArray.length + 1);
            this.pgMembersModel.setElementAt(((ProtectionGroupModel)object2).getProtectModuleModel(), 0);
            for (int i = 0; i < moduleModelArray.length; ++i) {
                this.pgMembersModel.setElementAt(moduleModelArray[i], i + 1);
            }
            this.setOpTargetType(1);
            if (this.warningPanel != null && (string = ((ProtectionGroupModel)object2).getName()).equals("XTCPROTGRP")) {
                String string2 = ((ModuleModel)((ProtectionGroupModel)object2).getProtectModuleModel()).getMfgData().name;
                for (int i = 0; i < moduleModelArray.length; ++i) {
                    if (moduleModelArray[i] == null || moduleModelArray[i].getMfgData().name.equals(string2)) continue;
                    bl = true;
                    break;
                }
            }
        } else if (object instanceof OnePlusOneModel) {
            block25: {
                if (db.on()) {
                    db.println("setSelectedModel: model is a 1+1");
                }
                object2 = (OnePlusOneModel)object;
                InterfaceModels interfaceModels = this.nodeModel.getIfModels();
                try {
                    InterfaceModel interfaceModel = interfaceModels.getInterfaceModel((PortModel)((OnePlusOneModel)object2).getMainEntityModel());
                    InterfaceModel interfaceModel2 = interfaceModels.getInterfaceModel((PortModel)((OnePlusOneModel)object2).getProtectEntityModel());
                    this.pgMembersModel.setSize(2);
                    this.pgMembersModel.setElementAt(interfaceModel2, 0);
                    this.pgMembersModel.setElementAt(interfaceModel, 1);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    this.pgMembersModel.setSize(0);
                    if (db.on()) {
                        db.println("AbstractCmsIOException for 1+1");
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    this.pgMembersModel.setSize(0);
                    if (!db.on()) break block25;
                    db.println("AbstractCmsNoSuchEntityException for 1+1");
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            this.opTarget = object2;
            this.setOpTargetType(2);
        } else if (object instanceof YCableModel) {
            block26: {
                if (db.on()) {
                    db.println("setSelectedModel: model is a Y Cable");
                }
                object2 = (YCableModel)object;
                InterfaceModels interfaceModels = this.nodeModel.getIfModels();
                try {
                    InterfaceModel interfaceModel = interfaceModels.getInterfaceModel((PortModel)((YCableModel)object2).getMainEntityModel());
                    InterfaceModel interfaceModel3 = interfaceModels.getInterfaceModel((PortModel)((YCableModel)object2).getProtectEntityModel());
                    this.pgMembersModel.setSize(2);
                    this.pgMembersModel.setElementAt(interfaceModel3, 0);
                    this.pgMembersModel.setElementAt(interfaceModel, 1);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    this.pgMembersModel.setSize(0);
                    if (db.on()) {
                        db.println("AbstractCmsIOException for 1+1");
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    this.pgMembersModel.setSize(0);
                    if (!db.on()) break block26;
                    db.println("AbstractCmsNoSuchEntityException for 1+1");
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            this.opTarget = object2;
            this.setOpTargetType(2);
        } else {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_UNEXPECTED_MODEL_CLASS_PARAM_1, object.getClass());
        }
        this.enableButtons(this.pgMembers.getSelectedValue());
        this.obsMembers = Arrays.asList(this.pgMembersModel.toArray());
        object2 = new ArrayList(this.obsContainers.size() + this.obsGroups.size() + this.obsMembers.size());
        object2.addAll(this.obsContainers);
        object2.addAll(this.obsGroups);
        object2.addAll(this.obsMembers);
        this.getObservableManager().setObservable(object2.toArray(new Observable[0]));
        if (this.warningPanel != null) {
            this.warningPanel.setVisible(bl);
            this.membersPanel.revalidate();
        }
    }

    protected void setOpTargetType(int n) {
        if (this.opTargetType != n) {
            if (n == 0) {
                this.membersPanel.remove(this.buttonBar);
            } else {
                this.membersPanel.add((Component)this.buttonBar, "South");
                if (n == 1) {
                    this.setButtonAttribute(this.switchPB, this.SWITCH);
                    this.forcePB.setVisible(false);
                } else if (n == 2) {
                    this.setButtonAttribute(this.switchPB, MANUAL);
                    this.forcePB.setVisible(true);
                }
            }
            this.opTargetType = n;
            this.membersPanel.revalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableButtons(Object object) {
        Object object2;
        Object e = this.pgList.getSelectedValue();
        if (e instanceof ProtectionGroupModel && this.nodeModel.getPlatform().is327() && ((String)(object2 = ((ProtectionGroupModel)e).getName())).equals("XTCPROTGRP")) {
            object = null;
        }
        if (object == null || !this.isUserAuthorized()) {
            this.clearPB.setEnabled(false);
            this.switchPB.setEnabled(false);
            this.forcePB.setEnabled(false);
            this.unlockPB.setEnabled(false);
            this.lockoutPB.setEnabled(false);
            this.lockonPB.setEnabled(false);
        } else if (this.opTargetType == 1) {
            eEqState eEqState2;
            int n;
            int n2;
            this.opTarget = object;
            object2 = ((ModuleModel)this.opTarget).getProtectionState();
            boolean bl = object2 == eProtectionState.LOCKED_OUT || object2 == eProtectionState.LOCKED_ON;
            eProtectionType eProtectionType2 = ((ModuleModel)this.opTarget).getProtectionGroupModel().getProtectType();
            ModuleModel[] moduleModelArray = null;
            boolean[] blArray = null;
            boolean[] blArray2 = null;
            boolean[] blArray3 = null;
            eProtectionState[] eProtectionStateArray = null;
            int n3 = 0;
            DefaultListModel defaultListModel = this.pgMembersModel;
            synchronized (defaultListModel) {
                n3 = this.pgMembersModel.getSize();
                if (n3 > 1) {
                    moduleModelArray = new ModuleModel[n3 - 1];
                    blArray = new boolean[n3 - 1];
                    blArray2 = new boolean[n3 - 1];
                    blArray3 = new boolean[n3 - 1];
                    eProtectionStateArray = new eProtectionState[n3 - 1];
                    n2 = 0;
                    for (n = 0; n < n3; ++n) {
                        ModuleModel moduleModel = (ModuleModel)this.pgMembersModel.getElementAt(n);
                        if (object == moduleModel) continue;
                        moduleModelArray[n2] = moduleModel;
                        blArray[n2] = moduleModel == moduleModel.getProtectionGroupModel().getProtectModuleModel();
                        eEqState eEqState3 = moduleModel.getState();
                        blArray2[n2] = eEqState3 == eEqState.STANDBY;
                        blArray3[n2] = eEqState3 == eEqState.ACTIVE;
                        eProtectionStateArray[n2] = moduleModel.getProtectionState();
                        ++n2;
                    }
                }
            }
            if (db.on()) {
                for (int i = 0; i < moduleModelArray.length; ++i) {
                    db.println("Other member is: " + moduleModelArray[i] + " and protect=" + blArray[i] + " and " + "standby=" + blArray2[i] + " and " + "active= " + blArray3[i] + " and state=" + eProtectionStateArray[i]);
                }
            }
            n2 = (eEqState2 = ((ModuleModel)this.opTarget).getState()) == eEqState.STANDBY ? 1 : 0;
            n = eEqState2 == eEqState.ACTIVE ? 1 : 0;
            boolean bl2 = this.opTarget == ((ModuleModel)this.opTarget).getProtectionGroupModel().getProtectModuleModel();
            this.clearPB.setEnabled(object2 != eProtectionState.NORMAL && !bl);
            this.unlockPB.setEnabled(bl);
            this.switchPB.setEnabled(object2 == eProtectionState.NORMAL && !bl && n != 0);
            boolean bl3 = true;
            boolean bl4 = true;
            if (bl2) {
                if (n2 != 0) {
                    if (eProtectionType2 == eProtectionType.ONE_FOR_ONE && !bl) {
                        for (int i = 0; i < n3 - 1; ++i) {
                            if (eProtectionStateArray[i] != eProtectionState.LOCKED_OUT && eProtectionStateArray[i] != eProtectionState.LOCKED_ON) continue;
                            bl3 = false;
                        }
                    } else {
                        bl3 = false;
                    }
                    bl4 = !bl;
                } else {
                    bl3 = !bl;
                    boolean bl5 = bl4 = !bl;
                    if (bl4 || this.switchPB.isEnabled()) {
                        for (int i = 0; i < n3 - 1; ++i) {
                            if (blArray[i] || !blArray2[i] || eProtectionStateArray[i] != eProtectionState.LOCKED_OUT) continue;
                            if (bl4) {
                                bl4 = false;
                            }
                            this.switchPB.setEnabled(false);
                            break;
                        }
                    }
                }
            } else if (n != 0) {
                int n4;
                bl3 = !bl;
                boolean bl6 = bl4 = !bl;
                if (bl4) {
                    for (n4 = 0; n4 < n3 - 1; ++n4) {
                        if (blArray[n4] && eProtectionStateArray[n4] == eProtectionState.LOCKED_OUT) {
                            bl4 = false;
                            break;
                        }
                        if (!blArray[n4] || !blArray3[n4]) continue;
                        bl4 = false;
                        break;
                    }
                }
                if (this.switchPB.isEnabled()) {
                    for (n4 = 0; n4 < n3 - 1; ++n4) {
                        if (blArray[n4] && blArray3[n4]) {
                            this.switchPB.setEnabled(false);
                        } else {
                            if ((!blArray[n4] || eProtectionStateArray[n4] != eProtectionState.LOCKED_ON) && eProtectionStateArray[n4] != eProtectionState.LOCKED_OUT) continue;
                            this.switchPB.setEnabled(false);
                        }
                        break;
                    }
                }
            } else {
                bl4 = !bl;
                bl3 = bl4;
                if (!bl) {
                    for (int i = 0; i < n3 - 1; ++i) {
                        if (!blArray[i] || !blArray3[i]) continue;
                        if (eProtectionStateArray[i] == eProtectionState.LOCKED_ON) {
                            bl3 = false;
                        }
                        if (eProtectionStateArray[i] != eProtectionState.LOCKED_OUT) break;
                        bl4 = false;
                        break;
                    }
                }
            }
            this.lockoutPB.setEnabled(bl4);
            this.lockonPB.setEnabled(bl3);
        } else if (this.opTargetType == 2) {
            object2 = null;
            if (this.opTarget instanceof OnePlusOneModel) {
                object2 = ((OnePlusOneModel)this.opTarget).getProtectionOp();
            } else if (this.opTarget instanceof YCableModel) {
                object2 = ((YCableModel)this.opTarget).getProtectionOp();
            } else {
                db.println("ERROR in SmpProtectionPane.java");
            }
            boolean bl = this.pgMembers.getSelectedIndex() == 1;
            boolean bl7 = object2 == eProtectionOp.LOCKOUT_OF_PROTECTION || object2 == eProtectionOp.LOCKOUT_OF_WORKING;
            boolean bl8 = object2 == eProtectionOp.FORCE_SWITCH_TO_WORKING || object2 == eProtectionOp.FORCE_SWITCH_TO_PROTECT;
            boolean bl9 = object2 == eProtectionOp.MANUAL_SWITCH_TO_WORKING || object2 == eProtectionOp.MANUAL_SWITCH_TO_PROTECT;
            boolean bl10 = object2 == eProtectionOp.CLEAR || object2 == eProtectionOp.APS_CLEAR;
            boolean bl11 = this.isOnePlusOneOpt(this.opTarget);
            this.clearPB.setEnabled(object2 != eProtectionOp.CLEAR && !bl7);
            this.switchPB.setEnabled(!this.isOpTargetOptOnePlusOne() && bl10);
            this.forcePB.setEnabled(bl10 || bl9);
            this.unlockPB.setEnabled(bl7);
            if (bl11) {
                this.lockoutPB.setEnabled(!bl7);
                this.lockonPB.setEnabled(false);
            } else {
                this.lockoutPB.setEnabled(!bl && !bl7);
                this.lockonPB.setEnabled(bl && !bl7);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        boolean bl = false;
        boolean bl2 = false;
        eProtectionOp eProtectionOp2 = null;
        Object var6_6 = null;
        String string = "Traffic may not switch away from this line.  Verify\nproper switch of traffic prior to performing potential\nservice affecting work on this line.\n\nOK to continue?\n";
        String string2 = "Unable to switch.  Protect card is already Active\n";
        if (db.on()) {
            db.println("actionPerformed: " + ((Component)object).getName());
        }
        try {
            Attribute attribute = (Attribute)((JButton)object).getClientProperty(ATTR);
            if (this.opTargetType == 2 && (attribute == MANUAL || attribute == FORCE)) {
                bl = true;
            }
            if (attribute != null) {
                Object object2;
                eProtectionOp2 = this.getProtectionOp(attribute, this.opTarget);
                if (this.opTarget instanceof OnePlusOneModel) {
                    boolean bl3;
                    object2 = (TdmPortModel)((OnePlusOneModel)this.opTarget).getProtectEntityModel();
                    TdmLineModel tdmLineModel = ((TdmPortModel)object2).getTdmLineModel();
                    boolean bl4 = tdmLineModel.isCurrentlyActive();
                    boolean bl5 = bl3 = !bl4;
                    bl2 = (eProtectionOp2 == eProtectionOp.MANUAL_SWITCH_TO_PROTECT || eProtectionOp2 == eProtectionOp.FORCE_SWITCH_TO_PROTECT) && bl4 || (eProtectionOp2 == eProtectionOp.MANUAL_SWITCH_TO_WORKING || eProtectionOp2 == eProtectionOp.FORCE_SWITCH_TO_WORKING) && bl3 ? CerentDialog.yesNoDialog((Component)((Object)this), (String)("The line targeted for this switch request is already\nactive.  The switch request can be applied, but\ntraffic will not switch at this time.\n\nContinue to apply " + attribute + " switch?\n"), (String)("Confirm " + attribute + " Operation")) : (bl ? CerentDialog.yesNoDialog((Component)((Object)this), (String)string, (String)("Confirm " + attribute + " Operation")) : CerentDialog.yesNoDialog((Component)((Object)this), (String)"Are you sure?", (String)("Confirm " + attribute + " Operation")));
                } else {
                    bl2 = bl ? CerentDialog.yesNoDialog((Component)((Object)this), (String)string, (String)("Confirm " + attribute + " Operation")) : CerentDialog.yesNoDialog((Component)((Object)this), (String)"Are you sure?", (String)("Confirm " + attribute + " Operation"));
                }
                if (bl2) {
                    if (this.opTargetType == 1) {
                        object2 = eModuleOp.from_int(attribute.getIntValue());
                        ((ModuleModel)this.opTarget).doCommand((eModuleOp)object2);
                    } else if (this.opTargetType == 2) {
                        if (this.opTarget instanceof OnePlusOneModel) {
                            ((OnePlusOneModel)this.opTarget).setProtectionOp(eProtectionOp2);
                        } else if (this.opTarget instanceof YCableModel) {
                            ((YCableModel)this.opTarget).setProtectionOp(eProtectionOp2);
                        }
                    }
                }
            }
        }
        catch (InvalidProtectionOp invalidProtectionOp) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_UNABLE_TO_SWITCH);
        }
        catch (ForceToPrimaryNotAllowed forceToPrimaryNotAllowed) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_UNABLE_TO_SWITCH_TO_PRIMARY);
        }
        catch (InternalCommError internalCommError) {
            SDebug.printStackTrace((Throwable)internalCommError);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_APPLY_FORCE_OPERATION);
        }
        catch (ProvisionError provisionError) {
            SDebug.printStackTrace((Throwable)provisionError);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "Provisioning error.");
        }
        catch (ProtectActive protectActive) {
            SDebug.printStackTrace((Throwable)protectActive);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "Protect is active.");
        }
        catch (Busy busy) {
            SDebug.printStackTrace((Throwable)busy);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "Previous operation is still in progress.");
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "Protection group is being removed.");
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "Missing interface.");
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "Wrong interface type.");
        }
        catch (ProtectFailedOrMissing protectFailedOrMissing) {
            SDebug.printStackTrace((Throwable)protectFailedOrMissing);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "Protect is failed or missing.");
        }
        catch (WorkingFailedOrMissing workingFailedOrMissing) {
            SDebug.printStackTrace((Throwable)workingFailedOrMissing);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "Working is failed or missing.");
        }
        catch (AlreadyLocked alreadyLocked) {
            SDebug.printStackTrace((Throwable)alreadyLocked);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "Already locked.");
        }
        catch (ProtectLocked protectLocked) {
            SDebug.printStackTrace((Throwable)protectLocked);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "Protect is locked.");
        }
        catch (WorkingLocked workingLocked) {
            SDebug.printStackTrace((Throwable)workingLocked);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "Working is locked.");
        }
        catch (InvalidState invalidState) {
            SDebug.printStackTrace((Throwable)invalidState);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "Invalid state for command.");
        }
        catch (DuplexLocked duplexLocked) {
            SDebug.printStackTrace((Throwable)duplexLocked);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "Duplex is locked.");
        }
        catch (DuplexUnlocked duplexUnlocked) {
            SDebug.printStackTrace((Throwable)duplexUnlocked);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "Duplex is unlocked.");
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.finer("AbstractCmsIOException in actionPerformed() " + (Object)((Object)abstractCmsIOException));
        }
    }

    protected eProtectionOp getProtectionOp(Attribute attribute, Object object) {
        boolean bl;
        eProtectionOp eProtectionOp2 = eProtectionOp.CLEAR;
        boolean bl2 = bl = this.pgMembers.getSelectedIndex() == 1;
        if (attribute == this.CLEAR || attribute == this.UNLOCK) {
            eProtectionOp2 = eProtectionOp.CLEAR;
        } else if (attribute == MANUAL) {
            eProtectionOp2 = bl ? eProtectionOp.MANUAL_SWITCH_TO_PROTECT : eProtectionOp.MANUAL_SWITCH_TO_WORKING;
        } else if (attribute == FORCE) {
            eProtectionOp2 = bl ? eProtectionOp.FORCE_SWITCH_TO_PROTECT : eProtectionOp.FORCE_SWITCH_TO_WORKING;
        } else if (attribute == this.LOCKOUT) {
            eProtectionOp2 = this.isOnePlusOneOpt(object) ? eProtectionOp.LOCKOUT_OF_PROTECTION : (bl ? eProtectionOp.LOCKOUT_OF_WORKING : eProtectionOp.LOCKOUT_OF_PROTECTION);
        } else if (attribute == this.LOCKON) {
            eProtectionOp2 = bl ? eProtectionOp.LOCKOUT_OF_PROTECTION : eProtectionOp.LOCKOUT_OF_WORKING;
        }
        return eProtectionOp2;
    }

    private boolean isOnePlusOneOpt(Object object) {
        if (object instanceof OnePlusOneModel) {
            return ((OnePlusOneModel)object).getOnePlusOneType() == eOnePlusOneType.ONEPLUSONE_OPTIMIZED;
        }
        return false;
    }

    protected GridBagPanel getButtonBar() {
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.inset(5, 5);
        gridBagPanel.anchorEast();
        gridBagPanel.add("Switch Commands: ", 0, 0);
        gridBagPanel.anchorCenter();
        gridBagPanel.fillHorizontal();
        this.clearPB = this.makeActionButton(this.CLEAR);
        gridBagPanel.add((Component)this.clearPB, 1, 0);
        this.switchPB = this.makeActionButton(this.SWITCH);
        gridBagPanel.add((Component)this.switchPB, 2, 0);
        this.forcePB = this.makeActionButton(FORCE);
        gridBagPanel.add((Component)this.forcePB, 3, 0);
        gridBagPanel.fillNone();
        gridBagPanel.anchorEast();
        gridBagPanel.add("Inhibit Switching: ", 0, 1);
        gridBagPanel.anchorCenter();
        gridBagPanel.fillHorizontal();
        this.unlockPB = this.makeActionButton(this.UNLOCK);
        gridBagPanel.add((Component)this.unlockPB, 1, 1);
        this.lockoutPB = this.makeActionButton(this.LOCKOUT);
        gridBagPanel.add((Component)this.lockoutPB, 2, 1);
        this.lockonPB = this.makeActionButton(this.LOCKON);
        gridBagPanel.add((Component)this.lockonPB, 3, 1);
        return gridBagPanel;
    }

    private JButton makeActionButton(Attribute attribute) {
        JButton jButton = new JButton();
        this.setButtonAttribute(jButton, attribute);
        if (this.isUserAuthorized()) {
            jButton.addActionListener(this);
        } else {
            jButton.setEnabled(false);
        }
        return jButton;
    }

    private void setButtonAttribute(JButton jButton, Attribute attribute) {
        jButton.setText(attribute.toString());
        jButton.putClientProperty(ATTR, attribute);
    }

    public void enteringPage() throws Exception {
        if (this.buttonBar == null) {
            this.init();
        }
        super.enteringPage();
    }

    public void update(Observable observable, Object object) {
        this.requestRefresh(this, null);
    }

    private boolean isOpTargetOptOnePlusOne() {
        return this.opTarget != null && this.opTarget instanceof OnePlusOneModel && ((OnePlusOneModel)this.opTarget).getOnePlusOneType() == eOnePlusOneType.ONEPLUSONE_OPTIMIZED;
    }

    private Collection filterForModule(Collection collection) {
        HashSet hashSet = new HashSet();
        Iterator iterator = collection.iterator();
        ModuleModel moduleModel = null;
        try {
            if (this.getUiModel() instanceof ModuleModel) {
                moduleModel = (ModuleModel)this.getUiModel();
            } else {
                return collection;
            }
            while (iterator.hasNext()) {
                try {
                    Model model;
                    Object e = iterator.next();
                    if (e instanceof OnePlusOneModel) {
                        model = (OnePlusOneModel)e;
                        if (!((OnePlusOneModel)model).getMainEntityModel().getModuleModel().equals(moduleModel) && !((OnePlusOneModel)model).getProtectEntityModel().getModuleModel().equals(moduleModel)) continue;
                        hashSet.add(e);
                        continue;
                    }
                    if (e instanceof YCableModel) {
                        model = (YCableModel)e;
                        if (!((YCableModel)model).getMainEntityModel().getModuleModel().equals(moduleModel) && !((YCableModel)model).getProtectEntityModel().getModuleModel().equals(moduleModel)) continue;
                        hashSet.add(e);
                        continue;
                    }
                    if (!(e instanceof ProtectionGroupModel)) continue;
                    model = (ProtectionGroupModel)e;
                    ModuleModel[] moduleModelArray = (ModuleModel[])((ProtectionGroupModel)model).getMainModuleModels();
                    ModuleModel moduleModel2 = (ModuleModel)((ProtectionGroupModel)model).getProtectModuleModel();
                    ArrayList<ModuleModel> arrayList = new ArrayList<ModuleModel>(Arrays.asList(moduleModelArray));
                    arrayList.add(moduleModel2);
                    if (!arrayList.contains(moduleModel)) continue;
                    hashSet.add(e);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) continue;
                    db.println("No such entity while filtering protection groups");
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("error in filtering protection groups");
                SDebug.printStackTrace((Throwable)exception);
            }
            return collection;
        }
        return hashSet;
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        public void refreshFromModel() {
            if (db.on()) {
                db.println("refreshFromModel: start");
            }
            ArrayList<ProtectionGroupModel> arrayList = new ArrayList<ProtectionGroupModel>();
            List<ProtectionGroupModel> list = Arrays.asList(SmpProtectionPane.this.nodeModel.getEntityTableModel().getProtectionGroupModelArray());
            if (SmpProtectionPane.this.getUiModel() instanceof ModuleModel) {
                arrayList.addAll(SmpProtectionPane.this.filterForModule(list));
            } else {
                arrayList.addAll(list);
            }
            Set set = SmpProtectionPane.this.nodeModel.getElementModelsDelegate().getElementsOfType(1);
            if (SmpProtectionPane.this.getUiModel() instanceof ModuleModel) {
                arrayList.addAll(SmpProtectionPane.this.filterForModule(set));
            } else {
                arrayList.addAll(set);
            }
            set = SmpProtectionPane.this.nodeModel.getElementModelsDelegate().getElementsOfType(4);
            if (SmpProtectionPane.this.getUiModel() instanceof ModuleModel) {
                arrayList.addAll(SmpProtectionPane.this.filterForModule(set));
            } else {
                arrayList.addAll(set);
            }
            set = SmpProtectionPane.this.nodeModel.getElementModelsDelegate().getElementsOfType(5);
            if (SmpProtectionPane.this.getUiModel() instanceof ModuleModel) {
                arrayList.addAll(SmpProtectionPane.this.filterForModule(set));
            } else {
                arrayList.addAll(set);
            }
            Collections.sort(arrayList, new PgComparator());
            SmpProtectionPane.this.obsGroups = arrayList;
            SmpProtectionPane.this.pgListModel.setSize(arrayList.size());
            int n = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                SmpProtectionPane.this.pgListModel.setElementAt(e, n++);
                if (!db.on()) continue;
                db.println("refreshFromModel: adding " + e + " to pgList");
            }
            SmpProtectionPane.this.setSelectedModel(SmpProtectionPane.this.pgList.getSelectedValue());
            if (db.on()) {
                db.println("refreshFromModel: finish");
            }
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)SmpProtectionPane.this), true);
            }
            return this.dscObservableManager;
        }
    }
}

