/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.HoTapModel;
import cerent.cms.model.HoTapModels;
import cerent.cms.model.INodeModel;
import cerent.cms.model.LoTapModel;
import cerent.cms.model.LoTapModels;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.TapModel;
import cerent.cms.model.TapModelCollection;
import cerent.cms.ui.RoDataSourceControl;
import cerent.cms.ui.shelf.SmpTestAccessPane;
import cerent.cms.ui.shelf.SmpTestAccessRowObject;
import cerent.util.BlockingModeController;
import cerent.util.IObservableManager;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class SmpTestAccessDataSource
extends AbstractRowDataSource
implements Observer,
RoDataSourceControl,
BlockingModeController {
    private NodeModelDelegate node;
    private List tapModels;
    private SmpTestAccessRowObject[] rowObjects;
    private ObservableManager observableManager;
    private static final int NEEDS_REFRESH = 1;
    private static final int NEEDS_RESET = 2;
    private static final SDebug db = new SDebug((KDebug)SmpTestAccessPane.db, "SmpTestAccessDataSource");

    public SmpTestAccessDataSource(INodeModel iNodeModel) {
        this.node = (NodeModelDelegate)iNodeModel;
        this.observableManager = new ObservableManager(this, true);
        this.observableManager.setBlockingModeController(this);
    }

    public Object getObjectAtRow(int n) {
        try {
            return this.rowObjects != null ? this.rowObjects[n] : null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (db.on()) {
                db.println("getObjectAtRow " + n + " out of bounds");
            }
            return null;
        }
    }

    public int getRowCount() {
        return this.rowObjects != null ? this.rowObjects.length : 0;
    }

    public Collection getAllObjects() {
        return this.rowObjects != null ? Arrays.asList(this.rowObjects) : new ArrayList();
    }

    public void refreshFromModel(int n) throws Exception {
        if (n == -1 || n == 2) {
            this.resetFromNodeModel();
        }
        this.refreshFromModel();
    }

    private void resetFromNodeModel() {
        if (SmpTestAccessDataSource.db.on) {
            db.println("resetFromNodeModel");
        }
        this.observableManager.setObservable(null);
        if (this.node != null) {
            TapModelCollection tapModelCollection = this.node.getTapModels();
            this.tapModels = new ArrayList();
            if (tapModelCollection != null) {
                HoTapModels hoTapModels = tapModelCollection.getHoTapModels();
                this.observableManager.addObservable((Observable)((Object)hoTapModels));
                HoTapModel[] hoTapModelArray = hoTapModels.getHoTapModels();
                if (SmpTestAccessDataSource.db.on) {
                    db.println("resetFromNodeModel: " + hoTapModelArray.length + " HO TAPs");
                }
                this.observableManager.addObservable((Observable[])hoTapModelArray);
                this.tapModels.addAll(Arrays.asList(hoTapModelArray));
                LoTapModels loTapModels = tapModelCollection.getLoTapModels();
                this.observableManager.addObservable((Observable)((Object)loTapModels));
                LoTapModel[] loTapModelArray = loTapModels.getLoTapModels();
                if (SmpTestAccessDataSource.db.on) {
                    db.println("resetFromNodeModel: " + loTapModelArray.length + " LO TAPs");
                }
                this.observableManager.addObservable((Observable[])loTapModelArray);
                this.tapModels.addAll(Arrays.asList(loTapModelArray));
            }
        }
    }

    public void refreshFromModel() {
        if (SmpTestAccessDataSource.db.on) {
            db.println("refreshFromModel()");
        }
        this.rowObjects = new SmpTestAccessRowObject[this.tapModels.size()];
        for (int i = 0; i < this.tapModels.size(); ++i) {
            Object e = this.tapModels.get(i);
            if (SmpTestAccessDataSource.db.on) {
                db.println("tapModels[" + i + "] = " + String.valueOf(e));
            }
            if (e instanceof TapModel) {
                this.rowObjects[i] = new SmpTestAccessRowObject((TapModel)e);
                continue;
            }
            if (SmpTestAccessDataSource.db.on) {
                db.println("tapModels[" + i + "] is not a TAP!");
            }
            this.rowObjects[i] = null;
        }
        if (SmpTestAccessDataSource.db.on) {
            db.println("refreshFromModel(): fireDataSourceChanged");
        }
        this.fireDataSourceChanged();
    }

    public IObservableManager getObservableManager() {
        if (SmpTestAccessDataSource.db.on) {
            db.println("getObservableManager: state = " + this.observableManager.getBlockingModeControllerState());
        }
        return this.observableManager;
    }

    public void disposeDataSource() {
        if (this.tapModels != null) {
            this.tapModels.clear();
        }
        this.rowObjects = null;
    }

    public void update(Observable observable, Object object) {
        int n;
        if (SmpTestAccessDataSource.db.on) {
            db.println("update: src = " + observable + ", evt = " + object);
        }
        if ((n = this.tapModels.indexOf(observable)) == -1 || object == ModelUpdateType.DELETED) {
            this.resetFromNodeModel();
        }
        this.refreshFromModel();
    }

    public int processBlockedEvent(Observable observable, Object object, int n) {
        int n2;
        if (SmpTestAccessDataSource.db.on) {
            db.println("processBlockedEvent: src " + observable + ", event = " + object + ", previousState = " + n);
        }
        if ((n2 = this.tapModels.indexOf(observable)) == -1 || object == ModelUpdateType.DELETED) {
            return 2;
        }
        if (n == 0) {
            return 1;
        }
        return n;
    }
}

